<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCredentialPolicyDefault StructType
 * @subpackage Structs
 */
class LCredentialPolicyDefault extends AbstractStructBase
{
    /**
     * The credentialUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $credentialUser;
    /**
     * The credentialType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $credentialType;
    /**
     * The credPolicyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $credPolicyName;
    /**
     * The credentials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $credentials;
    /**
     * The confirmCredentials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $confirmCredentials;
    /**
     * The credUserCantChange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $credUserCantChange;
    /**
     * The credUserMustChange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $credUserMustChange;
    /**
     * The credDoesNotExpire
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $credDoesNotExpire;
    /**
     * Constructor method for LCredentialPolicyDefault
     * @uses LCredentialPolicyDefault::setCredentialUser()
     * @uses LCredentialPolicyDefault::setCredentialType()
     * @uses LCredentialPolicyDefault::setCredPolicyName()
     * @uses LCredentialPolicyDefault::setCredentials()
     * @uses LCredentialPolicyDefault::setConfirmCredentials()
     * @uses LCredentialPolicyDefault::setCredUserCantChange()
     * @uses LCredentialPolicyDefault::setCredUserMustChange()
     * @uses LCredentialPolicyDefault::setCredDoesNotExpire()
     * @param string $credentialUser
     * @param string $credentialType
     * @param XFkType $credPolicyName
     * @param string $credentials
     * @param string $confirmCredentials
     * @param string $credUserCantChange
     * @param string $credUserMustChange
     * @param string $credDoesNotExpire
     */
    public function __construct($credentialUser = null, $credentialType = null, XFkType $credPolicyName = null, $credentials = null, $confirmCredentials = null, $credUserCantChange = null, $credUserMustChange = null, $credDoesNotExpire = null)
    {
        $this
            ->setCredentialUser($credentialUser)
            ->setCredentialType($credentialType)
            ->setCredPolicyName($credPolicyName)
            ->setCredentials($credentials)
            ->setConfirmCredentials($confirmCredentials)
            ->setCredUserCantChange($credUserCantChange)
            ->setCredUserMustChange($credUserMustChange)
            ->setCredDoesNotExpire($credDoesNotExpire);
    }
    /**
     * Get credentialUser value
     * @return string|null
     */
    public function getCredentialUser()
    {
        return $this->credentialUser;
    }
    /**
     * Set credentialUser value
     * @uses XCredentialUser::valueIsValid()
     * @uses XCredentialUser::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $credentialUser
     * @return LCredentialPolicyDefault
     */
    public function setCredentialUser($credentialUser = null)
    {
        // validation for constraint: enumeration
        if (!XCredentialUser::valueIsValid($credentialUser)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $credentialUser, implode(', ', XCredentialUser::getValidValues())), __LINE__);
        }
        $this->credentialUser = $credentialUser;
        return $this;
    }
    /**
     * Get credentialType value
     * @return string|null
     */
    public function getCredentialType()
    {
        return $this->credentialType;
    }
    /**
     * Set credentialType value
     * @uses XCredential::valueIsValid()
     * @uses XCredential::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $credentialType
     * @return LCredentialPolicyDefault
     */
    public function setCredentialType($credentialType = null)
    {
        // validation for constraint: enumeration
        if (!XCredential::valueIsValid($credentialType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $credentialType, implode(', ', XCredential::getValidValues())), __LINE__);
        }
        $this->credentialType = $credentialType;
        return $this;
    }
    /**
     * Get credPolicyName value
     * @return XFkType|null
     */
    public function getCredPolicyName()
    {
        return $this->credPolicyName;
    }
    /**
     * Set credPolicyName value
     * @param XFkType $credPolicyName
     * @return LCredentialPolicyDefault
     */
    public function setCredPolicyName(XFkType $credPolicyName = null)
    {
        $this->credPolicyName = $credPolicyName;
        return $this;
    }
    /**
     * Get credentials value
     * @return string|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param string $credentials
     * @return LCredentialPolicyDefault
     */
    public function setCredentials($credentials = null)
    {
        // validation for constraint: string
        if (!is_null($credentials) && !is_string($credentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($credentials)), __LINE__);
        }
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get confirmCredentials value
     * @return string|null
     */
    public function getConfirmCredentials()
    {
        return $this->confirmCredentials;
    }
    /**
     * Set confirmCredentials value
     * @param string $confirmCredentials
     * @return LCredentialPolicyDefault
     */
    public function setConfirmCredentials($confirmCredentials = null)
    {
        // validation for constraint: string
        if (!is_null($confirmCredentials) && !is_string($confirmCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($confirmCredentials)), __LINE__);
        }
        $this->confirmCredentials = $confirmCredentials;
        return $this;
    }
    /**
     * Get credUserCantChange value
     * @return string|null
     */
    public function getCredUserCantChange()
    {
        return $this->credUserCantChange;
    }
    /**
     * Set credUserCantChange value
     * @param string $credUserCantChange
     * @return LCredentialPolicyDefault
     */
    public function setCredUserCantChange($credUserCantChange = null)
    {
        // validation for constraint: pattern
        if (is_scalar($credUserCantChange) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $credUserCantChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($credUserCantChange, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($credUserCantChange) && !is_string($credUserCantChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($credUserCantChange)), __LINE__);
        }
        $this->credUserCantChange = $credUserCantChange;
        return $this;
    }
    /**
     * Get credUserMustChange value
     * @return string|null
     */
    public function getCredUserMustChange()
    {
        return $this->credUserMustChange;
    }
    /**
     * Set credUserMustChange value
     * @param string $credUserMustChange
     * @return LCredentialPolicyDefault
     */
    public function setCredUserMustChange($credUserMustChange = null)
    {
        // validation for constraint: pattern
        if (is_scalar($credUserMustChange) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $credUserMustChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($credUserMustChange, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($credUserMustChange) && !is_string($credUserMustChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($credUserMustChange)), __LINE__);
        }
        $this->credUserMustChange = $credUserMustChange;
        return $this;
    }
    /**
     * Get credDoesNotExpire value
     * @return string|null
     */
    public function getCredDoesNotExpire()
    {
        return $this->credDoesNotExpire;
    }
    /**
     * Set credDoesNotExpire value
     * @param string $credDoesNotExpire
     * @return LCredentialPolicyDefault
     */
    public function setCredDoesNotExpire($credDoesNotExpire = null)
    {
        // validation for constraint: pattern
        if (is_scalar($credDoesNotExpire) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $credDoesNotExpire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($credDoesNotExpire, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($credDoesNotExpire) && !is_string($credDoesNotExpire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($credDoesNotExpire)), __LINE__);
        }
        $this->credDoesNotExpire = $credDoesNotExpire;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LCredentialPolicyDefault
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
