<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LAppServerInfo StructType
 * @subpackage Structs
 */
class LAppServerInfo extends AbstractStructBase
{
    /**
     * The appServerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $appServerName;
    /**
     * The appServerContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $appServerContent;
    /**
     * The content
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XContent
     */
    public $content;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LAppServerInfo
     * @uses LAppServerInfo::setAppServerName()
     * @uses LAppServerInfo::setAppServerContent()
     * @uses LAppServerInfo::setContent()
     * @uses LAppServerInfo::setUuid()
     * @param XFkType $appServerName
     * @param string $appServerContent
     * @param XContent $content
     * @param string $uuid
     */
    public function __construct(XFkType $appServerName = null, $appServerContent = null, XContent $content = null, $uuid = null)
    {
        $this
            ->setAppServerName($appServerName)
            ->setAppServerContent($appServerContent)
            ->setContent($content)
            ->setUuid($uuid);
    }
    /**
     * Get appServerName value
     * @return XFkType|null
     */
    public function getAppServerName()
    {
        return $this->appServerName;
    }
    /**
     * Set appServerName value
     * @param XFkType $appServerName
     * @return LAppServerInfo
     */
    public function setAppServerName(XFkType $appServerName = null)
    {
        $this->appServerName = $appServerName;
        return $this;
    }
    /**
     * Get appServerContent value
     * @return string|null
     */
    public function getAppServerContent()
    {
        return $this->appServerContent;
    }
    /**
     * Set appServerContent value
     * @uses XAppServerContent::valueIsValid()
     * @uses XAppServerContent::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $appServerContent
     * @return LAppServerInfo
     */
    public function setAppServerContent($appServerContent = null)
    {
        // validation for constraint: enumeration
        if (!XAppServerContent::valueIsValid($appServerContent)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $appServerContent, implode(', ', XAppServerContent::getValidValues())), __LINE__);
        }
        $this->appServerContent = $appServerContent;
        return $this;
    }
    /**
     * Get content value
     * @return XContent|null
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param XContent $content
     * @return LAppServerInfo
     */
    public function setContent(XContent $content = null)
    {
        $this->content = $content;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LAppServerInfo
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LAppServerInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
