<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVoiceMailPilotReq StructType
 * @subpackage Structs
 */
class GetVoiceMailPilotReq extends AbstractStructBase
{
    /**
     * The dirn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - maxLength: 255
     * @var string
     */
    public $dirn;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The cssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $cssName;
    /**
     * The returnedTags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var RVoiceMailPilot
     */
    public $returnedTags;
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for GetVoiceMailPilotReq
     * @uses GetVoiceMailPilotReq::setDirn()
     * @uses GetVoiceMailPilotReq::setUuid()
     * @uses GetVoiceMailPilotReq::setCssName()
     * @uses GetVoiceMailPilotReq::setReturnedTags()
     * @uses GetVoiceMailPilotReq::setSequence()
     * @param string $dirn
     * @param string $uuid
     * @param XFkType $cssName
     * @param RVoiceMailPilot $returnedTags
     * @param int $sequence
     */
    public function __construct($dirn = null, $uuid = null, XFkType $cssName = null, RVoiceMailPilot $returnedTags = null, $sequence = null)
    {
        $this
            ->setDirn($dirn)
            ->setUuid($uuid)
            ->setCssName($cssName)
            ->setReturnedTags($returnedTags)
            ->setSequence($sequence);
    }
    /**
     * Get dirn value
     * @return string
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param string $dirn
     * @return GetVoiceMailPilotReq
     */
    public function setDirn($dirn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($dirn) && strlen($dirn) > 255) || (is_array($dirn) && count($dirn) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($dirn) ? strlen($dirn) : count($dirn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dirn) && !is_string($dirn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dirn)), __LINE__);
        }
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return GetVoiceMailPilotReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get cssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCssName()
    {
        return isset($this->cssName) ? $this->cssName : null;
    }
    /**
     * Set cssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $cssName
     * @return GetVoiceMailPilotReq
     */
    public function setCssName(XFkType $cssName = null)
    {
        if (is_null($cssName) || (is_array($cssName) && empty($cssName))) {
            unset($this->cssName);
        } else {
            $this->cssName = $cssName;
        }
        return $this;
    }
    /**
     * Get returnedTags value
     * @return RVoiceMailPilot|null
     */
    public function getReturnedTags()
    {
        return $this->returnedTags;
    }
    /**
     * Set returnedTags value
     * @param RVoiceMailPilot $returnedTags
     * @return GetVoiceMailPilotReq
     */
    public function setReturnedTags(RVoiceMailPilot $returnedTags = null)
    {
        $this->returnedTags = $returnedTags;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return GetVoiceMailPilotReq
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return GetVoiceMailPilotReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
