<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSNMPUserReq StructType
 * @subpackage Structs
 */
class GetSNMPUserReq extends APIRequest
{
    /**
     * The userName
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $userName;
    /**
     * Constructor method for GetSNMPUserReq
     * @uses GetSNMPUserReq::setUserName()
     * @param string $userName
     */
    public function __construct($userName = null)
    {
        $this
            ->setUserName($userName);
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return GetSNMPUserReq
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($userName) && strlen($userName) > 32) || (is_array($userName) && count($userName) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($userName) ? strlen($userName) : count($userName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return GetSNMPUserReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
