<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCredentialPolicyDefaultReq StructType
 * @subpackage Structs
 */
class GetCredentialPolicyDefaultReq extends AbstractStructBase
{
    /**
     * The credentialUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $credentialUser;
    /**
     * The credentialType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $credentialType;
    /**
     * The credPolicyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var XFkType
     */
    public $credPolicyName;
    /**
     * The returnedTags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var RCredentialPolicyDefault
     */
    public $returnedTags;
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for GetCredentialPolicyDefaultReq
     * @uses GetCredentialPolicyDefaultReq::setCredentialUser()
     * @uses GetCredentialPolicyDefaultReq::setCredentialType()
     * @uses GetCredentialPolicyDefaultReq::setCredPolicyName()
     * @uses GetCredentialPolicyDefaultReq::setReturnedTags()
     * @uses GetCredentialPolicyDefaultReq::setSequence()
     * @param string $credentialUser
     * @param string $credentialType
     * @param XFkType $credPolicyName
     * @param RCredentialPolicyDefault $returnedTags
     * @param int $sequence
     */
    public function __construct($credentialUser = null, $credentialType = null, XFkType $credPolicyName = null, RCredentialPolicyDefault $returnedTags = null, $sequence = null)
    {
        $this
            ->setCredentialUser($credentialUser)
            ->setCredentialType($credentialType)
            ->setCredPolicyName($credPolicyName)
            ->setReturnedTags($returnedTags)
            ->setSequence($sequence);
    }
    /**
     * Get credentialUser value
     * @return string
     */
    public function getCredentialUser()
    {
        return $this->credentialUser;
    }
    /**
     * Set credentialUser value
     * @uses XCredentialUser::valueIsValid()
     * @uses XCredentialUser::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $credentialUser
     * @return GetCredentialPolicyDefaultReq
     */
    public function setCredentialUser($credentialUser = null)
    {
        // validation for constraint: enumeration
        if (!XCredentialUser::valueIsValid($credentialUser)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $credentialUser, implode(', ', XCredentialUser::getValidValues())), __LINE__);
        }
        $this->credentialUser = $credentialUser;
        return $this;
    }
    /**
     * Get credentialType value
     * @return string
     */
    public function getCredentialType()
    {
        return $this->credentialType;
    }
    /**
     * Set credentialType value
     * @uses XCredential::valueIsValid()
     * @uses XCredential::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $credentialType
     * @return GetCredentialPolicyDefaultReq
     */
    public function setCredentialType($credentialType = null)
    {
        // validation for constraint: enumeration
        if (!XCredential::valueIsValid($credentialType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $credentialType, implode(', ', XCredential::getValidValues())), __LINE__);
        }
        $this->credentialType = $credentialType;
        return $this;
    }
    /**
     * Get credPolicyName value
     * @return XFkType
     */
    public function getCredPolicyName()
    {
        return $this->credPolicyName;
    }
    /**
     * Set credPolicyName value
     * @param XFkType $credPolicyName
     * @return GetCredentialPolicyDefaultReq
     */
    public function setCredPolicyName(XFkType $credPolicyName = null)
    {
        $this->credPolicyName = $credPolicyName;
        return $this;
    }
    /**
     * Get returnedTags value
     * @return RCredentialPolicyDefault|null
     */
    public function getReturnedTags()
    {
        return $this->returnedTags;
    }
    /**
     * Set returnedTags value
     * @param RCredentialPolicyDefault $returnedTags
     * @return GetCredentialPolicyDefaultReq
     */
    public function setReturnedTags(RCredentialPolicyDefault $returnedTags = null)
    {
        $this->returnedTags = $returnedTags;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return GetCredentialPolicyDefaultReq
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return GetCredentialPolicyDefaultReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
