<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for destinations StructType
 * @subpackage Structs
 */
class Destinations extends XCommonMembersExtension
{
    /**
     * The destination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 16
     * - minOccurs: 0
     * @var XH323TrunkDestination[]
     */
    public $destination;
    /**
     * Constructor method for destinations
     * @uses Destinations::setDestination()
     * @param XH323TrunkDestination[] $destination
     */
    public function __construct(array $destination = array())
    {
        $this
            ->setDestination($destination);
    }
    /**
     * Get destination value
     * @return XH323TrunkDestination[]|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @throws \InvalidArgumentException
     * @param XH323TrunkDestination[] $destination
     * @return Destinations
     */
    public function setDestination(array $destination = array())
    {
        foreach ($destination as $destinationsDestinationItem) {
            // validation for constraint: itemType
            if (!$destinationsDestinationItem instanceof XH323TrunkDestination) {
                throw new \InvalidArgumentException(sprintf('The destination property can only contain items of XH323TrunkDestination, "%s" given', is_object($destinationsDestinationItem) ? get_class($destinationsDestinationItem) : gettype($destinationsDestinationItem)), __LINE__);
            }
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Add item to destination value
     * @throws \InvalidArgumentException
     * @param XH323TrunkDestination $item
     * @return Destinations
     */
    public function addToDestination(XH323TrunkDestination $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof XH323TrunkDestination) {
            throw new \InvalidArgumentException(sprintf('The destination property can only contain items of XH323TrunkDestination, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->destination[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return Destinations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
