<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Change StructType
 * @subpackage Structs
 */
class Change extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $id;
    /**
     * The action
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $action;
    /**
     * The serviceType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceType;
    /**
     * The doGet
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $doGet;
    /**
     * The changedTags
     * @var ChangedTags
     */
    public $changedTags;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for Change
     * @uses Change::setId()
     * @uses Change::setAction()
     * @uses Change::setServiceType()
     * @uses Change::setDoGet()
     * @uses Change::setChangedTags()
     * @uses Change::setType()
     * @uses Change::setUuid()
     * @param int $id
     * @param string $action
     * @param string $serviceType
     * @param string $doGet
     * @param ChangedTags $changedTags
     * @param string $type
     * @param string $uuid
     */
    public function __construct($id = null, $action = null, $serviceType = null, $doGet = null, ChangedTags $changedTags = null, $type = null, $uuid = null)
    {
        $this
            ->setId($id)
            ->setAction($action)
            ->setServiceType($serviceType)
            ->setDoGet($doGet)
            ->setChangedTags($changedTags)
            ->setType($type)
            ->setUuid($uuid);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return Change
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->action;
    }
    /**
     * Set action value
     * @uses XChangeAction::valueIsValid()
     * @uses XChangeAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return Change
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!XChangeAction::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $action, implode(', ', XChangeAction::getValidValues())), __LINE__);
        }
        $this->action = $action;
        return $this;
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @param string $serviceType
     * @return Change
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: string
        if (!is_null($serviceType) && !is_string($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceType)), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get doGet value
     * @return string|null
     */
    public function getDoGet()
    {
        return $this->doGet;
    }
    /**
     * Set doGet value
     * @param string $doGet
     * @return Change
     */
    public function setDoGet($doGet = null)
    {
        // validation for constraint: pattern
        if (is_scalar($doGet) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $doGet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($doGet, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($doGet) && !is_string($doGet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($doGet)), __LINE__);
        }
        $this->doGet = $doGet;
        return $this;
    }
    /**
     * Get changedTags value
     * @return ChangedTags|null
     */
    public function getChangedTags()
    {
        return $this->changedTags;
    }
    /**
     * Set changedTags value
     * @param ChangedTags $changedTags
     * @return Change
     */
    public function setChangedTags(ChangedTags $changedTags = null)
    {
        $this->changedTags = $changedTags;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return Change
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return Change
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return Change
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
