<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for attributeSet StructType
 * @subpackage Structs
 */
class AttributeSet extends XCommonMembersExtension
{
    /**
     * The attributeNameString
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $attributeNameString;
    /**
     * The sdpAttributeHandling
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sdpAttributeHandling;
    /**
     * The allowedValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var string[]
     */
    public $allowedValue;
    /**
     * Constructor method for attributeSet
     * @uses AttributeSet::setAttributeNameString()
     * @uses AttributeSet::setSdpAttributeHandling()
     * @uses AttributeSet::setAllowedValue()
     * @param string $attributeNameString
     * @param string $sdpAttributeHandling
     * @param string[] $allowedValue
     */
    public function __construct($attributeNameString = null, $sdpAttributeHandling = null, array $allowedValue = array())
    {
        $this
            ->setAttributeNameString($attributeNameString)
            ->setSdpAttributeHandling($sdpAttributeHandling)
            ->setAllowedValue($allowedValue);
    }
    /**
     * Get attributeNameString value
     * @return string|null
     */
    public function getAttributeNameString()
    {
        return $this->attributeNameString;
    }
    /**
     * Set attributeNameString value
     * @param string $attributeNameString
     * @return AttributeSet
     */
    public function setAttributeNameString($attributeNameString = null)
    {
        // validation for constraint: string
        if (!is_null($attributeNameString) && !is_string($attributeNameString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attributeNameString)), __LINE__);
        }
        $this->attributeNameString = $attributeNameString;
        return $this;
    }
    /**
     * Get sdpAttributeHandling value
     * @return string|null
     */
    public function getSdpAttributeHandling()
    {
        return $this->sdpAttributeHandling;
    }
    /**
     * Set sdpAttributeHandling value
     * @param string $sdpAttributeHandling
     * @return AttributeSet
     */
    public function setSdpAttributeHandling($sdpAttributeHandling = null)
    {
        // validation for constraint: string
        if (!is_null($sdpAttributeHandling) && !is_string($sdpAttributeHandling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sdpAttributeHandling)), __LINE__);
        }
        $this->sdpAttributeHandling = $sdpAttributeHandling;
        return $this;
    }
    /**
     * Get allowedValue value
     * @return string[]|null
     */
    public function getAllowedValue()
    {
        return $this->allowedValue;
    }
    /**
     * Set allowedValue value
     * @throws \InvalidArgumentException
     * @param string[] $allowedValue
     * @return AttributeSet
     */
    public function setAllowedValue(array $allowedValue = array())
    {
        foreach ($allowedValue as $attributeSetAllowedValueItem) {
            // validation for constraint: itemType
            if (!is_string($attributeSetAllowedValueItem)) {
                throw new \InvalidArgumentException(sprintf('The allowedValue property can only contain items of string, "%s" given', is_object($attributeSetAllowedValueItem) ? get_class($attributeSetAllowedValueItem) : gettype($attributeSetAllowedValueItem)), __LINE__);
            }
        }
        $this->allowedValue = $allowedValue;
        return $this;
    }
    /**
     * Add item to allowedValue value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return AttributeSet
     */
    public function addToAllowedValue($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The allowedValue property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->allowedValue[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return AttributeSet
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
