<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AXLError StructType
 * @subpackage Structs
 */
class AXLError extends AbstractStructBase
{
    /**
     * The axlcode
     * @var int
     */
    public $axlcode;
    /**
     * The axlmessage
     * @var string
     */
    public $axlmessage;
    /**
     * The request
     * @var string
     */
    public $request;
    /**
     * Constructor method for AXLError
     * @uses AXLError::setAxlcode()
     * @uses AXLError::setAxlmessage()
     * @uses AXLError::setRequest()
     * @param int $axlcode
     * @param string $axlmessage
     * @param string $request
     */
    public function __construct($axlcode = null, $axlmessage = null, $request = null)
    {
        $this
            ->setAxlcode($axlcode)
            ->setAxlmessage($axlmessage)
            ->setRequest($request);
    }
    /**
     * Get axlcode value
     * @return int|null
     */
    public function getAxlcode()
    {
        return $this->axlcode;
    }
    /**
     * Set axlcode value
     * @param int $axlcode
     * @return AXLError
     */
    public function setAxlcode($axlcode = null)
    {
        // validation for constraint: int
        if (!is_null($axlcode) && !is_numeric($axlcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($axlcode)), __LINE__);
        }
        $this->axlcode = $axlcode;
        return $this;
    }
    /**
     * Get axlmessage value
     * @return string|null
     */
    public function getAxlmessage()
    {
        return $this->axlmessage;
    }
    /**
     * Set axlmessage value
     * @param string $axlmessage
     * @return AXLError
     */
    public function setAxlmessage($axlmessage = null)
    {
        // validation for constraint: string
        if (!is_null($axlmessage) && !is_string($axlmessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($axlmessage)), __LINE__);
        }
        $this->axlmessage = $axlmessage;
        return $this;
    }
    /**
     * Get request value
     * @return string|null
     */
    public function getRequest()
    {
        return $this->request;
    }
    /**
     * Set request value
     * @param string $request
     * @return AXLError
     */
    public function setRequest($request = null)
    {
        // validation for constraint: string
        if (!is_null($request) && !is_string($request)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($request)), __LINE__);
        }
        $this->request = $request;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return AXLError
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
