<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XUser StructType
 * @subpackage Structs
 */
class XUser extends AbstractStructBase
{
    /**
     * The lastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $lastName;
    /**
     * The userid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $userid;
    /**
     * The presenceGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var XFkType
     */
    public $presenceGroupName;
    /**
     * The firstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $firstName;
    /**
     * The middleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $middleName;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The pin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pin;
    /**
     * The mailid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mailid;
    /**
     * The department
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $department;
    /**
     * The manager
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $manager;
    /**
     * The userLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userLocale;
    /**
     * The associatedDevices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AssociatedDevices
     */
    public $associatedDevices;
    /**
     * The primaryExtension
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PrimaryExtension
     */
    public $primaryExtension;
    /**
     * The associatedPc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $associatedPc;
    /**
     * The associatedGroups
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AssociatedGroups
     */
    public $associatedGroups;
    /**
     * The enableCti
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableCti;
    /**
     * The digestCredentials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $digestCredentials;
    /**
     * The phoneProfiles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PhoneProfiles
     */
    public $phoneProfiles;
    /**
     * The defaultProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $defaultProfile;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The enableMobility
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableMobility;
    /**
     * The enableMobileVoiceAccess
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableMobileVoiceAccess;
    /**
     * The maxDeskPickupWaitTime
     * Meta informations extracted from the WSDL
     * - default: 10000
     * - documentation: Maximum wait time for Desk Pickup must be a number in the range 0 to 30000.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $maxDeskPickupWaitTime;
    /**
     * The remoteDestinationLimit
     * Meta informations extracted from the WSDL
     * - default: 4
     * - documentation: Remote Destination Limit must be a number in the range 1 to 10. Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $remoteDestinationLimit;
    /**
     * The passwordCredentials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PasswordCredentials
     */
    public $passwordCredentials;
    /**
     * The pinCredentials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PinCredentials
     */
    public $pinCredentials;
    /**
     * The primaryDevice
     * Meta informations extracted from the WSDL
     * - documentation: Primary Device for mobility users
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $primaryDevice;
    /**
     * The enableEmcc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableEmcc;
    /**
     * The ctiControlledDeviceProfiles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var CtiControlledDeviceProfiles
     */
    public $ctiControlledDeviceProfiles;
    /**
     * The patternPrecedence
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $patternPrecedence;
    /**
     * The numericUserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $numericUserId;
    /**
     * The mlppPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mlppPassword;
    /**
     * The customUserFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var CustomUserFields
     */
    public $customUserFields;
    /**
     * The homeCluster
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $homeCluster;
    /**
     * The imAndPresenceEnable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $imAndPresenceEnable;
    /**
     * The serviceProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $serviceProfile;
    /**
     * The lineAppearanceAssociationForPresences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var LineAppearanceAssociationForPresences
     */
    public $lineAppearanceAssociationForPresences;
    /**
     * The directoryUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $directoryUri;
    /**
     * The telephoneNumber
     * Meta informations extracted from the WSDL
     * - documentation: This field also corresponds to the field 'Number Displayed in Directory' for the Quick User/phone Add page.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $telephoneNumber;
    /**
     * The title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $title;
    /**
     * The mobileNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mobileNumber;
    /**
     * The homeNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $homeNumber;
    /**
     * The pagerNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pagerNumber;
    /**
     * The extensionsInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ExtensionsInfo
     */
    public $extensionsInfo;
    /**
     * The selfService
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $selfService;
    /**
     * The userProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $userProfile;
    /**
     * The calendarPresence
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $calendarPresence;
    /**
     * The ldapDirectoryName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $ldapDirectoryName;
    /**
     * The userIdentity
     * Meta informations extracted from the WSDL
     * - documentation: Value should be of of the format user@domain
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userIdentity;
    /**
     * The nameDialing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $nameDialing;
    /**
     * The ipccExtension
     * Meta informations extracted from the WSDL
     * - documentation: Applicable for Controlled Devices so this tag is appropriate for Get/UpdateUser APIs only.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $ipccExtension;
    /**
     * The convertUserAccount
     * Meta informations extracted from the WSDL
     * - documentation: These tags are for Get/UpdateUser APIs only.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $convertUserAccount;
    /**
     * The accountType
     * Meta informations extracted from the WSDL
     * - default: Local
     * - documentation: Valid values are 'Local' or 'LDAP'. Value of 'Local' implies this is a Locally created user and a value of 'LDAP' implies this user is an LDAP Synchronized user
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accountType;
    /**
     * The authenticationType
     * Meta informations extracted from the WSDL
     * - default: Local
     * - documentation: Valid values are 'Local' or 'LDAP'. Value of 'Local' implies authentication will happen at CUCM and a value of 'LDAP' implies authentication will happen at the LDAP
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationType;
    /**
     * Constructor method for XUser
     * @uses XUser::setLastName()
     * @uses XUser::setUserid()
     * @uses XUser::setPresenceGroupName()
     * @uses XUser::setFirstName()
     * @uses XUser::setMiddleName()
     * @uses XUser::setPassword()
     * @uses XUser::setPin()
     * @uses XUser::setMailid()
     * @uses XUser::setDepartment()
     * @uses XUser::setManager()
     * @uses XUser::setUserLocale()
     * @uses XUser::setAssociatedDevices()
     * @uses XUser::setPrimaryExtension()
     * @uses XUser::setAssociatedPc()
     * @uses XUser::setAssociatedGroups()
     * @uses XUser::setEnableCti()
     * @uses XUser::setDigestCredentials()
     * @uses XUser::setPhoneProfiles()
     * @uses XUser::setDefaultProfile()
     * @uses XUser::setSubscribeCallingSearchSpaceName()
     * @uses XUser::setEnableMobility()
     * @uses XUser::setEnableMobileVoiceAccess()
     * @uses XUser::setMaxDeskPickupWaitTime()
     * @uses XUser::setRemoteDestinationLimit()
     * @uses XUser::setPasswordCredentials()
     * @uses XUser::setPinCredentials()
     * @uses XUser::setPrimaryDevice()
     * @uses XUser::setEnableEmcc()
     * @uses XUser::setCtiControlledDeviceProfiles()
     * @uses XUser::setPatternPrecedence()
     * @uses XUser::setNumericUserId()
     * @uses XUser::setMlppPassword()
     * @uses XUser::setCustomUserFields()
     * @uses XUser::setHomeCluster()
     * @uses XUser::setImAndPresenceEnable()
     * @uses XUser::setServiceProfile()
     * @uses XUser::setLineAppearanceAssociationForPresences()
     * @uses XUser::setDirectoryUri()
     * @uses XUser::setTelephoneNumber()
     * @uses XUser::setTitle()
     * @uses XUser::setMobileNumber()
     * @uses XUser::setHomeNumber()
     * @uses XUser::setPagerNumber()
     * @uses XUser::setExtensionsInfo()
     * @uses XUser::setSelfService()
     * @uses XUser::setUserProfile()
     * @uses XUser::setCalendarPresence()
     * @uses XUser::setLdapDirectoryName()
     * @uses XUser::setUserIdentity()
     * @uses XUser::setNameDialing()
     * @uses XUser::setIpccExtension()
     * @uses XUser::setConvertUserAccount()
     * @uses XUser::setAccountType()
     * @uses XUser::setAuthenticationType()
     * @param string $lastName
     * @param string $userid
     * @param XFkType $presenceGroupName
     * @param string $firstName
     * @param string $middleName
     * @param string $password
     * @param string $pin
     * @param string $mailid
     * @param string $department
     * @param string $manager
     * @param string $userLocale
     * @param AssociatedDevices $associatedDevices
     * @param PrimaryExtension $primaryExtension
     * @param string $associatedPc
     * @param AssociatedGroups $associatedGroups
     * @param string $enableCti
     * @param string $digestCredentials
     * @param PhoneProfiles $phoneProfiles
     * @param XFkType $defaultProfile
     * @param XFkType $subscribeCallingSearchSpaceName
     * @param string $enableMobility
     * @param string $enableMobileVoiceAccess
     * @param string $maxDeskPickupWaitTime
     * @param string $remoteDestinationLimit
     * @param PasswordCredentials $passwordCredentials
     * @param PinCredentials $pinCredentials
     * @param XFkType $primaryDevice
     * @param string $enableEmcc
     * @param CtiControlledDeviceProfiles $ctiControlledDeviceProfiles
     * @param string $patternPrecedence
     * @param string $numericUserId
     * @param string $mlppPassword
     * @param CustomUserFields $customUserFields
     * @param string $homeCluster
     * @param string $imAndPresenceEnable
     * @param XFkType $serviceProfile
     * @param LineAppearanceAssociationForPresences $lineAppearanceAssociationForPresences
     * @param string $directoryUri
     * @param string $telephoneNumber
     * @param string $title
     * @param string $mobileNumber
     * @param string $homeNumber
     * @param string $pagerNumber
     * @param ExtensionsInfo $extensionsInfo
     * @param string $selfService
     * @param XFkType $userProfile
     * @param string $calendarPresence
     * @param XFkType $ldapDirectoryName
     * @param string $userIdentity
     * @param string $nameDialing
     * @param XFkType $ipccExtension
     * @param XFkType $convertUserAccount
     * @param string $accountType
     * @param string $authenticationType
     */
    public function __construct($lastName = null, $userid = null, XFkType $presenceGroupName = null, $firstName = null, $middleName = null, $password = null, $pin = null, $mailid = null, $department = null, $manager = null, $userLocale = null, AssociatedDevices $associatedDevices = null, PrimaryExtension $primaryExtension = null, $associatedPc = null, AssociatedGroups $associatedGroups = null, $enableCti = true, $digestCredentials = null, PhoneProfiles $phoneProfiles = null, XFkType $defaultProfile = null, XFkType $subscribeCallingSearchSpaceName = null, $enableMobility = false, $enableMobileVoiceAccess = false, $maxDeskPickupWaitTime = '10000', $remoteDestinationLimit = '4', PasswordCredentials $passwordCredentials = null, PinCredentials $pinCredentials = null, XFkType $primaryDevice = null, $enableEmcc = null, CtiControlledDeviceProfiles $ctiControlledDeviceProfiles = null, $patternPrecedence = 'Default', $numericUserId = null, $mlppPassword = null, CustomUserFields $customUserFields = null, $homeCluster = true, $imAndPresenceEnable = null, XFkType $serviceProfile = null, LineAppearanceAssociationForPresences $lineAppearanceAssociationForPresences = null, $directoryUri = null, $telephoneNumber = null, $title = null, $mobileNumber = null, $homeNumber = null, $pagerNumber = null, ExtensionsInfo $extensionsInfo = null, $selfService = null, XFkType $userProfile = null, $calendarPresence = false, XFkType $ldapDirectoryName = null, $userIdentity = null, $nameDialing = null, XFkType $ipccExtension = null, XFkType $convertUserAccount = null, $accountType = 'Local', $authenticationType = 'Local')
    {
        $this
            ->setLastName($lastName)
            ->setUserid($userid)
            ->setPresenceGroupName($presenceGroupName)
            ->setFirstName($firstName)
            ->setMiddleName($middleName)
            ->setPassword($password)
            ->setPin($pin)
            ->setMailid($mailid)
            ->setDepartment($department)
            ->setManager($manager)
            ->setUserLocale($userLocale)
            ->setAssociatedDevices($associatedDevices)
            ->setPrimaryExtension($primaryExtension)
            ->setAssociatedPc($associatedPc)
            ->setAssociatedGroups($associatedGroups)
            ->setEnableCti($enableCti)
            ->setDigestCredentials($digestCredentials)
            ->setPhoneProfiles($phoneProfiles)
            ->setDefaultProfile($defaultProfile)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setEnableMobility($enableMobility)
            ->setEnableMobileVoiceAccess($enableMobileVoiceAccess)
            ->setMaxDeskPickupWaitTime($maxDeskPickupWaitTime)
            ->setRemoteDestinationLimit($remoteDestinationLimit)
            ->setPasswordCredentials($passwordCredentials)
            ->setPinCredentials($pinCredentials)
            ->setPrimaryDevice($primaryDevice)
            ->setEnableEmcc($enableEmcc)
            ->setCtiControlledDeviceProfiles($ctiControlledDeviceProfiles)
            ->setPatternPrecedence($patternPrecedence)
            ->setNumericUserId($numericUserId)
            ->setMlppPassword($mlppPassword)
            ->setCustomUserFields($customUserFields)
            ->setHomeCluster($homeCluster)
            ->setImAndPresenceEnable($imAndPresenceEnable)
            ->setServiceProfile($serviceProfile)
            ->setLineAppearanceAssociationForPresences($lineAppearanceAssociationForPresences)
            ->setDirectoryUri($directoryUri)
            ->setTelephoneNumber($telephoneNumber)
            ->setTitle($title)
            ->setMobileNumber($mobileNumber)
            ->setHomeNumber($homeNumber)
            ->setPagerNumber($pagerNumber)
            ->setExtensionsInfo($extensionsInfo)
            ->setSelfService($selfService)
            ->setUserProfile($userProfile)
            ->setCalendarPresence($calendarPresence)
            ->setLdapDirectoryName($ldapDirectoryName)
            ->setUserIdentity($userIdentity)
            ->setNameDialing($nameDialing)
            ->setIpccExtension($ipccExtension)
            ->setConvertUserAccount($convertUserAccount)
            ->setAccountType($accountType)
            ->setAuthenticationType($authenticationType);
    }
    /**
     * Get lastName value
     * @return string
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return XUser
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get userid value
     * @return string
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return XUser
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userid)), __LINE__);
        }
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return XFkType
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param XFkType $presenceGroupName
     * @return XUser
     */
    public function setPresenceGroupName(XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return XUser
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get middleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->middleName;
    }
    /**
     * Set middleName value
     * @param string $middleName
     * @return XUser
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middleName)), __LINE__);
        }
        $this->middleName = $middleName;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return XUser
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get pin value
     * @return string|null
     */
    public function getPin()
    {
        return $this->pin;
    }
    /**
     * Set pin value
     * @param string $pin
     * @return XUser
     */
    public function setPin($pin = null)
    {
        // validation for constraint: string
        if (!is_null($pin) && !is_string($pin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pin)), __LINE__);
        }
        $this->pin = $pin;
        return $this;
    }
    /**
     * Get mailid value
     * @return string|null
     */
    public function getMailid()
    {
        return $this->mailid;
    }
    /**
     * Set mailid value
     * @param string $mailid
     * @return XUser
     */
    public function setMailid($mailid = null)
    {
        // validation for constraint: string
        if (!is_null($mailid) && !is_string($mailid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailid)), __LINE__);
        }
        $this->mailid = $mailid;
        return $this;
    }
    /**
     * Get department value
     * @return string|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param string $department
     * @return XUser
     */
    public function setDepartment($department = null)
    {
        // validation for constraint: string
        if (!is_null($department) && !is_string($department)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($department)), __LINE__);
        }
        $this->department = $department;
        return $this;
    }
    /**
     * Get manager value
     * @return string|null
     */
    public function getManager()
    {
        return $this->manager;
    }
    /**
     * Set manager value
     * @param string $manager
     * @return XUser
     */
    public function setManager($manager = null)
    {
        // validation for constraint: string
        if (!is_null($manager) && !is_string($manager)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manager)), __LINE__);
        }
        $this->manager = $manager;
        return $this;
    }
    /**
     * Get userLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserLocale()
    {
        return isset($this->userLocale) ? $this->userLocale : null;
    }
    /**
     * Set userLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XUserLocale::valueIsValid()
     * @uses XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userLocale
     * @return XUser
     */
    public function setUserLocale($userLocale = null)
    {
        // validation for constraint: enumeration
        if (!XUserLocale::valueIsValid($userLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userLocale, implode(', ', XUserLocale::getValidValues())), __LINE__);
        }
        if (is_null($userLocale) || (is_array($userLocale) && empty($userLocale))) {
            unset($this->userLocale);
        } else {
            $this->userLocale = $userLocale;
        }
        return $this;
    }
    /**
     * Get associatedDevices value
     * @return AssociatedDevices|null
     */
    public function getAssociatedDevices()
    {
        return $this->associatedDevices;
    }
    /**
     * Set associatedDevices value
     * @param AssociatedDevices $associatedDevices
     * @return XUser
     */
    public function setAssociatedDevices(AssociatedDevices $associatedDevices = null)
    {
        $this->associatedDevices = $associatedDevices;
        return $this;
    }
    /**
     * Get primaryExtension value
     * @return PrimaryExtension|null
     */
    public function getPrimaryExtension()
    {
        return $this->primaryExtension;
    }
    /**
     * Set primaryExtension value
     * @param PrimaryExtension $primaryExtension
     * @return XUser
     */
    public function setPrimaryExtension(PrimaryExtension $primaryExtension = null)
    {
        $this->primaryExtension = $primaryExtension;
        return $this;
    }
    /**
     * Get associatedPc value
     * @return string|null
     */
    public function getAssociatedPc()
    {
        return $this->associatedPc;
    }
    /**
     * Set associatedPc value
     * @param string $associatedPc
     * @return XUser
     */
    public function setAssociatedPc($associatedPc = null)
    {
        // validation for constraint: string
        if (!is_null($associatedPc) && !is_string($associatedPc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($associatedPc)), __LINE__);
        }
        $this->associatedPc = $associatedPc;
        return $this;
    }
    /**
     * Get associatedGroups value
     * @return AssociatedGroups|null
     */
    public function getAssociatedGroups()
    {
        return $this->associatedGroups;
    }
    /**
     * Set associatedGroups value
     * @param AssociatedGroups $associatedGroups
     * @return XUser
     */
    public function setAssociatedGroups(AssociatedGroups $associatedGroups = null)
    {
        $this->associatedGroups = $associatedGroups;
        return $this;
    }
    /**
     * Get enableCti value
     * @return string|null
     */
    public function getEnableCti()
    {
        return $this->enableCti;
    }
    /**
     * Set enableCti value
     * @param string $enableCti
     * @return XUser
     */
    public function setEnableCti($enableCti = true)
    {
        // validation for constraint: pattern
        if (is_scalar($enableCti) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableCti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableCti, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableCti) && !is_string($enableCti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableCti)), __LINE__);
        }
        $this->enableCti = $enableCti;
        return $this;
    }
    /**
     * Get digestCredentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDigestCredentials()
    {
        return isset($this->digestCredentials) ? $this->digestCredentials : null;
    }
    /**
     * Set digestCredentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $digestCredentials
     * @return XUser
     */
    public function setDigestCredentials($digestCredentials = null)
    {
        // validation for constraint: string
        if (!is_null($digestCredentials) && !is_string($digestCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($digestCredentials)), __LINE__);
        }
        if (is_null($digestCredentials) || (is_array($digestCredentials) && empty($digestCredentials))) {
            unset($this->digestCredentials);
        } else {
            $this->digestCredentials = $digestCredentials;
        }
        return $this;
    }
    /**
     * Get phoneProfiles value
     * @return PhoneProfiles|null
     */
    public function getPhoneProfiles()
    {
        return $this->phoneProfiles;
    }
    /**
     * Set phoneProfiles value
     * @param PhoneProfiles $phoneProfiles
     * @return XUser
     */
    public function setPhoneProfiles(PhoneProfiles $phoneProfiles = null)
    {
        $this->phoneProfiles = $phoneProfiles;
        return $this;
    }
    /**
     * Get defaultProfile value
     * @return XFkType|null
     */
    public function getDefaultProfile()
    {
        return $this->defaultProfile;
    }
    /**
     * Set defaultProfile value
     * @param XFkType $defaultProfile
     * @return XUser
     */
    public function setDefaultProfile(XFkType $defaultProfile = null)
    {
        $this->defaultProfile = $defaultProfile;
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return isset($this->subscribeCallingSearchSpaceName) ? $this->subscribeCallingSearchSpaceName : null;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $subscribeCallingSearchSpaceName
     * @return XUser
     */
    public function setSubscribeCallingSearchSpaceName(XFkType $subscribeCallingSearchSpaceName = null)
    {
        if (is_null($subscribeCallingSearchSpaceName) || (is_array($subscribeCallingSearchSpaceName) && empty($subscribeCallingSearchSpaceName))) {
            unset($this->subscribeCallingSearchSpaceName);
        } else {
            $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get enableMobility value
     * @return string|null
     */
    public function getEnableMobility()
    {
        return $this->enableMobility;
    }
    /**
     * Set enableMobility value
     * @param string $enableMobility
     * @return XUser
     */
    public function setEnableMobility($enableMobility = false)
    {
        // validation for constraint: pattern
        if (is_scalar($enableMobility) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableMobility, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableMobility) && !is_string($enableMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableMobility)), __LINE__);
        }
        $this->enableMobility = $enableMobility;
        return $this;
    }
    /**
     * Get enableMobileVoiceAccess value
     * @return string|null
     */
    public function getEnableMobileVoiceAccess()
    {
        return $this->enableMobileVoiceAccess;
    }
    /**
     * Set enableMobileVoiceAccess value
     * @param string $enableMobileVoiceAccess
     * @return XUser
     */
    public function setEnableMobileVoiceAccess($enableMobileVoiceAccess = false)
    {
        // validation for constraint: pattern
        if (is_scalar($enableMobileVoiceAccess) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableMobileVoiceAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableMobileVoiceAccess, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableMobileVoiceAccess) && !is_string($enableMobileVoiceAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableMobileVoiceAccess)), __LINE__);
        }
        $this->enableMobileVoiceAccess = $enableMobileVoiceAccess;
        return $this;
    }
    /**
     * Get maxDeskPickupWaitTime value
     * @return string|null
     */
    public function getMaxDeskPickupWaitTime()
    {
        return $this->maxDeskPickupWaitTime;
    }
    /**
     * Set maxDeskPickupWaitTime value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxDeskPickupWaitTime
     * @return XUser
     */
    public function setMaxDeskPickupWaitTime($maxDeskPickupWaitTime = '10000')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($maxDeskPickupWaitTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxDeskPickupWaitTime, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->maxDeskPickupWaitTime = $maxDeskPickupWaitTime;
        return $this;
    }
    /**
     * Get remoteDestinationLimit value
     * @return string|null
     */
    public function getRemoteDestinationLimit()
    {
        return $this->remoteDestinationLimit;
    }
    /**
     * Set remoteDestinationLimit value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $remoteDestinationLimit
     * @return XUser
     */
    public function setRemoteDestinationLimit($remoteDestinationLimit = '4')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($remoteDestinationLimit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $remoteDestinationLimit, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->remoteDestinationLimit = $remoteDestinationLimit;
        return $this;
    }
    /**
     * Get passwordCredentials value
     * @return PasswordCredentials|null
     */
    public function getPasswordCredentials()
    {
        return $this->passwordCredentials;
    }
    /**
     * Set passwordCredentials value
     * @param PasswordCredentials $passwordCredentials
     * @return XUser
     */
    public function setPasswordCredentials(PasswordCredentials $passwordCredentials = null)
    {
        $this->passwordCredentials = $passwordCredentials;
        return $this;
    }
    /**
     * Get pinCredentials value
     * @return PinCredentials|null
     */
    public function getPinCredentials()
    {
        return $this->pinCredentials;
    }
    /**
     * Set pinCredentials value
     * @param PinCredentials $pinCredentials
     * @return XUser
     */
    public function setPinCredentials(PinCredentials $pinCredentials = null)
    {
        $this->pinCredentials = $pinCredentials;
        return $this;
    }
    /**
     * Get primaryDevice value
     * @return XFkType|null
     */
    public function getPrimaryDevice()
    {
        return $this->primaryDevice;
    }
    /**
     * Set primaryDevice value
     * @param XFkType $primaryDevice
     * @return XUser
     */
    public function setPrimaryDevice(XFkType $primaryDevice = null)
    {
        $this->primaryDevice = $primaryDevice;
        return $this;
    }
    /**
     * Get enableEmcc value
     * @return string|null
     */
    public function getEnableEmcc()
    {
        return $this->enableEmcc;
    }
    /**
     * Set enableEmcc value
     * @param string $enableEmcc
     * @return XUser
     */
    public function setEnableEmcc($enableEmcc = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableEmcc) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableEmcc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableEmcc, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableEmcc) && !is_string($enableEmcc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableEmcc)), __LINE__);
        }
        $this->enableEmcc = $enableEmcc;
        return $this;
    }
    /**
     * Get ctiControlledDeviceProfiles value
     * @return CtiControlledDeviceProfiles|null
     */
    public function getCtiControlledDeviceProfiles()
    {
        return $this->ctiControlledDeviceProfiles;
    }
    /**
     * Set ctiControlledDeviceProfiles value
     * @param CtiControlledDeviceProfiles $ctiControlledDeviceProfiles
     * @return XUser
     */
    public function setCtiControlledDeviceProfiles(CtiControlledDeviceProfiles $ctiControlledDeviceProfiles = null)
    {
        $this->ctiControlledDeviceProfiles = $ctiControlledDeviceProfiles;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return string|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @uses XPatternPrecedence::valueIsValid()
     * @uses XPatternPrecedence::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $patternPrecedence
     * @return XUser
     */
    public function setPatternPrecedence($patternPrecedence = 'Default')
    {
        // validation for constraint: enumeration
        if (!XPatternPrecedence::valueIsValid($patternPrecedence)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $patternPrecedence, implode(', ', XPatternPrecedence::getValidValues())), __LINE__);
        }
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get numericUserId value
     * @return string|null
     */
    public function getNumericUserId()
    {
        return $this->numericUserId;
    }
    /**
     * Set numericUserId value
     * @param string $numericUserId
     * @return XUser
     */
    public function setNumericUserId($numericUserId = null)
    {
        // validation for constraint: string
        if (!is_null($numericUserId) && !is_string($numericUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numericUserId)), __LINE__);
        }
        $this->numericUserId = $numericUserId;
        return $this;
    }
    /**
     * Get mlppPassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMlppPassword()
    {
        return isset($this->mlppPassword) ? $this->mlppPassword : null;
    }
    /**
     * Set mlppPassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mlppPassword
     * @return XUser
     */
    public function setMlppPassword($mlppPassword = null)
    {
        // validation for constraint: string
        if (!is_null($mlppPassword) && !is_string($mlppPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mlppPassword)), __LINE__);
        }
        if (is_null($mlppPassword) || (is_array($mlppPassword) && empty($mlppPassword))) {
            unset($this->mlppPassword);
        } else {
            $this->mlppPassword = $mlppPassword;
        }
        return $this;
    }
    /**
     * Get customUserFields value
     * @return CustomUserFields|null
     */
    public function getCustomUserFields()
    {
        return $this->customUserFields;
    }
    /**
     * Set customUserFields value
     * @param CustomUserFields $customUserFields
     * @return XUser
     */
    public function setCustomUserFields(CustomUserFields $customUserFields = null)
    {
        $this->customUserFields = $customUserFields;
        return $this;
    }
    /**
     * Get homeCluster value
     * @return string|null
     */
    public function getHomeCluster()
    {
        return $this->homeCluster;
    }
    /**
     * Set homeCluster value
     * @param string $homeCluster
     * @return XUser
     */
    public function setHomeCluster($homeCluster = true)
    {
        // validation for constraint: pattern
        if (is_scalar($homeCluster) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $homeCluster)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($homeCluster, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($homeCluster) && !is_string($homeCluster)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($homeCluster)), __LINE__);
        }
        $this->homeCluster = $homeCluster;
        return $this;
    }
    /**
     * Get imAndPresenceEnable value
     * @return string|null
     */
    public function getImAndPresenceEnable()
    {
        return $this->imAndPresenceEnable;
    }
    /**
     * Set imAndPresenceEnable value
     * @param string $imAndPresenceEnable
     * @return XUser
     */
    public function setImAndPresenceEnable($imAndPresenceEnable = null)
    {
        // validation for constraint: pattern
        if (is_scalar($imAndPresenceEnable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $imAndPresenceEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($imAndPresenceEnable, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($imAndPresenceEnable) && !is_string($imAndPresenceEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imAndPresenceEnable)), __LINE__);
        }
        $this->imAndPresenceEnable = $imAndPresenceEnable;
        return $this;
    }
    /**
     * Get serviceProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getServiceProfile()
    {
        return isset($this->serviceProfile) ? $this->serviceProfile : null;
    }
    /**
     * Set serviceProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $serviceProfile
     * @return XUser
     */
    public function setServiceProfile(XFkType $serviceProfile = null)
    {
        if (is_null($serviceProfile) || (is_array($serviceProfile) && empty($serviceProfile))) {
            unset($this->serviceProfile);
        } else {
            $this->serviceProfile = $serviceProfile;
        }
        return $this;
    }
    /**
     * Get lineAppearanceAssociationForPresences value
     * @return LineAppearanceAssociationForPresences|null
     */
    public function getLineAppearanceAssociationForPresences()
    {
        return $this->lineAppearanceAssociationForPresences;
    }
    /**
     * Set lineAppearanceAssociationForPresences value
     * @param LineAppearanceAssociationForPresences $lineAppearanceAssociationForPresences
     * @return XUser
     */
    public function setLineAppearanceAssociationForPresences(LineAppearanceAssociationForPresences $lineAppearanceAssociationForPresences = null)
    {
        $this->lineAppearanceAssociationForPresences = $lineAppearanceAssociationForPresences;
        return $this;
    }
    /**
     * Get directoryUri value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDirectoryUri()
    {
        return isset($this->directoryUri) ? $this->directoryUri : null;
    }
    /**
     * Set directoryUri value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $directoryUri
     * @return XUser
     */
    public function setDirectoryUri($directoryUri = null)
    {
        // validation for constraint: string
        if (!is_null($directoryUri) && !is_string($directoryUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directoryUri)), __LINE__);
        }
        if (is_null($directoryUri) || (is_array($directoryUri) && empty($directoryUri))) {
            unset($this->directoryUri);
        } else {
            $this->directoryUri = $directoryUri;
        }
        return $this;
    }
    /**
     * Get telephoneNumber value
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return $this->telephoneNumber;
    }
    /**
     * Set telephoneNumber value
     * @param string $telephoneNumber
     * @return XUser
     */
    public function setTelephoneNumber($telephoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($telephoneNumber) && !is_string($telephoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephoneNumber)), __LINE__);
        }
        $this->telephoneNumber = $telephoneNumber;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return XUser
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get mobileNumber value
     * @return string|null
     */
    public function getMobileNumber()
    {
        return $this->mobileNumber;
    }
    /**
     * Set mobileNumber value
     * @param string $mobileNumber
     * @return XUser
     */
    public function setMobileNumber($mobileNumber = null)
    {
        // validation for constraint: string
        if (!is_null($mobileNumber) && !is_string($mobileNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mobileNumber)), __LINE__);
        }
        $this->mobileNumber = $mobileNumber;
        return $this;
    }
    /**
     * Get homeNumber value
     * @return string|null
     */
    public function getHomeNumber()
    {
        return $this->homeNumber;
    }
    /**
     * Set homeNumber value
     * @param string $homeNumber
     * @return XUser
     */
    public function setHomeNumber($homeNumber = null)
    {
        // validation for constraint: string
        if (!is_null($homeNumber) && !is_string($homeNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($homeNumber)), __LINE__);
        }
        $this->homeNumber = $homeNumber;
        return $this;
    }
    /**
     * Get pagerNumber value
     * @return string|null
     */
    public function getPagerNumber()
    {
        return $this->pagerNumber;
    }
    /**
     * Set pagerNumber value
     * @param string $pagerNumber
     * @return XUser
     */
    public function setPagerNumber($pagerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($pagerNumber) && !is_string($pagerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pagerNumber)), __LINE__);
        }
        $this->pagerNumber = $pagerNumber;
        return $this;
    }
    /**
     * Get extensionsInfo value
     * @return ExtensionsInfo|null
     */
    public function getExtensionsInfo()
    {
        return $this->extensionsInfo;
    }
    /**
     * Set extensionsInfo value
     * @param ExtensionsInfo $extensionsInfo
     * @return XUser
     */
    public function setExtensionsInfo(ExtensionsInfo $extensionsInfo = null)
    {
        $this->extensionsInfo = $extensionsInfo;
        return $this;
    }
    /**
     * Get selfService value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelfService()
    {
        return isset($this->selfService) ? $this->selfService : null;
    }
    /**
     * Set selfService value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selfService
     * @return XUser
     */
    public function setSelfService($selfService = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($selfService) && strlen($selfService) > 50) || (is_array($selfService) && count($selfService) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($selfService) ? strlen($selfService) : count($selfService)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($selfService) && !is_string($selfService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($selfService)), __LINE__);
        }
        if (is_null($selfService) || (is_array($selfService) && empty($selfService))) {
            unset($this->selfService);
        } else {
            $this->selfService = $selfService;
        }
        return $this;
    }
    /**
     * Get userProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getUserProfile()
    {
        return isset($this->userProfile) ? $this->userProfile : null;
    }
    /**
     * Set userProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $userProfile
     * @return XUser
     */
    public function setUserProfile(XFkType $userProfile = null)
    {
        if (is_null($userProfile) || (is_array($userProfile) && empty($userProfile))) {
            unset($this->userProfile);
        } else {
            $this->userProfile = $userProfile;
        }
        return $this;
    }
    /**
     * Get calendarPresence value
     * @return string|null
     */
    public function getCalendarPresence()
    {
        return $this->calendarPresence;
    }
    /**
     * Set calendarPresence value
     * @param string $calendarPresence
     * @return XUser
     */
    public function setCalendarPresence($calendarPresence = false)
    {
        // validation for constraint: pattern
        if (is_scalar($calendarPresence) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $calendarPresence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($calendarPresence, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($calendarPresence) && !is_string($calendarPresence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calendarPresence)), __LINE__);
        }
        $this->calendarPresence = $calendarPresence;
        return $this;
    }
    /**
     * Get ldapDirectoryName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getLdapDirectoryName()
    {
        return isset($this->ldapDirectoryName) ? $this->ldapDirectoryName : null;
    }
    /**
     * Set ldapDirectoryName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $ldapDirectoryName
     * @return XUser
     */
    public function setLdapDirectoryName(XFkType $ldapDirectoryName = null)
    {
        if (is_null($ldapDirectoryName) || (is_array($ldapDirectoryName) && empty($ldapDirectoryName))) {
            unset($this->ldapDirectoryName);
        } else {
            $this->ldapDirectoryName = $ldapDirectoryName;
        }
        return $this;
    }
    /**
     * Get userIdentity value
     * @return string|null
     */
    public function getUserIdentity()
    {
        return $this->userIdentity;
    }
    /**
     * Set userIdentity value
     * @param string $userIdentity
     * @return XUser
     */
    public function setUserIdentity($userIdentity = null)
    {
        // validation for constraint: string
        if (!is_null($userIdentity) && !is_string($userIdentity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userIdentity)), __LINE__);
        }
        $this->userIdentity = $userIdentity;
        return $this;
    }
    /**
     * Get nameDialing value
     * @return string|null
     */
    public function getNameDialing()
    {
        return $this->nameDialing;
    }
    /**
     * Set nameDialing value
     * @param string $nameDialing
     * @return XUser
     */
    public function setNameDialing($nameDialing = null)
    {
        // validation for constraint: string
        if (!is_null($nameDialing) && !is_string($nameDialing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameDialing)), __LINE__);
        }
        $this->nameDialing = $nameDialing;
        return $this;
    }
    /**
     * Get ipccExtension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getIpccExtension()
    {
        return isset($this->ipccExtension) ? $this->ipccExtension : null;
    }
    /**
     * Set ipccExtension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $ipccExtension
     * @return XUser
     */
    public function setIpccExtension(XFkType $ipccExtension = null)
    {
        if (is_null($ipccExtension) || (is_array($ipccExtension) && empty($ipccExtension))) {
            unset($this->ipccExtension);
        } else {
            $this->ipccExtension = $ipccExtension;
        }
        return $this;
    }
    /**
     * Get convertUserAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getConvertUserAccount()
    {
        return isset($this->convertUserAccount) ? $this->convertUserAccount : null;
    }
    /**
     * Set convertUserAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $convertUserAccount
     * @return XUser
     */
    public function setConvertUserAccount(XFkType $convertUserAccount = null)
    {
        if (is_null($convertUserAccount) || (is_array($convertUserAccount) && empty($convertUserAccount))) {
            unset($this->convertUserAccount);
        } else {
            $this->convertUserAccount = $convertUserAccount;
        }
        return $this;
    }
    /**
     * Get accountType value
     * @return string|null
     */
    public function getAccountType()
    {
        return $this->accountType;
    }
    /**
     * Set accountType value
     * @uses XAccountType::valueIsValid()
     * @uses XAccountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accountType
     * @return XUser
     */
    public function setAccountType($accountType = 'Local')
    {
        // validation for constraint: enumeration
        if (!XAccountType::valueIsValid($accountType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $accountType, implode(', ', XAccountType::getValidValues())), __LINE__);
        }
        $this->accountType = $accountType;
        return $this;
    }
    /**
     * Get authenticationType value
     * @return string|null
     */
    public function getAuthenticationType()
    {
        return $this->authenticationType;
    }
    /**
     * Set authenticationType value
     * @uses XAuthenticationType::valueIsValid()
     * @uses XAuthenticationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationType
     * @return XUser
     */
    public function setAuthenticationType($authenticationType = 'Local')
    {
        // validation for constraint: enumeration
        if (!XAuthenticationType::valueIsValid($authenticationType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authenticationType, implode(', ', XAuthenticationType::getValidValues())), __LINE__);
        }
        $this->authenticationType = $authenticationType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XUser
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
