<?php
/**
 * This class stands for XTrustRole EnumType
 * @subpackage Enumerations
 */
class XTrustRole
{
    /**
     * Constant for value 'SAST'
     * @return string 'SAST'
     */
    const VALUE_SAST = 'SAST';
    /**
     * Constant for value 'CallManager'
     * @return string 'CallManager'
     */
    const VALUE_CALL_MANAGER = 'CallManager';
    /**
     * Constant for value 'CallManagerTFTP'
     * @return string 'CallManagerTFTP'
     */
    const VALUE_CALL_MANAGER_TFTP = 'CallManagerTFTP';
    /**
     * Constant for value 'TFTP'
     * @return string 'TFTP'
     */
    const VALUE_TFTP = 'TFTP';
    /**
     * Constant for value 'CAPF'
     * @return string 'CAPF'
     */
    const VALUE_CAPF = 'CAPF';
    /**
     * Constant for value 'SRST'
     * @return string 'SRST'
     */
    const VALUE_SRST = 'SRST';
    /**
     * Constant for value 'Firewall'
     * @return string 'Firewall'
     */
    const VALUE_FIREWALL = 'Firewall';
    /**
     * Constant for value 'Application Server'
     * @return string 'Application Server'
     */
    const VALUE_APPLICATION_SERVER = 'Application Server';
    /**
     * Constant for value 'Certificate Authority'
     * @return string 'Certificate Authority'
     */
    const VALUE_CERTIFICATE_AUTHORITY = 'Certificate Authority';
    /**
     * Constant for value 'Authentication and Authorization'
     * @return string 'Authentication and Authorization'
     */
    const VALUE_AUTHENTICATION_AND_AUTHORIZATION = 'Authentication and Authorization';
    /**
     * Constant for value 'Signaling and Call Control'
     * @return string 'Signaling and Call Control'
     */
    const VALUE_SIGNALING_AND_CALL_CONTROL = 'Signaling and Call Control';
    /**
     * Constant for value 'Provisioning Service'
     * @return string 'Provisioning Service'
     */
    const VALUE_PROVISIONING_SERVICE = 'Provisioning Service';
    /**
     * Constant for value 'Data Service'
     * @return string 'Data Service'
     */
    const VALUE_DATA_SERVICE = 'Data Service';
    /**
     * Constant for value 'Network Element'
     * @return string 'Network Element'
     */
    const VALUE_NETWORK_ELEMENT = 'Network Element';
    /**
     * Constant for value 'Virtual Private Network'
     * @return string 'Virtual Private Network'
     */
    const VALUE_VIRTUAL_PRIVATE_NETWORK = 'Virtual Private Network';
    /**
     * Constant for value 'Serviceability'
     * @return string 'Serviceability'
     */
    const VALUE_SERVICEABILITY = 'Serviceability';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SAST
     * @uses self::VALUE_CALL_MANAGER
     * @uses self::VALUE_CALL_MANAGER_TFTP
     * @uses self::VALUE_TFTP
     * @uses self::VALUE_CAPF
     * @uses self::VALUE_SRST
     * @uses self::VALUE_FIREWALL
     * @uses self::VALUE_APPLICATION_SERVER
     * @uses self::VALUE_CERTIFICATE_AUTHORITY
     * @uses self::VALUE_AUTHENTICATION_AND_AUTHORIZATION
     * @uses self::VALUE_SIGNALING_AND_CALL_CONTROL
     * @uses self::VALUE_PROVISIONING_SERVICE
     * @uses self::VALUE_DATA_SERVICE
     * @uses self::VALUE_NETWORK_ELEMENT
     * @uses self::VALUE_VIRTUAL_PRIVATE_NETWORK
     * @uses self::VALUE_SERVICEABILITY
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SAST,
            self::VALUE_CALL_MANAGER,
            self::VALUE_CALL_MANAGER_TFTP,
            self::VALUE_TFTP,
            self::VALUE_CAPF,
            self::VALUE_SRST,
            self::VALUE_FIREWALL,
            self::VALUE_APPLICATION_SERVER,
            self::VALUE_CERTIFICATE_AUTHORITY,
            self::VALUE_AUTHENTICATION_AND_AUTHORIZATION,
            self::VALUE_SIGNALING_AND_CALL_CONTROL,
            self::VALUE_PROVISIONING_SERVICE,
            self::VALUE_DATA_SERVICE,
            self::VALUE_NETWORK_ELEMENT,
            self::VALUE_VIRTUAL_PRIVATE_NETWORK,
            self::VALUE_SERVICEABILITY,
            self::VALUE_UNKNOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
