<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XSyslogConfig StructType
 * @subpackage Structs
 */
class XSyslogConfig extends AbstractStructBase
{
    /**
     * The AlarmLevelEvent
     * @var string
     */
    public $AlarmLevelEvent;
    /**
     * The RemoteServerName1
     * @var string
     */
    public $RemoteServerName1;
    /**
     * The RemoteServerName2
     * @var string
     */
    public $RemoteServerName2;
    /**
     * The RemoteServerName3
     * @var string
     */
    public $RemoteServerName3;
    /**
     * The RemoteServerName4
     * @var string
     */
    public $RemoteServerName4;
    /**
     * The RemoteServerName5
     * @var string
     */
    public $RemoteServerName5;
    /**
     * The monitor
     * @var string
     */
    public $monitor;
    /**
     * The Enable
     * Meta informations extracted from the WSDL
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $Enable;
    /**
     * Constructor method for XSyslogConfig
     * @uses XSyslogConfig::setAlarmLevelEvent()
     * @uses XSyslogConfig::setRemoteServerName1()
     * @uses XSyslogConfig::setRemoteServerName2()
     * @uses XSyslogConfig::setRemoteServerName3()
     * @uses XSyslogConfig::setRemoteServerName4()
     * @uses XSyslogConfig::setRemoteServerName5()
     * @uses XSyslogConfig::setMonitor()
     * @uses XSyslogConfig::setEnable()
     * @param string $alarmLevelEvent
     * @param string $remoteServerName1
     * @param string $remoteServerName2
     * @param string $remoteServerName3
     * @param string $remoteServerName4
     * @param string $remoteServerName5
     * @param string $monitor
     * @param string $enable
     */
    public function __construct($alarmLevelEvent = null, $remoteServerName1 = null, $remoteServerName2 = null, $remoteServerName3 = null, $remoteServerName4 = null, $remoteServerName5 = null, $monitor = null, $enable = null)
    {
        $this
            ->setAlarmLevelEvent($alarmLevelEvent)
            ->setRemoteServerName1($remoteServerName1)
            ->setRemoteServerName2($remoteServerName2)
            ->setRemoteServerName3($remoteServerName3)
            ->setRemoteServerName4($remoteServerName4)
            ->setRemoteServerName5($remoteServerName5)
            ->setMonitor($monitor)
            ->setEnable($enable);
    }
    /**
     * Get AlarmLevelEvent value
     * @return string|null
     */
    public function getAlarmLevelEvent()
    {
        return $this->AlarmLevelEvent;
    }
    /**
     * Set AlarmLevelEvent value
     * @uses XAlarmSeverity::valueIsValid()
     * @uses XAlarmSeverity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alarmLevelEvent
     * @return XSyslogConfig
     */
    public function setAlarmLevelEvent($alarmLevelEvent = null)
    {
        // validation for constraint: enumeration
        if (!XAlarmSeverity::valueIsValid($alarmLevelEvent)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alarmLevelEvent, implode(', ', XAlarmSeverity::getValidValues())), __LINE__);
        }
        $this->AlarmLevelEvent = $alarmLevelEvent;
        return $this;
    }
    /**
     * Get RemoteServerName1 value
     * @return string|null
     */
    public function getRemoteServerName1()
    {
        return $this->RemoteServerName1;
    }
    /**
     * Set RemoteServerName1 value
     * @param string $remoteServerName1
     * @return XSyslogConfig
     */
    public function setRemoteServerName1($remoteServerName1 = null)
    {
        // validation for constraint: string
        if (!is_null($remoteServerName1) && !is_string($remoteServerName1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remoteServerName1)), __LINE__);
        }
        $this->RemoteServerName1 = $remoteServerName1;
        return $this;
    }
    /**
     * Get RemoteServerName2 value
     * @return string|null
     */
    public function getRemoteServerName2()
    {
        return $this->RemoteServerName2;
    }
    /**
     * Set RemoteServerName2 value
     * @param string $remoteServerName2
     * @return XSyslogConfig
     */
    public function setRemoteServerName2($remoteServerName2 = null)
    {
        // validation for constraint: string
        if (!is_null($remoteServerName2) && !is_string($remoteServerName2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remoteServerName2)), __LINE__);
        }
        $this->RemoteServerName2 = $remoteServerName2;
        return $this;
    }
    /**
     * Get RemoteServerName3 value
     * @return string|null
     */
    public function getRemoteServerName3()
    {
        return $this->RemoteServerName3;
    }
    /**
     * Set RemoteServerName3 value
     * @param string $remoteServerName3
     * @return XSyslogConfig
     */
    public function setRemoteServerName3($remoteServerName3 = null)
    {
        // validation for constraint: string
        if (!is_null($remoteServerName3) && !is_string($remoteServerName3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remoteServerName3)), __LINE__);
        }
        $this->RemoteServerName3 = $remoteServerName3;
        return $this;
    }
    /**
     * Get RemoteServerName4 value
     * @return string|null
     */
    public function getRemoteServerName4()
    {
        return $this->RemoteServerName4;
    }
    /**
     * Set RemoteServerName4 value
     * @param string $remoteServerName4
     * @return XSyslogConfig
     */
    public function setRemoteServerName4($remoteServerName4 = null)
    {
        // validation for constraint: string
        if (!is_null($remoteServerName4) && !is_string($remoteServerName4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remoteServerName4)), __LINE__);
        }
        $this->RemoteServerName4 = $remoteServerName4;
        return $this;
    }
    /**
     * Get RemoteServerName5 value
     * @return string|null
     */
    public function getRemoteServerName5()
    {
        return $this->RemoteServerName5;
    }
    /**
     * Set RemoteServerName5 value
     * @param string $remoteServerName5
     * @return XSyslogConfig
     */
    public function setRemoteServerName5($remoteServerName5 = null)
    {
        // validation for constraint: string
        if (!is_null($remoteServerName5) && !is_string($remoteServerName5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remoteServerName5)), __LINE__);
        }
        $this->RemoteServerName5 = $remoteServerName5;
        return $this;
    }
    /**
     * Get monitor value
     * @return string|null
     */
    public function getMonitor()
    {
        return $this->monitor;
    }
    /**
     * Set monitor value
     * @param string $monitor
     * @return XSyslogConfig
     */
    public function setMonitor($monitor = null)
    {
        // validation for constraint: string
        if (!is_null($monitor) && !is_string($monitor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($monitor)), __LINE__);
        }
        $this->monitor = $monitor;
        return $this;
    }
    /**
     * Get Enable value
     * @return string|null
     */
    public function getEnable()
    {
        return $this->Enable;
    }
    /**
     * Set Enable value
     * @param string $enable
     * @return XSyslogConfig
     */
    public function setEnable($enable = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enable, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enable) && !is_string($enable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enable)), __LINE__);
        }
        $this->Enable = $enable;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XSyslogConfig
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
