<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XSdpTransparencyProfile StructType
 * @subpackage Structs
 */
class XSdpTransparencyProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The attributeSet
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var AttributeSet[]
     */
    public $attributeSet;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * Constructor method for XSdpTransparencyProfile
     * @uses XSdpTransparencyProfile::setName()
     * @uses XSdpTransparencyProfile::setAttributeSet()
     * @uses XSdpTransparencyProfile::setDescription()
     * @param string $name
     * @param AttributeSet[] $attributeSet
     * @param string $description
     */
    public function __construct($name = null, array $attributeSet = array(), $description = null)
    {
        $this
            ->setName($name)
            ->setAttributeSet($attributeSet)
            ->setDescription($description);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XSdpTransparencyProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get attributeSet value
     * @return AttributeSet[]
     */
    public function getAttributeSet()
    {
        return $this->attributeSet;
    }
    /**
     * Set attributeSet value
     * @throws \InvalidArgumentException
     * @param AttributeSet[] $attributeSet
     * @return XSdpTransparencyProfile
     */
    public function setAttributeSet(array $attributeSet = array())
    {
        foreach ($attributeSet as $xSdpTransparencyProfileAttributeSetItem) {
            // validation for constraint: itemType
            if (!$xSdpTransparencyProfileAttributeSetItem instanceof AttributeSet) {
                throw new \InvalidArgumentException(sprintf('The attributeSet property can only contain items of AttributeSet, "%s" given', is_object($xSdpTransparencyProfileAttributeSetItem) ? get_class($xSdpTransparencyProfileAttributeSetItem) : gettype($xSdpTransparencyProfileAttributeSetItem)), __LINE__);
            }
        }
        $this->attributeSet = $attributeSet;
        return $this;
    }
    /**
     * Add item to attributeSet value
     * @throws \InvalidArgumentException
     * @param AttributeSet $item
     * @return XSdpTransparencyProfile
     */
    public function addToAttributeSet(AttributeSet $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof AttributeSet) {
            throw new \InvalidArgumentException(sprintf('The attributeSet property can only contain items of AttributeSet, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->attributeSet[] = $item;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return XSdpTransparencyProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XSdpTransparencyProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
