<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRouteGroup StructType
 * @subpackage Structs
 */
class XRouteGroup extends AbstractStructBase
{
    /**
     * The distributionAlgorithm
     * Meta informations extracted from the WSDL
     * - default: Circular
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $distributionAlgorithm;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var Members
     */
    public $members;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * Constructor method for XRouteGroup
     * @uses XRouteGroup::setDistributionAlgorithm()
     * @uses XRouteGroup::setMembers()
     * @uses XRouteGroup::setName()
     * @param string $distributionAlgorithm
     * @param Members $members
     * @param string $name
     */
    public function __construct($distributionAlgorithm = 'Circular', Members $members = null, $name = null)
    {
        $this
            ->setDistributionAlgorithm($distributionAlgorithm)
            ->setMembers($members)
            ->setName($name);
    }
    /**
     * Get distributionAlgorithm value
     * @return string
     */
    public function getDistributionAlgorithm()
    {
        return $this->distributionAlgorithm;
    }
    /**
     * Set distributionAlgorithm value
     * @uses XDistributeAlgorithm::valueIsValid()
     * @uses XDistributeAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $distributionAlgorithm
     * @return XRouteGroup
     */
    public function setDistributionAlgorithm($distributionAlgorithm = 'Circular')
    {
        // validation for constraint: enumeration
        if (!XDistributeAlgorithm::valueIsValid($distributionAlgorithm)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $distributionAlgorithm, implode(', ', XDistributeAlgorithm::getValidValues())), __LINE__);
        }
        $this->distributionAlgorithm = $distributionAlgorithm;
        return $this;
    }
    /**
     * Get members value
     * @return Members
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param Members $members
     * @return XRouteGroup
     */
    public function setMembers(Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XRouteGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XRouteGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
