<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XPickupGroupMember StructType
 * @subpackage Structs
 */
class XPickupGroupMember extends AbstractStructBase
{
    /**
     * The priority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $priority;
    /**
     * The pickupGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var XFkType
     */
    public $pickupGroupName;
    /**
     * The pickupDnAndPartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var PickupDnAndPartition
     */
    public $pickupDnAndPartition;
    /**
     * Constructor method for XPickupGroupMember
     * @uses XPickupGroupMember::setPriority()
     * @uses XPickupGroupMember::setPickupGroupName()
     * @uses XPickupGroupMember::setPickupDnAndPartition()
     * @param string $priority
     * @param XFkType $pickupGroupName
     * @param PickupDnAndPartition $pickupDnAndPartition
     */
    public function __construct($priority = null, XFkType $pickupGroupName = null, PickupDnAndPartition $pickupDnAndPartition = null)
    {
        $this
            ->setPriority($priority)
            ->setPickupGroupName($pickupGroupName)
            ->setPickupDnAndPartition($pickupDnAndPartition);
    }
    /**
     * Get priority value
     * @return string
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return XPickupGroupMember
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $priority, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get pickupGroupName value
     * @return XFkType
     */
    public function getPickupGroupName()
    {
        return $this->pickupGroupName;
    }
    /**
     * Set pickupGroupName value
     * @param XFkType $pickupGroupName
     * @return XPickupGroupMember
     */
    public function setPickupGroupName(XFkType $pickupGroupName = null)
    {
        $this->pickupGroupName = $pickupGroupName;
        return $this;
    }
    /**
     * Get pickupDnAndPartition value
     * @return PickupDnAndPartition
     */
    public function getPickupDnAndPartition()
    {
        return $this->pickupDnAndPartition;
    }
    /**
     * Set pickupDnAndPartition value
     * @param PickupDnAndPartition $pickupDnAndPartition
     * @return XPickupGroupMember
     */
    public function setPickupDnAndPartition(PickupDnAndPartition $pickupDnAndPartition = null)
    {
        $this->pickupDnAndPartition = $pickupDnAndPartition;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XPickupGroupMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
