<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XPatternMember StructType
 * @subpackage Structs
 */
class XPatternMember extends AbstractStructBase
{
    /**
     * The selectionOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $selectionOrder;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The dialParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DialParameters
     */
    public $dialParameters;
    /**
     * Constructor method for XPatternMember
     * @uses XPatternMember::setSelectionOrder()
     * @uses XPatternMember::setDescription()
     * @uses XPatternMember::setDialParameters()
     * @param string $selectionOrder
     * @param string $description
     * @param DialParameters $dialParameters
     */
    public function __construct($selectionOrder = null, $description = null, DialParameters $dialParameters = null)
    {
        $this
            ->setSelectionOrder($selectionOrder)
            ->setDescription($description)
            ->setDialParameters($dialParameters);
    }
    /**
     * Get selectionOrder value
     * @return string
     */
    public function getSelectionOrder()
    {
        return $this->selectionOrder;
    }
    /**
     * Set selectionOrder value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selectionOrder
     * @return XPatternMember
     */
    public function setSelectionOrder($selectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($selectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $selectionOrder, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->selectionOrder = $selectionOrder;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return XPatternMember
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get dialParameters value
     * @return DialParameters|null
     */
    public function getDialParameters()
    {
        return $this->dialParameters;
    }
    /**
     * Set dialParameters value
     * @param DialParameters $dialParameters
     * @return XPatternMember
     */
    public function setDialParameters(DialParameters $dialParameters = null)
    {
        $this->dialParameters = $dialParameters;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XPatternMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
