<?php
/**
 * This class stands for XMGCPSlotModule EnumType
 * @subpackage Enumerations
 */
class XMGCPSlotModule
{
    /**
     * Constant for value 'NM-1V'
     * @return string 'NM-1V'
     */
    const VALUE_NM_1_V = 'NM-1V';
    /**
     * Constant for value 'NM-2V'
     * @return string 'NM-2V'
     */
    const VALUE_NM_2_V = 'NM-2V';
    /**
     * Constant for value 'NM-HDV'
     * @return string 'NM-HDV'
     */
    const VALUE_NM_HDV = 'NM-HDV';
    /**
     * Constant for value 'VIC-SLOT'
     * @return string 'VIC-SLOT'
     */
    const VALUE_VIC_SLOT = 'VIC-SLOT';
    /**
     * Constant for value 'NONE'
     * @return string 'NONE'
     */
    const VALUE_NONE = 'NONE';
    /**
     * Constant for value 'VWIC-SLOT'
     * @return string 'VWIC-SLOT'
     */
    const VALUE_VWIC_SLOT = 'VWIC-SLOT';
    /**
     * Constant for value 'FLEX-SLOT'
     * @return string 'FLEX-SLOT'
     */
    const VALUE_FLEX_SLOT = 'FLEX-SLOT';
    /**
     * Constant for value 'ANALOG'
     * @return string 'ANALOG'
     */
    const VALUE_ANALOG = 'ANALOG';
    /**
     * Constant for value 'DIGITAL'
     * @return string 'DIGITAL'
     */
    const VALUE_DIGITAL = 'DIGITAL';
    /**
     * Constant for value 'VGC_PORT'
     * @return string 'VGC_PORT'
     */
    const VALUE_VGC_PORT = 'VGC_PORT';
    /**
     * Constant for value 'WS-X6600'
     * @return string 'WS-X6600'
     */
    const VALUE_WS_X_6600 = 'WS-X6600';
    /**
     * Constant for value 'AIM-VOICE-30 (2 subunits)'
     * @return string 'AIM-VOICE-30 (2 subunits)'
     */
    const VALUE_AIM_VOICE_30_2_SUBUNITS = 'AIM-VOICE-30 (2 subunits)';
    /**
     * Constant for value 'NM-HDA'
     * @return string 'NM-HDA'
     */
    const VALUE_NM_HDA = 'NM-HDA';
    /**
     * Constant for value 'PA-VXA'
     * @return string 'PA-VXA'
     */
    const VALUE_PA_VXA = 'PA-VXA';
    /**
     * Constant for value 'PA-VXB'
     * @return string 'PA-VXB'
     */
    const VALUE_PA_VXB = 'PA-VXB';
    /**
     * Constant for value 'PA-VXC'
     * @return string 'PA-VXC'
     */
    const VALUE_PA_VXC = 'PA-VXC';
    /**
     * Constant for value 'PA-MCX'
     * @return string 'PA-MCX'
     */
    const VALUE_PA_MCX = 'PA-MCX';
    /**
     * Constant for value 'NM-HD-1V'
     * @return string 'NM-HD-1V'
     */
    const VALUE_NM_HD_1_V = 'NM-HD-1V';
    /**
     * Constant for value 'NM-HD-2V'
     * @return string 'NM-HD-2V'
     */
    const VALUE_NM_HD_2_V = 'NM-HD-2V';
    /**
     * Constant for value 'NM-HD-2VE'
     * @return string 'NM-HD-2VE'
     */
    const VALUE_NM_HD_2_VE = 'NM-HD-2VE';
    /**
     * Constant for value 'GENERIC-SLOT'
     * @return string 'GENERIC-SLOT'
     */
    const VALUE_GENERIC_SLOT = 'GENERIC-SLOT';
    /**
     * Constant for value 'NM-4VWIC-MBRD'
     * @return string 'NM-4VWIC-MBRD'
     */
    const VALUE_NM_4_VWIC_MBRD = 'NM-4VWIC-MBRD';
    /**
     * Constant for value 'EVM-HD'
     * @return string 'EVM-HD'
     */
    const VALUE_EVM_HD = 'EVM-HD';
    /**
     * Constant for value 'NM-HDV2-0PORT'
     * @return string 'NM-HDV2-0PORT'
     */
    const VALUE_NM_HDV_2_0_PORT = 'NM-HDV2-0PORT';
    /**
     * Constant for value 'NM-HDV2-1PORT-T1'
     * @return string 'NM-HDV2-1PORT-T1'
     */
    const VALUE_NM_HDV_2_1_PORT_T_1 = 'NM-HDV2-1PORT-T1';
    /**
     * Constant for value 'NM-HDV2-1PORT-E1'
     * @return string 'NM-HDV2-1PORT-E1'
     */
    const VALUE_NM_HDV_2_1_PORT_E_1 = 'NM-HDV2-1PORT-E1';
    /**
     * Constant for value 'NM-HDV2-2PORT-T1'
     * @return string 'NM-HDV2-2PORT-T1'
     */
    const VALUE_NM_HDV_2_2_PORT_T_1 = 'NM-HDV2-2PORT-T1';
    /**
     * Constant for value 'NM-HDV2-2PORT-E1'
     * @return string 'NM-HDV2-2PORT-E1'
     */
    const VALUE_NM_HDV_2_2_PORT_E_1 = 'NM-HDV2-2PORT-E1';
    /**
     * Constant for value 'AIM-VOICE-30-SLOT-0 (3 subunits- slot 0 only)'
     * @return string 'AIM-VOICE-30-SLOT-0 (3 subunits- slot 0 only)'
     */
    const VALUE_AIM_VOICE_30_SLOT_0_3_SUBUNITS_SLOT_0_ONLY = 'AIM-VOICE-30-SLOT-0 (3 subunits- slot 0 only)';
    /**
     * Constant for value 'NM-3VWIC-MBRD'
     * @return string 'NM-3VWIC-MBRD'
     */
    const VALUE_NM_3_VWIC_MBRD = 'NM-3VWIC-MBRD';
    /**
     * Constant for value 'ISR-3NIM-MBRD'
     * @return string 'ISR-3NIM-MBRD'
     */
    const VALUE_ISR_3_NIM_MBRD = 'ISR-3NIM-MBRD';
    /**
     * Constant for value 'VG-2VWIC-MBRD'
     * @return string 'VG-2VWIC-MBRD'
     */
    const VALUE_VG_2_VWIC_MBRD = 'VG-2VWIC-MBRD';
    /**
     * Constant for value 'VG-3VWIC-MBRD'
     * @return string 'VG-3VWIC-MBRD'
     */
    const VALUE_VG_3_VWIC_MBRD = 'VG-3VWIC-MBRD';
    /**
     * Constant for value 'ISR-2NIM-MBRD'
     * @return string 'ISR-2NIM-MBRD'
     */
    const VALUE_ISR_2_NIM_MBRD = 'ISR-2NIM-MBRD';
    /**
     * Constant for value 'SM-X-NIM-ADPTR'
     * @return string 'SM-X-NIM-ADPTR'
     */
    const VALUE_SM_X_NIM_ADPTR = 'SM-X-NIM-ADPTR';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NM_1_V
     * @uses self::VALUE_NM_2_V
     * @uses self::VALUE_NM_HDV
     * @uses self::VALUE_VIC_SLOT
     * @uses self::VALUE_NONE
     * @uses self::VALUE_VWIC_SLOT
     * @uses self::VALUE_FLEX_SLOT
     * @uses self::VALUE_ANALOG
     * @uses self::VALUE_DIGITAL
     * @uses self::VALUE_VGC_PORT
     * @uses self::VALUE_WS_X_6600
     * @uses self::VALUE_AIM_VOICE_30_2_SUBUNITS
     * @uses self::VALUE_NM_HDA
     * @uses self::VALUE_PA_VXA
     * @uses self::VALUE_PA_VXB
     * @uses self::VALUE_PA_VXC
     * @uses self::VALUE_PA_MCX
     * @uses self::VALUE_NM_HD_1_V
     * @uses self::VALUE_NM_HD_2_V
     * @uses self::VALUE_NM_HD_2_VE
     * @uses self::VALUE_GENERIC_SLOT
     * @uses self::VALUE_NM_4_VWIC_MBRD
     * @uses self::VALUE_EVM_HD
     * @uses self::VALUE_NM_HDV_2_0_PORT
     * @uses self::VALUE_NM_HDV_2_1_PORT_T_1
     * @uses self::VALUE_NM_HDV_2_1_PORT_E_1
     * @uses self::VALUE_NM_HDV_2_2_PORT_T_1
     * @uses self::VALUE_NM_HDV_2_2_PORT_E_1
     * @uses self::VALUE_AIM_VOICE_30_SLOT_0_3_SUBUNITS_SLOT_0_ONLY
     * @uses self::VALUE_NM_3_VWIC_MBRD
     * @uses self::VALUE_ISR_3_NIM_MBRD
     * @uses self::VALUE_VG_2_VWIC_MBRD
     * @uses self::VALUE_VG_3_VWIC_MBRD
     * @uses self::VALUE_ISR_2_NIM_MBRD
     * @uses self::VALUE_SM_X_NIM_ADPTR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NM_1_V,
            self::VALUE_NM_2_V,
            self::VALUE_NM_HDV,
            self::VALUE_VIC_SLOT,
            self::VALUE_NONE,
            self::VALUE_VWIC_SLOT,
            self::VALUE_FLEX_SLOT,
            self::VALUE_ANALOG,
            self::VALUE_DIGITAL,
            self::VALUE_VGC_PORT,
            self::VALUE_WS_X_6600,
            self::VALUE_AIM_VOICE_30_2_SUBUNITS,
            self::VALUE_NM_HDA,
            self::VALUE_PA_VXA,
            self::VALUE_PA_VXB,
            self::VALUE_PA_VXC,
            self::VALUE_PA_MCX,
            self::VALUE_NM_HD_1_V,
            self::VALUE_NM_HD_2_V,
            self::VALUE_NM_HD_2_VE,
            self::VALUE_GENERIC_SLOT,
            self::VALUE_NM_4_VWIC_MBRD,
            self::VALUE_EVM_HD,
            self::VALUE_NM_HDV_2_0_PORT,
            self::VALUE_NM_HDV_2_1_PORT_T_1,
            self::VALUE_NM_HDV_2_1_PORT_E_1,
            self::VALUE_NM_HDV_2_2_PORT_T_1,
            self::VALUE_NM_HDV_2_2_PORT_E_1,
            self::VALUE_AIM_VOICE_30_SLOT_0_3_SUBUNITS_SLOT_0_ONLY,
            self::VALUE_NM_3_VWIC_MBRD,
            self::VALUE_ISR_3_NIM_MBRD,
            self::VALUE_VG_2_VWIC_MBRD,
            self::VALUE_VG_3_VWIC_MBRD,
            self::VALUE_ISR_2_NIM_MBRD,
            self::VALUE_SM_X_NIM_ADPTR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
