<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XLocation StructType
 * @subpackage Structs
 */
class XLocation extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The withinAudioBandwidth
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $withinAudioBandwidth;
    /**
     * The withinVideoBandwidth
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $withinVideoBandwidth;
    /**
     * The withinImmersiveKbits
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $withinImmersiveKbits;
    /**
     * The betweenLocations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var BetweenLocations
     */
    public $betweenLocations;
    /**
     * The relatedLocations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var RelatedLocations
     */
    public $relatedLocations;
    /**
     * Constructor method for XLocation
     * @uses XLocation::setName()
     * @uses XLocation::setWithinAudioBandwidth()
     * @uses XLocation::setWithinVideoBandwidth()
     * @uses XLocation::setWithinImmersiveKbits()
     * @uses XLocation::setBetweenLocations()
     * @uses XLocation::setRelatedLocations()
     * @param string $name
     * @param string $withinAudioBandwidth
     * @param string $withinVideoBandwidth
     * @param string $withinImmersiveKbits
     * @param BetweenLocations $betweenLocations
     * @param RelatedLocations $relatedLocations
     */
    public function __construct($name = null, $withinAudioBandwidth = '0', $withinVideoBandwidth = '0', $withinImmersiveKbits = '0', BetweenLocations $betweenLocations = null, RelatedLocations $relatedLocations = null)
    {
        $this
            ->setName($name)
            ->setWithinAudioBandwidth($withinAudioBandwidth)
            ->setWithinVideoBandwidth($withinVideoBandwidth)
            ->setWithinImmersiveKbits($withinImmersiveKbits)
            ->setBetweenLocations($betweenLocations)
            ->setRelatedLocations($relatedLocations);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XLocation
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get withinAudioBandwidth value
     * @return string
     */
    public function getWithinAudioBandwidth()
    {
        return $this->withinAudioBandwidth;
    }
    /**
     * Set withinAudioBandwidth value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $withinAudioBandwidth
     * @return XLocation
     */
    public function setWithinAudioBandwidth($withinAudioBandwidth = '0')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($withinAudioBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $withinAudioBandwidth, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->withinAudioBandwidth = $withinAudioBandwidth;
        return $this;
    }
    /**
     * Get withinVideoBandwidth value
     * @return string
     */
    public function getWithinVideoBandwidth()
    {
        return $this->withinVideoBandwidth;
    }
    /**
     * Set withinVideoBandwidth value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $withinVideoBandwidth
     * @return XLocation
     */
    public function setWithinVideoBandwidth($withinVideoBandwidth = '0')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($withinVideoBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $withinVideoBandwidth, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->withinVideoBandwidth = $withinVideoBandwidth;
        return $this;
    }
    /**
     * Get withinImmersiveKbits value
     * @return string
     */
    public function getWithinImmersiveKbits()
    {
        return $this->withinImmersiveKbits;
    }
    /**
     * Set withinImmersiveKbits value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $withinImmersiveKbits
     * @return XLocation
     */
    public function setWithinImmersiveKbits($withinImmersiveKbits = '0')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($withinImmersiveKbits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $withinImmersiveKbits, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->withinImmersiveKbits = $withinImmersiveKbits;
        return $this;
    }
    /**
     * Get betweenLocations value
     * @return BetweenLocations
     */
    public function getBetweenLocations()
    {
        return $this->betweenLocations;
    }
    /**
     * Set betweenLocations value
     * @param BetweenLocations $betweenLocations
     * @return XLocation
     */
    public function setBetweenLocations(BetweenLocations $betweenLocations = null)
    {
        $this->betweenLocations = $betweenLocations;
        return $this;
    }
    /**
     * Get relatedLocations value
     * @return RelatedLocations|null
     */
    public function getRelatedLocations()
    {
        return $this->relatedLocations;
    }
    /**
     * Set relatedLocations value
     * @param RelatedLocations $relatedLocations
     * @return XLocation
     */
    public function setRelatedLocations(RelatedLocations $relatedLocations = null)
    {
        $this->relatedLocations = $relatedLocations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
