<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XLineGroup StructType
 * @subpackage Structs
 */
class XLineGroup extends AbstractStructBase
{
    /**
     * The distributionAlgorithm
     * Meta informations extracted from the WSDL
     * - default: Longest Idle Time
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $distributionAlgorithm;
    /**
     * The rnaReversionTimeOut
     * Meta informations extracted from the WSDL
     * - default: 10
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $rnaReversionTimeOut;
    /**
     * The huntAlgorithmNoAnswer
     * Meta informations extracted from the WSDL
     * - default: Try next member; then, try next group in Hunt List
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $huntAlgorithmNoAnswer;
    /**
     * The huntAlgorithmBusy
     * Meta informations extracted from the WSDL
     * - default: Try next member; then, try next group in Hunt List
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $huntAlgorithmBusy;
    /**
     * The huntAlgorithmNotAvailable
     * Meta informations extracted from the WSDL
     * - default: Try next member; then, try next group in Hunt List
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $huntAlgorithmNotAvailable;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Members
     */
    public $members;
    /**
     * The autoLogOffHunt
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $autoLogOffHunt;
    /**
     * Constructor method for XLineGroup
     * @uses XLineGroup::setDistributionAlgorithm()
     * @uses XLineGroup::setRnaReversionTimeOut()
     * @uses XLineGroup::setHuntAlgorithmNoAnswer()
     * @uses XLineGroup::setHuntAlgorithmBusy()
     * @uses XLineGroup::setHuntAlgorithmNotAvailable()
     * @uses XLineGroup::setName()
     * @uses XLineGroup::setMembers()
     * @uses XLineGroup::setAutoLogOffHunt()
     * @param string $distributionAlgorithm
     * @param string $rnaReversionTimeOut
     * @param string $huntAlgorithmNoAnswer
     * @param string $huntAlgorithmBusy
     * @param string $huntAlgorithmNotAvailable
     * @param string $name
     * @param Members $members
     * @param string $autoLogOffHunt
     */
    public function __construct($distributionAlgorithm = 'Longest Idle Time', $rnaReversionTimeOut = '10', $huntAlgorithmNoAnswer = 'Try next member; then, try next group in Hunt List', $huntAlgorithmBusy = 'Try next member; then, try next group in Hunt List', $huntAlgorithmNotAvailable = 'Try next member; then, try next group in Hunt List', $name = null, Members $members = null, $autoLogOffHunt = false)
    {
        $this
            ->setDistributionAlgorithm($distributionAlgorithm)
            ->setRnaReversionTimeOut($rnaReversionTimeOut)
            ->setHuntAlgorithmNoAnswer($huntAlgorithmNoAnswer)
            ->setHuntAlgorithmBusy($huntAlgorithmBusy)
            ->setHuntAlgorithmNotAvailable($huntAlgorithmNotAvailable)
            ->setName($name)
            ->setMembers($members)
            ->setAutoLogOffHunt($autoLogOffHunt);
    }
    /**
     * Get distributionAlgorithm value
     * @return string
     */
    public function getDistributionAlgorithm()
    {
        return $this->distributionAlgorithm;
    }
    /**
     * Set distributionAlgorithm value
     * @uses XDistributeAlgorithm::valueIsValid()
     * @uses XDistributeAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $distributionAlgorithm
     * @return XLineGroup
     */
    public function setDistributionAlgorithm($distributionAlgorithm = 'Longest Idle Time')
    {
        // validation for constraint: enumeration
        if (!XDistributeAlgorithm::valueIsValid($distributionAlgorithm)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $distributionAlgorithm, implode(', ', XDistributeAlgorithm::getValidValues())), __LINE__);
        }
        $this->distributionAlgorithm = $distributionAlgorithm;
        return $this;
    }
    /**
     * Get rnaReversionTimeOut value
     * @return string
     */
    public function getRnaReversionTimeOut()
    {
        return $this->rnaReversionTimeOut;
    }
    /**
     * Set rnaReversionTimeOut value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rnaReversionTimeOut
     * @return XLineGroup
     */
    public function setRnaReversionTimeOut($rnaReversionTimeOut = '10')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($rnaReversionTimeOut)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rnaReversionTimeOut, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->rnaReversionTimeOut = $rnaReversionTimeOut;
        return $this;
    }
    /**
     * Get huntAlgorithmNoAnswer value
     * @return string
     */
    public function getHuntAlgorithmNoAnswer()
    {
        return $this->huntAlgorithmNoAnswer;
    }
    /**
     * Set huntAlgorithmNoAnswer value
     * @uses XHuntAlgorithm::valueIsValid()
     * @uses XHuntAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $huntAlgorithmNoAnswer
     * @return XLineGroup
     */
    public function setHuntAlgorithmNoAnswer($huntAlgorithmNoAnswer = 'Try next member; then, try next group in Hunt List')
    {
        // validation for constraint: enumeration
        if (!XHuntAlgorithm::valueIsValid($huntAlgorithmNoAnswer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $huntAlgorithmNoAnswer, implode(', ', XHuntAlgorithm::getValidValues())), __LINE__);
        }
        $this->huntAlgorithmNoAnswer = $huntAlgorithmNoAnswer;
        return $this;
    }
    /**
     * Get huntAlgorithmBusy value
     * @return string
     */
    public function getHuntAlgorithmBusy()
    {
        return $this->huntAlgorithmBusy;
    }
    /**
     * Set huntAlgorithmBusy value
     * @uses XHuntAlgorithm::valueIsValid()
     * @uses XHuntAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $huntAlgorithmBusy
     * @return XLineGroup
     */
    public function setHuntAlgorithmBusy($huntAlgorithmBusy = 'Try next member; then, try next group in Hunt List')
    {
        // validation for constraint: enumeration
        if (!XHuntAlgorithm::valueIsValid($huntAlgorithmBusy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $huntAlgorithmBusy, implode(', ', XHuntAlgorithm::getValidValues())), __LINE__);
        }
        $this->huntAlgorithmBusy = $huntAlgorithmBusy;
        return $this;
    }
    /**
     * Get huntAlgorithmNotAvailable value
     * @return string
     */
    public function getHuntAlgorithmNotAvailable()
    {
        return $this->huntAlgorithmNotAvailable;
    }
    /**
     * Set huntAlgorithmNotAvailable value
     * @uses XHuntAlgorithm::valueIsValid()
     * @uses XHuntAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $huntAlgorithmNotAvailable
     * @return XLineGroup
     */
    public function setHuntAlgorithmNotAvailable($huntAlgorithmNotAvailable = 'Try next member; then, try next group in Hunt List')
    {
        // validation for constraint: enumeration
        if (!XHuntAlgorithm::valueIsValid($huntAlgorithmNotAvailable)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $huntAlgorithmNotAvailable, implode(', ', XHuntAlgorithm::getValidValues())), __LINE__);
        }
        $this->huntAlgorithmNotAvailable = $huntAlgorithmNotAvailable;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XLineGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get members value
     * @return Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param Members $members
     * @return XLineGroup
     */
    public function setMembers(Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get autoLogOffHunt value
     * @return string|null
     */
    public function getAutoLogOffHunt()
    {
        return $this->autoLogOffHunt;
    }
    /**
     * Set autoLogOffHunt value
     * @param string $autoLogOffHunt
     * @return XLineGroup
     */
    public function setAutoLogOffHunt($autoLogOffHunt = false)
    {
        // validation for constraint: pattern
        if (is_scalar($autoLogOffHunt) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $autoLogOffHunt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($autoLogOffHunt, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($autoLogOffHunt) && !is_string($autoLogOffHunt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($autoLogOffHunt)), __LINE__);
        }
        $this->autoLogOffHunt = $autoLogOffHunt;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XLineGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
