<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XIpPhoneServices StructType
 * @subpackage Structs
 */
class XIpPhoneServices extends AbstractStructBase
{
    /**
     * The serviceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $serviceName;
    /**
     * The asciiServiceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $asciiServiceName;
    /**
     * The serviceUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $serviceUrl;
    /**
     * The serviceCategory
     * Meta informations extracted from the WSDL
     * - default: XML Service
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $serviceCategory;
    /**
     * The serviceType
     * Meta informations extracted from the WSDL
     * - default: Standard IP Phone Service
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $serviceType;
    /**
     * The serviceDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 128
     * @var string
     */
    public $serviceDescription;
    /**
     * The secureServiceUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $secureServiceUrl;
    /**
     * The serviceVendor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $serviceVendor;
    /**
     * The serviceVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $serviceVersion;
    /**
     * The enabled
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enabled;
    /**
     * The enterpriseSubscription
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enterpriseSubscription;
    /**
     * The parameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Parameters
     */
    public $parameters;
    /**
     * Constructor method for XIpPhoneServices
     * @uses XIpPhoneServices::setServiceName()
     * @uses XIpPhoneServices::setAsciiServiceName()
     * @uses XIpPhoneServices::setServiceUrl()
     * @uses XIpPhoneServices::setServiceCategory()
     * @uses XIpPhoneServices::setServiceType()
     * @uses XIpPhoneServices::setServiceDescription()
     * @uses XIpPhoneServices::setSecureServiceUrl()
     * @uses XIpPhoneServices::setServiceVendor()
     * @uses XIpPhoneServices::setServiceVersion()
     * @uses XIpPhoneServices::setEnabled()
     * @uses XIpPhoneServices::setEnterpriseSubscription()
     * @uses XIpPhoneServices::setParameters()
     * @param string $serviceName
     * @param string $asciiServiceName
     * @param string $serviceUrl
     * @param string $serviceCategory
     * @param string $serviceType
     * @param string $serviceDescription
     * @param string $secureServiceUrl
     * @param string $serviceVendor
     * @param string $serviceVersion
     * @param string $enabled
     * @param string $enterpriseSubscription
     * @param Parameters $parameters
     */
    public function __construct($serviceName = null, $asciiServiceName = null, $serviceUrl = null, $serviceCategory = 'XML Service', $serviceType = 'Standard IP Phone Service', $serviceDescription = null, $secureServiceUrl = null, $serviceVendor = null, $serviceVersion = null, $enabled = true, $enterpriseSubscription = false, Parameters $parameters = null)
    {
        $this
            ->setServiceName($serviceName)
            ->setAsciiServiceName($asciiServiceName)
            ->setServiceUrl($serviceUrl)
            ->setServiceCategory($serviceCategory)
            ->setServiceType($serviceType)
            ->setServiceDescription($serviceDescription)
            ->setSecureServiceUrl($secureServiceUrl)
            ->setServiceVendor($serviceVendor)
            ->setServiceVersion($serviceVersion)
            ->setEnabled($enabled)
            ->setEnterpriseSubscription($enterpriseSubscription)
            ->setParameters($parameters);
    }
    /**
     * Get serviceName value
     * @return string
     */
    public function getServiceName()
    {
        return $this->serviceName;
    }
    /**
     * Set serviceName value
     * @param string $serviceName
     * @return XIpPhoneServices
     */
    public function setServiceName($serviceName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($serviceName) && strlen($serviceName) > 128) || (is_array($serviceName) && count($serviceName) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($serviceName) ? strlen($serviceName) : count($serviceName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($serviceName) && !is_string($serviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceName)), __LINE__);
        }
        $this->serviceName = $serviceName;
        return $this;
    }
    /**
     * Get asciiServiceName value
     * @return string
     */
    public function getAsciiServiceName()
    {
        return $this->asciiServiceName;
    }
    /**
     * Set asciiServiceName value
     * @param string $asciiServiceName
     * @return XIpPhoneServices
     */
    public function setAsciiServiceName($asciiServiceName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($asciiServiceName) && strlen($asciiServiceName) > 128) || (is_array($asciiServiceName) && count($asciiServiceName) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($asciiServiceName) ? strlen($asciiServiceName) : count($asciiServiceName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($asciiServiceName) && !is_string($asciiServiceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($asciiServiceName)), __LINE__);
        }
        $this->asciiServiceName = $asciiServiceName;
        return $this;
    }
    /**
     * Get serviceUrl value
     * @return string
     */
    public function getServiceUrl()
    {
        return $this->serviceUrl;
    }
    /**
     * Set serviceUrl value
     * @param string $serviceUrl
     * @return XIpPhoneServices
     */
    public function setServiceUrl($serviceUrl = null)
    {
        // validation for constraint: string
        if (!is_null($serviceUrl) && !is_string($serviceUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceUrl)), __LINE__);
        }
        $this->serviceUrl = $serviceUrl;
        return $this;
    }
    /**
     * Get serviceCategory value
     * @return string
     */
    public function getServiceCategory()
    {
        return $this->serviceCategory;
    }
    /**
     * Set serviceCategory value
     * @uses XPhoneServiceCategory::valueIsValid()
     * @uses XPhoneServiceCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceCategory
     * @return XIpPhoneServices
     */
    public function setServiceCategory($serviceCategory = 'XML Service')
    {
        // validation for constraint: enumeration
        if (!XPhoneServiceCategory::valueIsValid($serviceCategory)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceCategory, implode(', ', XPhoneServiceCategory::getValidValues())), __LINE__);
        }
        $this->serviceCategory = $serviceCategory;
        return $this;
    }
    /**
     * Get serviceType value
     * @return string
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses XPhoneService::valueIsValid()
     * @uses XPhoneService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return XIpPhoneServices
     */
    public function setServiceType($serviceType = 'Standard IP Phone Service')
    {
        // validation for constraint: enumeration
        if (!XPhoneService::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', XPhoneService::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get serviceDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceDescription()
    {
        return isset($this->serviceDescription) ? $this->serviceDescription : null;
    }
    /**
     * Set serviceDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceDescription
     * @return XIpPhoneServices
     */
    public function setServiceDescription($serviceDescription = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($serviceDescription) && strlen($serviceDescription) > 128) || (is_array($serviceDescription) && count($serviceDescription) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($serviceDescription) ? strlen($serviceDescription) : count($serviceDescription)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($serviceDescription) && !is_string($serviceDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceDescription)), __LINE__);
        }
        if (is_null($serviceDescription) || (is_array($serviceDescription) && empty($serviceDescription))) {
            unset($this->serviceDescription);
        } else {
            $this->serviceDescription = $serviceDescription;
        }
        return $this;
    }
    /**
     * Get secureServiceUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecureServiceUrl()
    {
        return isset($this->secureServiceUrl) ? $this->secureServiceUrl : null;
    }
    /**
     * Set secureServiceUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $secureServiceUrl
     * @return XIpPhoneServices
     */
    public function setSecureServiceUrl($secureServiceUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureServiceUrl) && !is_string($secureServiceUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureServiceUrl)), __LINE__);
        }
        if (is_null($secureServiceUrl) || (is_array($secureServiceUrl) && empty($secureServiceUrl))) {
            unset($this->secureServiceUrl);
        } else {
            $this->secureServiceUrl = $secureServiceUrl;
        }
        return $this;
    }
    /**
     * Get serviceVendor value
     * @return string|null
     */
    public function getServiceVendor()
    {
        return $this->serviceVendor;
    }
    /**
     * Set serviceVendor value
     * @param string $serviceVendor
     * @return XIpPhoneServices
     */
    public function setServiceVendor($serviceVendor = null)
    {
        // validation for constraint: string
        if (!is_null($serviceVendor) && !is_string($serviceVendor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceVendor)), __LINE__);
        }
        $this->serviceVendor = $serviceVendor;
        return $this;
    }
    /**
     * Get serviceVersion value
     * @return string|null
     */
    public function getServiceVersion()
    {
        return $this->serviceVersion;
    }
    /**
     * Set serviceVersion value
     * @param string $serviceVersion
     * @return XIpPhoneServices
     */
    public function setServiceVersion($serviceVersion = null)
    {
        // validation for constraint: string
        if (!is_null($serviceVersion) && !is_string($serviceVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceVersion)), __LINE__);
        }
        $this->serviceVersion = $serviceVersion;
        return $this;
    }
    /**
     * Get enabled value
     * @return string|null
     */
    public function getEnabled()
    {
        return $this->enabled;
    }
    /**
     * Set enabled value
     * @param string $enabled
     * @return XIpPhoneServices
     */
    public function setEnabled($enabled = true)
    {
        // validation for constraint: pattern
        if (is_scalar($enabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enabled) && !is_string($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enabled)), __LINE__);
        }
        $this->enabled = $enabled;
        return $this;
    }
    /**
     * Get enterpriseSubscription value
     * @return string|null
     */
    public function getEnterpriseSubscription()
    {
        return $this->enterpriseSubscription;
    }
    /**
     * Set enterpriseSubscription value
     * @param string $enterpriseSubscription
     * @return XIpPhoneServices
     */
    public function setEnterpriseSubscription($enterpriseSubscription = false)
    {
        // validation for constraint: pattern
        if (is_scalar($enterpriseSubscription) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enterpriseSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enterpriseSubscription, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enterpriseSubscription) && !is_string($enterpriseSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enterpriseSubscription)), __LINE__);
        }
        $this->enterpriseSubscription = $enterpriseSubscription;
        return $this;
    }
    /**
     * Get parameters value
     * @return Parameters|null
     */
    public function getParameters()
    {
        return $this->parameters;
    }
    /**
     * Set parameters value
     * @param Parameters $parameters
     * @return XIpPhoneServices
     */
    public function setParameters(Parameters $parameters = null)
    {
        $this->parameters = $parameters;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XIpPhoneServices
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
