<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XExtension StructType
 * @subpackage Structs
 */
class XExtension extends AbstractStructBase
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var XFkType
     */
    public $pattern;
    /**
     * The sortOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sortOrder;
    /**
     * The routePartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $routePartition;
    /**
     * The linePrimaryUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $linePrimaryUri;
    /**
     * The partition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $partition;
    /**
     * Constructor method for XExtension
     * @uses XExtension::setPattern()
     * @uses XExtension::setSortOrder()
     * @uses XExtension::setRoutePartition()
     * @uses XExtension::setLinePrimaryUri()
     * @uses XExtension::setPartition()
     * @param XFkType $pattern
     * @param string $sortOrder
     * @param string $routePartition
     * @param string $linePrimaryUri
     * @param XFkType $partition
     */
    public function __construct(XFkType $pattern = null, $sortOrder = null, $routePartition = null, $linePrimaryUri = null, XFkType $partition = null)
    {
        $this
            ->setPattern($pattern)
            ->setSortOrder($sortOrder)
            ->setRoutePartition($routePartition)
            ->setLinePrimaryUri($linePrimaryUri)
            ->setPartition($partition);
    }
    /**
     * Get pattern value
     * @return XFkType
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param XFkType $pattern
     * @return XExtension
     */
    public function setPattern(XFkType $pattern = null)
    {
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get sortOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSortOrder()
    {
        return isset($this->sortOrder) ? $this->sortOrder : null;
    }
    /**
     * Set sortOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sortOrder
     * @return XExtension
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sortOrder, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($sortOrder) || (is_array($sortOrder) && empty($sortOrder))) {
            unset($this->sortOrder);
        } else {
            $this->sortOrder = $sortOrder;
        }
        return $this;
    }
    /**
     * Get routePartition value
     * @return string|null
     */
    public function getRoutePartition()
    {
        return $this->routePartition;
    }
    /**
     * Set routePartition value
     * @param string $routePartition
     * @return XExtension
     */
    public function setRoutePartition($routePartition = null)
    {
        // validation for constraint: string
        if (!is_null($routePartition) && !is_string($routePartition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routePartition)), __LINE__);
        }
        $this->routePartition = $routePartition;
        return $this;
    }
    /**
     * Get linePrimaryUri value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLinePrimaryUri()
    {
        return isset($this->linePrimaryUri) ? $this->linePrimaryUri : null;
    }
    /**
     * Set linePrimaryUri value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $linePrimaryUri
     * @return XExtension
     */
    public function setLinePrimaryUri($linePrimaryUri = null)
    {
        // validation for constraint: string
        if (!is_null($linePrimaryUri) && !is_string($linePrimaryUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($linePrimaryUri)), __LINE__);
        }
        if (is_null($linePrimaryUri) || (is_array($linePrimaryUri) && empty($linePrimaryUri))) {
            unset($this->linePrimaryUri);
        } else {
            $this->linePrimaryUri = $linePrimaryUri;
        }
        return $this;
    }
    /**
     * Get partition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getPartition()
    {
        return isset($this->partition) ? $this->partition : null;
    }
    /**
     * Set partition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $partition
     * @return XExtension
     */
    public function setPartition(XFkType $partition = null)
    {
        if (is_null($partition) || (is_array($partition) && empty($partition))) {
            unset($this->partition);
        } else {
            $this->partition = $partition;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XExtension
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
