<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XEnterpriseFeatureAccessConfiguration StructType
 * @subpackage Structs
 */
class XEnterpriseFeatureAccessConfiguration extends AbstractStructBase
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $pattern;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $routePartitionName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The isDefaultEafNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isDefaultEafNumber;
    /**
     * Constructor method for XEnterpriseFeatureAccessConfiguration
     * @uses XEnterpriseFeatureAccessConfiguration::setPattern()
     * @uses XEnterpriseFeatureAccessConfiguration::setRoutePartitionName()
     * @uses XEnterpriseFeatureAccessConfiguration::setDescription()
     * @uses XEnterpriseFeatureAccessConfiguration::setIsDefaultEafNumber()
     * @param string $pattern
     * @param XFkType $routePartitionName
     * @param string $description
     * @param string $isDefaultEafNumber
     */
    public function __construct($pattern = null, XFkType $routePartitionName = null, $description = null, $isDefaultEafNumber = null)
    {
        $this
            ->setPattern($pattern)
            ->setRoutePartitionName($routePartitionName)
            ->setDescription($description)
            ->setIsDefaultEafNumber($isDefaultEafNumber);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return XEnterpriseFeatureAccessConfiguration
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pattern) && strlen($pattern) > 16) || (is_array($pattern) && count($pattern) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($pattern) ? strlen($pattern) : count($pattern)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get routePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getRoutePartitionName()
    {
        return isset($this->routePartitionName) ? $this->routePartitionName : null;
    }
    /**
     * Set routePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $routePartitionName
     * @return XEnterpriseFeatureAccessConfiguration
     */
    public function setRoutePartitionName(XFkType $routePartitionName = null)
    {
        if (is_null($routePartitionName) || (is_array($routePartitionName) && empty($routePartitionName))) {
            unset($this->routePartitionName);
        } else {
            $this->routePartitionName = $routePartitionName;
        }
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return XEnterpriseFeatureAccessConfiguration
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isDefaultEafNumber value
     * @return string|null
     */
    public function getIsDefaultEafNumber()
    {
        return $this->isDefaultEafNumber;
    }
    /**
     * Set isDefaultEafNumber value
     * @param string $isDefaultEafNumber
     * @return XEnterpriseFeatureAccessConfiguration
     */
    public function setIsDefaultEafNumber($isDefaultEafNumber = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isDefaultEafNumber) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isDefaultEafNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isDefaultEafNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isDefaultEafNumber) && !is_string($isDefaultEafNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isDefaultEafNumber)), __LINE__);
        }
        $this->isDefaultEafNumber = $isDefaultEafNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XEnterpriseFeatureAccessConfiguration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
