<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XDeviceProfile StructType
 * @subpackage Structs
 */
class XDeviceProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $product;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta informations extracted from the WSDL
     * - default: User
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $protocolSide;
    /**
     * The phoneTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $phoneTemplateName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: Optional description of the device
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The userHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The vendorConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XVendorConfig
     */
    public $vendorConfig;
    /**
     * The traceFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $traceFlag;
    /**
     * The mlppDomainId
     * Meta informations extracted from the WSDL
     * - documentation: This setting only effects devices that support MLPP. Use -1 to set to null
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 128
     * @var string
     */
    public $mlppDomainId;
    /**
     * The mlppIndicationStatus
     * Meta informations extracted from the WSDL
     * - default: Off
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta informations extracted from the WSDL
     * - default: Default
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $preemption;
    /**
     * The lines
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Lines
     */
    public $lines;
    /**
     * The speeddials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Speeddials
     */
    public $speeddials;
    /**
     * The busyLampFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var BusyLampFields
     */
    public $busyLampFields;
    /**
     * The blfDirectedCallParks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var BlfDirectedCallParks
     */
    public $blfDirectedCallParks;
    /**
     * The addOnModules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AddOnModules
     */
    public $addOnModules;
    /**
     * The userLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userLocale;
    /**
     * The singleButtonBarge
     * Meta informations extracted from the WSDL
     * - default: Default
     * - documentation: This tag is valid only for devices that support SBB.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $singleButtonBarge;
    /**
     * The joinAcrossLines
     * Meta informations extracted from the WSDL
     * - default: Default
     * - documentation: This tag is valid only for devices that support JAL..
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $joinAcrossLines;
    /**
     * The loginUserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $loginUserId;
    /**
     * The ignorePresentationIndicators
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: The new Ignore Presentation Indicators flag for Hospitality feature is required for most phones andand device profiles. Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ignorePresentationIndicators;
    /**
     * The dndOption
     * Meta informations extracted from the WSDL
     * - default: Ringer Off
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dndOption;
    /**
     * The dndRingSetting
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dndRingSetting;
    /**
     * The dndStatus
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $dndStatus;
    /**
     * The emccCallingSearchSpace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $emccCallingSearchSpace;
    /**
     * The alwaysUsePrimeLine
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The softkeyTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $softkeyTemplateName;
    /**
     * The callInfoPrivacyStatus
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callInfoPrivacyStatus;
    /**
     * The services
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Services
     */
    public $services;
    /**
     * The featureControlPolicy
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for RT Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $featureControlPolicy;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * Constructor method for XDeviceProfile
     * @uses XDeviceProfile::setName()
     * @uses XDeviceProfile::setProduct()
     * @uses XDeviceProfile::setClass()
     * @uses XDeviceProfile::setProtocol()
     * @uses XDeviceProfile::setProtocolSide()
     * @uses XDeviceProfile::setPhoneTemplateName()
     * @uses XDeviceProfile::setDescription()
     * @uses XDeviceProfile::setUserHoldMohAudioSourceId()
     * @uses XDeviceProfile::setVendorConfig()
     * @uses XDeviceProfile::setTraceFlag()
     * @uses XDeviceProfile::setMlppDomainId()
     * @uses XDeviceProfile::setMlppIndicationStatus()
     * @uses XDeviceProfile::setPreemption()
     * @uses XDeviceProfile::setLines()
     * @uses XDeviceProfile::setSpeeddials()
     * @uses XDeviceProfile::setBusyLampFields()
     * @uses XDeviceProfile::setBlfDirectedCallParks()
     * @uses XDeviceProfile::setAddOnModules()
     * @uses XDeviceProfile::setUserLocale()
     * @uses XDeviceProfile::setSingleButtonBarge()
     * @uses XDeviceProfile::setJoinAcrossLines()
     * @uses XDeviceProfile::setLoginUserId()
     * @uses XDeviceProfile::setIgnorePresentationIndicators()
     * @uses XDeviceProfile::setDndOption()
     * @uses XDeviceProfile::setDndRingSetting()
     * @uses XDeviceProfile::setDndStatus()
     * @uses XDeviceProfile::setEmccCallingSearchSpace()
     * @uses XDeviceProfile::setAlwaysUsePrimeLine()
     * @uses XDeviceProfile::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses XDeviceProfile::setSoftkeyTemplateName()
     * @uses XDeviceProfile::setCallInfoPrivacyStatus()
     * @uses XDeviceProfile::setServices()
     * @uses XDeviceProfile::setFeatureControlPolicy()
     * @uses XDeviceProfile::setCtiid()
     * @param string $name
     * @param string $product
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param XFkType $phoneTemplateName
     * @param string $description
     * @param string $userHoldMohAudioSourceId
     * @param XVendorConfig $vendorConfig
     * @param string $traceFlag
     * @param string $mlppDomainId
     * @param string $mlppIndicationStatus
     * @param string $preemption
     * @param Lines $lines
     * @param Speeddials $speeddials
     * @param BusyLampFields $busyLampFields
     * @param BlfDirectedCallParks $blfDirectedCallParks
     * @param AddOnModules $addOnModules
     * @param string $userLocale
     * @param string $singleButtonBarge
     * @param string $joinAcrossLines
     * @param XFkType $loginUserId
     * @param string $ignorePresentationIndicators
     * @param string $dndOption
     * @param string $dndRingSetting
     * @param string $dndStatus
     * @param XFkType $emccCallingSearchSpace
     * @param string $alwaysUsePrimeLine
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @param XFkType $softkeyTemplateName
     * @param string $callInfoPrivacyStatus
     * @param Services $services
     * @param XFkType $featureControlPolicy
     * @param int $ctiid
     */
    public function __construct($name = null, $product = null, $class = null, $protocol = null, $protocolSide = 'User', XFkType $phoneTemplateName = null, $description = null, $userHoldMohAudioSourceId = null, XVendorConfig $vendorConfig = null, $traceFlag = null, $mlppDomainId = null, $mlppIndicationStatus = 'Off', $preemption = 'Default', Lines $lines = null, Speeddials $speeddials = null, BusyLampFields $busyLampFields = null, BlfDirectedCallParks $blfDirectedCallParks = null, AddOnModules $addOnModules = null, $userLocale = null, $singleButtonBarge = 'Default', $joinAcrossLines = 'Default', XFkType $loginUserId = null, $ignorePresentationIndicators = false, $dndOption = 'Ringer Off', $dndRingSetting = null, $dndStatus = null, XFkType $emccCallingSearchSpace = null, $alwaysUsePrimeLine = 'Default', $alwaysUsePrimeLineForVoiceMessage = 'Default', XFkType $softkeyTemplateName = null, $callInfoPrivacyStatus = 'Default', Services $services = null, XFkType $featureControlPolicy = null, $ctiid = null)
    {
        $this
            ->setName($name)
            ->setProduct($product)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setPhoneTemplateName($phoneTemplateName)
            ->setDescription($description)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setVendorConfig($vendorConfig)
            ->setTraceFlag($traceFlag)
            ->setMlppDomainId($mlppDomainId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setLines($lines)
            ->setSpeeddials($speeddials)
            ->setBusyLampFields($busyLampFields)
            ->setBlfDirectedCallParks($blfDirectedCallParks)
            ->setAddOnModules($addOnModules)
            ->setUserLocale($userLocale)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setLoginUserId($loginUserId)
            ->setIgnorePresentationIndicators($ignorePresentationIndicators)
            ->setDndOption($dndOption)
            ->setDndRingSetting($dndRingSetting)
            ->setDndStatus($dndStatus)
            ->setEmccCallingSearchSpace($emccCallingSearchSpace)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setSoftkeyTemplateName($softkeyTemplateName)
            ->setCallInfoPrivacyStatus($callInfoPrivacyStatus)
            ->setServices($services)
            ->setFeatureControlPolicy($featureControlPolicy)
            ->setCtiid($ctiid);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XDeviceProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses XProduct::valueIsValid()
     * @uses XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return XDeviceProfile
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get class value
     * @return string
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses XClass::valueIsValid()
     * @uses XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return XDeviceProfile
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $class, implode(', ', XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses XDeviceProtocol::valueIsValid()
     * @uses XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return XDeviceProfile
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocol, implode(', ', XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @uses XProtocolSide::valueIsValid()
     * @uses XProtocolSide::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocolSide
     * @return XDeviceProfile
     */
    public function setProtocolSide($protocolSide = 'User')
    {
        // validation for constraint: enumeration
        if (!XProtocolSide::valueIsValid($protocolSide)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocolSide, implode(', ', XProtocolSide::getValidValues())), __LINE__);
        }
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get phoneTemplateName value
     * @return XFkType
     */
    public function getPhoneTemplateName()
    {
        return $this->phoneTemplateName;
    }
    /**
     * Set phoneTemplateName value
     * @param XFkType $phoneTemplateName
     * @return XDeviceProfile
     */
    public function setPhoneTemplateName(XFkType $phoneTemplateName = null)
    {
        $this->phoneTemplateName = $phoneTemplateName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return XDeviceProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return isset($this->userHoldMohAudioSourceId) ? $this->userHoldMohAudioSourceId : null;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XMOHAudioSourceId::valueIsValid()
     * @uses XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userHoldMohAudioSourceId
     * @return XDeviceProfile
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!XMOHAudioSourceId::valueIsValid($userHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userHoldMohAudioSourceId, implode(', ', XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        if (is_null($userHoldMohAudioSourceId) || (is_array($userHoldMohAudioSourceId) && empty($userHoldMohAudioSourceId))) {
            unset($this->userHoldMohAudioSourceId);
        } else {
            $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        }
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param XVendorConfig $vendorConfig
     * @return XDeviceProfile
     */
    public function setVendorConfig(XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get traceFlag value
     * @return string|null
     */
    public function getTraceFlag()
    {
        return $this->traceFlag;
    }
    /**
     * Set traceFlag value
     * @param string $traceFlag
     * @return XDeviceProfile
     */
    public function setTraceFlag($traceFlag = null)
    {
        // validation for constraint: pattern
        if (is_scalar($traceFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($traceFlag, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($traceFlag) && !is_string($traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($traceFlag)), __LINE__);
        }
        $this->traceFlag = $traceFlag;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return isset($this->mlppDomainId) ? $this->mlppDomainId : null;
    }
    /**
     * Set mlppDomainId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mlppDomainId
     * @return XDeviceProfile
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mlppDomainId) && strlen($mlppDomainId) > 128) || (is_array($mlppDomainId) && count($mlppDomainId) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($mlppDomainId) ? strlen($mlppDomainId) : count($mlppDomainId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mlppDomainId) && !is_string($mlppDomainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mlppDomainId)), __LINE__);
        }
        if (is_null($mlppDomainId) || (is_array($mlppDomainId) && empty($mlppDomainId))) {
            unset($this->mlppDomainId);
        } else {
            $this->mlppDomainId = $mlppDomainId;
        }
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppIndicationStatus
     * @return XDeviceProfile
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = 'Off')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($mlppIndicationStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mlppIndicationStatus, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return string|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @uses XPreemption::valueIsValid()
     * @uses XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preemption
     * @return XDeviceProfile
     */
    public function setPreemption($preemption = 'Default')
    {
        // validation for constraint: enumeration
        if (!XPreemption::valueIsValid($preemption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preemption, implode(', ', XPreemption::getValidValues())), __LINE__);
        }
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get lines value
     * @return Lines|null
     */
    public function getLines()
    {
        return $this->lines;
    }
    /**
     * Set lines value
     * @param Lines $lines
     * @return XDeviceProfile
     */
    public function setLines(Lines $lines = null)
    {
        $this->lines = $lines;
        return $this;
    }
    /**
     * Get speeddials value
     * @return Speeddials|null
     */
    public function getSpeeddials()
    {
        return $this->speeddials;
    }
    /**
     * Set speeddials value
     * @param Speeddials $speeddials
     * @return XDeviceProfile
     */
    public function setSpeeddials(Speeddials $speeddials = null)
    {
        $this->speeddials = $speeddials;
        return $this;
    }
    /**
     * Get busyLampFields value
     * @return BusyLampFields|null
     */
    public function getBusyLampFields()
    {
        return $this->busyLampFields;
    }
    /**
     * Set busyLampFields value
     * @param BusyLampFields $busyLampFields
     * @return XDeviceProfile
     */
    public function setBusyLampFields(BusyLampFields $busyLampFields = null)
    {
        $this->busyLampFields = $busyLampFields;
        return $this;
    }
    /**
     * Get blfDirectedCallParks value
     * @return BlfDirectedCallParks|null
     */
    public function getBlfDirectedCallParks()
    {
        return $this->blfDirectedCallParks;
    }
    /**
     * Set blfDirectedCallParks value
     * @param BlfDirectedCallParks $blfDirectedCallParks
     * @return XDeviceProfile
     */
    public function setBlfDirectedCallParks(BlfDirectedCallParks $blfDirectedCallParks = null)
    {
        $this->blfDirectedCallParks = $blfDirectedCallParks;
        return $this;
    }
    /**
     * Get addOnModules value
     * @return AddOnModules|null
     */
    public function getAddOnModules()
    {
        return $this->addOnModules;
    }
    /**
     * Set addOnModules value
     * @param AddOnModules $addOnModules
     * @return XDeviceProfile
     */
    public function setAddOnModules(AddOnModules $addOnModules = null)
    {
        $this->addOnModules = $addOnModules;
        return $this;
    }
    /**
     * Get userLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserLocale()
    {
        return isset($this->userLocale) ? $this->userLocale : null;
    }
    /**
     * Set userLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XUserLocale::valueIsValid()
     * @uses XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userLocale
     * @return XDeviceProfile
     */
    public function setUserLocale($userLocale = null)
    {
        // validation for constraint: enumeration
        if (!XUserLocale::valueIsValid($userLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userLocale, implode(', ', XUserLocale::getValidValues())), __LINE__);
        }
        if (is_null($userLocale) || (is_array($userLocale) && empty($userLocale))) {
            unset($this->userLocale);
        } else {
            $this->userLocale = $userLocale;
        }
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return string|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @uses XBarge::valueIsValid()
     * @uses XBarge::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $singleButtonBarge
     * @return XDeviceProfile
     */
    public function setSingleButtonBarge($singleButtonBarge = 'Default')
    {
        // validation for constraint: enumeration
        if (!XBarge::valueIsValid($singleButtonBarge)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $singleButtonBarge, implode(', ', XBarge::getValidValues())), __LINE__);
        }
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return string|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $joinAcrossLines
     * @return XDeviceProfile
     */
    public function setJoinAcrossLines($joinAcrossLines = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($joinAcrossLines)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $joinAcrossLines, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get loginUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getLoginUserId()
    {
        return isset($this->loginUserId) ? $this->loginUserId : null;
    }
    /**
     * Set loginUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $loginUserId
     * @return XDeviceProfile
     */
    public function setLoginUserId(XFkType $loginUserId = null)
    {
        if (is_null($loginUserId) || (is_array($loginUserId) && empty($loginUserId))) {
            unset($this->loginUserId);
        } else {
            $this->loginUserId = $loginUserId;
        }
        return $this;
    }
    /**
     * Get ignorePresentationIndicators value
     * @return string|null
     */
    public function getIgnorePresentationIndicators()
    {
        return $this->ignorePresentationIndicators;
    }
    /**
     * Set ignorePresentationIndicators value
     * @param string $ignorePresentationIndicators
     * @return XDeviceProfile
     */
    public function setIgnorePresentationIndicators($ignorePresentationIndicators = false)
    {
        // validation for constraint: pattern
        if (is_scalar($ignorePresentationIndicators) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $ignorePresentationIndicators)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($ignorePresentationIndicators, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ignorePresentationIndicators) && !is_string($ignorePresentationIndicators)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ignorePresentationIndicators)), __LINE__);
        }
        $this->ignorePresentationIndicators = $ignorePresentationIndicators;
        return $this;
    }
    /**
     * Get dndOption value
     * @return string|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @uses XDNDOption::valueIsValid()
     * @uses XDNDOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndOption
     * @return XDeviceProfile
     */
    public function setDndOption($dndOption = 'Ringer Off')
    {
        // validation for constraint: enumeration
        if (!XDNDOption::valueIsValid($dndOption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndOption, implode(', ', XDNDOption::getValidValues())), __LINE__);
        }
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get dndRingSetting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDndRingSetting()
    {
        return isset($this->dndRingSetting) ? $this->dndRingSetting : null;
    }
    /**
     * Set dndRingSetting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XRingSetting::valueIsValid()
     * @uses XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndRingSetting
     * @return XDeviceProfile
     */
    public function setDndRingSetting($dndRingSetting = null)
    {
        // validation for constraint: enumeration
        if (!XRingSetting::valueIsValid($dndRingSetting)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndRingSetting, implode(', ', XRingSetting::getValidValues())), __LINE__);
        }
        if (is_null($dndRingSetting) || (is_array($dndRingSetting) && empty($dndRingSetting))) {
            unset($this->dndRingSetting);
        } else {
            $this->dndRingSetting = $dndRingSetting;
        }
        return $this;
    }
    /**
     * Get dndStatus value
     * @return string|null
     */
    public function getDndStatus()
    {
        return $this->dndStatus;
    }
    /**
     * Set dndStatus value
     * @param string $dndStatus
     * @return XDeviceProfile
     */
    public function setDndStatus($dndStatus = null)
    {
        // validation for constraint: pattern
        if (is_scalar($dndStatus) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $dndStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($dndStatus, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dndStatus) && !is_string($dndStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dndStatus)), __LINE__);
        }
        $this->dndStatus = $dndStatus;
        return $this;
    }
    /**
     * Get emccCallingSearchSpace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getEmccCallingSearchSpace()
    {
        return isset($this->emccCallingSearchSpace) ? $this->emccCallingSearchSpace : null;
    }
    /**
     * Set emccCallingSearchSpace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $emccCallingSearchSpace
     * @return XDeviceProfile
     */
    public function setEmccCallingSearchSpace(XFkType $emccCallingSearchSpace = null)
    {
        if (is_null($emccCallingSearchSpace) || (is_array($emccCallingSearchSpace) && empty($emccCallingSearchSpace))) {
            unset($this->emccCallingSearchSpace);
        } else {
            $this->emccCallingSearchSpace = $emccCallingSearchSpace;
        }
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return string|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLine
     * @return XDeviceProfile
     */
    public function setAlwaysUsePrimeLine($alwaysUsePrimeLine = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($alwaysUsePrimeLine)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLine, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return string|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @return XDeviceProfile
     */
    public function setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($alwaysUsePrimeLineForVoiceMessage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLineForVoiceMessage, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get softkeyTemplateName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getSoftkeyTemplateName()
    {
        return isset($this->softkeyTemplateName) ? $this->softkeyTemplateName : null;
    }
    /**
     * Set softkeyTemplateName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $softkeyTemplateName
     * @return XDeviceProfile
     */
    public function setSoftkeyTemplateName(XFkType $softkeyTemplateName = null)
    {
        if (is_null($softkeyTemplateName) || (is_array($softkeyTemplateName) && empty($softkeyTemplateName))) {
            unset($this->softkeyTemplateName);
        } else {
            $this->softkeyTemplateName = $softkeyTemplateName;
        }
        return $this;
    }
    /**
     * Get callInfoPrivacyStatus value
     * @return string|null
     */
    public function getCallInfoPrivacyStatus()
    {
        return $this->callInfoPrivacyStatus;
    }
    /**
     * Set callInfoPrivacyStatus value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callInfoPrivacyStatus
     * @return XDeviceProfile
     */
    public function setCallInfoPrivacyStatus($callInfoPrivacyStatus = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($callInfoPrivacyStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callInfoPrivacyStatus, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->callInfoPrivacyStatus = $callInfoPrivacyStatus;
        return $this;
    }
    /**
     * Get services value
     * @return Services|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param Services $services
     * @return XDeviceProfile
     */
    public function setServices(Services $services = null)
    {
        $this->services = $services;
        return $this;
    }
    /**
     * Get featureControlPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getFeatureControlPolicy()
    {
        return isset($this->featureControlPolicy) ? $this->featureControlPolicy : null;
    }
    /**
     * Set featureControlPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $featureControlPolicy
     * @return XDeviceProfile
     */
    public function setFeatureControlPolicy(XFkType $featureControlPolicy = null)
    {
        if (is_null($featureControlPolicy) || (is_array($featureControlPolicy) && empty($featureControlPolicy))) {
            unset($this->featureControlPolicy);
        } else {
            $this->featureControlPolicy = $featureControlPolicy;
        }
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return XDeviceProfile
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XDeviceProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
