<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCiscoCatalyst600024PortFXSGateway StructType
 * @subpackage Structs
 */
class XCiscoCatalyst600024PortFXSGateway extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $product;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - documentation: For devices with load information, if any special load information is specified the special attribute is set to TRUE.Otherwise,the load information is default for the product.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta informations extracted from the WSDL
     * - default: User
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $protocolSide;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $devicePoolName;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var XFkType
     */
    public $locationName;
    /**
     * The portSelectionOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $portSelectionOrder;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - documentation: UUID changed each time device is updated
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The commonDeviceConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The networkLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkLocale;
    /**
     * The mediaResourceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $mediaResourceListName;
    /**
     * The automatedAlternateRoutingCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The loadInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XLoadInformation
     */
    public $loadInformation;
    /**
     * The vendorConfig
     * Meta informations extracted from the WSDL
     * - documentation: Not valid for CTI route points and VoiceMail ports
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XVendorConfig
     */
    public $vendorConfig;
    /**
     * The traceFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $traceFlag;
    /**
     * The mlppDomainId
     * Meta informations extracted from the WSDL
     * - documentation: This setting only effects devices that support MLPP. Use -1 to set to null
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 128
     * @var string
     */
    public $mlppDomainId;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The cgpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $geoLocationName;
    /**
     * The ports
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Ports
     */
    public $ports;
    /**
     * The transmitUtf8
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $transmitUtf8;
    /**
     * The geoLocationFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $geoLocationFilterName;
    /**
     * Constructor method for XCiscoCatalyst600024PortFXSGateway
     * @uses XCiscoCatalyst600024PortFXSGateway::setName()
     * @uses XCiscoCatalyst600024PortFXSGateway::setProduct()
     * @uses XCiscoCatalyst600024PortFXSGateway::setClass()
     * @uses XCiscoCatalyst600024PortFXSGateway::setProtocol()
     * @uses XCiscoCatalyst600024PortFXSGateway::setProtocolSide()
     * @uses XCiscoCatalyst600024PortFXSGateway::setDevicePoolName()
     * @uses XCiscoCatalyst600024PortFXSGateway::setLocationName()
     * @uses XCiscoCatalyst600024PortFXSGateway::setPortSelectionOrder()
     * @uses XCiscoCatalyst600024PortFXSGateway::setDescription()
     * @uses XCiscoCatalyst600024PortFXSGateway::setCallingSearchSpaceName()
     * @uses XCiscoCatalyst600024PortFXSGateway::setCommonDeviceConfigName()
     * @uses XCiscoCatalyst600024PortFXSGateway::setNetworkLocale()
     * @uses XCiscoCatalyst600024PortFXSGateway::setMediaResourceListName()
     * @uses XCiscoCatalyst600024PortFXSGateway::setAutomatedAlternateRoutingCssName()
     * @uses XCiscoCatalyst600024PortFXSGateway::setAarNeighborhoodName()
     * @uses XCiscoCatalyst600024PortFXSGateway::setLoadInformation()
     * @uses XCiscoCatalyst600024PortFXSGateway::setVendorConfig()
     * @uses XCiscoCatalyst600024PortFXSGateway::setTraceFlag()
     * @uses XCiscoCatalyst600024PortFXSGateway::setMlppDomainId()
     * @uses XCiscoCatalyst600024PortFXSGateway::setUseTrustedRelayPoint()
     * @uses XCiscoCatalyst600024PortFXSGateway::setCgpnTransformationCssName()
     * @uses XCiscoCatalyst600024PortFXSGateway::setUseDevicePoolCgpnTransformCss()
     * @uses XCiscoCatalyst600024PortFXSGateway::setGeoLocationName()
     * @uses XCiscoCatalyst600024PortFXSGateway::setPorts()
     * @uses XCiscoCatalyst600024PortFXSGateway::setTransmitUtf8()
     * @uses XCiscoCatalyst600024PortFXSGateway::setGeoLocationFilterName()
     * @param string $name
     * @param string $product
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param XFkType $devicePoolName
     * @param XFkType $locationName
     * @param string $portSelectionOrder
     * @param string $description
     * @param XFkType $callingSearchSpaceName
     * @param XFkType $commonDeviceConfigName
     * @param string $networkLocale
     * @param XFkType $mediaResourceListName
     * @param XFkType $automatedAlternateRoutingCssName
     * @param XFkType $aarNeighborhoodName
     * @param XLoadInformation $loadInformation
     * @param XVendorConfig $vendorConfig
     * @param string $traceFlag
     * @param string $mlppDomainId
     * @param string $useTrustedRelayPoint
     * @param XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param XFkType $geoLocationName
     * @param Ports $ports
     * @param string $transmitUtf8
     * @param XFkType $geoLocationFilterName
     */
    public function __construct($name = null, $product = null, $class = null, $protocol = null, $protocolSide = 'User', XFkType $devicePoolName = null, XFkType $locationName = null, $portSelectionOrder = null, $description = null, XFkType $callingSearchSpaceName = null, XFkType $commonDeviceConfigName = null, $networkLocale = null, XFkType $mediaResourceListName = null, XFkType $automatedAlternateRoutingCssName = null, XFkType $aarNeighborhoodName = null, XLoadInformation $loadInformation = null, XVendorConfig $vendorConfig = null, $traceFlag = null, $mlppDomainId = null, $useTrustedRelayPoint = 'Default', XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = null, XFkType $geoLocationName = null, Ports $ports = null, $transmitUtf8 = false, XFkType $geoLocationFilterName = null)
    {
        $this
            ->setName($name)
            ->setProduct($product)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setDevicePoolName($devicePoolName)
            ->setLocationName($locationName)
            ->setPortSelectionOrder($portSelectionOrder)
            ->setDescription($description)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setNetworkLocale($networkLocale)
            ->setMediaResourceListName($mediaResourceListName)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setLoadInformation($loadInformation)
            ->setVendorConfig($vendorConfig)
            ->setTraceFlag($traceFlag)
            ->setMlppDomainId($mlppDomainId)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setPorts($ports)
            ->setTransmitUtf8($transmitUtf8)
            ->setGeoLocationFilterName($geoLocationFilterName);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XCiscoCatalyst600024PortFXSGateway
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses XProduct::valueIsValid()
     * @uses XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return XCiscoCatalyst600024PortFXSGateway
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get class value
     * @return string
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses XClass::valueIsValid()
     * @uses XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return XCiscoCatalyst600024PortFXSGateway
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $class, implode(', ', XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses XDeviceProtocol::valueIsValid()
     * @uses XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return XCiscoCatalyst600024PortFXSGateway
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocol, implode(', ', XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @uses XProtocolSide::valueIsValid()
     * @uses XProtocolSide::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocolSide
     * @return XCiscoCatalyst600024PortFXSGateway
     */
    public function setProtocolSide($protocolSide = 'User')
    {
        // validation for constraint: enumeration
        if (!XProtocolSide::valueIsValid($protocolSide)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocolSide, implode(', ', XProtocolSide::getValidValues())), __LINE__);
        }
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return XFkType
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param XFkType $devicePoolName
     * @return XCiscoCatalyst600024PortFXSGateway
     */
    public function setDevicePoolName(XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get locationName value
     * @return XFkType
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param XFkType $locationName
     * @return XCiscoCatalyst600024PortFXSGateway
     */
    public function setLocationName(XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get portSelectionOrder value
     * @return string
     */
    public function getPortSelectionOrder()
    {
        return $this->portSelectionOrder;
    }
    /**
     * Set portSelectionOrder value
     * @uses XTrunkSelectionOrder::valueIsValid()
     * @uses XTrunkSelectionOrder::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $portSelectionOrder
     * @return XCiscoCatalyst600024PortFXSGateway
     */
    public function setPortSelectionOrder($portSelectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!XTrunkSelectionOrder::valueIsValid($portSelectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $portSelectionOrder, implode(', ', XTrunkSelectionOrder::getValidValues())), __LINE__);
        }
        $this->portSelectionOrder = $portSelectionOrder;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return XCiscoCatalyst600024PortFXSGateway
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return isset($this->callingSearchSpaceName) ? $this->callingSearchSpaceName : null;
    }
    /**
     * Set callingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $callingSearchSpaceName
     * @return XCiscoCatalyst600024PortFXSGateway
     */
    public function setCallingSearchSpaceName(XFkType $callingSearchSpaceName = null)
    {
        if (is_null($callingSearchSpaceName) || (is_array($callingSearchSpaceName) && empty($callingSearchSpaceName))) {
            unset($this->callingSearchSpaceName);
        } else {
            $this->callingSearchSpaceName = $callingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return isset($this->commonDeviceConfigName) ? $this->commonDeviceConfigName : null;
    }
    /**
     * Set commonDeviceConfigName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $commonDeviceConfigName
     * @return XCiscoCatalyst600024PortFXSGateway
     */
    public function setCommonDeviceConfigName(XFkType $commonDeviceConfigName = null)
    {
        if (is_null($commonDeviceConfigName) || (is_array($commonDeviceConfigName) && empty($commonDeviceConfigName))) {
            unset($this->commonDeviceConfigName);
        } else {
            $this->commonDeviceConfigName = $commonDeviceConfigName;
        }
        return $this;
    }
    /**
     * Get networkLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return isset($this->networkLocale) ? $this->networkLocale : null;
    }
    /**
     * Set networkLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XCountry::valueIsValid()
     * @uses XCountry::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocale
     * @return XCiscoCatalyst600024PortFXSGateway
     */
    public function setNetworkLocale($networkLocale = null)
    {
        // validation for constraint: enumeration
        if (!XCountry::valueIsValid($networkLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkLocale, implode(', ', XCountry::getValidValues())), __LINE__);
        }
        if (is_null($networkLocale) || (is_array($networkLocale) && empty($networkLocale))) {
            unset($this->networkLocale);
        } else {
            $this->networkLocale = $networkLocale;
        }
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getMediaResourceListName()
    {
        return isset($this->mediaResourceListName) ? $this->mediaResourceListName : null;
    }
    /**
     * Set mediaResourceListName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $mediaResourceListName
     * @return XCiscoCatalyst600024PortFXSGateway
     */
    public function setMediaResourceListName(XFkType $mediaResourceListName = null)
    {
        if (is_null($mediaResourceListName) || (is_array($mediaResourceListName) && empty($mediaResourceListName))) {
            unset($this->mediaResourceListName);
        } else {
            $this->mediaResourceListName = $mediaResourceListName;
        }
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return isset($this->automatedAlternateRoutingCssName) ? $this->automatedAlternateRoutingCssName : null;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $automatedAlternateRoutingCssName
     * @return XCiscoCatalyst600024PortFXSGateway
     */
    public function setAutomatedAlternateRoutingCssName(XFkType $automatedAlternateRoutingCssName = null)
    {
        if (is_null($automatedAlternateRoutingCssName) || (is_array($automatedAlternateRoutingCssName) && empty($automatedAlternateRoutingCssName))) {
            unset($this->automatedAlternateRoutingCssName);
        } else {
            $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        }
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return isset($this->aarNeighborhoodName) ? $this->aarNeighborhoodName : null;
    }
    /**
     * Set aarNeighborhoodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $aarNeighborhoodName
     * @return XCiscoCatalyst600024PortFXSGateway
     */
    public function setAarNeighborhoodName(XFkType $aarNeighborhoodName = null)
    {
        if (is_null($aarNeighborhoodName) || (is_array($aarNeighborhoodName) && empty($aarNeighborhoodName))) {
            unset($this->aarNeighborhoodName);
        } else {
            $this->aarNeighborhoodName = $aarNeighborhoodName;
        }
        return $this;
    }
    /**
     * Get loadInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return isset($this->loadInformation) ? $this->loadInformation : null;
    }
    /**
     * Set loadInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XLoadInformation $loadInformation
     * @return XCiscoCatalyst600024PortFXSGateway
     */
    public function setLoadInformation(XLoadInformation $loadInformation = null)
    {
        if (is_null($loadInformation) || (is_array($loadInformation) && empty($loadInformation))) {
            unset($this->loadInformation);
        } else {
            $this->loadInformation = $loadInformation;
        }
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param XVendorConfig $vendorConfig
     * @return XCiscoCatalyst600024PortFXSGateway
     */
    public function setVendorConfig(XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get traceFlag value
     * @return string|null
     */
    public function getTraceFlag()
    {
        return $this->traceFlag;
    }
    /**
     * Set traceFlag value
     * @param string $traceFlag
     * @return XCiscoCatalyst600024PortFXSGateway
     */
    public function setTraceFlag($traceFlag = null)
    {
        // validation for constraint: pattern
        if (is_scalar($traceFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($traceFlag, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($traceFlag) && !is_string($traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($traceFlag)), __LINE__);
        }
        $this->traceFlag = $traceFlag;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return isset($this->mlppDomainId) ? $this->mlppDomainId : null;
    }
    /**
     * Set mlppDomainId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mlppDomainId
     * @return XCiscoCatalyst600024PortFXSGateway
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mlppDomainId) && strlen($mlppDomainId) > 128) || (is_array($mlppDomainId) && count($mlppDomainId) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($mlppDomainId) ? strlen($mlppDomainId) : count($mlppDomainId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mlppDomainId) && !is_string($mlppDomainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mlppDomainId)), __LINE__);
        }
        if (is_null($mlppDomainId) || (is_array($mlppDomainId) && empty($mlppDomainId))) {
            unset($this->mlppDomainId);
        } else {
            $this->mlppDomainId = $mlppDomainId;
        }
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return XCiscoCatalyst600024PortFXSGateway
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useTrustedRelayPoint, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return isset($this->cgpnTransformationCssName) ? $this->cgpnTransformationCssName : null;
    }
    /**
     * Set cgpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $cgpnTransformationCssName
     * @return XCiscoCatalyst600024PortFXSGateway
     */
    public function setCgpnTransformationCssName(XFkType $cgpnTransformationCssName = null)
    {
        if (is_null($cgpnTransformationCssName) || (is_array($cgpnTransformationCssName) && empty($cgpnTransformationCssName))) {
            unset($this->cgpnTransformationCssName);
        } else {
            $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return XCiscoCatalyst600024PortFXSGateway
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCss) && !is_string($useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getGeoLocationName()
    {
        return isset($this->geoLocationName) ? $this->geoLocationName : null;
    }
    /**
     * Set geoLocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $geoLocationName
     * @return XCiscoCatalyst600024PortFXSGateway
     */
    public function setGeoLocationName(XFkType $geoLocationName = null)
    {
        if (is_null($geoLocationName) || (is_array($geoLocationName) && empty($geoLocationName))) {
            unset($this->geoLocationName);
        } else {
            $this->geoLocationName = $geoLocationName;
        }
        return $this;
    }
    /**
     * Get ports value
     * @return Ports|null
     */
    public function getPorts()
    {
        return $this->ports;
    }
    /**
     * Set ports value
     * @param Ports $ports
     * @return XCiscoCatalyst600024PortFXSGateway
     */
    public function setPorts(Ports $ports = null)
    {
        $this->ports = $ports;
        return $this;
    }
    /**
     * Get transmitUtf8 value
     * @return string|null
     */
    public function getTransmitUtf8()
    {
        return $this->transmitUtf8;
    }
    /**
     * Set transmitUtf8 value
     * @param string $transmitUtf8
     * @return XCiscoCatalyst600024PortFXSGateway
     */
    public function setTransmitUtf8($transmitUtf8 = false)
    {
        // validation for constraint: pattern
        if (is_scalar($transmitUtf8) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($transmitUtf8, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($transmitUtf8) && !is_string($transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transmitUtf8)), __LINE__);
        }
        $this->transmitUtf8 = $transmitUtf8;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return isset($this->geoLocationFilterName) ? $this->geoLocationFilterName : null;
    }
    /**
     * Set geoLocationFilterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $geoLocationFilterName
     * @return XCiscoCatalyst600024PortFXSGateway
     */
    public function setGeoLocationFilterName(XFkType $geoLocationFilterName = null)
    {
        if (is_null($geoLocationFilterName) || (is_array($geoLocationFilterName) && empty($geoLocationFilterName))) {
            unset($this->geoLocationFilterName);
        } else {
            $this->geoLocationFilterName = $geoLocationFilterName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XCiscoCatalyst600024PortFXSGateway
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
