<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateWifiHotspotReq StructType
 * @subpackage Structs
 */
class UpdateWifiHotspotReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The ssidPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ssidPrefix;
    /**
     * The userModifiable
     * Meta informations extracted from the WSDL
     * - default: Allowed
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userModifiable;
    /**
     * The frequencyBand
     * Meta informations extracted from the WSDL
     * - default: Auto
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $frequencyBand;
    /**
     * The authenticationMethod
     * Meta informations extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $authenticationMethod;
    /**
     * The hostName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 64
     * @var string
     */
    public $hostName;
    /**
     * The port
     * Meta informations extracted from the WSDL
     * - default: 1812
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $port;
    /**
     * The sharedSecret
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sharedSecret;
    /**
     * The pskPassPhrase
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pskPassPhrase;
    /**
     * The wepKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $wepKey;
    /**
     * The passwordDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $passwordDescription;
    /**
     * Constructor method for UpdateWifiHotspotReq
     * @uses UpdateWifiHotspotReq::setNewName()
     * @uses UpdateWifiHotspotReq::setDescription()
     * @uses UpdateWifiHotspotReq::setSsidPrefix()
     * @uses UpdateWifiHotspotReq::setUserModifiable()
     * @uses UpdateWifiHotspotReq::setFrequencyBand()
     * @uses UpdateWifiHotspotReq::setAuthenticationMethod()
     * @uses UpdateWifiHotspotReq::setHostName()
     * @uses UpdateWifiHotspotReq::setPort()
     * @uses UpdateWifiHotspotReq::setSharedSecret()
     * @uses UpdateWifiHotspotReq::setPskPassPhrase()
     * @uses UpdateWifiHotspotReq::setWepKey()
     * @uses UpdateWifiHotspotReq::setPasswordDescription()
     * @param string $newName
     * @param string $description
     * @param string $ssidPrefix
     * @param string $userModifiable
     * @param string $frequencyBand
     * @param string $authenticationMethod
     * @param string $hostName
     * @param string $port
     * @param string $sharedSecret
     * @param string $pskPassPhrase
     * @param string $wepKey
     * @param string $passwordDescription
     */
    public function __construct($newName = null, $description = null, $ssidPrefix = null, $userModifiable = 'Allowed', $frequencyBand = 'Auto', $authenticationMethod = 'None', $hostName = null, $port = '1812', $sharedSecret = null, $pskPassPhrase = null, $wepKey = null, $passwordDescription = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setSsidPrefix($ssidPrefix)
            ->setUserModifiable($userModifiable)
            ->setFrequencyBand($frequencyBand)
            ->setAuthenticationMethod($authenticationMethod)
            ->setHostName($hostName)
            ->setPort($port)
            ->setSharedSecret($sharedSecret)
            ->setPskPassPhrase($pskPassPhrase)
            ->setWepKey($wepKey)
            ->setPasswordDescription($passwordDescription);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return UpdateWifiHotspotReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return UpdateWifiHotspotReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get ssidPrefix value
     * @return string|null
     */
    public function getSsidPrefix()
    {
        return $this->ssidPrefix;
    }
    /**
     * Set ssidPrefix value
     * @param string $ssidPrefix
     * @return UpdateWifiHotspotReq
     */
    public function setSsidPrefix($ssidPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($ssidPrefix) && !is_string($ssidPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ssidPrefix)), __LINE__);
        }
        $this->ssidPrefix = $ssidPrefix;
        return $this;
    }
    /**
     * Get userModifiable value
     * @return string|null
     */
    public function getUserModifiable()
    {
        return $this->userModifiable;
    }
    /**
     * Set userModifiable value
     * @uses XWLANProfileChanges::valueIsValid()
     * @uses XWLANProfileChanges::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userModifiable
     * @return UpdateWifiHotspotReq
     */
    public function setUserModifiable($userModifiable = 'Allowed')
    {
        // validation for constraint: enumeration
        if (!XWLANProfileChanges::valueIsValid($userModifiable)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userModifiable, implode(', ', XWLANProfileChanges::getValidValues())), __LINE__);
        }
        $this->userModifiable = $userModifiable;
        return $this;
    }
    /**
     * Get frequencyBand value
     * @return string|null
     */
    public function getFrequencyBand()
    {
        return $this->frequencyBand;
    }
    /**
     * Set frequencyBand value
     * @uses XWiFiFrequency::valueIsValid()
     * @uses XWiFiFrequency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $frequencyBand
     * @return UpdateWifiHotspotReq
     */
    public function setFrequencyBand($frequencyBand = 'Auto')
    {
        // validation for constraint: enumeration
        if (!XWiFiFrequency::valueIsValid($frequencyBand)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $frequencyBand, implode(', ', XWiFiFrequency::getValidValues())), __LINE__);
        }
        $this->frequencyBand = $frequencyBand;
        return $this;
    }
    /**
     * Get authenticationMethod value
     * @return string|null
     */
    public function getAuthenticationMethod()
    {
        return $this->authenticationMethod;
    }
    /**
     * Set authenticationMethod value
     * @uses XHotspotAuthenticationMethod::valueIsValid()
     * @uses XHotspotAuthenticationMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationMethod
     * @return UpdateWifiHotspotReq
     */
    public function setAuthenticationMethod($authenticationMethod = 'None')
    {
        // validation for constraint: enumeration
        if (!XHotspotAuthenticationMethod::valueIsValid($authenticationMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authenticationMethod, implode(', ', XHotspotAuthenticationMethod::getValidValues())), __LINE__);
        }
        $this->authenticationMethod = $authenticationMethod;
        return $this;
    }
    /**
     * Get hostName value
     * @return string|null
     */
    public function getHostName()
    {
        return $this->hostName;
    }
    /**
     * Set hostName value
     * @param string $hostName
     * @return UpdateWifiHotspotReq
     */
    public function setHostName($hostName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($hostName) && strlen($hostName) > 64) || (is_array($hostName) && count($hostName) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($hostName) ? strlen($hostName) : count($hostName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hostName) && !is_string($hostName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hostName)), __LINE__);
        }
        $this->hostName = $hostName;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return UpdateWifiHotspotReq
     */
    public function setPort($port = '1812')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $port, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Get sharedSecret value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSharedSecret()
    {
        return isset($this->sharedSecret) ? $this->sharedSecret : null;
    }
    /**
     * Set sharedSecret value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sharedSecret
     * @return UpdateWifiHotspotReq
     */
    public function setSharedSecret($sharedSecret = null)
    {
        // validation for constraint: string
        if (!is_null($sharedSecret) && !is_string($sharedSecret)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sharedSecret)), __LINE__);
        }
        if (is_null($sharedSecret) || (is_array($sharedSecret) && empty($sharedSecret))) {
            unset($this->sharedSecret);
        } else {
            $this->sharedSecret = $sharedSecret;
        }
        return $this;
    }
    /**
     * Get pskPassPhrase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPskPassPhrase()
    {
        return isset($this->pskPassPhrase) ? $this->pskPassPhrase : null;
    }
    /**
     * Set pskPassPhrase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pskPassPhrase
     * @return UpdateWifiHotspotReq
     */
    public function setPskPassPhrase($pskPassPhrase = null)
    {
        // validation for constraint: string
        if (!is_null($pskPassPhrase) && !is_string($pskPassPhrase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pskPassPhrase)), __LINE__);
        }
        if (is_null($pskPassPhrase) || (is_array($pskPassPhrase) && empty($pskPassPhrase))) {
            unset($this->pskPassPhrase);
        } else {
            $this->pskPassPhrase = $pskPassPhrase;
        }
        return $this;
    }
    /**
     * Get wepKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWepKey()
    {
        return isset($this->wepKey) ? $this->wepKey : null;
    }
    /**
     * Set wepKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wepKey
     * @return UpdateWifiHotspotReq
     */
    public function setWepKey($wepKey = null)
    {
        // validation for constraint: string
        if (!is_null($wepKey) && !is_string($wepKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wepKey)), __LINE__);
        }
        if (is_null($wepKey) || (is_array($wepKey) && empty($wepKey))) {
            unset($this->wepKey);
        } else {
            $this->wepKey = $wepKey;
        }
        return $this;
    }
    /**
     * Get passwordDescription value
     * @return string|null
     */
    public function getPasswordDescription()
    {
        return $this->passwordDescription;
    }
    /**
     * Set passwordDescription value
     * @param string $passwordDescription
     * @return UpdateWifiHotspotReq
     */
    public function setPasswordDescription($passwordDescription = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($passwordDescription) && strlen($passwordDescription) > 255) || (is_array($passwordDescription) && count($passwordDescription) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($passwordDescription) ? strlen($passwordDescription) : count($passwordDescription)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($passwordDescription) && !is_string($passwordDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passwordDescription)), __LINE__);
        }
        $this->passwordDescription = $passwordDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdateWifiHotspotReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
