<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateVoiceMailPortReq StructType
 * @subpackage Structs
 */
class UpdateVoiceMailPortReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: Optional description of the device
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var XFkType
     */
    public $locationName;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The securityProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $securityProfileName;
    /**
     * The geoLocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $geoLocationName;
    /**
     * The automatedAlternateRoutingCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The dnPattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dnPattern;
    /**
     * The routePartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $routePartition;
    /**
     * The dnCallingSearchSpace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $dnCallingSearchSpace;
    /**
     * The aarNeighborhoodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The callerIdDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $callerIdDisplay;
    /**
     * The callerIdDisplayAscii
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $callerIdDisplayAscii;
    /**
     * The externalMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $externalMask;
    /**
     * Constructor method for UpdateVoiceMailPortReq
     * @uses UpdateVoiceMailPortReq::setNewName()
     * @uses UpdateVoiceMailPortReq::setDescription()
     * @uses UpdateVoiceMailPortReq::setCallingSearchSpaceName()
     * @uses UpdateVoiceMailPortReq::setDevicePoolName()
     * @uses UpdateVoiceMailPortReq::setCommonDeviceConfigName()
     * @uses UpdateVoiceMailPortReq::setLocationName()
     * @uses UpdateVoiceMailPortReq::setUseTrustedRelayPoint()
     * @uses UpdateVoiceMailPortReq::setSecurityProfileName()
     * @uses UpdateVoiceMailPortReq::setGeoLocationName()
     * @uses UpdateVoiceMailPortReq::setAutomatedAlternateRoutingCssName()
     * @uses UpdateVoiceMailPortReq::setDnPattern()
     * @uses UpdateVoiceMailPortReq::setRoutePartition()
     * @uses UpdateVoiceMailPortReq::setDnCallingSearchSpace()
     * @uses UpdateVoiceMailPortReq::setAarNeighborhoodName()
     * @uses UpdateVoiceMailPortReq::setCallerIdDisplay()
     * @uses UpdateVoiceMailPortReq::setCallerIdDisplayAscii()
     * @uses UpdateVoiceMailPortReq::setExternalMask()
     * @param string $newName
     * @param string $description
     * @param XFkType $callingSearchSpaceName
     * @param XFkType $devicePoolName
     * @param XFkType $commonDeviceConfigName
     * @param XFkType $locationName
     * @param string $useTrustedRelayPoint
     * @param XFkType $securityProfileName
     * @param XFkType $geoLocationName
     * @param XFkType $automatedAlternateRoutingCssName
     * @param string $dnPattern
     * @param XFkType $routePartition
     * @param XFkType $dnCallingSearchSpace
     * @param XFkType $aarNeighborhoodName
     * @param string $callerIdDisplay
     * @param string $callerIdDisplayAscii
     * @param string $externalMask
     */
    public function __construct($newName = null, $description = null, XFkType $callingSearchSpaceName = null, XFkType $devicePoolName = null, XFkType $commonDeviceConfigName = null, XFkType $locationName = null, $useTrustedRelayPoint = 'Default', XFkType $securityProfileName = null, XFkType $geoLocationName = null, XFkType $automatedAlternateRoutingCssName = null, $dnPattern = null, XFkType $routePartition = null, XFkType $dnCallingSearchSpace = null, XFkType $aarNeighborhoodName = null, $callerIdDisplay = null, $callerIdDisplayAscii = null, $externalMask = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setLocationName($locationName)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setSecurityProfileName($securityProfileName)
            ->setGeoLocationName($geoLocationName)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setDnPattern($dnPattern)
            ->setRoutePartition($routePartition)
            ->setDnCallingSearchSpace($dnCallingSearchSpace)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setCallerIdDisplay($callerIdDisplay)
            ->setCallerIdDisplayAscii($callerIdDisplayAscii)
            ->setExternalMask($externalMask);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return UpdateVoiceMailPortReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 128) || (is_array($newName) && count($newName) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return UpdateVoiceMailPortReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return isset($this->callingSearchSpaceName) ? $this->callingSearchSpaceName : null;
    }
    /**
     * Set callingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $callingSearchSpaceName
     * @return UpdateVoiceMailPortReq
     */
    public function setCallingSearchSpaceName(XFkType $callingSearchSpaceName = null)
    {
        if (is_null($callingSearchSpaceName) || (is_array($callingSearchSpaceName) && empty($callingSearchSpaceName))) {
            unset($this->callingSearchSpaceName);
        } else {
            $this->callingSearchSpaceName = $callingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get devicePoolName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getDevicePoolName()
    {
        return isset($this->devicePoolName) ? $this->devicePoolName : null;
    }
    /**
     * Set devicePoolName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $devicePoolName
     * @return UpdateVoiceMailPortReq
     */
    public function setDevicePoolName(XFkType $devicePoolName = null)
    {
        if (is_null($devicePoolName) || (is_array($devicePoolName) && empty($devicePoolName))) {
            unset($this->devicePoolName);
        } else {
            $this->devicePoolName = $devicePoolName;
        }
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return isset($this->commonDeviceConfigName) ? $this->commonDeviceConfigName : null;
    }
    /**
     * Set commonDeviceConfigName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $commonDeviceConfigName
     * @return UpdateVoiceMailPortReq
     */
    public function setCommonDeviceConfigName(XFkType $commonDeviceConfigName = null)
    {
        if (is_null($commonDeviceConfigName) || (is_array($commonDeviceConfigName) && empty($commonDeviceConfigName))) {
            unset($this->commonDeviceConfigName);
        } else {
            $this->commonDeviceConfigName = $commonDeviceConfigName;
        }
        return $this;
    }
    /**
     * Get locationName value
     * @return XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param XFkType $locationName
     * @return UpdateVoiceMailPortReq
     */
    public function setLocationName(XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return UpdateVoiceMailPortReq
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useTrustedRelayPoint, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get securityProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getSecurityProfileName()
    {
        return isset($this->securityProfileName) ? $this->securityProfileName : null;
    }
    /**
     * Set securityProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $securityProfileName
     * @return UpdateVoiceMailPortReq
     */
    public function setSecurityProfileName(XFkType $securityProfileName = null)
    {
        if (is_null($securityProfileName) || (is_array($securityProfileName) && empty($securityProfileName))) {
            unset($this->securityProfileName);
        } else {
            $this->securityProfileName = $securityProfileName;
        }
        return $this;
    }
    /**
     * Get geoLocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getGeoLocationName()
    {
        return isset($this->geoLocationName) ? $this->geoLocationName : null;
    }
    /**
     * Set geoLocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $geoLocationName
     * @return UpdateVoiceMailPortReq
     */
    public function setGeoLocationName(XFkType $geoLocationName = null)
    {
        if (is_null($geoLocationName) || (is_array($geoLocationName) && empty($geoLocationName))) {
            unset($this->geoLocationName);
        } else {
            $this->geoLocationName = $geoLocationName;
        }
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return isset($this->automatedAlternateRoutingCssName) ? $this->automatedAlternateRoutingCssName : null;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $automatedAlternateRoutingCssName
     * @return UpdateVoiceMailPortReq
     */
    public function setAutomatedAlternateRoutingCssName(XFkType $automatedAlternateRoutingCssName = null)
    {
        if (is_null($automatedAlternateRoutingCssName) || (is_array($automatedAlternateRoutingCssName) && empty($automatedAlternateRoutingCssName))) {
            unset($this->automatedAlternateRoutingCssName);
        } else {
            $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        }
        return $this;
    }
    /**
     * Get dnPattern value
     * @return string|null
     */
    public function getDnPattern()
    {
        return $this->dnPattern;
    }
    /**
     * Set dnPattern value
     * @param string $dnPattern
     * @return UpdateVoiceMailPortReq
     */
    public function setDnPattern($dnPattern = null)
    {
        // validation for constraint: string
        if (!is_null($dnPattern) && !is_string($dnPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dnPattern)), __LINE__);
        }
        $this->dnPattern = $dnPattern;
        return $this;
    }
    /**
     * Get routePartition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getRoutePartition()
    {
        return isset($this->routePartition) ? $this->routePartition : null;
    }
    /**
     * Set routePartition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $routePartition
     * @return UpdateVoiceMailPortReq
     */
    public function setRoutePartition(XFkType $routePartition = null)
    {
        if (is_null($routePartition) || (is_array($routePartition) && empty($routePartition))) {
            unset($this->routePartition);
        } else {
            $this->routePartition = $routePartition;
        }
        return $this;
    }
    /**
     * Get dnCallingSearchSpace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getDnCallingSearchSpace()
    {
        return isset($this->dnCallingSearchSpace) ? $this->dnCallingSearchSpace : null;
    }
    /**
     * Set dnCallingSearchSpace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $dnCallingSearchSpace
     * @return UpdateVoiceMailPortReq
     */
    public function setDnCallingSearchSpace(XFkType $dnCallingSearchSpace = null)
    {
        if (is_null($dnCallingSearchSpace) || (is_array($dnCallingSearchSpace) && empty($dnCallingSearchSpace))) {
            unset($this->dnCallingSearchSpace);
        } else {
            $this->dnCallingSearchSpace = $dnCallingSearchSpace;
        }
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return isset($this->aarNeighborhoodName) ? $this->aarNeighborhoodName : null;
    }
    /**
     * Set aarNeighborhoodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $aarNeighborhoodName
     * @return UpdateVoiceMailPortReq
     */
    public function setAarNeighborhoodName(XFkType $aarNeighborhoodName = null)
    {
        if (is_null($aarNeighborhoodName) || (is_array($aarNeighborhoodName) && empty($aarNeighborhoodName))) {
            unset($this->aarNeighborhoodName);
        } else {
            $this->aarNeighborhoodName = $aarNeighborhoodName;
        }
        return $this;
    }
    /**
     * Get callerIdDisplay value
     * @return string|null
     */
    public function getCallerIdDisplay()
    {
        return $this->callerIdDisplay;
    }
    /**
     * Set callerIdDisplay value
     * @param string $callerIdDisplay
     * @return UpdateVoiceMailPortReq
     */
    public function setCallerIdDisplay($callerIdDisplay = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callerIdDisplay) && strlen($callerIdDisplay) > 128) || (is_array($callerIdDisplay) && count($callerIdDisplay) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($callerIdDisplay) ? strlen($callerIdDisplay) : count($callerIdDisplay)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callerIdDisplay) && !is_string($callerIdDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callerIdDisplay)), __LINE__);
        }
        $this->callerIdDisplay = $callerIdDisplay;
        return $this;
    }
    /**
     * Get callerIdDisplayAscii value
     * @return string|null
     */
    public function getCallerIdDisplayAscii()
    {
        return $this->callerIdDisplayAscii;
    }
    /**
     * Set callerIdDisplayAscii value
     * @param string $callerIdDisplayAscii
     * @return UpdateVoiceMailPortReq
     */
    public function setCallerIdDisplayAscii($callerIdDisplayAscii = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callerIdDisplayAscii) && strlen($callerIdDisplayAscii) > 50) || (is_array($callerIdDisplayAscii) && count($callerIdDisplayAscii) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($callerIdDisplayAscii) ? strlen($callerIdDisplayAscii) : count($callerIdDisplayAscii)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callerIdDisplayAscii) && !is_string($callerIdDisplayAscii)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callerIdDisplayAscii)), __LINE__);
        }
        $this->callerIdDisplayAscii = $callerIdDisplayAscii;
        return $this;
    }
    /**
     * Get externalMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalMask()
    {
        return isset($this->externalMask) ? $this->externalMask : null;
    }
    /**
     * Set externalMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalMask
     * @return UpdateVoiceMailPortReq
     */
    public function setExternalMask($externalMask = null)
    {
        // validation for constraint: string
        if (!is_null($externalMask) && !is_string($externalMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalMask)), __LINE__);
        }
        if (is_null($externalMask) || (is_array($externalMask) && empty($externalMask))) {
            unset($this->externalMask);
        } else {
            $this->externalMask = $externalMask;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdateVoiceMailPortReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
