<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateVohServerReq StructType
 * @subpackage Structs
 */
class UpdateVohServerReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The sipTrunkName
     * Meta informations extracted from the WSDL
     * - documentation: SIP Trunk for Video On Hold Server
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var XFkType
     */
    public $sipTrunkName;
    /**
     * The defaultVideoStreamId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $defaultVideoStreamId;
    /**
     * Constructor method for UpdateVohServerReq
     * @uses UpdateVohServerReq::setNewName()
     * @uses UpdateVohServerReq::setDescription()
     * @uses UpdateVohServerReq::setSipTrunkName()
     * @uses UpdateVohServerReq::setDefaultVideoStreamId()
     * @param string $newName
     * @param string $description
     * @param XFkType $sipTrunkName
     * @param string $defaultVideoStreamId
     */
    public function __construct($newName = null, $description = null, XFkType $sipTrunkName = null, $defaultVideoStreamId = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setSipTrunkName($sipTrunkName)
            ->setDefaultVideoStreamId($defaultVideoStreamId);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return UpdateVohServerReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return UpdateVohServerReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get sipTrunkName value
     * @return XFkType|null
     */
    public function getSipTrunkName()
    {
        return $this->sipTrunkName;
    }
    /**
     * Set sipTrunkName value
     * @param XFkType $sipTrunkName
     * @return UpdateVohServerReq
     */
    public function setSipTrunkName(XFkType $sipTrunkName = null)
    {
        $this->sipTrunkName = $sipTrunkName;
        return $this;
    }
    /**
     * Get defaultVideoStreamId value
     * @return string|null
     */
    public function getDefaultVideoStreamId()
    {
        return $this->defaultVideoStreamId;
    }
    /**
     * Set defaultVideoStreamId value
     * @param string $defaultVideoStreamId
     * @return UpdateVohServerReq
     */
    public function setDefaultVideoStreamId($defaultVideoStreamId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultVideoStreamId) && !is_string($defaultVideoStreamId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($defaultVideoStreamId)), __LINE__);
        }
        $this->defaultVideoStreamId = $defaultVideoStreamId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdateVohServerReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
