<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSafForwarderReq StructType
 * @subpackage Structs
 */
class UpdateSafForwarderReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The clientLabel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $clientLabel;
    /**
     * The safSecurityProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var XFkType
     */
    public $safSecurityProfile;
    /**
     * The ipAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $ipAddress;
    /**
     * The port
     * Meta informations extracted from the WSDL
     * - default: 5050
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $port;
    /**
     * The enableTcpKeepAlive
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableTcpKeepAlive;
    /**
     * The safReconnectInterval
     * Meta informations extracted from the WSDL
     * - default: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $safReconnectInterval;
    /**
     * The safNotificationsWindowSize
     * Meta informations extracted from the WSDL
     * - default: 7
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $safNotificationsWindowSize;
    /**
     * The removeAssociatedCucms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var RemoveAssociatedCucms
     */
    public $removeAssociatedCucms;
    /**
     * The addAssociatedCucms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AddAssociatedCucms
     */
    public $addAssociatedCucms;
    /**
     * The associatedCucms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AssociatedCucms
     */
    public $associatedCucms;
    /**
     * Constructor method for UpdateSafForwarderReq
     * @uses UpdateSafForwarderReq::setNewName()
     * @uses UpdateSafForwarderReq::setDescription()
     * @uses UpdateSafForwarderReq::setClientLabel()
     * @uses UpdateSafForwarderReq::setSafSecurityProfile()
     * @uses UpdateSafForwarderReq::setIpAddress()
     * @uses UpdateSafForwarderReq::setPort()
     * @uses UpdateSafForwarderReq::setEnableTcpKeepAlive()
     * @uses UpdateSafForwarderReq::setSafReconnectInterval()
     * @uses UpdateSafForwarderReq::setSafNotificationsWindowSize()
     * @uses UpdateSafForwarderReq::setRemoveAssociatedCucms()
     * @uses UpdateSafForwarderReq::setAddAssociatedCucms()
     * @uses UpdateSafForwarderReq::setAssociatedCucms()
     * @param string $newName
     * @param string $description
     * @param string $clientLabel
     * @param XFkType $safSecurityProfile
     * @param string $ipAddress
     * @param string $port
     * @param string $enableTcpKeepAlive
     * @param string $safReconnectInterval
     * @param string $safNotificationsWindowSize
     * @param RemoveAssociatedCucms $removeAssociatedCucms
     * @param AddAssociatedCucms $addAssociatedCucms
     * @param AssociatedCucms $associatedCucms
     */
    public function __construct($newName = null, $description = null, $clientLabel = null, XFkType $safSecurityProfile = null, $ipAddress = null, $port = '5050', $enableTcpKeepAlive = true, $safReconnectInterval = '20', $safNotificationsWindowSize = '7', RemoveAssociatedCucms $removeAssociatedCucms = null, AddAssociatedCucms $addAssociatedCucms = null, AssociatedCucms $associatedCucms = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setClientLabel($clientLabel)
            ->setSafSecurityProfile($safSecurityProfile)
            ->setIpAddress($ipAddress)
            ->setPort($port)
            ->setEnableTcpKeepAlive($enableTcpKeepAlive)
            ->setSafReconnectInterval($safReconnectInterval)
            ->setSafNotificationsWindowSize($safNotificationsWindowSize)
            ->setRemoveAssociatedCucms($removeAssociatedCucms)
            ->setAddAssociatedCucms($addAssociatedCucms)
            ->setAssociatedCucms($associatedCucms);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return UpdateSafForwarderReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 255) || (is_array($newName) && count($newName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return UpdateSafForwarderReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get clientLabel value
     * @return string|null
     */
    public function getClientLabel()
    {
        return $this->clientLabel;
    }
    /**
     * Set clientLabel value
     * @param string $clientLabel
     * @return UpdateSafForwarderReq
     */
    public function setClientLabel($clientLabel = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($clientLabel) && strlen($clientLabel) > 255) || (is_array($clientLabel) && count($clientLabel) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($clientLabel) ? strlen($clientLabel) : count($clientLabel)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($clientLabel) && !is_string($clientLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientLabel)), __LINE__);
        }
        $this->clientLabel = $clientLabel;
        return $this;
    }
    /**
     * Get safSecurityProfile value
     * @return XFkType|null
     */
    public function getSafSecurityProfile()
    {
        return $this->safSecurityProfile;
    }
    /**
     * Set safSecurityProfile value
     * @param XFkType $safSecurityProfile
     * @return UpdateSafForwarderReq
     */
    public function setSafSecurityProfile(XFkType $safSecurityProfile = null)
    {
        $this->safSecurityProfile = $safSecurityProfile;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return UpdateSafForwarderReq
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ipAddress) && strlen($ipAddress) > 255) || (is_array($ipAddress) && count($ipAddress) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($ipAddress) ? strlen($ipAddress) : count($ipAddress)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipAddress)), __LINE__);
        }
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return UpdateSafForwarderReq
     */
    public function setPort($port = '5050')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $port, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Get enableTcpKeepAlive value
     * @return string|null
     */
    public function getEnableTcpKeepAlive()
    {
        return $this->enableTcpKeepAlive;
    }
    /**
     * Set enableTcpKeepAlive value
     * @param string $enableTcpKeepAlive
     * @return UpdateSafForwarderReq
     */
    public function setEnableTcpKeepAlive($enableTcpKeepAlive = true)
    {
        // validation for constraint: pattern
        if (is_scalar($enableTcpKeepAlive) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableTcpKeepAlive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableTcpKeepAlive, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableTcpKeepAlive) && !is_string($enableTcpKeepAlive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableTcpKeepAlive)), __LINE__);
        }
        $this->enableTcpKeepAlive = $enableTcpKeepAlive;
        return $this;
    }
    /**
     * Get safReconnectInterval value
     * @return string|null
     */
    public function getSafReconnectInterval()
    {
        return $this->safReconnectInterval;
    }
    /**
     * Set safReconnectInterval value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $safReconnectInterval
     * @return UpdateSafForwarderReq
     */
    public function setSafReconnectInterval($safReconnectInterval = '20')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($safReconnectInterval)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $safReconnectInterval, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->safReconnectInterval = $safReconnectInterval;
        return $this;
    }
    /**
     * Get safNotificationsWindowSize value
     * @return string|null
     */
    public function getSafNotificationsWindowSize()
    {
        return $this->safNotificationsWindowSize;
    }
    /**
     * Set safNotificationsWindowSize value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $safNotificationsWindowSize
     * @return UpdateSafForwarderReq
     */
    public function setSafNotificationsWindowSize($safNotificationsWindowSize = '7')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($safNotificationsWindowSize)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $safNotificationsWindowSize, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->safNotificationsWindowSize = $safNotificationsWindowSize;
        return $this;
    }
    /**
     * Get removeAssociatedCucms value
     * @return RemoveAssociatedCucms|null
     */
    public function getRemoveAssociatedCucms()
    {
        return $this->removeAssociatedCucms;
    }
    /**
     * Set removeAssociatedCucms value
     * @param RemoveAssociatedCucms $removeAssociatedCucms
     * @return UpdateSafForwarderReq
     */
    public function setRemoveAssociatedCucms(RemoveAssociatedCucms $removeAssociatedCucms = null)
    {
        $this->removeAssociatedCucms = $removeAssociatedCucms;
        return $this;
    }
    /**
     * Get addAssociatedCucms value
     * @return AddAssociatedCucms|null
     */
    public function getAddAssociatedCucms()
    {
        return $this->addAssociatedCucms;
    }
    /**
     * Set addAssociatedCucms value
     * @param AddAssociatedCucms $addAssociatedCucms
     * @return UpdateSafForwarderReq
     */
    public function setAddAssociatedCucms(AddAssociatedCucms $addAssociatedCucms = null)
    {
        $this->addAssociatedCucms = $addAssociatedCucms;
        return $this;
    }
    /**
     * Get associatedCucms value
     * @return AssociatedCucms|null
     */
    public function getAssociatedCucms()
    {
        return $this->associatedCucms;
    }
    /**
     * Set associatedCucms value
     * @param AssociatedCucms $associatedCucms
     * @return UpdateSafForwarderReq
     */
    public function setAssociatedCucms(AssociatedCucms $associatedCucms = null)
    {
        $this->associatedCucms = $associatedCucms;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdateSafForwarderReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
