<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdatePresenceRedundancyGroupReq StructType
 * @subpackage Structs
 */
class UpdatePresenceRedundancyGroupReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The server1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $server1;
    /**
     * The server2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $server2;
    /**
     * The haEnabled
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $haEnabled;
    /**
     * Constructor method for UpdatePresenceRedundancyGroupReq
     * @uses UpdatePresenceRedundancyGroupReq::setNewName()
     * @uses UpdatePresenceRedundancyGroupReq::setDescription()
     * @uses UpdatePresenceRedundancyGroupReq::setServer1()
     * @uses UpdatePresenceRedundancyGroupReq::setServer2()
     * @uses UpdatePresenceRedundancyGroupReq::setHaEnabled()
     * @param string $newName
     * @param string $description
     * @param XFkType $server1
     * @param XFkType $server2
     * @param string $haEnabled
     */
    public function __construct($newName = null, $description = null, XFkType $server1 = null, XFkType $server2 = null, $haEnabled = false)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setServer1($server1)
            ->setServer2($server2)
            ->setHaEnabled($haEnabled);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return UpdatePresenceRedundancyGroupReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 255) || (is_array($newName) && count($newName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return UpdatePresenceRedundancyGroupReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get server1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getServer1()
    {
        return isset($this->server1) ? $this->server1 : null;
    }
    /**
     * Set server1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $server1
     * @return UpdatePresenceRedundancyGroupReq
     */
    public function setServer1(XFkType $server1 = null)
    {
        if (is_null($server1) || (is_array($server1) && empty($server1))) {
            unset($this->server1);
        } else {
            $this->server1 = $server1;
        }
        return $this;
    }
    /**
     * Get server2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getServer2()
    {
        return isset($this->server2) ? $this->server2 : null;
    }
    /**
     * Set server2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $server2
     * @return UpdatePresenceRedundancyGroupReq
     */
    public function setServer2(XFkType $server2 = null)
    {
        if (is_null($server2) || (is_array($server2) && empty($server2))) {
            unset($this->server2);
        } else {
            $this->server2 = $server2;
        }
        return $this;
    }
    /**
     * Get haEnabled value
     * @return string|null
     */
    public function getHaEnabled()
    {
        return $this->haEnabled;
    }
    /**
     * Set haEnabled value
     * @param string $haEnabled
     * @return UpdatePresenceRedundancyGroupReq
     */
    public function setHaEnabled($haEnabled = false)
    {
        // validation for constraint: pattern
        if (is_scalar($haEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $haEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($haEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($haEnabled) && !is_string($haEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($haEnabled)), __LINE__);
        }
        $this->haEnabled = $haEnabled;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdatePresenceRedundancyGroupReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
