<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateIvrUserLocaleReq StructType
 * @subpackage Structs
 */
class UpdateIvrUserLocaleReq extends APIRequest
{
    /**
     * The userLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $userLocale;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newUserLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newUserLocale;
    /**
     * The orderIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $orderIndex;
    /**
     * Constructor method for UpdateIvrUserLocaleReq
     * @uses UpdateIvrUserLocaleReq::setUserLocale()
     * @uses UpdateIvrUserLocaleReq::setUuid()
     * @uses UpdateIvrUserLocaleReq::setNewUserLocale()
     * @uses UpdateIvrUserLocaleReq::setOrderIndex()
     * @param string $userLocale
     * @param string $uuid
     * @param string $newUserLocale
     * @param string $orderIndex
     */
    public function __construct($userLocale = null, $uuid = null, $newUserLocale = null, $orderIndex = null)
    {
        $this
            ->setUserLocale($userLocale)
            ->setUuid($uuid)
            ->setNewUserLocale($newUserLocale)
            ->setOrderIndex($orderIndex);
    }
    /**
     * Get userLocale value
     * @return string
     */
    public function getUserLocale()
    {
        return $this->userLocale;
    }
    /**
     * Set userLocale value
     * @uses XUserLocale::valueIsValid()
     * @uses XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userLocale
     * @return UpdateIvrUserLocaleReq
     */
    public function setUserLocale($userLocale = null)
    {
        // validation for constraint: enumeration
        if (!XUserLocale::valueIsValid($userLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userLocale, implode(', ', XUserLocale::getValidValues())), __LINE__);
        }
        $this->userLocale = $userLocale;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return UpdateIvrUserLocaleReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get newUserLocale value
     * @return string|null
     */
    public function getNewUserLocale()
    {
        return $this->newUserLocale;
    }
    /**
     * Set newUserLocale value
     * @uses XUserLocale::valueIsValid()
     * @uses XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $newUserLocale
     * @return UpdateIvrUserLocaleReq
     */
    public function setNewUserLocale($newUserLocale = null)
    {
        // validation for constraint: enumeration
        if (!XUserLocale::valueIsValid($newUserLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $newUserLocale, implode(', ', XUserLocale::getValidValues())), __LINE__);
        }
        $this->newUserLocale = $newUserLocale;
        return $this;
    }
    /**
     * Get orderIndex value
     * @return string|null
     */
    public function getOrderIndex()
    {
        return $this->orderIndex;
    }
    /**
     * Set orderIndex value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderIndex
     * @return UpdateIvrUserLocaleReq
     */
    public function setOrderIndex($orderIndex = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($orderIndex)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $orderIndex, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->orderIndex = $orderIndex;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdateIvrUserLocaleReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
