<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveRemoteClusterReq StructType
 * @subpackage Structs
 */
class RemoveRemoteClusterReq extends AbstractStructBase
{
    /**
     * The clusterId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $clusterId;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for RemoveRemoteClusterReq
     * @uses RemoveRemoteClusterReq::setClusterId()
     * @uses RemoveRemoteClusterReq::setUuid()
     * @uses RemoveRemoteClusterReq::setSequence()
     * @param string $clusterId
     * @param string $uuid
     * @param int $sequence
     */
    public function __construct($clusterId = null, $uuid = null, $sequence = null)
    {
        $this
            ->setClusterId($clusterId)
            ->setUuid($uuid)
            ->setSequence($sequence);
    }
    /**
     * Get clusterId value
     * @return string
     */
    public function getClusterId()
    {
        return $this->clusterId;
    }
    /**
     * Set clusterId value
     * @param string $clusterId
     * @return RemoveRemoteClusterReq
     */
    public function setClusterId($clusterId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($clusterId) && strlen($clusterId) > 255) || (is_array($clusterId) && count($clusterId) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($clusterId) ? strlen($clusterId) : count($clusterId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($clusterId) && !is_string($clusterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clusterId)), __LINE__);
        }
        $this->clusterId = $clusterId;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RemoveRemoteClusterReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return RemoveRemoteClusterReq
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RemoveRemoteClusterReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
