<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RTodAccess StructType
 * @subpackage Structs
 */
class RTodAccess extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The ownerIdName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $ownerIdName;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Members
     */
    public $members;
    /**
     * The associatedRemoteDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AssociatedRemoteDestination
     */
    public $associatedRemoteDestination;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RTodAccess
     * @uses RTodAccess::setName()
     * @uses RTodAccess::setDescription()
     * @uses RTodAccess::setOwnerIdName()
     * @uses RTodAccess::setMembers()
     * @uses RTodAccess::setAssociatedRemoteDestination()
     * @uses RTodAccess::setUuid()
     * @param string $name
     * @param string $description
     * @param XFkType $ownerIdName
     * @param Members $members
     * @param AssociatedRemoteDestination $associatedRemoteDestination
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, XFkType $ownerIdName = null, Members $members = null, AssociatedRemoteDestination $associatedRemoteDestination = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setOwnerIdName($ownerIdName)
            ->setMembers($members)
            ->setAssociatedRemoteDestination($associatedRemoteDestination)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RTodAccess
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return RTodAccess
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get ownerIdName value
     * @return XFkType|null
     */
    public function getOwnerIdName()
    {
        return $this->ownerIdName;
    }
    /**
     * Set ownerIdName value
     * @param XFkType $ownerIdName
     * @return RTodAccess
     */
    public function setOwnerIdName(XFkType $ownerIdName = null)
    {
        $this->ownerIdName = $ownerIdName;
        return $this;
    }
    /**
     * Get members value
     * @return Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param Members $members
     * @return RTodAccess
     */
    public function setMembers(Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get associatedRemoteDestination value
     * @return AssociatedRemoteDestination|null
     */
    public function getAssociatedRemoteDestination()
    {
        return $this->associatedRemoteDestination;
    }
    /**
     * Set associatedRemoteDestination value
     * @param AssociatedRemoteDestination $associatedRemoteDestination
     * @return RTodAccess
     */
    public function setAssociatedRemoteDestination(AssociatedRemoteDestination $associatedRemoteDestination = null)
    {
        $this->associatedRemoteDestination = $associatedRemoteDestination;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RTodAccess
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RTodAccess
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
