<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RSipTrunkSecurityProfile StructType
 * @subpackage Structs
 */
class RSipTrunkSecurityProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 64
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $description;
    /**
     * The securityMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $securityMode;
    /**
     * The incomingTransport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $incomingTransport;
    /**
     * The outgoingTransport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $outgoingTransport;
    /**
     * The digestAuthentication
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $digestAuthentication;
    /**
     * The noncePolicyTime
     * Meta informations extracted from the WSDL
     * - documentation: Only if digestAuthentication is enabled this value can be changed.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $noncePolicyTime;
    /**
     * The x509SubjectName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 4096
     * @var string
     */
    public $x509SubjectName;
    /**
     * The incomingPort
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $incomingPort;
    /**
     * The applLevelAuthentication
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $applLevelAuthentication;
    /**
     * The acceptPresenceSubscription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptPresenceSubscription;
    /**
     * The acceptOutOfDialogRefer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptOutOfDialogRefer;
    /**
     * The acceptUnsolicitedNotification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptUnsolicitedNotification;
    /**
     * The allowReplaceHeader
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowReplaceHeader;
    /**
     * The transmitSecurityStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $transmitSecurityStatus;
    /**
     * The sipV150OutboundSdpOfferFiltering
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipV150OutboundSdpOfferFiltering;
    /**
     * The allowChargingHeader
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowChargingHeader;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RSipTrunkSecurityProfile
     * @uses RSipTrunkSecurityProfile::setName()
     * @uses RSipTrunkSecurityProfile::setDescription()
     * @uses RSipTrunkSecurityProfile::setSecurityMode()
     * @uses RSipTrunkSecurityProfile::setIncomingTransport()
     * @uses RSipTrunkSecurityProfile::setOutgoingTransport()
     * @uses RSipTrunkSecurityProfile::setDigestAuthentication()
     * @uses RSipTrunkSecurityProfile::setNoncePolicyTime()
     * @uses RSipTrunkSecurityProfile::setX509SubjectName()
     * @uses RSipTrunkSecurityProfile::setIncomingPort()
     * @uses RSipTrunkSecurityProfile::setApplLevelAuthentication()
     * @uses RSipTrunkSecurityProfile::setAcceptPresenceSubscription()
     * @uses RSipTrunkSecurityProfile::setAcceptOutOfDialogRefer()
     * @uses RSipTrunkSecurityProfile::setAcceptUnsolicitedNotification()
     * @uses RSipTrunkSecurityProfile::setAllowReplaceHeader()
     * @uses RSipTrunkSecurityProfile::setTransmitSecurityStatus()
     * @uses RSipTrunkSecurityProfile::setSipV150OutboundSdpOfferFiltering()
     * @uses RSipTrunkSecurityProfile::setAllowChargingHeader()
     * @uses RSipTrunkSecurityProfile::setUuid()
     * @param string $name
     * @param string $description
     * @param string $securityMode
     * @param string $incomingTransport
     * @param string $outgoingTransport
     * @param string $digestAuthentication
     * @param string $noncePolicyTime
     * @param string $x509SubjectName
     * @param string $incomingPort
     * @param string $applLevelAuthentication
     * @param string $acceptPresenceSubscription
     * @param string $acceptOutOfDialogRefer
     * @param string $acceptUnsolicitedNotification
     * @param string $allowReplaceHeader
     * @param string $transmitSecurityStatus
     * @param string $sipV150OutboundSdpOfferFiltering
     * @param string $allowChargingHeader
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $securityMode = null, $incomingTransport = null, $outgoingTransport = null, $digestAuthentication = null, $noncePolicyTime = null, $x509SubjectName = null, $incomingPort = null, $applLevelAuthentication = null, $acceptPresenceSubscription = null, $acceptOutOfDialogRefer = null, $acceptUnsolicitedNotification = null, $allowReplaceHeader = null, $transmitSecurityStatus = null, $sipV150OutboundSdpOfferFiltering = null, $allowChargingHeader = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setSecurityMode($securityMode)
            ->setIncomingTransport($incomingTransport)
            ->setOutgoingTransport($outgoingTransport)
            ->setDigestAuthentication($digestAuthentication)
            ->setNoncePolicyTime($noncePolicyTime)
            ->setX509SubjectName($x509SubjectName)
            ->setIncomingPort($incomingPort)
            ->setApplLevelAuthentication($applLevelAuthentication)
            ->setAcceptPresenceSubscription($acceptPresenceSubscription)
            ->setAcceptOutOfDialogRefer($acceptOutOfDialogRefer)
            ->setAcceptUnsolicitedNotification($acceptUnsolicitedNotification)
            ->setAllowReplaceHeader($allowReplaceHeader)
            ->setTransmitSecurityStatus($transmitSecurityStatus)
            ->setSipV150OutboundSdpOfferFiltering($sipV150OutboundSdpOfferFiltering)
            ->setAllowChargingHeader($allowChargingHeader)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RSipTrunkSecurityProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 64) || (is_array($name) && count($name) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return RSipTrunkSecurityProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 100) || (is_array($description) && count($description) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get securityMode value
     * @return string|null
     */
    public function getSecurityMode()
    {
        return $this->securityMode;
    }
    /**
     * Set securityMode value
     * @uses XDeviceSecurityMode::valueIsValid()
     * @uses XDeviceSecurityMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $securityMode
     * @return RSipTrunkSecurityProfile
     */
    public function setSecurityMode($securityMode = null)
    {
        // validation for constraint: enumeration
        if (!XDeviceSecurityMode::valueIsValid($securityMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $securityMode, implode(', ', XDeviceSecurityMode::getValidValues())), __LINE__);
        }
        $this->securityMode = $securityMode;
        return $this;
    }
    /**
     * Get incomingTransport value
     * @return string|null
     */
    public function getIncomingTransport()
    {
        return $this->incomingTransport;
    }
    /**
     * Set incomingTransport value
     * @uses XTransport::valueIsValid()
     * @uses XTransport::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $incomingTransport
     * @return RSipTrunkSecurityProfile
     */
    public function setIncomingTransport($incomingTransport = null)
    {
        // validation for constraint: enumeration
        if (!XTransport::valueIsValid($incomingTransport)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $incomingTransport, implode(', ', XTransport::getValidValues())), __LINE__);
        }
        $this->incomingTransport = $incomingTransport;
        return $this;
    }
    /**
     * Get outgoingTransport value
     * @return string|null
     */
    public function getOutgoingTransport()
    {
        return $this->outgoingTransport;
    }
    /**
     * Set outgoingTransport value
     * @uses XTransport::valueIsValid()
     * @uses XTransport::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $outgoingTransport
     * @return RSipTrunkSecurityProfile
     */
    public function setOutgoingTransport($outgoingTransport = null)
    {
        // validation for constraint: enumeration
        if (!XTransport::valueIsValid($outgoingTransport)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $outgoingTransport, implode(', ', XTransport::getValidValues())), __LINE__);
        }
        $this->outgoingTransport = $outgoingTransport;
        return $this;
    }
    /**
     * Get digestAuthentication value
     * @return string|null
     */
    public function getDigestAuthentication()
    {
        return $this->digestAuthentication;
    }
    /**
     * Set digestAuthentication value
     * @param string $digestAuthentication
     * @return RSipTrunkSecurityProfile
     */
    public function setDigestAuthentication($digestAuthentication = null)
    {
        // validation for constraint: pattern
        if (is_scalar($digestAuthentication) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $digestAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($digestAuthentication, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($digestAuthentication) && !is_string($digestAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($digestAuthentication)), __LINE__);
        }
        $this->digestAuthentication = $digestAuthentication;
        return $this;
    }
    /**
     * Get noncePolicyTime value
     * @return string|null
     */
    public function getNoncePolicyTime()
    {
        return $this->noncePolicyTime;
    }
    /**
     * Set noncePolicyTime value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $noncePolicyTime
     * @return RSipTrunkSecurityProfile
     */
    public function setNoncePolicyTime($noncePolicyTime = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($noncePolicyTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $noncePolicyTime, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->noncePolicyTime = $noncePolicyTime;
        return $this;
    }
    /**
     * Get x509SubjectName value
     * @return string|null
     */
    public function getX509SubjectName()
    {
        return $this->x509SubjectName;
    }
    /**
     * Set x509SubjectName value
     * @param string $x509SubjectName
     * @return RSipTrunkSecurityProfile
     */
    public function setX509SubjectName($x509SubjectName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($x509SubjectName) && strlen($x509SubjectName) > 4096) || (is_array($x509SubjectName) && count($x509SubjectName) > 4096)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4096 element(s) or a scalar of 4096 character(s) at most, "%d" length given', is_scalar($x509SubjectName) ? strlen($x509SubjectName) : count($x509SubjectName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($x509SubjectName) && !is_string($x509SubjectName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($x509SubjectName)), __LINE__);
        }
        $this->x509SubjectName = $x509SubjectName;
        return $this;
    }
    /**
     * Get incomingPort value
     * @return string|null
     */
    public function getIncomingPort()
    {
        return $this->incomingPort;
    }
    /**
     * Set incomingPort value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $incomingPort
     * @return RSipTrunkSecurityProfile
     */
    public function setIncomingPort($incomingPort = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($incomingPort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $incomingPort, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->incomingPort = $incomingPort;
        return $this;
    }
    /**
     * Get applLevelAuthentication value
     * @return string|null
     */
    public function getApplLevelAuthentication()
    {
        return $this->applLevelAuthentication;
    }
    /**
     * Set applLevelAuthentication value
     * @param string $applLevelAuthentication
     * @return RSipTrunkSecurityProfile
     */
    public function setApplLevelAuthentication($applLevelAuthentication = null)
    {
        // validation for constraint: pattern
        if (is_scalar($applLevelAuthentication) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $applLevelAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($applLevelAuthentication, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($applLevelAuthentication) && !is_string($applLevelAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applLevelAuthentication)), __LINE__);
        }
        $this->applLevelAuthentication = $applLevelAuthentication;
        return $this;
    }
    /**
     * Get acceptPresenceSubscription value
     * @return string|null
     */
    public function getAcceptPresenceSubscription()
    {
        return $this->acceptPresenceSubscription;
    }
    /**
     * Set acceptPresenceSubscription value
     * @param string $acceptPresenceSubscription
     * @return RSipTrunkSecurityProfile
     */
    public function setAcceptPresenceSubscription($acceptPresenceSubscription = null)
    {
        // validation for constraint: pattern
        if (is_scalar($acceptPresenceSubscription) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptPresenceSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($acceptPresenceSubscription, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($acceptPresenceSubscription) && !is_string($acceptPresenceSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($acceptPresenceSubscription)), __LINE__);
        }
        $this->acceptPresenceSubscription = $acceptPresenceSubscription;
        return $this;
    }
    /**
     * Get acceptOutOfDialogRefer value
     * @return string|null
     */
    public function getAcceptOutOfDialogRefer()
    {
        return $this->acceptOutOfDialogRefer;
    }
    /**
     * Set acceptOutOfDialogRefer value
     * @param string $acceptOutOfDialogRefer
     * @return RSipTrunkSecurityProfile
     */
    public function setAcceptOutOfDialogRefer($acceptOutOfDialogRefer = null)
    {
        // validation for constraint: pattern
        if (is_scalar($acceptOutOfDialogRefer) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptOutOfDialogRefer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($acceptOutOfDialogRefer, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($acceptOutOfDialogRefer) && !is_string($acceptOutOfDialogRefer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($acceptOutOfDialogRefer)), __LINE__);
        }
        $this->acceptOutOfDialogRefer = $acceptOutOfDialogRefer;
        return $this;
    }
    /**
     * Get acceptUnsolicitedNotification value
     * @return string|null
     */
    public function getAcceptUnsolicitedNotification()
    {
        return $this->acceptUnsolicitedNotification;
    }
    /**
     * Set acceptUnsolicitedNotification value
     * @param string $acceptUnsolicitedNotification
     * @return RSipTrunkSecurityProfile
     */
    public function setAcceptUnsolicitedNotification($acceptUnsolicitedNotification = null)
    {
        // validation for constraint: pattern
        if (is_scalar($acceptUnsolicitedNotification) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptUnsolicitedNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($acceptUnsolicitedNotification, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($acceptUnsolicitedNotification) && !is_string($acceptUnsolicitedNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($acceptUnsolicitedNotification)), __LINE__);
        }
        $this->acceptUnsolicitedNotification = $acceptUnsolicitedNotification;
        return $this;
    }
    /**
     * Get allowReplaceHeader value
     * @return string|null
     */
    public function getAllowReplaceHeader()
    {
        return $this->allowReplaceHeader;
    }
    /**
     * Set allowReplaceHeader value
     * @param string $allowReplaceHeader
     * @return RSipTrunkSecurityProfile
     */
    public function setAllowReplaceHeader($allowReplaceHeader = null)
    {
        // validation for constraint: pattern
        if (is_scalar($allowReplaceHeader) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowReplaceHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowReplaceHeader, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowReplaceHeader) && !is_string($allowReplaceHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowReplaceHeader)), __LINE__);
        }
        $this->allowReplaceHeader = $allowReplaceHeader;
        return $this;
    }
    /**
     * Get transmitSecurityStatus value
     * @return string|null
     */
    public function getTransmitSecurityStatus()
    {
        return $this->transmitSecurityStatus;
    }
    /**
     * Set transmitSecurityStatus value
     * @param string $transmitSecurityStatus
     * @return RSipTrunkSecurityProfile
     */
    public function setTransmitSecurityStatus($transmitSecurityStatus = null)
    {
        // validation for constraint: pattern
        if (is_scalar($transmitSecurityStatus) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $transmitSecurityStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($transmitSecurityStatus, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($transmitSecurityStatus) && !is_string($transmitSecurityStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transmitSecurityStatus)), __LINE__);
        }
        $this->transmitSecurityStatus = $transmitSecurityStatus;
        return $this;
    }
    /**
     * Get sipV150OutboundSdpOfferFiltering value
     * @return string|null
     */
    public function getSipV150OutboundSdpOfferFiltering()
    {
        return $this->sipV150OutboundSdpOfferFiltering;
    }
    /**
     * Set sipV150OutboundSdpOfferFiltering value
     * @uses XV150SDPFilter::valueIsValid()
     * @uses XV150SDPFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipV150OutboundSdpOfferFiltering
     * @return RSipTrunkSecurityProfile
     */
    public function setSipV150OutboundSdpOfferFiltering($sipV150OutboundSdpOfferFiltering = null)
    {
        // validation for constraint: enumeration
        if (!XV150SDPFilter::valueIsValid($sipV150OutboundSdpOfferFiltering)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sipV150OutboundSdpOfferFiltering, implode(', ', XV150SDPFilter::getValidValues())), __LINE__);
        }
        $this->sipV150OutboundSdpOfferFiltering = $sipV150OutboundSdpOfferFiltering;
        return $this;
    }
    /**
     * Get allowChargingHeader value
     * @return string|null
     */
    public function getAllowChargingHeader()
    {
        return $this->allowChargingHeader;
    }
    /**
     * Set allowChargingHeader value
     * @param string $allowChargingHeader
     * @return RSipTrunkSecurityProfile
     */
    public function setAllowChargingHeader($allowChargingHeader = null)
    {
        // validation for constraint: pattern
        if (is_scalar($allowChargingHeader) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowChargingHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowChargingHeader, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowChargingHeader) && !is_string($allowChargingHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowChargingHeader)), __LINE__);
        }
        $this->allowChargingHeader = $allowChargingHeader;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RSipTrunkSecurityProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RSipTrunkSecurityProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
