<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RSafForwarder StructType
 * @subpackage Structs
 */
class RSafForwarder extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The clientLabel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $clientLabel;
    /**
     * The safSecurityProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $safSecurityProfile;
    /**
     * The ipAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $ipAddress;
    /**
     * The port
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $port;
    /**
     * The enableTcpKeepAlive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableTcpKeepAlive;
    /**
     * The safReconnectInterval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $safReconnectInterval;
    /**
     * The safNotificationsWindowSize
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $safNotificationsWindowSize;
    /**
     * The associatedCucms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AssociatedCucms
     */
    public $associatedCucms;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RSafForwarder
     * @uses RSafForwarder::setName()
     * @uses RSafForwarder::setDescription()
     * @uses RSafForwarder::setClientLabel()
     * @uses RSafForwarder::setSafSecurityProfile()
     * @uses RSafForwarder::setIpAddress()
     * @uses RSafForwarder::setPort()
     * @uses RSafForwarder::setEnableTcpKeepAlive()
     * @uses RSafForwarder::setSafReconnectInterval()
     * @uses RSafForwarder::setSafNotificationsWindowSize()
     * @uses RSafForwarder::setAssociatedCucms()
     * @uses RSafForwarder::setUuid()
     * @param string $name
     * @param string $description
     * @param string $clientLabel
     * @param XFkType $safSecurityProfile
     * @param string $ipAddress
     * @param string $port
     * @param string $enableTcpKeepAlive
     * @param string $safReconnectInterval
     * @param string $safNotificationsWindowSize
     * @param AssociatedCucms $associatedCucms
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $clientLabel = null, XFkType $safSecurityProfile = null, $ipAddress = null, $port = null, $enableTcpKeepAlive = null, $safReconnectInterval = null, $safNotificationsWindowSize = null, AssociatedCucms $associatedCucms = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setClientLabel($clientLabel)
            ->setSafSecurityProfile($safSecurityProfile)
            ->setIpAddress($ipAddress)
            ->setPort($port)
            ->setEnableTcpKeepAlive($enableTcpKeepAlive)
            ->setSafReconnectInterval($safReconnectInterval)
            ->setSafNotificationsWindowSize($safNotificationsWindowSize)
            ->setAssociatedCucms($associatedCucms)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RSafForwarder
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 255) || (is_array($name) && count($name) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return RSafForwarder
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get clientLabel value
     * @return string|null
     */
    public function getClientLabel()
    {
        return $this->clientLabel;
    }
    /**
     * Set clientLabel value
     * @param string $clientLabel
     * @return RSafForwarder
     */
    public function setClientLabel($clientLabel = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($clientLabel) && strlen($clientLabel) > 255) || (is_array($clientLabel) && count($clientLabel) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($clientLabel) ? strlen($clientLabel) : count($clientLabel)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($clientLabel) && !is_string($clientLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientLabel)), __LINE__);
        }
        $this->clientLabel = $clientLabel;
        return $this;
    }
    /**
     * Get safSecurityProfile value
     * @return XFkType|null
     */
    public function getSafSecurityProfile()
    {
        return $this->safSecurityProfile;
    }
    /**
     * Set safSecurityProfile value
     * @param XFkType $safSecurityProfile
     * @return RSafForwarder
     */
    public function setSafSecurityProfile(XFkType $safSecurityProfile = null)
    {
        $this->safSecurityProfile = $safSecurityProfile;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return RSafForwarder
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ipAddress) && strlen($ipAddress) > 255) || (is_array($ipAddress) && count($ipAddress) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($ipAddress) ? strlen($ipAddress) : count($ipAddress)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipAddress)), __LINE__);
        }
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return RSafForwarder
     */
    public function setPort($port = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $port, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Get enableTcpKeepAlive value
     * @return string|null
     */
    public function getEnableTcpKeepAlive()
    {
        return $this->enableTcpKeepAlive;
    }
    /**
     * Set enableTcpKeepAlive value
     * @param string $enableTcpKeepAlive
     * @return RSafForwarder
     */
    public function setEnableTcpKeepAlive($enableTcpKeepAlive = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableTcpKeepAlive) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableTcpKeepAlive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableTcpKeepAlive, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableTcpKeepAlive) && !is_string($enableTcpKeepAlive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableTcpKeepAlive)), __LINE__);
        }
        $this->enableTcpKeepAlive = $enableTcpKeepAlive;
        return $this;
    }
    /**
     * Get safReconnectInterval value
     * @return string|null
     */
    public function getSafReconnectInterval()
    {
        return $this->safReconnectInterval;
    }
    /**
     * Set safReconnectInterval value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $safReconnectInterval
     * @return RSafForwarder
     */
    public function setSafReconnectInterval($safReconnectInterval = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($safReconnectInterval)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $safReconnectInterval, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->safReconnectInterval = $safReconnectInterval;
        return $this;
    }
    /**
     * Get safNotificationsWindowSize value
     * @return string|null
     */
    public function getSafNotificationsWindowSize()
    {
        return $this->safNotificationsWindowSize;
    }
    /**
     * Set safNotificationsWindowSize value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $safNotificationsWindowSize
     * @return RSafForwarder
     */
    public function setSafNotificationsWindowSize($safNotificationsWindowSize = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($safNotificationsWindowSize)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $safNotificationsWindowSize, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->safNotificationsWindowSize = $safNotificationsWindowSize;
        return $this;
    }
    /**
     * Get associatedCucms value
     * @return AssociatedCucms|null
     */
    public function getAssociatedCucms()
    {
        return $this->associatedCucms;
    }
    /**
     * Set associatedCucms value
     * @param AssociatedCucms $associatedCucms
     * @return RSafForwarder
     */
    public function setAssociatedCucms(AssociatedCucms $associatedCucms = null)
    {
        $this->associatedCucms = $associatedCucms;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RSafForwarder
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RSafForwarder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
