<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RRouteGroup StructType
 * @subpackage Structs
 */
class RRouteGroup extends AbstractStructBase
{
    /**
     * The dialPlanWizardGenld
     * Meta informations extracted from the WSDL
     * - documentation: Read-only.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dialPlanWizardGenld;
    /**
     * The distributionAlgorithm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $distributionAlgorithm;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Members
     */
    public $members;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RRouteGroup
     * @uses RRouteGroup::setDialPlanWizardGenld()
     * @uses RRouteGroup::setDistributionAlgorithm()
     * @uses RRouteGroup::setMembers()
     * @uses RRouteGroup::setName()
     * @uses RRouteGroup::setUuid()
     * @param string $dialPlanWizardGenld
     * @param string $distributionAlgorithm
     * @param Members $members
     * @param string $name
     * @param string $uuid
     */
    public function __construct($dialPlanWizardGenld = null, $distributionAlgorithm = null, Members $members = null, $name = null, $uuid = null)
    {
        $this
            ->setDialPlanWizardGenld($dialPlanWizardGenld)
            ->setDistributionAlgorithm($distributionAlgorithm)
            ->setMembers($members)
            ->setName($name)
            ->setUuid($uuid);
    }
    /**
     * Get dialPlanWizardGenld value
     * @return string|null
     */
    public function getDialPlanWizardGenld()
    {
        return $this->dialPlanWizardGenld;
    }
    /**
     * Set dialPlanWizardGenld value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dialPlanWizardGenld
     * @return RRouteGroup
     */
    public function setDialPlanWizardGenld($dialPlanWizardGenld = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($dialPlanWizardGenld)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dialPlanWizardGenld, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->dialPlanWizardGenld = $dialPlanWizardGenld;
        return $this;
    }
    /**
     * Get distributionAlgorithm value
     * @return string|null
     */
    public function getDistributionAlgorithm()
    {
        return $this->distributionAlgorithm;
    }
    /**
     * Set distributionAlgorithm value
     * @uses XDistributeAlgorithm::valueIsValid()
     * @uses XDistributeAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $distributionAlgorithm
     * @return RRouteGroup
     */
    public function setDistributionAlgorithm($distributionAlgorithm = null)
    {
        // validation for constraint: enumeration
        if (!XDistributeAlgorithm::valueIsValid($distributionAlgorithm)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $distributionAlgorithm, implode(', ', XDistributeAlgorithm::getValidValues())), __LINE__);
        }
        $this->distributionAlgorithm = $distributionAlgorithm;
        return $this;
    }
    /**
     * Get members value
     * @return Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param Members $members
     * @return RRouteGroup
     */
    public function setMembers(Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RRouteGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RRouteGroup
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RRouteGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
