<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RRemoteDestination StructType
 * @subpackage Structs
 */
class RRemoteDestination extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The destination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $destination;
    /**
     * The answerTooSoonTimer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $answerTooSoonTimer;
    /**
     * The answerTooLateTimer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $answerTooLateTimer;
    /**
     * The delayBeforeRingingCell
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $delayBeforeRingingCell;
    /**
     * The ownerUserId
     * Meta informations extracted from the WSDL
     * - documentation: From 10.5, to get proper value of this tag in get handler's response it is required to have value of todaccess, in case if user does not give any value in todaccesss tag, axl will insert a random row so that get handler response can
     * return proper value of Owner User id
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $ownerUserId;
    /**
     * The remoteDestinationProfileName
     * Meta informations extracted from the WSDL
     * - documentation: If you are giving value to dualModeDeviceName then you can't give value to remoteDestinationProfileName,viceversa
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $remoteDestinationProfileName;
    /**
     * The ctiRemoteDeviceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $ctiRemoteDeviceName;
    /**
     * The dualModeDeviceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $dualModeDeviceName;
    /**
     * The isMobilePhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isMobilePhone;
    /**
     * The enableMobileConnect
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableMobileConnect;
    /**
     * The lineAssociations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var LineAssociations
     */
    public $lineAssociations;
    /**
     * The timeZone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timeZone;
    /**
     * The todAccessName
     * Meta informations extracted from the WSDL
     * - documentation: From 10.5 version if a user doesn't specify a value in this tag, AXL will still insert a random row in todaccess because value in todaccess is required to fetch value of owner user id properly in get handler
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $todAccessName;
    /**
     * The mobileSmartClientName
     * Meta informations extracted from the WSDL
     * - documentation: This tag is not applicable for dualmode phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $mobileSmartClientName;
    /**
     * The mobilityProfileName
     * Meta informations extracted from the WSDL
     * - documentation: This tag is applicable only to CUMC devices.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $mobilityProfileName;
    /**
     * The singleNumberReachVoicemail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $singleNumberReachVoicemail;
    /**
     * The dialViaOfficeReverseVoicemail
     * Meta informations extracted from the WSDL
     * - documentation: This tag is for Mobility Identity
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dialViaOfficeReverseVoicemail;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RRemoteDestination
     * @uses RRemoteDestination::setName()
     * @uses RRemoteDestination::setDestination()
     * @uses RRemoteDestination::setAnswerTooSoonTimer()
     * @uses RRemoteDestination::setAnswerTooLateTimer()
     * @uses RRemoteDestination::setDelayBeforeRingingCell()
     * @uses RRemoteDestination::setOwnerUserId()
     * @uses RRemoteDestination::setRemoteDestinationProfileName()
     * @uses RRemoteDestination::setCtiRemoteDeviceName()
     * @uses RRemoteDestination::setDualModeDeviceName()
     * @uses RRemoteDestination::setIsMobilePhone()
     * @uses RRemoteDestination::setEnableMobileConnect()
     * @uses RRemoteDestination::setLineAssociations()
     * @uses RRemoteDestination::setTimeZone()
     * @uses RRemoteDestination::setTodAccessName()
     * @uses RRemoteDestination::setMobileSmartClientName()
     * @uses RRemoteDestination::setMobilityProfileName()
     * @uses RRemoteDestination::setSingleNumberReachVoicemail()
     * @uses RRemoteDestination::setDialViaOfficeReverseVoicemail()
     * @uses RRemoteDestination::setUuid()
     * @param string $name
     * @param string $destination
     * @param string $answerTooSoonTimer
     * @param string $answerTooLateTimer
     * @param string $delayBeforeRingingCell
     * @param XFkType $ownerUserId
     * @param XFkType $remoteDestinationProfileName
     * @param XFkType $ctiRemoteDeviceName
     * @param XFkType $dualModeDeviceName
     * @param string $isMobilePhone
     * @param string $enableMobileConnect
     * @param LineAssociations $lineAssociations
     * @param string $timeZone
     * @param XFkType $todAccessName
     * @param XFkType $mobileSmartClientName
     * @param XFkType $mobilityProfileName
     * @param string $singleNumberReachVoicemail
     * @param string $dialViaOfficeReverseVoicemail
     * @param string $uuid
     */
    public function __construct($name = null, $destination = null, $answerTooSoonTimer = null, $answerTooLateTimer = null, $delayBeforeRingingCell = null, XFkType $ownerUserId = null, XFkType $remoteDestinationProfileName = null, XFkType $ctiRemoteDeviceName = null, XFkType $dualModeDeviceName = null, $isMobilePhone = null, $enableMobileConnect = null, LineAssociations $lineAssociations = null, $timeZone = null, XFkType $todAccessName = null, XFkType $mobileSmartClientName = null, XFkType $mobilityProfileName = null, $singleNumberReachVoicemail = null, $dialViaOfficeReverseVoicemail = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDestination($destination)
            ->setAnswerTooSoonTimer($answerTooSoonTimer)
            ->setAnswerTooLateTimer($answerTooLateTimer)
            ->setDelayBeforeRingingCell($delayBeforeRingingCell)
            ->setOwnerUserId($ownerUserId)
            ->setRemoteDestinationProfileName($remoteDestinationProfileName)
            ->setCtiRemoteDeviceName($ctiRemoteDeviceName)
            ->setDualModeDeviceName($dualModeDeviceName)
            ->setIsMobilePhone($isMobilePhone)
            ->setEnableMobileConnect($enableMobileConnect)
            ->setLineAssociations($lineAssociations)
            ->setTimeZone($timeZone)
            ->setTodAccessName($todAccessName)
            ->setMobileSmartClientName($mobileSmartClientName)
            ->setMobilityProfileName($mobilityProfileName)
            ->setSingleNumberReachVoicemail($singleNumberReachVoicemail)
            ->setDialViaOfficeReverseVoicemail($dialViaOfficeReverseVoicemail)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RRemoteDestination
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return RRemoteDestination
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get answerTooSoonTimer value
     * @return string|null
     */
    public function getAnswerTooSoonTimer()
    {
        return $this->answerTooSoonTimer;
    }
    /**
     * Set answerTooSoonTimer value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $answerTooSoonTimer
     * @return RRemoteDestination
     */
    public function setAnswerTooSoonTimer($answerTooSoonTimer = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($answerTooSoonTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $answerTooSoonTimer, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->answerTooSoonTimer = $answerTooSoonTimer;
        return $this;
    }
    /**
     * Get answerTooLateTimer value
     * @return string|null
     */
    public function getAnswerTooLateTimer()
    {
        return $this->answerTooLateTimer;
    }
    /**
     * Set answerTooLateTimer value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $answerTooLateTimer
     * @return RRemoteDestination
     */
    public function setAnswerTooLateTimer($answerTooLateTimer = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($answerTooLateTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $answerTooLateTimer, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->answerTooLateTimer = $answerTooLateTimer;
        return $this;
    }
    /**
     * Get delayBeforeRingingCell value
     * @return string|null
     */
    public function getDelayBeforeRingingCell()
    {
        return $this->delayBeforeRingingCell;
    }
    /**
     * Set delayBeforeRingingCell value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $delayBeforeRingingCell
     * @return RRemoteDestination
     */
    public function setDelayBeforeRingingCell($delayBeforeRingingCell = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($delayBeforeRingingCell)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $delayBeforeRingingCell, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->delayBeforeRingingCell = $delayBeforeRingingCell;
        return $this;
    }
    /**
     * Get ownerUserId value
     * @return XFkType|null
     */
    public function getOwnerUserId()
    {
        return $this->ownerUserId;
    }
    /**
     * Set ownerUserId value
     * @param XFkType $ownerUserId
     * @return RRemoteDestination
     */
    public function setOwnerUserId(XFkType $ownerUserId = null)
    {
        $this->ownerUserId = $ownerUserId;
        return $this;
    }
    /**
     * Get remoteDestinationProfileName value
     * @return XFkType|null
     */
    public function getRemoteDestinationProfileName()
    {
        return $this->remoteDestinationProfileName;
    }
    /**
     * Set remoteDestinationProfileName value
     * @param XFkType $remoteDestinationProfileName
     * @return RRemoteDestination
     */
    public function setRemoteDestinationProfileName(XFkType $remoteDestinationProfileName = null)
    {
        $this->remoteDestinationProfileName = $remoteDestinationProfileName;
        return $this;
    }
    /**
     * Get ctiRemoteDeviceName value
     * @return XFkType|null
     */
    public function getCtiRemoteDeviceName()
    {
        return $this->ctiRemoteDeviceName;
    }
    /**
     * Set ctiRemoteDeviceName value
     * @param XFkType $ctiRemoteDeviceName
     * @return RRemoteDestination
     */
    public function setCtiRemoteDeviceName(XFkType $ctiRemoteDeviceName = null)
    {
        $this->ctiRemoteDeviceName = $ctiRemoteDeviceName;
        return $this;
    }
    /**
     * Get dualModeDeviceName value
     * @return XFkType|null
     */
    public function getDualModeDeviceName()
    {
        return $this->dualModeDeviceName;
    }
    /**
     * Set dualModeDeviceName value
     * @param XFkType $dualModeDeviceName
     * @return RRemoteDestination
     */
    public function setDualModeDeviceName(XFkType $dualModeDeviceName = null)
    {
        $this->dualModeDeviceName = $dualModeDeviceName;
        return $this;
    }
    /**
     * Get isMobilePhone value
     * @return string|null
     */
    public function getIsMobilePhone()
    {
        return $this->isMobilePhone;
    }
    /**
     * Set isMobilePhone value
     * @param string $isMobilePhone
     * @return RRemoteDestination
     */
    public function setIsMobilePhone($isMobilePhone = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isMobilePhone) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isMobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isMobilePhone, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isMobilePhone) && !is_string($isMobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isMobilePhone)), __LINE__);
        }
        $this->isMobilePhone = $isMobilePhone;
        return $this;
    }
    /**
     * Get enableMobileConnect value
     * @return string|null
     */
    public function getEnableMobileConnect()
    {
        return $this->enableMobileConnect;
    }
    /**
     * Set enableMobileConnect value
     * @param string $enableMobileConnect
     * @return RRemoteDestination
     */
    public function setEnableMobileConnect($enableMobileConnect = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableMobileConnect) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableMobileConnect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableMobileConnect, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableMobileConnect) && !is_string($enableMobileConnect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableMobileConnect)), __LINE__);
        }
        $this->enableMobileConnect = $enableMobileConnect;
        return $this;
    }
    /**
     * Get lineAssociations value
     * @return LineAssociations|null
     */
    public function getLineAssociations()
    {
        return $this->lineAssociations;
    }
    /**
     * Set lineAssociations value
     * @param LineAssociations $lineAssociations
     * @return RRemoteDestination
     */
    public function setLineAssociations(LineAssociations $lineAssociations = null)
    {
        $this->lineAssociations = $lineAssociations;
        return $this;
    }
    /**
     * Get timeZone value
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }
    /**
     * Set timeZone value
     * @uses XTimeZone::valueIsValid()
     * @uses XTimeZone::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeZone
     * @return RRemoteDestination
     */
    public function setTimeZone($timeZone = null)
    {
        // validation for constraint: enumeration
        if (!XTimeZone::valueIsValid($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timeZone, implode(', ', XTimeZone::getValidValues())), __LINE__);
        }
        $this->timeZone = $timeZone;
        return $this;
    }
    /**
     * Get todAccessName value
     * @return XFkType|null
     */
    public function getTodAccessName()
    {
        return $this->todAccessName;
    }
    /**
     * Set todAccessName value
     * @param XFkType $todAccessName
     * @return RRemoteDestination
     */
    public function setTodAccessName(XFkType $todAccessName = null)
    {
        $this->todAccessName = $todAccessName;
        return $this;
    }
    /**
     * Get mobileSmartClientName value
     * @return XFkType|null
     */
    public function getMobileSmartClientName()
    {
        return $this->mobileSmartClientName;
    }
    /**
     * Set mobileSmartClientName value
     * @param XFkType $mobileSmartClientName
     * @return RRemoteDestination
     */
    public function setMobileSmartClientName(XFkType $mobileSmartClientName = null)
    {
        $this->mobileSmartClientName = $mobileSmartClientName;
        return $this;
    }
    /**
     * Get mobilityProfileName value
     * @return XFkType|null
     */
    public function getMobilityProfileName()
    {
        return $this->mobilityProfileName;
    }
    /**
     * Set mobilityProfileName value
     * @param XFkType $mobilityProfileName
     * @return RRemoteDestination
     */
    public function setMobilityProfileName(XFkType $mobilityProfileName = null)
    {
        $this->mobilityProfileName = $mobilityProfileName;
        return $this;
    }
    /**
     * Get singleNumberReachVoicemail value
     * @return string|null
     */
    public function getSingleNumberReachVoicemail()
    {
        return $this->singleNumberReachVoicemail;
    }
    /**
     * Set singleNumberReachVoicemail value
     * @uses XVMAvoidancePolicy::valueIsValid()
     * @uses XVMAvoidancePolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $singleNumberReachVoicemail
     * @return RRemoteDestination
     */
    public function setSingleNumberReachVoicemail($singleNumberReachVoicemail = null)
    {
        // validation for constraint: enumeration
        if (!XVMAvoidancePolicy::valueIsValid($singleNumberReachVoicemail)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $singleNumberReachVoicemail, implode(', ', XVMAvoidancePolicy::getValidValues())), __LINE__);
        }
        $this->singleNumberReachVoicemail = $singleNumberReachVoicemail;
        return $this;
    }
    /**
     * Get dialViaOfficeReverseVoicemail value
     * @return string|null
     */
    public function getDialViaOfficeReverseVoicemail()
    {
        return $this->dialViaOfficeReverseVoicemail;
    }
    /**
     * Set dialViaOfficeReverseVoicemail value
     * @uses XVMAvoidancePolicy::valueIsValid()
     * @uses XVMAvoidancePolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dialViaOfficeReverseVoicemail
     * @return RRemoteDestination
     */
    public function setDialViaOfficeReverseVoicemail($dialViaOfficeReverseVoicemail = null)
    {
        // validation for constraint: enumeration
        if (!XVMAvoidancePolicy::valueIsValid($dialViaOfficeReverseVoicemail)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dialViaOfficeReverseVoicemail, implode(', ', XVMAvoidancePolicy::getValidValues())), __LINE__);
        }
        $this->dialViaOfficeReverseVoicemail = $dialViaOfficeReverseVoicemail;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RRemoteDestination
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RRemoteDestination
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
