<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RMohServer StructType
 * @subpackage Structs
 */
class RMohServer extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The processNodeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $processNodeName;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $devicePoolName;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $locationName;
    /**
     * The maxUnicastConnections
     * Meta informations extracted from the WSDL
     * - documentation: Maximum Half Duplex Streams must be a number in the range 0 to 500.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxUnicastConnections;
    /**
     * The maxMulticastConnections
     * Meta informations extracted from the WSDL
     * - documentation: Maximum Multicast Connections must be a number in the range 0 to 999999.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxMulticastConnections;
    /**
     * The fixedAudioSourceDevice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fixedAudioSourceDevice;
    /**
     * The runFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $runFlag;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The isMultiCastEnabled
     * Meta informations extracted from the WSDL
     * - documentation: If isMultiCastEnabled is false then these elements are not necessary.MOHServer will be added to the database without the values of these tags. ie. The table MOHServerMulticastInfo table will be empty. Multicast Base Port number must
     * be an even number in the range 16384 to 32766.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isMultiCastEnabled;
    /**
     * The baseMulticastIpaddress
     * Meta informations extracted from the WSDL
     * - documentation: If isMultiCastEnabled is false then these elements are not necessary.MOHServer will be added to the database without the values of these tags. ie. The table MOHServerMulticastInfo table will be empty. Multicast Base Port number must
     * be an even number in the range 16384 to 32766. baseMulticastIPAddress and baseMulticastPort must be a unique pair. All Multicast IP Addresses must be in the range 239.1.1.1 to 239.255.255.255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $baseMulticastIpaddress;
    /**
     * The baseMulticastPort
     * Meta informations extracted from the WSDL
     * - documentation: If isMultiCastEnabled is false then these elements are not necessary.MOHServer will be added to the database without the values of these tags. ie. The table MOHServerMulticastInfo table will be empty. Multicast Base Port number must
     * be an even number in the range 16384 to 32766
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $baseMulticastPort;
    /**
     * The multicastIncrementOnIp
     * Meta informations extracted from the WSDL
     * - documentation: If isMultiCastEnabled is false then these elements are not necessary.MOHServer will be added to the database without the values of these tags. ie. The table MOHServerMulticastInfo table will be empty.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $multicastIncrementOnIp;
    /**
     * The audioSources
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AudioSources
     */
    public $audioSources;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RMohServer
     * @uses RMohServer::setName()
     * @uses RMohServer::setDescription()
     * @uses RMohServer::setProcessNodeName()
     * @uses RMohServer::setDevicePoolName()
     * @uses RMohServer::setLocationName()
     * @uses RMohServer::setMaxUnicastConnections()
     * @uses RMohServer::setMaxMulticastConnections()
     * @uses RMohServer::setFixedAudioSourceDevice()
     * @uses RMohServer::setRunFlag()
     * @uses RMohServer::setUseTrustedRelayPoint()
     * @uses RMohServer::setIsMultiCastEnabled()
     * @uses RMohServer::setBaseMulticastIpaddress()
     * @uses RMohServer::setBaseMulticastPort()
     * @uses RMohServer::setMulticastIncrementOnIp()
     * @uses RMohServer::setAudioSources()
     * @uses RMohServer::setUuid()
     * @param string $name
     * @param string $description
     * @param XFkType $processNodeName
     * @param XFkType $devicePoolName
     * @param XFkType $locationName
     * @param string $maxUnicastConnections
     * @param string $maxMulticastConnections
     * @param string $fixedAudioSourceDevice
     * @param string $runFlag
     * @param string $useTrustedRelayPoint
     * @param string $isMultiCastEnabled
     * @param string $baseMulticastIpaddress
     * @param string $baseMulticastPort
     * @param string $multicastIncrementOnIp
     * @param AudioSources $audioSources
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, XFkType $processNodeName = null, XFkType $devicePoolName = null, XFkType $locationName = null, $maxUnicastConnections = null, $maxMulticastConnections = null, $fixedAudioSourceDevice = null, $runFlag = null, $useTrustedRelayPoint = null, $isMultiCastEnabled = null, $baseMulticastIpaddress = null, $baseMulticastPort = null, $multicastIncrementOnIp = null, AudioSources $audioSources = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setProcessNodeName($processNodeName)
            ->setDevicePoolName($devicePoolName)
            ->setLocationName($locationName)
            ->setMaxUnicastConnections($maxUnicastConnections)
            ->setMaxMulticastConnections($maxMulticastConnections)
            ->setFixedAudioSourceDevice($fixedAudioSourceDevice)
            ->setRunFlag($runFlag)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setIsMultiCastEnabled($isMultiCastEnabled)
            ->setBaseMulticastIpaddress($baseMulticastIpaddress)
            ->setBaseMulticastPort($baseMulticastPort)
            ->setMulticastIncrementOnIp($multicastIncrementOnIp)
            ->setAudioSources($audioSources)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RMohServer
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return RMohServer
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get processNodeName value
     * @return XFkType|null
     */
    public function getProcessNodeName()
    {
        return $this->processNodeName;
    }
    /**
     * Set processNodeName value
     * @param XFkType $processNodeName
     * @return RMohServer
     */
    public function setProcessNodeName(XFkType $processNodeName = null)
    {
        $this->processNodeName = $processNodeName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param XFkType $devicePoolName
     * @return RMohServer
     */
    public function setDevicePoolName(XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get locationName value
     * @return XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param XFkType $locationName
     * @return RMohServer
     */
    public function setLocationName(XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get maxUnicastConnections value
     * @return string|null
     */
    public function getMaxUnicastConnections()
    {
        return $this->maxUnicastConnections;
    }
    /**
     * Set maxUnicastConnections value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxUnicastConnections
     * @return RMohServer
     */
    public function setMaxUnicastConnections($maxUnicastConnections = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($maxUnicastConnections)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxUnicastConnections, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->maxUnicastConnections = $maxUnicastConnections;
        return $this;
    }
    /**
     * Get maxMulticastConnections value
     * @return string|null
     */
    public function getMaxMulticastConnections()
    {
        return $this->maxMulticastConnections;
    }
    /**
     * Set maxMulticastConnections value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxMulticastConnections
     * @return RMohServer
     */
    public function setMaxMulticastConnections($maxMulticastConnections = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($maxMulticastConnections)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxMulticastConnections, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->maxMulticastConnections = $maxMulticastConnections;
        return $this;
    }
    /**
     * Get fixedAudioSourceDevice value
     * @return string|null
     */
    public function getFixedAudioSourceDevice()
    {
        return $this->fixedAudioSourceDevice;
    }
    /**
     * Set fixedAudioSourceDevice value
     * @param string $fixedAudioSourceDevice
     * @return RMohServer
     */
    public function setFixedAudioSourceDevice($fixedAudioSourceDevice = null)
    {
        // validation for constraint: string
        if (!is_null($fixedAudioSourceDevice) && !is_string($fixedAudioSourceDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fixedAudioSourceDevice)), __LINE__);
        }
        $this->fixedAudioSourceDevice = $fixedAudioSourceDevice;
        return $this;
    }
    /**
     * Get runFlag value
     * @return string|null
     */
    public function getRunFlag()
    {
        return $this->runFlag;
    }
    /**
     * Set runFlag value
     * @param string $runFlag
     * @return RMohServer
     */
    public function setRunFlag($runFlag = null)
    {
        // validation for constraint: pattern
        if (is_scalar($runFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $runFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($runFlag, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($runFlag) && !is_string($runFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($runFlag)), __LINE__);
        }
        $this->runFlag = $runFlag;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return RMohServer
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useTrustedRelayPoint, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get isMultiCastEnabled value
     * @return string|null
     */
    public function getIsMultiCastEnabled()
    {
        return $this->isMultiCastEnabled;
    }
    /**
     * Set isMultiCastEnabled value
     * @param string $isMultiCastEnabled
     * @return RMohServer
     */
    public function setIsMultiCastEnabled($isMultiCastEnabled = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isMultiCastEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isMultiCastEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isMultiCastEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isMultiCastEnabled) && !is_string($isMultiCastEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isMultiCastEnabled)), __LINE__);
        }
        $this->isMultiCastEnabled = $isMultiCastEnabled;
        return $this;
    }
    /**
     * Get baseMulticastIpaddress value
     * @return string|null
     */
    public function getBaseMulticastIpaddress()
    {
        return $this->baseMulticastIpaddress;
    }
    /**
     * Set baseMulticastIpaddress value
     * @param string $baseMulticastIpaddress
     * @return RMohServer
     */
    public function setBaseMulticastIpaddress($baseMulticastIpaddress = null)
    {
        // validation for constraint: string
        if (!is_null($baseMulticastIpaddress) && !is_string($baseMulticastIpaddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baseMulticastIpaddress)), __LINE__);
        }
        $this->baseMulticastIpaddress = $baseMulticastIpaddress;
        return $this;
    }
    /**
     * Get baseMulticastPort value
     * @return string|null
     */
    public function getBaseMulticastPort()
    {
        return $this->baseMulticastPort;
    }
    /**
     * Set baseMulticastPort value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $baseMulticastPort
     * @return RMohServer
     */
    public function setBaseMulticastPort($baseMulticastPort = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($baseMulticastPort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $baseMulticastPort, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->baseMulticastPort = $baseMulticastPort;
        return $this;
    }
    /**
     * Get multicastIncrementOnIp value
     * @return string|null
     */
    public function getMulticastIncrementOnIp()
    {
        return $this->multicastIncrementOnIp;
    }
    /**
     * Set multicastIncrementOnIp value
     * @param string $multicastIncrementOnIp
     * @return RMohServer
     */
    public function setMulticastIncrementOnIp($multicastIncrementOnIp = null)
    {
        // validation for constraint: pattern
        if (is_scalar($multicastIncrementOnIp) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $multicastIncrementOnIp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($multicastIncrementOnIp, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($multicastIncrementOnIp) && !is_string($multicastIncrementOnIp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($multicastIncrementOnIp)), __LINE__);
        }
        $this->multicastIncrementOnIp = $multicastIncrementOnIp;
        return $this;
    }
    /**
     * Get audioSources value
     * @return AudioSources|null
     */
    public function getAudioSources()
    {
        return $this->audioSources;
    }
    /**
     * Set audioSources value
     * @param AudioSources $audioSources
     * @return RMohServer
     */
    public function setAudioSources(AudioSources $audioSources = null)
    {
        $this->audioSources = $audioSources;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RMohServer
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RMohServer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
