<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RLocation StructType
 * @subpackage Structs
 */
class RLocation extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: Read only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The relatedLocations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var RelatedLocations
     */
    public $relatedLocations;
    /**
     * The withinAudioBandwidth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $withinAudioBandwidth;
    /**
     * The withinVideoBandwidth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $withinVideoBandwidth;
    /**
     * The withinImmersiveKbits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $withinImmersiveKbits;
    /**
     * The betweenLocations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var BetweenLocations
     */
    public $betweenLocations;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RLocation
     * @uses RLocation::setName()
     * @uses RLocation::setId()
     * @uses RLocation::setRelatedLocations()
     * @uses RLocation::setWithinAudioBandwidth()
     * @uses RLocation::setWithinVideoBandwidth()
     * @uses RLocation::setWithinImmersiveKbits()
     * @uses RLocation::setBetweenLocations()
     * @uses RLocation::setUuid()
     * @param string $name
     * @param string $id
     * @param RelatedLocations $relatedLocations
     * @param string $withinAudioBandwidth
     * @param string $withinVideoBandwidth
     * @param string $withinImmersiveKbits
     * @param BetweenLocations $betweenLocations
     * @param string $uuid
     */
    public function __construct($name = null, $id = null, RelatedLocations $relatedLocations = null, $withinAudioBandwidth = null, $withinVideoBandwidth = null, $withinImmersiveKbits = null, BetweenLocations $betweenLocations = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setId($id)
            ->setRelatedLocations($relatedLocations)
            ->setWithinAudioBandwidth($withinAudioBandwidth)
            ->setWithinVideoBandwidth($withinVideoBandwidth)
            ->setWithinImmersiveKbits($withinImmersiveKbits)
            ->setBetweenLocations($betweenLocations)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RLocation
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $id
     * @return RLocation
     */
    public function setId($id = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($id)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $id, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get relatedLocations value
     * @return RelatedLocations|null
     */
    public function getRelatedLocations()
    {
        return $this->relatedLocations;
    }
    /**
     * Set relatedLocations value
     * @param RelatedLocations $relatedLocations
     * @return RLocation
     */
    public function setRelatedLocations(RelatedLocations $relatedLocations = null)
    {
        $this->relatedLocations = $relatedLocations;
        return $this;
    }
    /**
     * Get withinAudioBandwidth value
     * @return string|null
     */
    public function getWithinAudioBandwidth()
    {
        return $this->withinAudioBandwidth;
    }
    /**
     * Set withinAudioBandwidth value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $withinAudioBandwidth
     * @return RLocation
     */
    public function setWithinAudioBandwidth($withinAudioBandwidth = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($withinAudioBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $withinAudioBandwidth, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->withinAudioBandwidth = $withinAudioBandwidth;
        return $this;
    }
    /**
     * Get withinVideoBandwidth value
     * @return string|null
     */
    public function getWithinVideoBandwidth()
    {
        return $this->withinVideoBandwidth;
    }
    /**
     * Set withinVideoBandwidth value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $withinVideoBandwidth
     * @return RLocation
     */
    public function setWithinVideoBandwidth($withinVideoBandwidth = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($withinVideoBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $withinVideoBandwidth, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->withinVideoBandwidth = $withinVideoBandwidth;
        return $this;
    }
    /**
     * Get withinImmersiveKbits value
     * @return string|null
     */
    public function getWithinImmersiveKbits()
    {
        return $this->withinImmersiveKbits;
    }
    /**
     * Set withinImmersiveKbits value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $withinImmersiveKbits
     * @return RLocation
     */
    public function setWithinImmersiveKbits($withinImmersiveKbits = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($withinImmersiveKbits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $withinImmersiveKbits, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->withinImmersiveKbits = $withinImmersiveKbits;
        return $this;
    }
    /**
     * Get betweenLocations value
     * @return BetweenLocations|null
     */
    public function getBetweenLocations()
    {
        return $this->betweenLocations;
    }
    /**
     * Set betweenLocations value
     * @param BetweenLocations $betweenLocations
     * @return RLocation
     */
    public function setBetweenLocations(BetweenLocations $betweenLocations = null)
    {
        $this->betweenLocations = $betweenLocations;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RLocation
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
