<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RLineAppearanceAssociationForPresence StructType
 * @subpackage Structs
 */
class RLineAppearanceAssociationForPresence extends AbstractStructBase
{
    /**
     * The laapAssociate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $laapAssociate;
    /**
     * The laapProductType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $laapProductType;
    /**
     * The laapDeviceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $laapDeviceName;
    /**
     * The laapDirectory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $laapDirectory;
    /**
     * The laapPartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $laapPartition;
    /**
     * The laapDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $laapDescription;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RLineAppearanceAssociationForPresence
     * @uses RLineAppearanceAssociationForPresence::setLaapAssociate()
     * @uses RLineAppearanceAssociationForPresence::setLaapProductType()
     * @uses RLineAppearanceAssociationForPresence::setLaapDeviceName()
     * @uses RLineAppearanceAssociationForPresence::setLaapDirectory()
     * @uses RLineAppearanceAssociationForPresence::setLaapPartition()
     * @uses RLineAppearanceAssociationForPresence::setLaapDescription()
     * @uses RLineAppearanceAssociationForPresence::setUuid()
     * @param XFkType $laapAssociate
     * @param string $laapProductType
     * @param string $laapDeviceName
     * @param string $laapDirectory
     * @param string $laapPartition
     * @param string $laapDescription
     * @param string $uuid
     */
    public function __construct(XFkType $laapAssociate = null, $laapProductType = null, $laapDeviceName = null, $laapDirectory = null, $laapPartition = null, $laapDescription = null, $uuid = null)
    {
        $this
            ->setLaapAssociate($laapAssociate)
            ->setLaapProductType($laapProductType)
            ->setLaapDeviceName($laapDeviceName)
            ->setLaapDirectory($laapDirectory)
            ->setLaapPartition($laapPartition)
            ->setLaapDescription($laapDescription)
            ->setUuid($uuid);
    }
    /**
     * Get laapAssociate value
     * @return XFkType|null
     */
    public function getLaapAssociate()
    {
        return $this->laapAssociate;
    }
    /**
     * Set laapAssociate value
     * @param XFkType $laapAssociate
     * @return RLineAppearanceAssociationForPresence
     */
    public function setLaapAssociate(XFkType $laapAssociate = null)
    {
        $this->laapAssociate = $laapAssociate;
        return $this;
    }
    /**
     * Get laapProductType value
     * @return string|null
     */
    public function getLaapProductType()
    {
        return $this->laapProductType;
    }
    /**
     * Set laapProductType value
     * @param string $laapProductType
     * @return RLineAppearanceAssociationForPresence
     */
    public function setLaapProductType($laapProductType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($laapProductType) && strlen($laapProductType) > 128) || (is_array($laapProductType) && count($laapProductType) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($laapProductType) ? strlen($laapProductType) : count($laapProductType)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($laapProductType) && !is_string($laapProductType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($laapProductType)), __LINE__);
        }
        $this->laapProductType = $laapProductType;
        return $this;
    }
    /**
     * Get laapDeviceName value
     * @return string|null
     */
    public function getLaapDeviceName()
    {
        return $this->laapDeviceName;
    }
    /**
     * Set laapDeviceName value
     * @param string $laapDeviceName
     * @return RLineAppearanceAssociationForPresence
     */
    public function setLaapDeviceName($laapDeviceName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($laapDeviceName) && strlen($laapDeviceName) > 128) || (is_array($laapDeviceName) && count($laapDeviceName) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($laapDeviceName) ? strlen($laapDeviceName) : count($laapDeviceName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($laapDeviceName) && !is_string($laapDeviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($laapDeviceName)), __LINE__);
        }
        $this->laapDeviceName = $laapDeviceName;
        return $this;
    }
    /**
     * Get laapDirectory value
     * @return string|null
     */
    public function getLaapDirectory()
    {
        return $this->laapDirectory;
    }
    /**
     * Set laapDirectory value
     * @param string $laapDirectory
     * @return RLineAppearanceAssociationForPresence
     */
    public function setLaapDirectory($laapDirectory = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($laapDirectory) && strlen($laapDirectory) > 128) || (is_array($laapDirectory) && count($laapDirectory) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($laapDirectory) ? strlen($laapDirectory) : count($laapDirectory)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($laapDirectory) && !is_string($laapDirectory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($laapDirectory)), __LINE__);
        }
        $this->laapDirectory = $laapDirectory;
        return $this;
    }
    /**
     * Get laapPartition value
     * @return string|null
     */
    public function getLaapPartition()
    {
        return $this->laapPartition;
    }
    /**
     * Set laapPartition value
     * @param string $laapPartition
     * @return RLineAppearanceAssociationForPresence
     */
    public function setLaapPartition($laapPartition = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($laapPartition) && strlen($laapPartition) > 128) || (is_array($laapPartition) && count($laapPartition) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($laapPartition) ? strlen($laapPartition) : count($laapPartition)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($laapPartition) && !is_string($laapPartition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($laapPartition)), __LINE__);
        }
        $this->laapPartition = $laapPartition;
        return $this;
    }
    /**
     * Get laapDescription value
     * @return string|null
     */
    public function getLaapDescription()
    {
        return $this->laapDescription;
    }
    /**
     * Set laapDescription value
     * @param string $laapDescription
     * @return RLineAppearanceAssociationForPresence
     */
    public function setLaapDescription($laapDescription = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($laapDescription) && strlen($laapDescription) > 128) || (is_array($laapDescription) && count($laapDescription) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($laapDescription) ? strlen($laapDescription) : count($laapDescription)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($laapDescription) && !is_string($laapDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($laapDescription)), __LINE__);
        }
        $this->laapDescription = $laapDescription;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RLineAppearanceAssociationForPresence
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RLineAppearanceAssociationForPresence
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
