<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RExtensions StructType
 * @subpackage Structs
 */
class RExtensions extends AbstractStructBase
{
    /**
     * The extension
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $extension;
    /**
     * The linePrimaryUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $linePrimaryUri;
    /**
     * The partition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $partition;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RExtensions
     * @uses RExtensions::setExtension()
     * @uses RExtensions::setLinePrimaryUri()
     * @uses RExtensions::setPartition()
     * @uses RExtensions::setUuid()
     * @param XFkType $extension
     * @param string $linePrimaryUri
     * @param XFkType $partition
     * @param string $uuid
     */
    public function __construct(XFkType $extension = null, $linePrimaryUri = null, XFkType $partition = null, $uuid = null)
    {
        $this
            ->setExtension($extension)
            ->setLinePrimaryUri($linePrimaryUri)
            ->setPartition($partition)
            ->setUuid($uuid);
    }
    /**
     * Get extension value
     * @return XFkType|null
     */
    public function getExtension()
    {
        return $this->extension;
    }
    /**
     * Set extension value
     * @param XFkType $extension
     * @return RExtensions
     */
    public function setExtension(XFkType $extension = null)
    {
        $this->extension = $extension;
        return $this;
    }
    /**
     * Get linePrimaryUri value
     * @return string|null
     */
    public function getLinePrimaryUri()
    {
        return $this->linePrimaryUri;
    }
    /**
     * Set linePrimaryUri value
     * @param string $linePrimaryUri
     * @return RExtensions
     */
    public function setLinePrimaryUri($linePrimaryUri = null)
    {
        // validation for constraint: string
        if (!is_null($linePrimaryUri) && !is_string($linePrimaryUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($linePrimaryUri)), __LINE__);
        }
        $this->linePrimaryUri = $linePrimaryUri;
        return $this;
    }
    /**
     * Get partition value
     * @return XFkType|null
     */
    public function getPartition()
    {
        return $this->partition;
    }
    /**
     * Set partition value
     * @param XFkType $partition
     * @return RExtensions
     */
    public function setPartition(XFkType $partition = null)
    {
        $this->partition = $partition;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RExtensions
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RExtensions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
