<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RCcdAdvertisingService StructType
 * @subpackage Structs
 */
class RCcdAdvertisingService extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $description;
    /**
     * The isActivated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isActivated;
    /**
     * The hostDnGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $hostDnGroup;
    /**
     * The safSipTrunk
     * Meta informations extracted from the WSDL
     * - documentation: Either safSipTrunk, safH323Trunk or both should be configured while adding
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $safSipTrunk;
    /**
     * The safH323Trunk
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $safH323Trunk;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RCcdAdvertisingService
     * @uses RCcdAdvertisingService::setName()
     * @uses RCcdAdvertisingService::setDescription()
     * @uses RCcdAdvertisingService::setIsActivated()
     * @uses RCcdAdvertisingService::setHostDnGroup()
     * @uses RCcdAdvertisingService::setSafSipTrunk()
     * @uses RCcdAdvertisingService::setSafH323Trunk()
     * @uses RCcdAdvertisingService::setUuid()
     * @param string $name
     * @param string $description
     * @param string $isActivated
     * @param XFkType $hostDnGroup
     * @param XFkType $safSipTrunk
     * @param XFkType $safH323Trunk
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $isActivated = null, XFkType $hostDnGroup = null, XFkType $safSipTrunk = null, XFkType $safH323Trunk = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setIsActivated($isActivated)
            ->setHostDnGroup($hostDnGroup)
            ->setSafSipTrunk($safSipTrunk)
            ->setSafH323Trunk($safH323Trunk)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RCcdAdvertisingService
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return RCcdAdvertisingService
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 50) || (is_array($description) && count($description) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isActivated value
     * @return string|null
     */
    public function getIsActivated()
    {
        return $this->isActivated;
    }
    /**
     * Set isActivated value
     * @param string $isActivated
     * @return RCcdAdvertisingService
     */
    public function setIsActivated($isActivated = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isActivated) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isActivated, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isActivated) && !is_string($isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isActivated)), __LINE__);
        }
        $this->isActivated = $isActivated;
        return $this;
    }
    /**
     * Get hostDnGroup value
     * @return XFkType|null
     */
    public function getHostDnGroup()
    {
        return $this->hostDnGroup;
    }
    /**
     * Set hostDnGroup value
     * @param XFkType $hostDnGroup
     * @return RCcdAdvertisingService
     */
    public function setHostDnGroup(XFkType $hostDnGroup = null)
    {
        $this->hostDnGroup = $hostDnGroup;
        return $this;
    }
    /**
     * Get safSipTrunk value
     * @return XFkType|null
     */
    public function getSafSipTrunk()
    {
        return $this->safSipTrunk;
    }
    /**
     * Set safSipTrunk value
     * @param XFkType $safSipTrunk
     * @return RCcdAdvertisingService
     */
    public function setSafSipTrunk(XFkType $safSipTrunk = null)
    {
        $this->safSipTrunk = $safSipTrunk;
        return $this;
    }
    /**
     * Get safH323Trunk value
     * @return XFkType|null
     */
    public function getSafH323Trunk()
    {
        return $this->safH323Trunk;
    }
    /**
     * Set safH323Trunk value
     * @param XFkType $safH323Trunk
     * @return RCcdAdvertisingService
     */
    public function setSafH323Trunk(XFkType $safH323Trunk = null)
    {
        $this->safH323Trunk = $safH323Trunk;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RCcdAdvertisingService
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RCcdAdvertisingService
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
