<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pageSection StructType
 * @subpackage Structs
 */
class PageSection extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The state
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $state;
    /**
     * The order
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $order;
    /**
     * Constructor method for pageSection
     * @uses PageSection::setName()
     * @uses PageSection::setState()
     * @uses PageSection::setOrder()
     * @param string $name
     * @param string $state
     * @param string $order
     */
    public function __construct($name = null, $state = null, $order = null)
    {
        $this
            ->setName($name)
            ->setState($state)
            ->setOrder($order);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @uses XWebPageSection::valueIsValid()
     * @uses XWebPageSection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $name
     * @return PageSection
     */
    public function setName($name = null)
    {
        // validation for constraint: enumeration
        if (!XWebPageSection::valueIsValid($name)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $name, implode(', ', XWebPageSection::getValidValues())), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @uses XWebPageDisplay::valueIsValid()
     * @uses XWebPageDisplay::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return PageSection
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!XWebPageDisplay::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $state, implode(', ', XWebPageDisplay::getValidValues())), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get order value
     * @return string|null
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $order
     * @return PageSection
     */
    public function setOrder($order = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($order)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $order, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->order = $order;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return PageSection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
