<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXSipProfile StructType
 * @subpackage Structs
 */
class OXSipProfile extends AbstractStructBase
{
    /**
     * The userInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $userInfo;
    /**
     * The dtmfDbLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $dtmfDbLevel;
    /**
     * The callHoldRingback
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $callHoldRingback;
    /**
     * The anonymousCallBlock
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $anonymousCallBlock;
    /**
     * The callerIdBlock
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $callerIdBlock;
    /**
     * The dndControl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $dndControl;
    /**
     * The telnetLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $telnetLevel;
    /**
     * The rerouteIncomingRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $rerouteIncomingRequest;
    /**
     * The resourcePriorityNamespaceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $resourcePriorityNamespaceListName;
    /**
     * The rsvpOverSip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $rsvpOverSip;
    /**
     * The sipRe11XxEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $sipRe11XxEnabled;
    /**
     * The gClear
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $gClear;
    /**
     * The sipBandwidthModifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $sipBandwidthModifier;
    /**
     * The userAgentServerHeaderInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $userAgentServerHeaderInfo;
    /**
     * The sipNormalizationScript
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $sipNormalizationScript;
    /**
     * The dialStringInterpretation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $dialStringInterpretation;
    /**
     * The acceptAudioCodecPreferences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $acceptAudioCodecPreferences;
    /**
     * The resourcePriorityNamespace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $resourcePriorityNamespace;
    /**
     * The callingLineIdentification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $callingLineIdentification;
    /**
     * The videoCallTrafficClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $videoCallTrafficClass;
    /**
     * The sdpTransparency
     * Meta informations extracted from the WSDL
     * - documentation: SDP Transparency Profile for SIP Profile
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $sdpTransparency;
    /**
     * The sipSessionRefreshMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $sipSessionRefreshMethod;
    /**
     * The earlyOfferSuppVoiceCall
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $earlyOfferSuppVoiceCall;
    /**
     * The cucmVersionInSipHeader
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $cucmVersionInSipHeader;
    /**
     * The confidentialAccessLevelHeaders
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $confidentialAccessLevelHeaders;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for OXSipProfile
     * @uses OXSipProfile::setUserInfo()
     * @uses OXSipProfile::setDtmfDbLevel()
     * @uses OXSipProfile::setCallHoldRingback()
     * @uses OXSipProfile::setAnonymousCallBlock()
     * @uses OXSipProfile::setCallerIdBlock()
     * @uses OXSipProfile::setDndControl()
     * @uses OXSipProfile::setTelnetLevel()
     * @uses OXSipProfile::setRerouteIncomingRequest()
     * @uses OXSipProfile::setResourcePriorityNamespaceListName()
     * @uses OXSipProfile::setRsvpOverSip()
     * @uses OXSipProfile::setSipRe11XxEnabled()
     * @uses OXSipProfile::setGClear()
     * @uses OXSipProfile::setSipBandwidthModifier()
     * @uses OXSipProfile::setUserAgentServerHeaderInfo()
     * @uses OXSipProfile::setSipNormalizationScript()
     * @uses OXSipProfile::setDialStringInterpretation()
     * @uses OXSipProfile::setAcceptAudioCodecPreferences()
     * @uses OXSipProfile::setResourcePriorityNamespace()
     * @uses OXSipProfile::setCallingLineIdentification()
     * @uses OXSipProfile::setVideoCallTrafficClass()
     * @uses OXSipProfile::setSdpTransparency()
     * @uses OXSipProfile::setSipSessionRefreshMethod()
     * @uses OXSipProfile::setEarlyOfferSuppVoiceCall()
     * @uses OXSipProfile::setCucmVersionInSipHeader()
     * @uses OXSipProfile::setConfidentialAccessLevelHeaders()
     * @uses OXSipProfile::setUuid()
     * @param OXFkType $userInfo
     * @param OXFkType $dtmfDbLevel
     * @param OXFkType $callHoldRingback
     * @param OXFkType $anonymousCallBlock
     * @param OXFkType $callerIdBlock
     * @param OXFkType $dndControl
     * @param OXFkType $telnetLevel
     * @param OXFkType $rerouteIncomingRequest
     * @param OXFkType $resourcePriorityNamespaceListName
     * @param OXFkType $rsvpOverSip
     * @param OXFkType $sipRe11XxEnabled
     * @param OXFkType $gClear
     * @param OXFkType $sipBandwidthModifier
     * @param OXFkType $userAgentServerHeaderInfo
     * @param OXFkType $sipNormalizationScript
     * @param OXFkType $dialStringInterpretation
     * @param OXFkType $acceptAudioCodecPreferences
     * @param OXFkType $resourcePriorityNamespace
     * @param OXFkType $callingLineIdentification
     * @param OXFkType $videoCallTrafficClass
     * @param OXFkType $sdpTransparency
     * @param OXFkType $sipSessionRefreshMethod
     * @param OXFkType $earlyOfferSuppVoiceCall
     * @param OXFkType $cucmVersionInSipHeader
     * @param OXFkType $confidentialAccessLevelHeaders
     * @param string $uuid
     */
    public function __construct(OXFkType $userInfo = null, OXFkType $dtmfDbLevel = null, OXFkType $callHoldRingback = null, OXFkType $anonymousCallBlock = null, OXFkType $callerIdBlock = null, OXFkType $dndControl = null, OXFkType $telnetLevel = null, OXFkType $rerouteIncomingRequest = null, OXFkType $resourcePriorityNamespaceListName = null, OXFkType $rsvpOverSip = null, OXFkType $sipRe11XxEnabled = null, OXFkType $gClear = null, OXFkType $sipBandwidthModifier = null, OXFkType $userAgentServerHeaderInfo = null, OXFkType $sipNormalizationScript = null, OXFkType $dialStringInterpretation = null, OXFkType $acceptAudioCodecPreferences = null, OXFkType $resourcePriorityNamespace = null, OXFkType $callingLineIdentification = null, OXFkType $videoCallTrafficClass = null, OXFkType $sdpTransparency = null, OXFkType $sipSessionRefreshMethod = null, OXFkType $earlyOfferSuppVoiceCall = null, OXFkType $cucmVersionInSipHeader = null, OXFkType $confidentialAccessLevelHeaders = null, $uuid = null)
    {
        $this
            ->setUserInfo($userInfo)
            ->setDtmfDbLevel($dtmfDbLevel)
            ->setCallHoldRingback($callHoldRingback)
            ->setAnonymousCallBlock($anonymousCallBlock)
            ->setCallerIdBlock($callerIdBlock)
            ->setDndControl($dndControl)
            ->setTelnetLevel($telnetLevel)
            ->setRerouteIncomingRequest($rerouteIncomingRequest)
            ->setResourcePriorityNamespaceListName($resourcePriorityNamespaceListName)
            ->setRsvpOverSip($rsvpOverSip)
            ->setSipRe11XxEnabled($sipRe11XxEnabled)
            ->setGClear($gClear)
            ->setSipBandwidthModifier($sipBandwidthModifier)
            ->setUserAgentServerHeaderInfo($userAgentServerHeaderInfo)
            ->setSipNormalizationScript($sipNormalizationScript)
            ->setDialStringInterpretation($dialStringInterpretation)
            ->setAcceptAudioCodecPreferences($acceptAudioCodecPreferences)
            ->setResourcePriorityNamespace($resourcePriorityNamespace)
            ->setCallingLineIdentification($callingLineIdentification)
            ->setVideoCallTrafficClass($videoCallTrafficClass)
            ->setSdpTransparency($sdpTransparency)
            ->setSipSessionRefreshMethod($sipSessionRefreshMethod)
            ->setEarlyOfferSuppVoiceCall($earlyOfferSuppVoiceCall)
            ->setCucmVersionInSipHeader($cucmVersionInSipHeader)
            ->setConfidentialAccessLevelHeaders($confidentialAccessLevelHeaders)
            ->setUuid($uuid);
    }
    /**
     * Get userInfo value
     * @return OXFkType|null
     */
    public function getUserInfo()
    {
        return $this->userInfo;
    }
    /**
     * Set userInfo value
     * @param OXFkType $userInfo
     * @return OXSipProfile
     */
    public function setUserInfo(OXFkType $userInfo = null)
    {
        $this->userInfo = $userInfo;
        return $this;
    }
    /**
     * Get dtmfDbLevel value
     * @return OXFkType|null
     */
    public function getDtmfDbLevel()
    {
        return $this->dtmfDbLevel;
    }
    /**
     * Set dtmfDbLevel value
     * @param OXFkType $dtmfDbLevel
     * @return OXSipProfile
     */
    public function setDtmfDbLevel(OXFkType $dtmfDbLevel = null)
    {
        $this->dtmfDbLevel = $dtmfDbLevel;
        return $this;
    }
    /**
     * Get callHoldRingback value
     * @return OXFkType|null
     */
    public function getCallHoldRingback()
    {
        return $this->callHoldRingback;
    }
    /**
     * Set callHoldRingback value
     * @param OXFkType $callHoldRingback
     * @return OXSipProfile
     */
    public function setCallHoldRingback(OXFkType $callHoldRingback = null)
    {
        $this->callHoldRingback = $callHoldRingback;
        return $this;
    }
    /**
     * Get anonymousCallBlock value
     * @return OXFkType|null
     */
    public function getAnonymousCallBlock()
    {
        return $this->anonymousCallBlock;
    }
    /**
     * Set anonymousCallBlock value
     * @param OXFkType $anonymousCallBlock
     * @return OXSipProfile
     */
    public function setAnonymousCallBlock(OXFkType $anonymousCallBlock = null)
    {
        $this->anonymousCallBlock = $anonymousCallBlock;
        return $this;
    }
    /**
     * Get callerIdBlock value
     * @return OXFkType|null
     */
    public function getCallerIdBlock()
    {
        return $this->callerIdBlock;
    }
    /**
     * Set callerIdBlock value
     * @param OXFkType $callerIdBlock
     * @return OXSipProfile
     */
    public function setCallerIdBlock(OXFkType $callerIdBlock = null)
    {
        $this->callerIdBlock = $callerIdBlock;
        return $this;
    }
    /**
     * Get dndControl value
     * @return OXFkType|null
     */
    public function getDndControl()
    {
        return $this->dndControl;
    }
    /**
     * Set dndControl value
     * @param OXFkType $dndControl
     * @return OXSipProfile
     */
    public function setDndControl(OXFkType $dndControl = null)
    {
        $this->dndControl = $dndControl;
        return $this;
    }
    /**
     * Get telnetLevel value
     * @return OXFkType|null
     */
    public function getTelnetLevel()
    {
        return $this->telnetLevel;
    }
    /**
     * Set telnetLevel value
     * @param OXFkType $telnetLevel
     * @return OXSipProfile
     */
    public function setTelnetLevel(OXFkType $telnetLevel = null)
    {
        $this->telnetLevel = $telnetLevel;
        return $this;
    }
    /**
     * Get rerouteIncomingRequest value
     * @return OXFkType|null
     */
    public function getRerouteIncomingRequest()
    {
        return $this->rerouteIncomingRequest;
    }
    /**
     * Set rerouteIncomingRequest value
     * @param OXFkType $rerouteIncomingRequest
     * @return OXSipProfile
     */
    public function setRerouteIncomingRequest(OXFkType $rerouteIncomingRequest = null)
    {
        $this->rerouteIncomingRequest = $rerouteIncomingRequest;
        return $this;
    }
    /**
     * Get resourcePriorityNamespaceListName value
     * @return OXFkType|null
     */
    public function getResourcePriorityNamespaceListName()
    {
        return $this->resourcePriorityNamespaceListName;
    }
    /**
     * Set resourcePriorityNamespaceListName value
     * @param OXFkType $resourcePriorityNamespaceListName
     * @return OXSipProfile
     */
    public function setResourcePriorityNamespaceListName(OXFkType $resourcePriorityNamespaceListName = null)
    {
        $this->resourcePriorityNamespaceListName = $resourcePriorityNamespaceListName;
        return $this;
    }
    /**
     * Get rsvpOverSip value
     * @return OXFkType|null
     */
    public function getRsvpOverSip()
    {
        return $this->rsvpOverSip;
    }
    /**
     * Set rsvpOverSip value
     * @param OXFkType $rsvpOverSip
     * @return OXSipProfile
     */
    public function setRsvpOverSip(OXFkType $rsvpOverSip = null)
    {
        $this->rsvpOverSip = $rsvpOverSip;
        return $this;
    }
    /**
     * Get sipRe11XxEnabled value
     * @return OXFkType|null
     */
    public function getSipRe11XxEnabled()
    {
        return $this->sipRe11XxEnabled;
    }
    /**
     * Set sipRe11XxEnabled value
     * @param OXFkType $sipRe11XxEnabled
     * @return OXSipProfile
     */
    public function setSipRe11XxEnabled(OXFkType $sipRe11XxEnabled = null)
    {
        $this->sipRe11XxEnabled = $sipRe11XxEnabled;
        return $this;
    }
    /**
     * Get gClear value
     * @return OXFkType|null
     */
    public function getGClear()
    {
        return $this->gClear;
    }
    /**
     * Set gClear value
     * @param OXFkType $gClear
     * @return OXSipProfile
     */
    public function setGClear(OXFkType $gClear = null)
    {
        $this->gClear = $gClear;
        return $this;
    }
    /**
     * Get sipBandwidthModifier value
     * @return OXFkType|null
     */
    public function getSipBandwidthModifier()
    {
        return $this->sipBandwidthModifier;
    }
    /**
     * Set sipBandwidthModifier value
     * @param OXFkType $sipBandwidthModifier
     * @return OXSipProfile
     */
    public function setSipBandwidthModifier(OXFkType $sipBandwidthModifier = null)
    {
        $this->sipBandwidthModifier = $sipBandwidthModifier;
        return $this;
    }
    /**
     * Get userAgentServerHeaderInfo value
     * @return OXFkType|null
     */
    public function getUserAgentServerHeaderInfo()
    {
        return $this->userAgentServerHeaderInfo;
    }
    /**
     * Set userAgentServerHeaderInfo value
     * @param OXFkType $userAgentServerHeaderInfo
     * @return OXSipProfile
     */
    public function setUserAgentServerHeaderInfo(OXFkType $userAgentServerHeaderInfo = null)
    {
        $this->userAgentServerHeaderInfo = $userAgentServerHeaderInfo;
        return $this;
    }
    /**
     * Get sipNormalizationScript value
     * @return OXFkType|null
     */
    public function getSipNormalizationScript()
    {
        return $this->sipNormalizationScript;
    }
    /**
     * Set sipNormalizationScript value
     * @param OXFkType $sipNormalizationScript
     * @return OXSipProfile
     */
    public function setSipNormalizationScript(OXFkType $sipNormalizationScript = null)
    {
        $this->sipNormalizationScript = $sipNormalizationScript;
        return $this;
    }
    /**
     * Get dialStringInterpretation value
     * @return OXFkType|null
     */
    public function getDialStringInterpretation()
    {
        return $this->dialStringInterpretation;
    }
    /**
     * Set dialStringInterpretation value
     * @param OXFkType $dialStringInterpretation
     * @return OXSipProfile
     */
    public function setDialStringInterpretation(OXFkType $dialStringInterpretation = null)
    {
        $this->dialStringInterpretation = $dialStringInterpretation;
        return $this;
    }
    /**
     * Get acceptAudioCodecPreferences value
     * @return OXFkType|null
     */
    public function getAcceptAudioCodecPreferences()
    {
        return $this->acceptAudioCodecPreferences;
    }
    /**
     * Set acceptAudioCodecPreferences value
     * @param OXFkType $acceptAudioCodecPreferences
     * @return OXSipProfile
     */
    public function setAcceptAudioCodecPreferences(OXFkType $acceptAudioCodecPreferences = null)
    {
        $this->acceptAudioCodecPreferences = $acceptAudioCodecPreferences;
        return $this;
    }
    /**
     * Get resourcePriorityNamespace value
     * @return OXFkType|null
     */
    public function getResourcePriorityNamespace()
    {
        return $this->resourcePriorityNamespace;
    }
    /**
     * Set resourcePriorityNamespace value
     * @param OXFkType $resourcePriorityNamespace
     * @return OXSipProfile
     */
    public function setResourcePriorityNamespace(OXFkType $resourcePriorityNamespace = null)
    {
        $this->resourcePriorityNamespace = $resourcePriorityNamespace;
        return $this;
    }
    /**
     * Get callingLineIdentification value
     * @return OXFkType|null
     */
    public function getCallingLineIdentification()
    {
        return $this->callingLineIdentification;
    }
    /**
     * Set callingLineIdentification value
     * @param OXFkType $callingLineIdentification
     * @return OXSipProfile
     */
    public function setCallingLineIdentification(OXFkType $callingLineIdentification = null)
    {
        $this->callingLineIdentification = $callingLineIdentification;
        return $this;
    }
    /**
     * Get videoCallTrafficClass value
     * @return OXFkType|null
     */
    public function getVideoCallTrafficClass()
    {
        return $this->videoCallTrafficClass;
    }
    /**
     * Set videoCallTrafficClass value
     * @param OXFkType $videoCallTrafficClass
     * @return OXSipProfile
     */
    public function setVideoCallTrafficClass(OXFkType $videoCallTrafficClass = null)
    {
        $this->videoCallTrafficClass = $videoCallTrafficClass;
        return $this;
    }
    /**
     * Get sdpTransparency value
     * @return OXFkType|null
     */
    public function getSdpTransparency()
    {
        return $this->sdpTransparency;
    }
    /**
     * Set sdpTransparency value
     * @param OXFkType $sdpTransparency
     * @return OXSipProfile
     */
    public function setSdpTransparency(OXFkType $sdpTransparency = null)
    {
        $this->sdpTransparency = $sdpTransparency;
        return $this;
    }
    /**
     * Get sipSessionRefreshMethod value
     * @return OXFkType|null
     */
    public function getSipSessionRefreshMethod()
    {
        return $this->sipSessionRefreshMethod;
    }
    /**
     * Set sipSessionRefreshMethod value
     * @param OXFkType $sipSessionRefreshMethod
     * @return OXSipProfile
     */
    public function setSipSessionRefreshMethod(OXFkType $sipSessionRefreshMethod = null)
    {
        $this->sipSessionRefreshMethod = $sipSessionRefreshMethod;
        return $this;
    }
    /**
     * Get earlyOfferSuppVoiceCall value
     * @return OXFkType|null
     */
    public function getEarlyOfferSuppVoiceCall()
    {
        return $this->earlyOfferSuppVoiceCall;
    }
    /**
     * Set earlyOfferSuppVoiceCall value
     * @param OXFkType $earlyOfferSuppVoiceCall
     * @return OXSipProfile
     */
    public function setEarlyOfferSuppVoiceCall(OXFkType $earlyOfferSuppVoiceCall = null)
    {
        $this->earlyOfferSuppVoiceCall = $earlyOfferSuppVoiceCall;
        return $this;
    }
    /**
     * Get cucmVersionInSipHeader value
     * @return OXFkType|null
     */
    public function getCucmVersionInSipHeader()
    {
        return $this->cucmVersionInSipHeader;
    }
    /**
     * Set cucmVersionInSipHeader value
     * @param OXFkType $cucmVersionInSipHeader
     * @return OXSipProfile
     */
    public function setCucmVersionInSipHeader(OXFkType $cucmVersionInSipHeader = null)
    {
        $this->cucmVersionInSipHeader = $cucmVersionInSipHeader;
        return $this;
    }
    /**
     * Get confidentialAccessLevelHeaders value
     * @return OXFkType|null
     */
    public function getConfidentialAccessLevelHeaders()
    {
        return $this->confidentialAccessLevelHeaders;
    }
    /**
     * Set confidentialAccessLevelHeaders value
     * @param OXFkType $confidentialAccessLevelHeaders
     * @return OXSipProfile
     */
    public function setConfidentialAccessLevelHeaders(OXFkType $confidentialAccessLevelHeaders = null)
    {
        $this->confidentialAccessLevelHeaders = $confidentialAccessLevelHeaders;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return OXSipProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return OXSipProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
