<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXPhone StructType
 * @subpackage Structs
 */
class OXPhone extends AbstractStructBase
{
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $product;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $class;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkTypeProduct
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta informations extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $protocolSide;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $commonDeviceConfigName;
    /**
     * The commonPhoneConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $commonPhoneConfigName;
    /**
     * The networkLocation
     * Meta informations extracted from the WSDL
     * - documentation: The new Device Destination for Trunk to Trunk Transfer and Drop Conference Feature is required for most gateways ,except FXS gateways and phones.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $networkLocation;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $locationName;
    /**
     * The mediaResourceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $mediaResourceListName;
    /**
     * The networkHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $userHoldMohAudioSourceId;
    /**
     * The automatedAlternateRoutingCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $aarNeighborhoodName;
    /**
     * The mlppIndicationStatus
     * Meta informations extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta informations extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $preemption;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $useTrustedRelayPoint;
    /**
     * The securityProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkTypeProduct_Protocol
     */
    public $securityProfileName;
    /**
     * The sipProfileName
     * Meta informations extracted from the WSDL
     * - documentation: This Tag is valid only for SIP Phones and SIP Trunks
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $sipProfileName;
    /**
     * The cgpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The geoLocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $geoLocationName;
    /**
     * The geoLocationFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $geoLocationFilterName;
    /**
     * The lines
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Lines
     */
    public $lines;
    /**
     * The phoneTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $phoneTemplateName;
    /**
     * The primaryPhoneName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $primaryPhoneName;
    /**
     * The ringSettingIdleBlfAudibleAlert
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $ringSettingIdleBlfAudibleAlert;
    /**
     * The ringSettingBusyBlfAudibleAlert
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $ringSettingBusyBlfAudibleAlert;
    /**
     * The blfDirectedCallParks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var BlfDirectedCallParks
     */
    public $blfDirectedCallParks;
    /**
     * The addOnModules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AddOnModules
     */
    public $addOnModules;
    /**
     * The userLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $userLocale;
    /**
     * The networkLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkTypeProduct
     */
    public $networkLocale;
    /**
     * The services
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Services
     */
    public $services;
    /**
     * The softkeyTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $softkeyTemplateName;
    /**
     * The defaultProfileName
     * Meta informations extracted from the WSDL
     * - documentation: The name of the default profile for this device.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkTypeProduct_Protocol
     */
    public $defaultProfileName;
    /**
     * The singleButtonBarge
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support SBB.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $singleButtonBarge;
    /**
     * The joinAcrossLines
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support JAL..
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $joinAcrossLines;
    /**
     * The builtInBridgeStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $builtInBridgeStatus;
    /**
     * The callInfoPrivacyStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $callInfoPrivacyStatus;
    /**
     * The ownerUserName
     * Meta informations extracted from the WSDL
     * - documentation: Read-only for IP Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkTypeProduct
     */
    public $ownerUserName;
    /**
     * The packetCaptureMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $packetCaptureMode;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - documentation: Support for this tag has been removed for IMS phones from 9.0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The rerouteCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $rerouteCallingSearchSpaceName;
    /**
     * The presenceGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $presenceGroupName;
    /**
     * The certificateOperation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $certificateOperation;
    /**
     * The authenticationMode
     * Meta informations extracted from the WSDL
     * - documentation: authenticationMode can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $authenticationMode;
    /**
     * The keySize
     * Meta informations extracted from the WSDL
     * - documentation: keySize can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $keySize;
    /**
     * The deviceMobilityMode
     * Meta informations extracted from the WSDL
     * - documentation: Specifies if the phone is configured for device mobility or not.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $deviceMobilityMode;
    /**
     * The dndOption
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkTypeProduct_Protocol
     */
    public $dndOption;
    /**
     * The dndRingSetting
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $dndRingSetting;
    /**
     * The mobilityUserIdName
     * Meta informations extracted from the WSDL
     * - documentation: The userid of the mobility user for this phone.Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $mobilityUserIdName;
    /**
     * The phoneSuite
     * Meta informations extracted from the WSDL
     * - documentation: If a blank tag is passed ,the value of the default is inserted into the database.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $phoneSuite;
    /**
     * The phoneServiceDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $phoneServiceDisplay;
    /**
     * The mtpPreferedCodec
     * Meta informations extracted from the WSDL
     * - documentation: This field is applicable only to SIP phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $mtpPreferedCodec;
    /**
     * The dialRulesName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkTypeProduct
     */
    public $dialRulesName;
    /**
     * The outboundCallRollover
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that Automatic Outbound Callrollover
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $outboundCallRollover;
    /**
     * The alwaysUsePrimeLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The featureControlPolicy
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for RT Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $featureControlPolicy;
    /**
     * The deviceTrustMode
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for TIP endpoints
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $deviceTrustMode;
    /**
     * The confidentialAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The cgpnIngressDN
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $cgpnIngressDN;
    /**
     * The wifiHotspotProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $wifiHotspotProfile;
    /**
     * The wirelessLanProfileGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $wirelessLanProfileGroup;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for OXPhone
     * @uses OXPhone::setProduct()
     * @uses OXPhone::setClass()
     * @uses OXPhone::setProtocol()
     * @uses OXPhone::setProtocolSide()
     * @uses OXPhone::setCallingSearchSpaceName()
     * @uses OXPhone::setDevicePoolName()
     * @uses OXPhone::setCommonDeviceConfigName()
     * @uses OXPhone::setCommonPhoneConfigName()
     * @uses OXPhone::setNetworkLocation()
     * @uses OXPhone::setLocationName()
     * @uses OXPhone::setMediaResourceListName()
     * @uses OXPhone::setNetworkHoldMohAudioSourceId()
     * @uses OXPhone::setUserHoldMohAudioSourceId()
     * @uses OXPhone::setAutomatedAlternateRoutingCssName()
     * @uses OXPhone::setAarNeighborhoodName()
     * @uses OXPhone::setMlppIndicationStatus()
     * @uses OXPhone::setPreemption()
     * @uses OXPhone::setUseTrustedRelayPoint()
     * @uses OXPhone::setSecurityProfileName()
     * @uses OXPhone::setSipProfileName()
     * @uses OXPhone::setCgpnTransformationCssName()
     * @uses OXPhone::setGeoLocationName()
     * @uses OXPhone::setGeoLocationFilterName()
     * @uses OXPhone::setLines()
     * @uses OXPhone::setPhoneTemplateName()
     * @uses OXPhone::setPrimaryPhoneName()
     * @uses OXPhone::setRingSettingIdleBlfAudibleAlert()
     * @uses OXPhone::setRingSettingBusyBlfAudibleAlert()
     * @uses OXPhone::setBlfDirectedCallParks()
     * @uses OXPhone::setAddOnModules()
     * @uses OXPhone::setUserLocale()
     * @uses OXPhone::setNetworkLocale()
     * @uses OXPhone::setServices()
     * @uses OXPhone::setSoftkeyTemplateName()
     * @uses OXPhone::setDefaultProfileName()
     * @uses OXPhone::setSingleButtonBarge()
     * @uses OXPhone::setJoinAcrossLines()
     * @uses OXPhone::setBuiltInBridgeStatus()
     * @uses OXPhone::setCallInfoPrivacyStatus()
     * @uses OXPhone::setOwnerUserName()
     * @uses OXPhone::setPacketCaptureMode()
     * @uses OXPhone::setSubscribeCallingSearchSpaceName()
     * @uses OXPhone::setRerouteCallingSearchSpaceName()
     * @uses OXPhone::setPresenceGroupName()
     * @uses OXPhone::setCertificateOperation()
     * @uses OXPhone::setAuthenticationMode()
     * @uses OXPhone::setKeySize()
     * @uses OXPhone::setDeviceMobilityMode()
     * @uses OXPhone::setDndOption()
     * @uses OXPhone::setDndRingSetting()
     * @uses OXPhone::setMobilityUserIdName()
     * @uses OXPhone::setPhoneSuite()
     * @uses OXPhone::setPhoneServiceDisplay()
     * @uses OXPhone::setMtpPreferedCodec()
     * @uses OXPhone::setDialRulesName()
     * @uses OXPhone::setOutboundCallRollover()
     * @uses OXPhone::setAlwaysUsePrimeLine()
     * @uses OXPhone::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses OXPhone::setFeatureControlPolicy()
     * @uses OXPhone::setDeviceTrustMode()
     * @uses OXPhone::setConfidentialAccess()
     * @uses OXPhone::setCgpnIngressDN()
     * @uses OXPhone::setWifiHotspotProfile()
     * @uses OXPhone::setWirelessLanProfileGroup()
     * @uses OXPhone::setCtiid()
     * @uses OXPhone::setUuid()
     * @param OXFkType $product
     * @param OXFkType $class
     * @param OXFkTypeProduct $protocol
     * @param OXFkType $protocolSide
     * @param OXFkType $callingSearchSpaceName
     * @param OXFkType $devicePoolName
     * @param OXFkType $commonDeviceConfigName
     * @param OXFkType $commonPhoneConfigName
     * @param OXFkType $networkLocation
     * @param OXFkType $locationName
     * @param OXFkType $mediaResourceListName
     * @param OXFkType $networkHoldMohAudioSourceId
     * @param OXFkType $userHoldMohAudioSourceId
     * @param OXFkType $automatedAlternateRoutingCssName
     * @param OXFkType $aarNeighborhoodName
     * @param OXFkType $mlppIndicationStatus
     * @param OXFkType $preemption
     * @param OXFkType $useTrustedRelayPoint
     * @param OXFkTypeProduct_Protocol $securityProfileName
     * @param OXFkType $sipProfileName
     * @param OXFkType $cgpnTransformationCssName
     * @param OXFkType $geoLocationName
     * @param OXFkType $geoLocationFilterName
     * @param Lines $lines
     * @param OXFkType $phoneTemplateName
     * @param OXFkType $primaryPhoneName
     * @param OXFkType $ringSettingIdleBlfAudibleAlert
     * @param OXFkType $ringSettingBusyBlfAudibleAlert
     * @param BlfDirectedCallParks $blfDirectedCallParks
     * @param AddOnModules $addOnModules
     * @param OXFkType $userLocale
     * @param OXFkTypeProduct $networkLocale
     * @param Services $services
     * @param OXFkType $softkeyTemplateName
     * @param OXFkTypeProduct_Protocol $defaultProfileName
     * @param OXFkType $singleButtonBarge
     * @param OXFkType $joinAcrossLines
     * @param OXFkType $builtInBridgeStatus
     * @param OXFkType $callInfoPrivacyStatus
     * @param OXFkTypeProduct $ownerUserName
     * @param OXFkType $packetCaptureMode
     * @param OXFkType $subscribeCallingSearchSpaceName
     * @param OXFkType $rerouteCallingSearchSpaceName
     * @param OXFkType $presenceGroupName
     * @param OXFkType $certificateOperation
     * @param OXFkType $authenticationMode
     * @param OXFkType $keySize
     * @param OXFkType $deviceMobilityMode
     * @param OXFkTypeProduct_Protocol $dndOption
     * @param OXFkType $dndRingSetting
     * @param OXFkType $mobilityUserIdName
     * @param OXFkType $phoneSuite
     * @param OXFkType $phoneServiceDisplay
     * @param OXFkType $mtpPreferedCodec
     * @param OXFkTypeProduct $dialRulesName
     * @param OXFkType $outboundCallRollover
     * @param OXFkType $alwaysUsePrimeLine
     * @param OXFkType $alwaysUsePrimeLineForVoiceMessage
     * @param OXFkType $featureControlPolicy
     * @param OXFkType $deviceTrustMode
     * @param ConfidentialAccess $confidentialAccess
     * @param OXFkType $cgpnIngressDN
     * @param OXFkType $wifiHotspotProfile
     * @param OXFkType $wirelessLanProfileGroup
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct(OXFkType $product = null, OXFkType $class = null, OXFkTypeProduct $protocol = null, OXFkType $protocolSide = null, OXFkType $callingSearchSpaceName = null, OXFkType $devicePoolName = null, OXFkType $commonDeviceConfigName = null, OXFkType $commonPhoneConfigName = null, OXFkType $networkLocation = null, OXFkType $locationName = null, OXFkType $mediaResourceListName = null, OXFkType $networkHoldMohAudioSourceId = null, OXFkType $userHoldMohAudioSourceId = null, OXFkType $automatedAlternateRoutingCssName = null, OXFkType $aarNeighborhoodName = null, OXFkType $mlppIndicationStatus = null, OXFkType $preemption = null, OXFkType $useTrustedRelayPoint = null, OXFkTypeProduct_Protocol $securityProfileName = null, OXFkType $sipProfileName = null, OXFkType $cgpnTransformationCssName = null, OXFkType $geoLocationName = null, OXFkType $geoLocationFilterName = null, Lines $lines = null, OXFkType $phoneTemplateName = null, OXFkType $primaryPhoneName = null, OXFkType $ringSettingIdleBlfAudibleAlert = null, OXFkType $ringSettingBusyBlfAudibleAlert = null, BlfDirectedCallParks $blfDirectedCallParks = null, AddOnModules $addOnModules = null, OXFkType $userLocale = null, OXFkTypeProduct $networkLocale = null, Services $services = null, OXFkType $softkeyTemplateName = null, OXFkTypeProduct_Protocol $defaultProfileName = null, OXFkType $singleButtonBarge = null, OXFkType $joinAcrossLines = null, OXFkType $builtInBridgeStatus = null, OXFkType $callInfoPrivacyStatus = null, OXFkTypeProduct $ownerUserName = null, OXFkType $packetCaptureMode = null, OXFkType $subscribeCallingSearchSpaceName = null, OXFkType $rerouteCallingSearchSpaceName = null, OXFkType $presenceGroupName = null, OXFkType $certificateOperation = null, OXFkType $authenticationMode = null, OXFkType $keySize = null, OXFkType $deviceMobilityMode = null, OXFkTypeProduct_Protocol $dndOption = null, OXFkType $dndRingSetting = null, OXFkType $mobilityUserIdName = null, OXFkType $phoneSuite = null, OXFkType $phoneServiceDisplay = null, OXFkType $mtpPreferedCodec = null, OXFkTypeProduct $dialRulesName = null, OXFkType $outboundCallRollover = null, OXFkType $alwaysUsePrimeLine = null, OXFkType $alwaysUsePrimeLineForVoiceMessage = null, OXFkType $featureControlPolicy = null, OXFkType $deviceTrustMode = null, ConfidentialAccess $confidentialAccess = null, OXFkType $cgpnIngressDN = null, OXFkType $wifiHotspotProfile = null, OXFkType $wirelessLanProfileGroup = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setProduct($product)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setCommonPhoneConfigName($commonPhoneConfigName)
            ->setNetworkLocation($networkLocation)
            ->setLocationName($locationName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setSecurityProfileName($securityProfileName)
            ->setSipProfileName($sipProfileName)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setGeoLocationName($geoLocationName)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setLines($lines)
            ->setPhoneTemplateName($phoneTemplateName)
            ->setPrimaryPhoneName($primaryPhoneName)
            ->setRingSettingIdleBlfAudibleAlert($ringSettingIdleBlfAudibleAlert)
            ->setRingSettingBusyBlfAudibleAlert($ringSettingBusyBlfAudibleAlert)
            ->setBlfDirectedCallParks($blfDirectedCallParks)
            ->setAddOnModules($addOnModules)
            ->setUserLocale($userLocale)
            ->setNetworkLocale($networkLocale)
            ->setServices($services)
            ->setSoftkeyTemplateName($softkeyTemplateName)
            ->setDefaultProfileName($defaultProfileName)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setBuiltInBridgeStatus($builtInBridgeStatus)
            ->setCallInfoPrivacyStatus($callInfoPrivacyStatus)
            ->setOwnerUserName($ownerUserName)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setRerouteCallingSearchSpaceName($rerouteCallingSearchSpaceName)
            ->setPresenceGroupName($presenceGroupName)
            ->setCertificateOperation($certificateOperation)
            ->setAuthenticationMode($authenticationMode)
            ->setKeySize($keySize)
            ->setDeviceMobilityMode($deviceMobilityMode)
            ->setDndOption($dndOption)
            ->setDndRingSetting($dndRingSetting)
            ->setMobilityUserIdName($mobilityUserIdName)
            ->setPhoneSuite($phoneSuite)
            ->setPhoneServiceDisplay($phoneServiceDisplay)
            ->setMtpPreferedCodec($mtpPreferedCodec)
            ->setDialRulesName($dialRulesName)
            ->setOutboundCallRollover($outboundCallRollover)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setFeatureControlPolicy($featureControlPolicy)
            ->setDeviceTrustMode($deviceTrustMode)
            ->setConfidentialAccess($confidentialAccess)
            ->setCgpnIngressDN($cgpnIngressDN)
            ->setWifiHotspotProfile($wifiHotspotProfile)
            ->setWirelessLanProfileGroup($wirelessLanProfileGroup)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get product value
     * @return OXFkType|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param OXFkType $product
     * @return OXPhone
     */
    public function setProduct(OXFkType $product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get class value
     * @return OXFkType|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param OXFkType $class
     * @return OXPhone
     */
    public function setClass(OXFkType $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return OXFkTypeProduct|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param OXFkTypeProduct $protocol
     * @return OXPhone
     */
    public function setProtocol(OXFkTypeProduct $protocol = null)
    {
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return OXFkType|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @param OXFkType $protocolSide
     * @return OXPhone
     */
    public function setProtocolSide(OXFkType $protocolSide = null)
    {
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return OXFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param OXFkType $callingSearchSpaceName
     * @return OXPhone
     */
    public function setCallingSearchSpaceName(OXFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return OXFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param OXFkType $devicePoolName
     * @return OXPhone
     */
    public function setDevicePoolName(OXFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return OXFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param OXFkType $commonDeviceConfigName
     * @return OXPhone
     */
    public function setCommonDeviceConfigName(OXFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get commonPhoneConfigName value
     * @return OXFkType|null
     */
    public function getCommonPhoneConfigName()
    {
        return $this->commonPhoneConfigName;
    }
    /**
     * Set commonPhoneConfigName value
     * @param OXFkType $commonPhoneConfigName
     * @return OXPhone
     */
    public function setCommonPhoneConfigName(OXFkType $commonPhoneConfigName = null)
    {
        $this->commonPhoneConfigName = $commonPhoneConfigName;
        return $this;
    }
    /**
     * Get networkLocation value
     * @return OXFkType|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @param OXFkType $networkLocation
     * @return OXPhone
     */
    public function setNetworkLocation(OXFkType $networkLocation = null)
    {
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get locationName value
     * @return OXFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param OXFkType $locationName
     * @return OXPhone
     */
    public function setLocationName(OXFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * @return OXFkType|null
     */
    public function getMediaResourceListName()
    {
        return $this->mediaResourceListName;
    }
    /**
     * Set mediaResourceListName value
     * @param OXFkType $mediaResourceListName
     * @return OXPhone
     */
    public function setMediaResourceListName(OXFkType $mediaResourceListName = null)
    {
        $this->mediaResourceListName = $mediaResourceListName;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * @return OXFkType|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return $this->networkHoldMohAudioSourceId;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * @param OXFkType $networkHoldMohAudioSourceId
     * @return OXPhone
     */
    public function setNetworkHoldMohAudioSourceId(OXFkType $networkHoldMohAudioSourceId = null)
    {
        $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return OXFkType|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @param OXFkType $userHoldMohAudioSourceId
     * @return OXPhone
     */
    public function setUserHoldMohAudioSourceId(OXFkType $userHoldMohAudioSourceId = null)
    {
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return OXFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param OXFkType $automatedAlternateRoutingCssName
     * @return OXPhone
     */
    public function setAutomatedAlternateRoutingCssName(OXFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return OXFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param OXFkType $aarNeighborhoodName
     * @return OXPhone
     */
    public function setAarNeighborhoodName(OXFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return OXFkType|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @param OXFkType $mlppIndicationStatus
     * @return OXPhone
     */
    public function setMlppIndicationStatus(OXFkType $mlppIndicationStatus = null)
    {
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return OXFkType|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @param OXFkType $preemption
     * @return OXPhone
     */
    public function setPreemption(OXFkType $preemption = null)
    {
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return OXFkType|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @param OXFkType $useTrustedRelayPoint
     * @return OXPhone
     */
    public function setUseTrustedRelayPoint(OXFkType $useTrustedRelayPoint = null)
    {
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get securityProfileName value
     * @return OXFkTypeProduct_Protocol|null
     */
    public function getSecurityProfileName()
    {
        return $this->securityProfileName;
    }
    /**
     * Set securityProfileName value
     * @param OXFkTypeProduct_Protocol $securityProfileName
     * @return OXPhone
     */
    public function setSecurityProfileName(OXFkTypeProduct_Protocol $securityProfileName = null)
    {
        $this->securityProfileName = $securityProfileName;
        return $this;
    }
    /**
     * Get sipProfileName value
     * @return OXFkType|null
     */
    public function getSipProfileName()
    {
        return $this->sipProfileName;
    }
    /**
     * Set sipProfileName value
     * @param OXFkType $sipProfileName
     * @return OXPhone
     */
    public function setSipProfileName(OXFkType $sipProfileName = null)
    {
        $this->sipProfileName = $sipProfileName;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return OXFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param OXFkType $cgpnTransformationCssName
     * @return OXPhone
     */
    public function setCgpnTransformationCssName(OXFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return OXFkType|null
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param OXFkType $geoLocationName
     * @return OXPhone
     */
    public function setGeoLocationName(OXFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * @return OXFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return $this->geoLocationFilterName;
    }
    /**
     * Set geoLocationFilterName value
     * @param OXFkType $geoLocationFilterName
     * @return OXPhone
     */
    public function setGeoLocationFilterName(OXFkType $geoLocationFilterName = null)
    {
        $this->geoLocationFilterName = $geoLocationFilterName;
        return $this;
    }
    /**
     * Get lines value
     * @return Lines|null
     */
    public function getLines()
    {
        return $this->lines;
    }
    /**
     * Set lines value
     * @param Lines $lines
     * @return OXPhone
     */
    public function setLines(Lines $lines = null)
    {
        $this->lines = $lines;
        return $this;
    }
    /**
     * Get phoneTemplateName value
     * @return OXFkType|null
     */
    public function getPhoneTemplateName()
    {
        return $this->phoneTemplateName;
    }
    /**
     * Set phoneTemplateName value
     * @param OXFkType $phoneTemplateName
     * @return OXPhone
     */
    public function setPhoneTemplateName(OXFkType $phoneTemplateName = null)
    {
        $this->phoneTemplateName = $phoneTemplateName;
        return $this;
    }
    /**
     * Get primaryPhoneName value
     * @return OXFkType|null
     */
    public function getPrimaryPhoneName()
    {
        return $this->primaryPhoneName;
    }
    /**
     * Set primaryPhoneName value
     * @param OXFkType $primaryPhoneName
     * @return OXPhone
     */
    public function setPrimaryPhoneName(OXFkType $primaryPhoneName = null)
    {
        $this->primaryPhoneName = $primaryPhoneName;
        return $this;
    }
    /**
     * Get ringSettingIdleBlfAudibleAlert value
     * @return OXFkType|null
     */
    public function getRingSettingIdleBlfAudibleAlert()
    {
        return $this->ringSettingIdleBlfAudibleAlert;
    }
    /**
     * Set ringSettingIdleBlfAudibleAlert value
     * @param OXFkType $ringSettingIdleBlfAudibleAlert
     * @return OXPhone
     */
    public function setRingSettingIdleBlfAudibleAlert(OXFkType $ringSettingIdleBlfAudibleAlert = null)
    {
        $this->ringSettingIdleBlfAudibleAlert = $ringSettingIdleBlfAudibleAlert;
        return $this;
    }
    /**
     * Get ringSettingBusyBlfAudibleAlert value
     * @return OXFkType|null
     */
    public function getRingSettingBusyBlfAudibleAlert()
    {
        return $this->ringSettingBusyBlfAudibleAlert;
    }
    /**
     * Set ringSettingBusyBlfAudibleAlert value
     * @param OXFkType $ringSettingBusyBlfAudibleAlert
     * @return OXPhone
     */
    public function setRingSettingBusyBlfAudibleAlert(OXFkType $ringSettingBusyBlfAudibleAlert = null)
    {
        $this->ringSettingBusyBlfAudibleAlert = $ringSettingBusyBlfAudibleAlert;
        return $this;
    }
    /**
     * Get blfDirectedCallParks value
     * @return BlfDirectedCallParks|null
     */
    public function getBlfDirectedCallParks()
    {
        return $this->blfDirectedCallParks;
    }
    /**
     * Set blfDirectedCallParks value
     * @param BlfDirectedCallParks $blfDirectedCallParks
     * @return OXPhone
     */
    public function setBlfDirectedCallParks(BlfDirectedCallParks $blfDirectedCallParks = null)
    {
        $this->blfDirectedCallParks = $blfDirectedCallParks;
        return $this;
    }
    /**
     * Get addOnModules value
     * @return AddOnModules|null
     */
    public function getAddOnModules()
    {
        return $this->addOnModules;
    }
    /**
     * Set addOnModules value
     * @param AddOnModules $addOnModules
     * @return OXPhone
     */
    public function setAddOnModules(AddOnModules $addOnModules = null)
    {
        $this->addOnModules = $addOnModules;
        return $this;
    }
    /**
     * Get userLocale value
     * @return OXFkType|null
     */
    public function getUserLocale()
    {
        return $this->userLocale;
    }
    /**
     * Set userLocale value
     * @param OXFkType $userLocale
     * @return OXPhone
     */
    public function setUserLocale(OXFkType $userLocale = null)
    {
        $this->userLocale = $userLocale;
        return $this;
    }
    /**
     * Get networkLocale value
     * @return OXFkTypeProduct|null
     */
    public function getNetworkLocale()
    {
        return $this->networkLocale;
    }
    /**
     * Set networkLocale value
     * @param OXFkTypeProduct $networkLocale
     * @return OXPhone
     */
    public function setNetworkLocale(OXFkTypeProduct $networkLocale = null)
    {
        $this->networkLocale = $networkLocale;
        return $this;
    }
    /**
     * Get services value
     * @return Services|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param Services $services
     * @return OXPhone
     */
    public function setServices(Services $services = null)
    {
        $this->services = $services;
        return $this;
    }
    /**
     * Get softkeyTemplateName value
     * @return OXFkType|null
     */
    public function getSoftkeyTemplateName()
    {
        return $this->softkeyTemplateName;
    }
    /**
     * Set softkeyTemplateName value
     * @param OXFkType $softkeyTemplateName
     * @return OXPhone
     */
    public function setSoftkeyTemplateName(OXFkType $softkeyTemplateName = null)
    {
        $this->softkeyTemplateName = $softkeyTemplateName;
        return $this;
    }
    /**
     * Get defaultProfileName value
     * @return OXFkTypeProduct_Protocol|null
     */
    public function getDefaultProfileName()
    {
        return $this->defaultProfileName;
    }
    /**
     * Set defaultProfileName value
     * @param OXFkTypeProduct_Protocol $defaultProfileName
     * @return OXPhone
     */
    public function setDefaultProfileName(OXFkTypeProduct_Protocol $defaultProfileName = null)
    {
        $this->defaultProfileName = $defaultProfileName;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return OXFkType|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @param OXFkType $singleButtonBarge
     * @return OXPhone
     */
    public function setSingleButtonBarge(OXFkType $singleButtonBarge = null)
    {
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return OXFkType|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @param OXFkType $joinAcrossLines
     * @return OXPhone
     */
    public function setJoinAcrossLines(OXFkType $joinAcrossLines = null)
    {
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get builtInBridgeStatus value
     * @return OXFkType|null
     */
    public function getBuiltInBridgeStatus()
    {
        return $this->builtInBridgeStatus;
    }
    /**
     * Set builtInBridgeStatus value
     * @param OXFkType $builtInBridgeStatus
     * @return OXPhone
     */
    public function setBuiltInBridgeStatus(OXFkType $builtInBridgeStatus = null)
    {
        $this->builtInBridgeStatus = $builtInBridgeStatus;
        return $this;
    }
    /**
     * Get callInfoPrivacyStatus value
     * @return OXFkType|null
     */
    public function getCallInfoPrivacyStatus()
    {
        return $this->callInfoPrivacyStatus;
    }
    /**
     * Set callInfoPrivacyStatus value
     * @param OXFkType $callInfoPrivacyStatus
     * @return OXPhone
     */
    public function setCallInfoPrivacyStatus(OXFkType $callInfoPrivacyStatus = null)
    {
        $this->callInfoPrivacyStatus = $callInfoPrivacyStatus;
        return $this;
    }
    /**
     * Get ownerUserName value
     * @return OXFkTypeProduct|null
     */
    public function getOwnerUserName()
    {
        return $this->ownerUserName;
    }
    /**
     * Set ownerUserName value
     * @param OXFkTypeProduct $ownerUserName
     * @return OXPhone
     */
    public function setOwnerUserName(OXFkTypeProduct $ownerUserName = null)
    {
        $this->ownerUserName = $ownerUserName;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return OXFkType|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @param OXFkType $packetCaptureMode
     * @return OXPhone
     */
    public function setPacketCaptureMode(OXFkType $packetCaptureMode = null)
    {
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * @return OXFkType|null
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return $this->subscribeCallingSearchSpaceName;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * @param OXFkType $subscribeCallingSearchSpaceName
     * @return OXPhone
     */
    public function setSubscribeCallingSearchSpaceName(OXFkType $subscribeCallingSearchSpaceName = null)
    {
        $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get rerouteCallingSearchSpaceName value
     * @return OXFkType|null
     */
    public function getRerouteCallingSearchSpaceName()
    {
        return $this->rerouteCallingSearchSpaceName;
    }
    /**
     * Set rerouteCallingSearchSpaceName value
     * @param OXFkType $rerouteCallingSearchSpaceName
     * @return OXPhone
     */
    public function setRerouteCallingSearchSpaceName(OXFkType $rerouteCallingSearchSpaceName = null)
    {
        $this->rerouteCallingSearchSpaceName = $rerouteCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return OXFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param OXFkType $presenceGroupName
     * @return OXPhone
     */
    public function setPresenceGroupName(OXFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get certificateOperation value
     * @return OXFkType|null
     */
    public function getCertificateOperation()
    {
        return $this->certificateOperation;
    }
    /**
     * Set certificateOperation value
     * @param OXFkType $certificateOperation
     * @return OXPhone
     */
    public function setCertificateOperation(OXFkType $certificateOperation = null)
    {
        $this->certificateOperation = $certificateOperation;
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return OXFkType|null
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @param OXFkType $authenticationMode
     * @return OXPhone
     */
    public function setAuthenticationMode(OXFkType $authenticationMode = null)
    {
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get keySize value
     * @return OXFkType|null
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @param OXFkType $keySize
     * @return OXPhone
     */
    public function setKeySize(OXFkType $keySize = null)
    {
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get deviceMobilityMode value
     * @return OXFkType|null
     */
    public function getDeviceMobilityMode()
    {
        return $this->deviceMobilityMode;
    }
    /**
     * Set deviceMobilityMode value
     * @param OXFkType $deviceMobilityMode
     * @return OXPhone
     */
    public function setDeviceMobilityMode(OXFkType $deviceMobilityMode = null)
    {
        $this->deviceMobilityMode = $deviceMobilityMode;
        return $this;
    }
    /**
     * Get dndOption value
     * @return OXFkTypeProduct_Protocol|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @param OXFkTypeProduct_Protocol $dndOption
     * @return OXPhone
     */
    public function setDndOption(OXFkTypeProduct_Protocol $dndOption = null)
    {
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get dndRingSetting value
     * @return OXFkType|null
     */
    public function getDndRingSetting()
    {
        return $this->dndRingSetting;
    }
    /**
     * Set dndRingSetting value
     * @param OXFkType $dndRingSetting
     * @return OXPhone
     */
    public function setDndRingSetting(OXFkType $dndRingSetting = null)
    {
        $this->dndRingSetting = $dndRingSetting;
        return $this;
    }
    /**
     * Get mobilityUserIdName value
     * @return OXFkType|null
     */
    public function getMobilityUserIdName()
    {
        return $this->mobilityUserIdName;
    }
    /**
     * Set mobilityUserIdName value
     * @param OXFkType $mobilityUserIdName
     * @return OXPhone
     */
    public function setMobilityUserIdName(OXFkType $mobilityUserIdName = null)
    {
        $this->mobilityUserIdName = $mobilityUserIdName;
        return $this;
    }
    /**
     * Get phoneSuite value
     * @return OXFkType|null
     */
    public function getPhoneSuite()
    {
        return $this->phoneSuite;
    }
    /**
     * Set phoneSuite value
     * @param OXFkType $phoneSuite
     * @return OXPhone
     */
    public function setPhoneSuite(OXFkType $phoneSuite = null)
    {
        $this->phoneSuite = $phoneSuite;
        return $this;
    }
    /**
     * Get phoneServiceDisplay value
     * @return OXFkType|null
     */
    public function getPhoneServiceDisplay()
    {
        return $this->phoneServiceDisplay;
    }
    /**
     * Set phoneServiceDisplay value
     * @param OXFkType $phoneServiceDisplay
     * @return OXPhone
     */
    public function setPhoneServiceDisplay(OXFkType $phoneServiceDisplay = null)
    {
        $this->phoneServiceDisplay = $phoneServiceDisplay;
        return $this;
    }
    /**
     * Get mtpPreferedCodec value
     * @return OXFkType|null
     */
    public function getMtpPreferedCodec()
    {
        return $this->mtpPreferedCodec;
    }
    /**
     * Set mtpPreferedCodec value
     * @param OXFkType $mtpPreferedCodec
     * @return OXPhone
     */
    public function setMtpPreferedCodec(OXFkType $mtpPreferedCodec = null)
    {
        $this->mtpPreferedCodec = $mtpPreferedCodec;
        return $this;
    }
    /**
     * Get dialRulesName value
     * @return OXFkTypeProduct|null
     */
    public function getDialRulesName()
    {
        return $this->dialRulesName;
    }
    /**
     * Set dialRulesName value
     * @param OXFkTypeProduct $dialRulesName
     * @return OXPhone
     */
    public function setDialRulesName(OXFkTypeProduct $dialRulesName = null)
    {
        $this->dialRulesName = $dialRulesName;
        return $this;
    }
    /**
     * Get outboundCallRollover value
     * @return OXFkType|null
     */
    public function getOutboundCallRollover()
    {
        return $this->outboundCallRollover;
    }
    /**
     * Set outboundCallRollover value
     * @param OXFkType $outboundCallRollover
     * @return OXPhone
     */
    public function setOutboundCallRollover(OXFkType $outboundCallRollover = null)
    {
        $this->outboundCallRollover = $outboundCallRollover;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return OXFkType|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @param OXFkType $alwaysUsePrimeLine
     * @return OXPhone
     */
    public function setAlwaysUsePrimeLine(OXFkType $alwaysUsePrimeLine = null)
    {
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return OXFkType|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @param OXFkType $alwaysUsePrimeLineForVoiceMessage
     * @return OXPhone
     */
    public function setAlwaysUsePrimeLineForVoiceMessage(OXFkType $alwaysUsePrimeLineForVoiceMessage = null)
    {
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get featureControlPolicy value
     * @return OXFkType|null
     */
    public function getFeatureControlPolicy()
    {
        return $this->featureControlPolicy;
    }
    /**
     * Set featureControlPolicy value
     * @param OXFkType $featureControlPolicy
     * @return OXPhone
     */
    public function setFeatureControlPolicy(OXFkType $featureControlPolicy = null)
    {
        $this->featureControlPolicy = $featureControlPolicy;
        return $this;
    }
    /**
     * Get deviceTrustMode value
     * @return OXFkType|null
     */
    public function getDeviceTrustMode()
    {
        return $this->deviceTrustMode;
    }
    /**
     * Set deviceTrustMode value
     * @param OXFkType $deviceTrustMode
     * @return OXPhone
     */
    public function setDeviceTrustMode(OXFkType $deviceTrustMode = null)
    {
        $this->deviceTrustMode = $deviceTrustMode;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param ConfidentialAccess $confidentialAccess
     * @return OXPhone
     */
    public function setConfidentialAccess(ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get cgpnIngressDN value
     * @return OXFkType|null
     */
    public function getCgpnIngressDN()
    {
        return $this->cgpnIngressDN;
    }
    /**
     * Set cgpnIngressDN value
     * @param OXFkType $cgpnIngressDN
     * @return OXPhone
     */
    public function setCgpnIngressDN(OXFkType $cgpnIngressDN = null)
    {
        $this->cgpnIngressDN = $cgpnIngressDN;
        return $this;
    }
    /**
     * Get wifiHotspotProfile value
     * @return OXFkType|null
     */
    public function getWifiHotspotProfile()
    {
        return $this->wifiHotspotProfile;
    }
    /**
     * Set wifiHotspotProfile value
     * @param OXFkType $wifiHotspotProfile
     * @return OXPhone
     */
    public function setWifiHotspotProfile(OXFkType $wifiHotspotProfile = null)
    {
        $this->wifiHotspotProfile = $wifiHotspotProfile;
        return $this;
    }
    /**
     * Get wirelessLanProfileGroup value
     * @return OXFkType|null
     */
    public function getWirelessLanProfileGroup()
    {
        return $this->wirelessLanProfileGroup;
    }
    /**
     * Set wirelessLanProfileGroup value
     * @param OXFkType $wirelessLanProfileGroup
     * @return OXPhone
     */
    public function setWirelessLanProfileGroup(OXFkType $wirelessLanProfileGroup = null)
    {
        $this->wirelessLanProfileGroup = $wirelessLanProfileGroup;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return OXPhone
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return OXPhone
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return OXPhone
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
