<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXLine StructType
 * @subpackage Structs
 */
class OXLine extends AbstractStructBase
{
    /**
     * The usage
     * Meta informations extracted from the WSDL
     * - documentation: For Intercom DN and Intercom Translation patterns the usage tag value needs to be specified explicitly as Device Intercom and Translation Intercom respectively. For all other patterns it is a Read-only tag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $routePartitionName;
    /**
     * The aarNeighborhoodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $aarNeighborhoodName;
    /**
     * The callForwardAll
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXCallForwardAll
     */
    public $callForwardAll;
    /**
     * The callForwardBusy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXCallForwardBusy
     */
    public $callForwardBusy;
    /**
     * The callForwardBusyInt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXCallForwardBusyInt
     */
    public $callForwardBusyInt;
    /**
     * The callForwardNoAnswer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXCallForwardNoAnswer
     */
    public $callForwardNoAnswer;
    /**
     * The callForwardNoAnswerInt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXCallForwardNoAnswerInt
     */
    public $callForwardNoAnswerInt;
    /**
     * The callForwardNoCoverage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXCallForwardNoCoverage
     */
    public $callForwardNoCoverage;
    /**
     * The callForwardNoCoverageInt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXCallForwardNoCoverageInt
     */
    public $callForwardNoCoverageInt;
    /**
     * The callForwardOnFailure
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXCallForwardOnFailure
     */
    public $callForwardOnFailure;
    /**
     * The callForwardAlternateParty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXCallForwardAlternateParty
     */
    public $callForwardAlternateParty;
    /**
     * The callForwardNotRegistered
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXCallForwardNotRegistered
     */
    public $callForwardNotRegistered;
    /**
     * The callForwardNotRegisteredInt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXCallForwardNotRegisteredInt
     */
    public $callForwardNotRegisteredInt;
    /**
     * The callPickupGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $callPickupGroupName;
    /**
     * The autoAnswer
     * Meta informations extracted from the WSDL
     * - documentation: For an intercom line this tag should be treated as a mandatory tag and the valid values are Auto Answer with Headset and Auto Answer with Speakerphone.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $autoAnswer;
    /**
     * The networkHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: A value of 0 means 'none selected'.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: A value of 0 means 'none selected'.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $userHoldMohAudioSourceId;
    /**
     * The presenceGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $presenceGroupName;
    /**
     * The shareLineAppearanceCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $shareLineAppearanceCssName;
    /**
     * The voiceMailProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $voiceMailProfileName;
    /**
     * The patternPrecedence
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $patternPrecedence;
    /**
     * The releaseClause
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $releaseClause;
    /**
     * The cfaCssPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $cfaCssPolicy;
    /**
     * The defaultActivatedDeviceName
     * Meta informations extracted from the WSDL
     * - documentation: This tag is applicable for only intercom lines and if not set, intercom lines will not be active.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $defaultActivatedDeviceName;
    /**
     * The parkMonForwardNoRetrieveCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $parkMonForwardNoRetrieveCssName;
    /**
     * The parkMonForwardNoRetrieveIntCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $parkMonForwardNoRetrieveIntCssName;
    /**
     * The partyEntranceTone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $partyEntranceTone;
    /**
     * The directoryURIs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DirectoryURIs
     */
    public $directoryURIs;
    /**
     * The confidentialAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The externalCallControlProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $externalCallControlProfile;
    /**
     * The enterpriseAltNum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var EnterpriseAltNum
     */
    public $enterpriseAltNum;
    /**
     * The e164AltNum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var E164AltNum
     */
    public $e164AltNum;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for OXLine
     * @uses OXLine::setUsage()
     * @uses OXLine::setRoutePartitionName()
     * @uses OXLine::setAarNeighborhoodName()
     * @uses OXLine::setCallForwardAll()
     * @uses OXLine::setCallForwardBusy()
     * @uses OXLine::setCallForwardBusyInt()
     * @uses OXLine::setCallForwardNoAnswer()
     * @uses OXLine::setCallForwardNoAnswerInt()
     * @uses OXLine::setCallForwardNoCoverage()
     * @uses OXLine::setCallForwardNoCoverageInt()
     * @uses OXLine::setCallForwardOnFailure()
     * @uses OXLine::setCallForwardAlternateParty()
     * @uses OXLine::setCallForwardNotRegistered()
     * @uses OXLine::setCallForwardNotRegisteredInt()
     * @uses OXLine::setCallPickupGroupName()
     * @uses OXLine::setAutoAnswer()
     * @uses OXLine::setNetworkHoldMohAudioSourceId()
     * @uses OXLine::setUserHoldMohAudioSourceId()
     * @uses OXLine::setPresenceGroupName()
     * @uses OXLine::setShareLineAppearanceCssName()
     * @uses OXLine::setVoiceMailProfileName()
     * @uses OXLine::setPatternPrecedence()
     * @uses OXLine::setReleaseClause()
     * @uses OXLine::setCfaCssPolicy()
     * @uses OXLine::setDefaultActivatedDeviceName()
     * @uses OXLine::setParkMonForwardNoRetrieveCssName()
     * @uses OXLine::setParkMonForwardNoRetrieveIntCssName()
     * @uses OXLine::setPartyEntranceTone()
     * @uses OXLine::setDirectoryURIs()
     * @uses OXLine::setConfidentialAccess()
     * @uses OXLine::setExternalCallControlProfile()
     * @uses OXLine::setEnterpriseAltNum()
     * @uses OXLine::setE164AltNum()
     * @uses OXLine::setUuid()
     * @param OXFkType $usage
     * @param OXFkType $routePartitionName
     * @param OXFkType $aarNeighborhoodName
     * @param OXCallForwardAll $callForwardAll
     * @param OXCallForwardBusy $callForwardBusy
     * @param OXCallForwardBusyInt $callForwardBusyInt
     * @param OXCallForwardNoAnswer $callForwardNoAnswer
     * @param OXCallForwardNoAnswerInt $callForwardNoAnswerInt
     * @param OXCallForwardNoCoverage $callForwardNoCoverage
     * @param OXCallForwardNoCoverageInt $callForwardNoCoverageInt
     * @param OXCallForwardOnFailure $callForwardOnFailure
     * @param OXCallForwardAlternateParty $callForwardAlternateParty
     * @param OXCallForwardNotRegistered $callForwardNotRegistered
     * @param OXCallForwardNotRegisteredInt $callForwardNotRegisteredInt
     * @param OXFkType $callPickupGroupName
     * @param OXFkType $autoAnswer
     * @param OXFkType $networkHoldMohAudioSourceId
     * @param OXFkType $userHoldMohAudioSourceId
     * @param OXFkType $presenceGroupName
     * @param OXFkType $shareLineAppearanceCssName
     * @param OXFkType $voiceMailProfileName
     * @param OXFkType $patternPrecedence
     * @param OXFkType $releaseClause
     * @param OXFkType $cfaCssPolicy
     * @param OXFkType $defaultActivatedDeviceName
     * @param OXFkType $parkMonForwardNoRetrieveCssName
     * @param OXFkType $parkMonForwardNoRetrieveIntCssName
     * @param OXFkType $partyEntranceTone
     * @param DirectoryURIs $directoryURIs
     * @param ConfidentialAccess $confidentialAccess
     * @param OXFkType $externalCallControlProfile
     * @param EnterpriseAltNum $enterpriseAltNum
     * @param E164AltNum $e164AltNum
     * @param string $uuid
     */
    public function __construct(OXFkType $usage = null, OXFkType $routePartitionName = null, OXFkType $aarNeighborhoodName = null, OXCallForwardAll $callForwardAll = null, OXCallForwardBusy $callForwardBusy = null, OXCallForwardBusyInt $callForwardBusyInt = null, OXCallForwardNoAnswer $callForwardNoAnswer = null, OXCallForwardNoAnswerInt $callForwardNoAnswerInt = null, OXCallForwardNoCoverage $callForwardNoCoverage = null, OXCallForwardNoCoverageInt $callForwardNoCoverageInt = null, OXCallForwardOnFailure $callForwardOnFailure = null, OXCallForwardAlternateParty $callForwardAlternateParty = null, OXCallForwardNotRegistered $callForwardNotRegistered = null, OXCallForwardNotRegisteredInt $callForwardNotRegisteredInt = null, OXFkType $callPickupGroupName = null, OXFkType $autoAnswer = null, OXFkType $networkHoldMohAudioSourceId = null, OXFkType $userHoldMohAudioSourceId = null, OXFkType $presenceGroupName = null, OXFkType $shareLineAppearanceCssName = null, OXFkType $voiceMailProfileName = null, OXFkType $patternPrecedence = null, OXFkType $releaseClause = null, OXFkType $cfaCssPolicy = null, OXFkType $defaultActivatedDeviceName = null, OXFkType $parkMonForwardNoRetrieveCssName = null, OXFkType $parkMonForwardNoRetrieveIntCssName = null, OXFkType $partyEntranceTone = null, DirectoryURIs $directoryURIs = null, ConfidentialAccess $confidentialAccess = null, OXFkType $externalCallControlProfile = null, EnterpriseAltNum $enterpriseAltNum = null, E164AltNum $e164AltNum = null, $uuid = null)
    {
        $this
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setCallForwardAll($callForwardAll)
            ->setCallForwardBusy($callForwardBusy)
            ->setCallForwardBusyInt($callForwardBusyInt)
            ->setCallForwardNoAnswer($callForwardNoAnswer)
            ->setCallForwardNoAnswerInt($callForwardNoAnswerInt)
            ->setCallForwardNoCoverage($callForwardNoCoverage)
            ->setCallForwardNoCoverageInt($callForwardNoCoverageInt)
            ->setCallForwardOnFailure($callForwardOnFailure)
            ->setCallForwardAlternateParty($callForwardAlternateParty)
            ->setCallForwardNotRegistered($callForwardNotRegistered)
            ->setCallForwardNotRegisteredInt($callForwardNotRegisteredInt)
            ->setCallPickupGroupName($callPickupGroupName)
            ->setAutoAnswer($autoAnswer)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setPresenceGroupName($presenceGroupName)
            ->setShareLineAppearanceCssName($shareLineAppearanceCssName)
            ->setVoiceMailProfileName($voiceMailProfileName)
            ->setPatternPrecedence($patternPrecedence)
            ->setReleaseClause($releaseClause)
            ->setCfaCssPolicy($cfaCssPolicy)
            ->setDefaultActivatedDeviceName($defaultActivatedDeviceName)
            ->setParkMonForwardNoRetrieveCssName($parkMonForwardNoRetrieveCssName)
            ->setParkMonForwardNoRetrieveIntCssName($parkMonForwardNoRetrieveIntCssName)
            ->setPartyEntranceTone($partyEntranceTone)
            ->setDirectoryURIs($directoryURIs)
            ->setConfidentialAccess($confidentialAccess)
            ->setExternalCallControlProfile($externalCallControlProfile)
            ->setEnterpriseAltNum($enterpriseAltNum)
            ->setE164AltNum($e164AltNum)
            ->setUuid($uuid);
    }
    /**
     * Get usage value
     * @return OXFkType|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @param OXFkType $usage
     * @return OXLine
     */
    public function setUsage(OXFkType $usage = null)
    {
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return OXFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param OXFkType $routePartitionName
     * @return OXLine
     */
    public function setRoutePartitionName(OXFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return OXFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param OXFkType $aarNeighborhoodName
     * @return OXLine
     */
    public function setAarNeighborhoodName(OXFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get callForwardAll value
     * @return OXCallForwardAll|null
     */
    public function getCallForwardAll()
    {
        return $this->callForwardAll;
    }
    /**
     * Set callForwardAll value
     * @param OXCallForwardAll $callForwardAll
     * @return OXLine
     */
    public function setCallForwardAll(OXCallForwardAll $callForwardAll = null)
    {
        $this->callForwardAll = $callForwardAll;
        return $this;
    }
    /**
     * Get callForwardBusy value
     * @return OXCallForwardBusy|null
     */
    public function getCallForwardBusy()
    {
        return $this->callForwardBusy;
    }
    /**
     * Set callForwardBusy value
     * @param OXCallForwardBusy $callForwardBusy
     * @return OXLine
     */
    public function setCallForwardBusy(OXCallForwardBusy $callForwardBusy = null)
    {
        $this->callForwardBusy = $callForwardBusy;
        return $this;
    }
    /**
     * Get callForwardBusyInt value
     * @return OXCallForwardBusyInt|null
     */
    public function getCallForwardBusyInt()
    {
        return $this->callForwardBusyInt;
    }
    /**
     * Set callForwardBusyInt value
     * @param OXCallForwardBusyInt $callForwardBusyInt
     * @return OXLine
     */
    public function setCallForwardBusyInt(OXCallForwardBusyInt $callForwardBusyInt = null)
    {
        $this->callForwardBusyInt = $callForwardBusyInt;
        return $this;
    }
    /**
     * Get callForwardNoAnswer value
     * @return OXCallForwardNoAnswer|null
     */
    public function getCallForwardNoAnswer()
    {
        return $this->callForwardNoAnswer;
    }
    /**
     * Set callForwardNoAnswer value
     * @param OXCallForwardNoAnswer $callForwardNoAnswer
     * @return OXLine
     */
    public function setCallForwardNoAnswer(OXCallForwardNoAnswer $callForwardNoAnswer = null)
    {
        $this->callForwardNoAnswer = $callForwardNoAnswer;
        return $this;
    }
    /**
     * Get callForwardNoAnswerInt value
     * @return OXCallForwardNoAnswerInt|null
     */
    public function getCallForwardNoAnswerInt()
    {
        return $this->callForwardNoAnswerInt;
    }
    /**
     * Set callForwardNoAnswerInt value
     * @param OXCallForwardNoAnswerInt $callForwardNoAnswerInt
     * @return OXLine
     */
    public function setCallForwardNoAnswerInt(OXCallForwardNoAnswerInt $callForwardNoAnswerInt = null)
    {
        $this->callForwardNoAnswerInt = $callForwardNoAnswerInt;
        return $this;
    }
    /**
     * Get callForwardNoCoverage value
     * @return OXCallForwardNoCoverage|null
     */
    public function getCallForwardNoCoverage()
    {
        return $this->callForwardNoCoverage;
    }
    /**
     * Set callForwardNoCoverage value
     * @param OXCallForwardNoCoverage $callForwardNoCoverage
     * @return OXLine
     */
    public function setCallForwardNoCoverage(OXCallForwardNoCoverage $callForwardNoCoverage = null)
    {
        $this->callForwardNoCoverage = $callForwardNoCoverage;
        return $this;
    }
    /**
     * Get callForwardNoCoverageInt value
     * @return OXCallForwardNoCoverageInt|null
     */
    public function getCallForwardNoCoverageInt()
    {
        return $this->callForwardNoCoverageInt;
    }
    /**
     * Set callForwardNoCoverageInt value
     * @param OXCallForwardNoCoverageInt $callForwardNoCoverageInt
     * @return OXLine
     */
    public function setCallForwardNoCoverageInt(OXCallForwardNoCoverageInt $callForwardNoCoverageInt = null)
    {
        $this->callForwardNoCoverageInt = $callForwardNoCoverageInt;
        return $this;
    }
    /**
     * Get callForwardOnFailure value
     * @return OXCallForwardOnFailure|null
     */
    public function getCallForwardOnFailure()
    {
        return $this->callForwardOnFailure;
    }
    /**
     * Set callForwardOnFailure value
     * @param OXCallForwardOnFailure $callForwardOnFailure
     * @return OXLine
     */
    public function setCallForwardOnFailure(OXCallForwardOnFailure $callForwardOnFailure = null)
    {
        $this->callForwardOnFailure = $callForwardOnFailure;
        return $this;
    }
    /**
     * Get callForwardAlternateParty value
     * @return OXCallForwardAlternateParty|null
     */
    public function getCallForwardAlternateParty()
    {
        return $this->callForwardAlternateParty;
    }
    /**
     * Set callForwardAlternateParty value
     * @param OXCallForwardAlternateParty $callForwardAlternateParty
     * @return OXLine
     */
    public function setCallForwardAlternateParty(OXCallForwardAlternateParty $callForwardAlternateParty = null)
    {
        $this->callForwardAlternateParty = $callForwardAlternateParty;
        return $this;
    }
    /**
     * Get callForwardNotRegistered value
     * @return OXCallForwardNotRegistered|null
     */
    public function getCallForwardNotRegistered()
    {
        return $this->callForwardNotRegistered;
    }
    /**
     * Set callForwardNotRegistered value
     * @param OXCallForwardNotRegistered $callForwardNotRegistered
     * @return OXLine
     */
    public function setCallForwardNotRegistered(OXCallForwardNotRegistered $callForwardNotRegistered = null)
    {
        $this->callForwardNotRegistered = $callForwardNotRegistered;
        return $this;
    }
    /**
     * Get callForwardNotRegisteredInt value
     * @return OXCallForwardNotRegisteredInt|null
     */
    public function getCallForwardNotRegisteredInt()
    {
        return $this->callForwardNotRegisteredInt;
    }
    /**
     * Set callForwardNotRegisteredInt value
     * @param OXCallForwardNotRegisteredInt $callForwardNotRegisteredInt
     * @return OXLine
     */
    public function setCallForwardNotRegisteredInt(OXCallForwardNotRegisteredInt $callForwardNotRegisteredInt = null)
    {
        $this->callForwardNotRegisteredInt = $callForwardNotRegisteredInt;
        return $this;
    }
    /**
     * Get callPickupGroupName value
     * @return OXFkType|null
     */
    public function getCallPickupGroupName()
    {
        return $this->callPickupGroupName;
    }
    /**
     * Set callPickupGroupName value
     * @param OXFkType $callPickupGroupName
     * @return OXLine
     */
    public function setCallPickupGroupName(OXFkType $callPickupGroupName = null)
    {
        $this->callPickupGroupName = $callPickupGroupName;
        return $this;
    }
    /**
     * Get autoAnswer value
     * @return OXFkType|null
     */
    public function getAutoAnswer()
    {
        return $this->autoAnswer;
    }
    /**
     * Set autoAnswer value
     * @param OXFkType $autoAnswer
     * @return OXLine
     */
    public function setAutoAnswer(OXFkType $autoAnswer = null)
    {
        $this->autoAnswer = $autoAnswer;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * @return OXFkType|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return $this->networkHoldMohAudioSourceId;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * @param OXFkType $networkHoldMohAudioSourceId
     * @return OXLine
     */
    public function setNetworkHoldMohAudioSourceId(OXFkType $networkHoldMohAudioSourceId = null)
    {
        $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return OXFkType|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @param OXFkType $userHoldMohAudioSourceId
     * @return OXLine
     */
    public function setUserHoldMohAudioSourceId(OXFkType $userHoldMohAudioSourceId = null)
    {
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return OXFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param OXFkType $presenceGroupName
     * @return OXLine
     */
    public function setPresenceGroupName(OXFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get shareLineAppearanceCssName value
     * @return OXFkType|null
     */
    public function getShareLineAppearanceCssName()
    {
        return $this->shareLineAppearanceCssName;
    }
    /**
     * Set shareLineAppearanceCssName value
     * @param OXFkType $shareLineAppearanceCssName
     * @return OXLine
     */
    public function setShareLineAppearanceCssName(OXFkType $shareLineAppearanceCssName = null)
    {
        $this->shareLineAppearanceCssName = $shareLineAppearanceCssName;
        return $this;
    }
    /**
     * Get voiceMailProfileName value
     * @return OXFkType|null
     */
    public function getVoiceMailProfileName()
    {
        return $this->voiceMailProfileName;
    }
    /**
     * Set voiceMailProfileName value
     * @param OXFkType $voiceMailProfileName
     * @return OXLine
     */
    public function setVoiceMailProfileName(OXFkType $voiceMailProfileName = null)
    {
        $this->voiceMailProfileName = $voiceMailProfileName;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return OXFkType|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @param OXFkType $patternPrecedence
     * @return OXLine
     */
    public function setPatternPrecedence(OXFkType $patternPrecedence = null)
    {
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get releaseClause value
     * @return OXFkType|null
     */
    public function getReleaseClause()
    {
        return $this->releaseClause;
    }
    /**
     * Set releaseClause value
     * @param OXFkType $releaseClause
     * @return OXLine
     */
    public function setReleaseClause(OXFkType $releaseClause = null)
    {
        $this->releaseClause = $releaseClause;
        return $this;
    }
    /**
     * Get cfaCssPolicy value
     * @return OXFkType|null
     */
    public function getCfaCssPolicy()
    {
        return $this->cfaCssPolicy;
    }
    /**
     * Set cfaCssPolicy value
     * @param OXFkType $cfaCssPolicy
     * @return OXLine
     */
    public function setCfaCssPolicy(OXFkType $cfaCssPolicy = null)
    {
        $this->cfaCssPolicy = $cfaCssPolicy;
        return $this;
    }
    /**
     * Get defaultActivatedDeviceName value
     * @return OXFkType|null
     */
    public function getDefaultActivatedDeviceName()
    {
        return $this->defaultActivatedDeviceName;
    }
    /**
     * Set defaultActivatedDeviceName value
     * @param OXFkType $defaultActivatedDeviceName
     * @return OXLine
     */
    public function setDefaultActivatedDeviceName(OXFkType $defaultActivatedDeviceName = null)
    {
        $this->defaultActivatedDeviceName = $defaultActivatedDeviceName;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveCssName value
     * @return OXFkType|null
     */
    public function getParkMonForwardNoRetrieveCssName()
    {
        return $this->parkMonForwardNoRetrieveCssName;
    }
    /**
     * Set parkMonForwardNoRetrieveCssName value
     * @param OXFkType $parkMonForwardNoRetrieveCssName
     * @return OXLine
     */
    public function setParkMonForwardNoRetrieveCssName(OXFkType $parkMonForwardNoRetrieveCssName = null)
    {
        $this->parkMonForwardNoRetrieveCssName = $parkMonForwardNoRetrieveCssName;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveIntCssName value
     * @return OXFkType|null
     */
    public function getParkMonForwardNoRetrieveIntCssName()
    {
        return $this->parkMonForwardNoRetrieveIntCssName;
    }
    /**
     * Set parkMonForwardNoRetrieveIntCssName value
     * @param OXFkType $parkMonForwardNoRetrieveIntCssName
     * @return OXLine
     */
    public function setParkMonForwardNoRetrieveIntCssName(OXFkType $parkMonForwardNoRetrieveIntCssName = null)
    {
        $this->parkMonForwardNoRetrieveIntCssName = $parkMonForwardNoRetrieveIntCssName;
        return $this;
    }
    /**
     * Get partyEntranceTone value
     * @return OXFkType|null
     */
    public function getPartyEntranceTone()
    {
        return $this->partyEntranceTone;
    }
    /**
     * Set partyEntranceTone value
     * @param OXFkType $partyEntranceTone
     * @return OXLine
     */
    public function setPartyEntranceTone(OXFkType $partyEntranceTone = null)
    {
        $this->partyEntranceTone = $partyEntranceTone;
        return $this;
    }
    /**
     * Get directoryURIs value
     * @return DirectoryURIs|null
     */
    public function getDirectoryURIs()
    {
        return $this->directoryURIs;
    }
    /**
     * Set directoryURIs value
     * @param DirectoryURIs $directoryURIs
     * @return OXLine
     */
    public function setDirectoryURIs(DirectoryURIs $directoryURIs = null)
    {
        $this->directoryURIs = $directoryURIs;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param ConfidentialAccess $confidentialAccess
     * @return OXLine
     */
    public function setConfidentialAccess(ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get externalCallControlProfile value
     * @return OXFkType|null
     */
    public function getExternalCallControlProfile()
    {
        return $this->externalCallControlProfile;
    }
    /**
     * Set externalCallControlProfile value
     * @param OXFkType $externalCallControlProfile
     * @return OXLine
     */
    public function setExternalCallControlProfile(OXFkType $externalCallControlProfile = null)
    {
        $this->externalCallControlProfile = $externalCallControlProfile;
        return $this;
    }
    /**
     * Get enterpriseAltNum value
     * @return EnterpriseAltNum|null
     */
    public function getEnterpriseAltNum()
    {
        return $this->enterpriseAltNum;
    }
    /**
     * Set enterpriseAltNum value
     * @param EnterpriseAltNum $enterpriseAltNum
     * @return OXLine
     */
    public function setEnterpriseAltNum(EnterpriseAltNum $enterpriseAltNum = null)
    {
        $this->enterpriseAltNum = $enterpriseAltNum;
        return $this;
    }
    /**
     * Get e164AltNum value
     * @return E164AltNum|null
     */
    public function getE164AltNum()
    {
        return $this->e164AltNum;
    }
    /**
     * Set e164AltNum value
     * @param E164AltNum $e164AltNum
     * @return OXLine
     */
    public function setE164AltNum(E164AltNum $e164AltNum = null)
    {
        $this->e164AltNum = $e164AltNum;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return OXLine
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return OXLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
