<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXDeviceProfile StructType
 * @subpackage Structs
 */
class OXDeviceProfile extends AbstractStructBase
{
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $product;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $class;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkTypeProduct
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta informations extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $protocolSide;
    /**
     * The userHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $userHoldMohAudioSourceId;
    /**
     * The mlppIndicationStatus
     * Meta informations extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta informations extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $preemption;
    /**
     * The lines
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Lines
     */
    public $lines;
    /**
     * The phoneTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkTypeProduct_Protocol
     */
    public $phoneTemplateName;
    /**
     * The blfDirectedCallParks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var BlfDirectedCallParks
     */
    public $blfDirectedCallParks;
    /**
     * The addOnModules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AddOnModules
     */
    public $addOnModules;
    /**
     * The userLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $userLocale;
    /**
     * The singleButtonBarge
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support SBB.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $singleButtonBarge;
    /**
     * The joinAcrossLines
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support JAL..
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $joinAcrossLines;
    /**
     * The loginUserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $loginUserId;
    /**
     * The dndOption
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $dndOption;
    /**
     * The dndRingSetting
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $dndRingSetting;
    /**
     * The emccCallingSearchSpace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $emccCallingSearchSpace;
    /**
     * The alwaysUsePrimeLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The softkeyTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $softkeyTemplateName;
    /**
     * The callInfoPrivacyStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $callInfoPrivacyStatus;
    /**
     * The services
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Services
     */
    public $services;
    /**
     * The featureControlPolicy
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for RT Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OXFkType
     */
    public $featureControlPolicy;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for OXDeviceProfile
     * @uses OXDeviceProfile::setProduct()
     * @uses OXDeviceProfile::setClass()
     * @uses OXDeviceProfile::setProtocol()
     * @uses OXDeviceProfile::setProtocolSide()
     * @uses OXDeviceProfile::setUserHoldMohAudioSourceId()
     * @uses OXDeviceProfile::setMlppIndicationStatus()
     * @uses OXDeviceProfile::setPreemption()
     * @uses OXDeviceProfile::setLines()
     * @uses OXDeviceProfile::setPhoneTemplateName()
     * @uses OXDeviceProfile::setBlfDirectedCallParks()
     * @uses OXDeviceProfile::setAddOnModules()
     * @uses OXDeviceProfile::setUserLocale()
     * @uses OXDeviceProfile::setSingleButtonBarge()
     * @uses OXDeviceProfile::setJoinAcrossLines()
     * @uses OXDeviceProfile::setLoginUserId()
     * @uses OXDeviceProfile::setDndOption()
     * @uses OXDeviceProfile::setDndRingSetting()
     * @uses OXDeviceProfile::setEmccCallingSearchSpace()
     * @uses OXDeviceProfile::setAlwaysUsePrimeLine()
     * @uses OXDeviceProfile::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses OXDeviceProfile::setSoftkeyTemplateName()
     * @uses OXDeviceProfile::setCallInfoPrivacyStatus()
     * @uses OXDeviceProfile::setServices()
     * @uses OXDeviceProfile::setFeatureControlPolicy()
     * @uses OXDeviceProfile::setCtiid()
     * @uses OXDeviceProfile::setUuid()
     * @param OXFkType $product
     * @param OXFkType $class
     * @param OXFkTypeProduct $protocol
     * @param OXFkType $protocolSide
     * @param OXFkType $userHoldMohAudioSourceId
     * @param OXFkType $mlppIndicationStatus
     * @param OXFkType $preemption
     * @param Lines $lines
     * @param OXFkTypeProduct_Protocol $phoneTemplateName
     * @param BlfDirectedCallParks $blfDirectedCallParks
     * @param AddOnModules $addOnModules
     * @param OXFkType $userLocale
     * @param OXFkType $singleButtonBarge
     * @param OXFkType $joinAcrossLines
     * @param OXFkType $loginUserId
     * @param OXFkType $dndOption
     * @param OXFkType $dndRingSetting
     * @param OXFkType $emccCallingSearchSpace
     * @param OXFkType $alwaysUsePrimeLine
     * @param OXFkType $alwaysUsePrimeLineForVoiceMessage
     * @param OXFkType $softkeyTemplateName
     * @param OXFkType $callInfoPrivacyStatus
     * @param Services $services
     * @param OXFkType $featureControlPolicy
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct(OXFkType $product = null, OXFkType $class = null, OXFkTypeProduct $protocol = null, OXFkType $protocolSide = null, OXFkType $userHoldMohAudioSourceId = null, OXFkType $mlppIndicationStatus = null, OXFkType $preemption = null, Lines $lines = null, OXFkTypeProduct_Protocol $phoneTemplateName = null, BlfDirectedCallParks $blfDirectedCallParks = null, AddOnModules $addOnModules = null, OXFkType $userLocale = null, OXFkType $singleButtonBarge = null, OXFkType $joinAcrossLines = null, OXFkType $loginUserId = null, OXFkType $dndOption = null, OXFkType $dndRingSetting = null, OXFkType $emccCallingSearchSpace = null, OXFkType $alwaysUsePrimeLine = null, OXFkType $alwaysUsePrimeLineForVoiceMessage = null, OXFkType $softkeyTemplateName = null, OXFkType $callInfoPrivacyStatus = null, Services $services = null, OXFkType $featureControlPolicy = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setProduct($product)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setLines($lines)
            ->setPhoneTemplateName($phoneTemplateName)
            ->setBlfDirectedCallParks($blfDirectedCallParks)
            ->setAddOnModules($addOnModules)
            ->setUserLocale($userLocale)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setLoginUserId($loginUserId)
            ->setDndOption($dndOption)
            ->setDndRingSetting($dndRingSetting)
            ->setEmccCallingSearchSpace($emccCallingSearchSpace)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setSoftkeyTemplateName($softkeyTemplateName)
            ->setCallInfoPrivacyStatus($callInfoPrivacyStatus)
            ->setServices($services)
            ->setFeatureControlPolicy($featureControlPolicy)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get product value
     * @return OXFkType|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param OXFkType $product
     * @return OXDeviceProfile
     */
    public function setProduct(OXFkType $product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get class value
     * @return OXFkType|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param OXFkType $class
     * @return OXDeviceProfile
     */
    public function setClass(OXFkType $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return OXFkTypeProduct|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param OXFkTypeProduct $protocol
     * @return OXDeviceProfile
     */
    public function setProtocol(OXFkTypeProduct $protocol = null)
    {
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return OXFkType|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @param OXFkType $protocolSide
     * @return OXDeviceProfile
     */
    public function setProtocolSide(OXFkType $protocolSide = null)
    {
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return OXFkType|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @param OXFkType $userHoldMohAudioSourceId
     * @return OXDeviceProfile
     */
    public function setUserHoldMohAudioSourceId(OXFkType $userHoldMohAudioSourceId = null)
    {
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return OXFkType|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @param OXFkType $mlppIndicationStatus
     * @return OXDeviceProfile
     */
    public function setMlppIndicationStatus(OXFkType $mlppIndicationStatus = null)
    {
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return OXFkType|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @param OXFkType $preemption
     * @return OXDeviceProfile
     */
    public function setPreemption(OXFkType $preemption = null)
    {
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get lines value
     * @return Lines|null
     */
    public function getLines()
    {
        return $this->lines;
    }
    /**
     * Set lines value
     * @param Lines $lines
     * @return OXDeviceProfile
     */
    public function setLines(Lines $lines = null)
    {
        $this->lines = $lines;
        return $this;
    }
    /**
     * Get phoneTemplateName value
     * @return OXFkTypeProduct_Protocol|null
     */
    public function getPhoneTemplateName()
    {
        return $this->phoneTemplateName;
    }
    /**
     * Set phoneTemplateName value
     * @param OXFkTypeProduct_Protocol $phoneTemplateName
     * @return OXDeviceProfile
     */
    public function setPhoneTemplateName(OXFkTypeProduct_Protocol $phoneTemplateName = null)
    {
        $this->phoneTemplateName = $phoneTemplateName;
        return $this;
    }
    /**
     * Get blfDirectedCallParks value
     * @return BlfDirectedCallParks|null
     */
    public function getBlfDirectedCallParks()
    {
        return $this->blfDirectedCallParks;
    }
    /**
     * Set blfDirectedCallParks value
     * @param BlfDirectedCallParks $blfDirectedCallParks
     * @return OXDeviceProfile
     */
    public function setBlfDirectedCallParks(BlfDirectedCallParks $blfDirectedCallParks = null)
    {
        $this->blfDirectedCallParks = $blfDirectedCallParks;
        return $this;
    }
    /**
     * Get addOnModules value
     * @return AddOnModules|null
     */
    public function getAddOnModules()
    {
        return $this->addOnModules;
    }
    /**
     * Set addOnModules value
     * @param AddOnModules $addOnModules
     * @return OXDeviceProfile
     */
    public function setAddOnModules(AddOnModules $addOnModules = null)
    {
        $this->addOnModules = $addOnModules;
        return $this;
    }
    /**
     * Get userLocale value
     * @return OXFkType|null
     */
    public function getUserLocale()
    {
        return $this->userLocale;
    }
    /**
     * Set userLocale value
     * @param OXFkType $userLocale
     * @return OXDeviceProfile
     */
    public function setUserLocale(OXFkType $userLocale = null)
    {
        $this->userLocale = $userLocale;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return OXFkType|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @param OXFkType $singleButtonBarge
     * @return OXDeviceProfile
     */
    public function setSingleButtonBarge(OXFkType $singleButtonBarge = null)
    {
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return OXFkType|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @param OXFkType $joinAcrossLines
     * @return OXDeviceProfile
     */
    public function setJoinAcrossLines(OXFkType $joinAcrossLines = null)
    {
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get loginUserId value
     * @return OXFkType|null
     */
    public function getLoginUserId()
    {
        return $this->loginUserId;
    }
    /**
     * Set loginUserId value
     * @param OXFkType $loginUserId
     * @return OXDeviceProfile
     */
    public function setLoginUserId(OXFkType $loginUserId = null)
    {
        $this->loginUserId = $loginUserId;
        return $this;
    }
    /**
     * Get dndOption value
     * @return OXFkType|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @param OXFkType $dndOption
     * @return OXDeviceProfile
     */
    public function setDndOption(OXFkType $dndOption = null)
    {
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get dndRingSetting value
     * @return OXFkType|null
     */
    public function getDndRingSetting()
    {
        return $this->dndRingSetting;
    }
    /**
     * Set dndRingSetting value
     * @param OXFkType $dndRingSetting
     * @return OXDeviceProfile
     */
    public function setDndRingSetting(OXFkType $dndRingSetting = null)
    {
        $this->dndRingSetting = $dndRingSetting;
        return $this;
    }
    /**
     * Get emccCallingSearchSpace value
     * @return OXFkType|null
     */
    public function getEmccCallingSearchSpace()
    {
        return $this->emccCallingSearchSpace;
    }
    /**
     * Set emccCallingSearchSpace value
     * @param OXFkType $emccCallingSearchSpace
     * @return OXDeviceProfile
     */
    public function setEmccCallingSearchSpace(OXFkType $emccCallingSearchSpace = null)
    {
        $this->emccCallingSearchSpace = $emccCallingSearchSpace;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return OXFkType|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @param OXFkType $alwaysUsePrimeLine
     * @return OXDeviceProfile
     */
    public function setAlwaysUsePrimeLine(OXFkType $alwaysUsePrimeLine = null)
    {
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return OXFkType|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @param OXFkType $alwaysUsePrimeLineForVoiceMessage
     * @return OXDeviceProfile
     */
    public function setAlwaysUsePrimeLineForVoiceMessage(OXFkType $alwaysUsePrimeLineForVoiceMessage = null)
    {
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get softkeyTemplateName value
     * @return OXFkType|null
     */
    public function getSoftkeyTemplateName()
    {
        return $this->softkeyTemplateName;
    }
    /**
     * Set softkeyTemplateName value
     * @param OXFkType $softkeyTemplateName
     * @return OXDeviceProfile
     */
    public function setSoftkeyTemplateName(OXFkType $softkeyTemplateName = null)
    {
        $this->softkeyTemplateName = $softkeyTemplateName;
        return $this;
    }
    /**
     * Get callInfoPrivacyStatus value
     * @return OXFkType|null
     */
    public function getCallInfoPrivacyStatus()
    {
        return $this->callInfoPrivacyStatus;
    }
    /**
     * Set callInfoPrivacyStatus value
     * @param OXFkType $callInfoPrivacyStatus
     * @return OXDeviceProfile
     */
    public function setCallInfoPrivacyStatus(OXFkType $callInfoPrivacyStatus = null)
    {
        $this->callInfoPrivacyStatus = $callInfoPrivacyStatus;
        return $this;
    }
    /**
     * Get services value
     * @return Services|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param Services $services
     * @return OXDeviceProfile
     */
    public function setServices(Services $services = null)
    {
        $this->services = $services;
        return $this;
    }
    /**
     * Get featureControlPolicy value
     * @return OXFkType|null
     */
    public function getFeatureControlPolicy()
    {
        return $this->featureControlPolicy;
    }
    /**
     * Set featureControlPolicy value
     * @param OXFkType $featureControlPolicy
     * @return OXDeviceProfile
     */
    public function setFeatureControlPolicy(OXFkType $featureControlPolicy = null)
    {
        $this->featureControlPolicy = $featureControlPolicy;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return OXDeviceProfile
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return OXDeviceProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return OXDeviceProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
