<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LUserPhoneAssociation StructType
 * @subpackage Structs
 */
class LUserPhoneAssociation extends AbstractStructBase
{
    /**
     * The userId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userId;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The pin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pin;
    /**
     * The lastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lastName;
    /**
     * The middleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $middleName;
    /**
     * The firstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The productType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $productType;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The dnCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $dnCssName;
    /**
     * The phoneCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $phoneCssName;
    /**
     * The e164Mask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $e164Mask;
    /**
     * The extension
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $extension;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $routePartitionName;
    /**
     * The voiceMailProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $voiceMailProfileName;
    /**
     * The enableExtensionMobility
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableExtensionMobility;
    /**
     * The DirectoryURI
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DirectoryURI;
    /**
     * The DirectoryNumberURIPartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $DirectoryNumberURIPartition;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LUserPhoneAssociation
     * @uses LUserPhoneAssociation::setUserId()
     * @uses LUserPhoneAssociation::setPassword()
     * @uses LUserPhoneAssociation::setPin()
     * @uses LUserPhoneAssociation::setLastName()
     * @uses LUserPhoneAssociation::setMiddleName()
     * @uses LUserPhoneAssociation::setFirstName()
     * @uses LUserPhoneAssociation::setProductType()
     * @uses LUserPhoneAssociation::setName()
     * @uses LUserPhoneAssociation::setDnCssName()
     * @uses LUserPhoneAssociation::setPhoneCssName()
     * @uses LUserPhoneAssociation::setE164Mask()
     * @uses LUserPhoneAssociation::setExtension()
     * @uses LUserPhoneAssociation::setRoutePartitionName()
     * @uses LUserPhoneAssociation::setVoiceMailProfileName()
     * @uses LUserPhoneAssociation::setEnableExtensionMobility()
     * @uses LUserPhoneAssociation::setDirectoryURI()
     * @uses LUserPhoneAssociation::setDirectoryNumberURIPartition()
     * @uses LUserPhoneAssociation::setUuid()
     * @param string $userId
     * @param string $password
     * @param string $pin
     * @param string $lastName
     * @param string $middleName
     * @param string $firstName
     * @param string $productType
     * @param string $name
     * @param XFkType $dnCssName
     * @param XFkType $phoneCssName
     * @param string $e164Mask
     * @param string $extension
     * @param XFkType $routePartitionName
     * @param XFkType $voiceMailProfileName
     * @param string $enableExtensionMobility
     * @param string $directoryURI
     * @param XFkType $directoryNumberURIPartition
     * @param string $uuid
     */
    public function __construct($userId = null, $password = null, $pin = null, $lastName = null, $middleName = null, $firstName = null, $productType = null, $name = null, XFkType $dnCssName = null, XFkType $phoneCssName = null, $e164Mask = null, $extension = null, XFkType $routePartitionName = null, XFkType $voiceMailProfileName = null, $enableExtensionMobility = null, $directoryURI = null, XFkType $directoryNumberURIPartition = null, $uuid = null)
    {
        $this
            ->setUserId($userId)
            ->setPassword($password)
            ->setPin($pin)
            ->setLastName($lastName)
            ->setMiddleName($middleName)
            ->setFirstName($firstName)
            ->setProductType($productType)
            ->setName($name)
            ->setDnCssName($dnCssName)
            ->setPhoneCssName($phoneCssName)
            ->setE164Mask($e164Mask)
            ->setExtension($extension)
            ->setRoutePartitionName($routePartitionName)
            ->setVoiceMailProfileName($voiceMailProfileName)
            ->setEnableExtensionMobility($enableExtensionMobility)
            ->setDirectoryURI($directoryURI)
            ->setDirectoryNumberURIPartition($directoryNumberURIPartition)
            ->setUuid($uuid);
    }
    /**
     * Get userId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return LUserPhoneAssociation
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userId)), __LINE__);
        }
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return LUserPhoneAssociation
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get pin value
     * @return string|null
     */
    public function getPin()
    {
        return $this->pin;
    }
    /**
     * Set pin value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pin
     * @return LUserPhoneAssociation
     */
    public function setPin($pin = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($pin)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pin, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->pin = $pin;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return LUserPhoneAssociation
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get middleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->middleName;
    }
    /**
     * Set middleName value
     * @param string $middleName
     * @return LUserPhoneAssociation
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middleName)), __LINE__);
        }
        $this->middleName = $middleName;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return LUserPhoneAssociation
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get productType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->productType;
    }
    /**
     * Set productType value
     * @uses XModel::valueIsValid()
     * @uses XModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productType
     * @return LUserPhoneAssociation
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: enumeration
        if (!XModel::valueIsValid($productType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $productType, implode(', ', XModel::getValidValues())), __LINE__);
        }
        $this->productType = $productType;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return LUserPhoneAssociation
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get dnCssName value
     * @return XFkType|null
     */
    public function getDnCssName()
    {
        return $this->dnCssName;
    }
    /**
     * Set dnCssName value
     * @param XFkType $dnCssName
     * @return LUserPhoneAssociation
     */
    public function setDnCssName(XFkType $dnCssName = null)
    {
        $this->dnCssName = $dnCssName;
        return $this;
    }
    /**
     * Get phoneCssName value
     * @return XFkType|null
     */
    public function getPhoneCssName()
    {
        return $this->phoneCssName;
    }
    /**
     * Set phoneCssName value
     * @param XFkType $phoneCssName
     * @return LUserPhoneAssociation
     */
    public function setPhoneCssName(XFkType $phoneCssName = null)
    {
        $this->phoneCssName = $phoneCssName;
        return $this;
    }
    /**
     * Get e164Mask value
     * @return string|null
     */
    public function getE164Mask()
    {
        return $this->e164Mask;
    }
    /**
     * Set e164Mask value
     * @param string $e164Mask
     * @return LUserPhoneAssociation
     */
    public function setE164Mask($e164Mask = null)
    {
        // validation for constraint: string
        if (!is_null($e164Mask) && !is_string($e164Mask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($e164Mask)), __LINE__);
        }
        $this->e164Mask = $e164Mask;
        return $this;
    }
    /**
     * Get extension value
     * @return string|null
     */
    public function getExtension()
    {
        return $this->extension;
    }
    /**
     * Set extension value
     * @param string $extension
     * @return LUserPhoneAssociation
     */
    public function setExtension($extension = null)
    {
        // validation for constraint: string
        if (!is_null($extension) && !is_string($extension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($extension)), __LINE__);
        }
        $this->extension = $extension;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return XFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param XFkType $routePartitionName
     * @return LUserPhoneAssociation
     */
    public function setRoutePartitionName(XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get voiceMailProfileName value
     * @return XFkType|null
     */
    public function getVoiceMailProfileName()
    {
        return $this->voiceMailProfileName;
    }
    /**
     * Set voiceMailProfileName value
     * @param XFkType $voiceMailProfileName
     * @return LUserPhoneAssociation
     */
    public function setVoiceMailProfileName(XFkType $voiceMailProfileName = null)
    {
        $this->voiceMailProfileName = $voiceMailProfileName;
        return $this;
    }
    /**
     * Get enableExtensionMobility value
     * @return string|null
     */
    public function getEnableExtensionMobility()
    {
        return $this->enableExtensionMobility;
    }
    /**
     * Set enableExtensionMobility value
     * @param string $enableExtensionMobility
     * @return LUserPhoneAssociation
     */
    public function setEnableExtensionMobility($enableExtensionMobility = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableExtensionMobility) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableExtensionMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableExtensionMobility, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableExtensionMobility) && !is_string($enableExtensionMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableExtensionMobility)), __LINE__);
        }
        $this->enableExtensionMobility = $enableExtensionMobility;
        return $this;
    }
    /**
     * Get DirectoryURI value
     * @return string|null
     */
    public function getDirectoryURI()
    {
        return $this->DirectoryURI;
    }
    /**
     * Set DirectoryURI value
     * @param string $directoryURI
     * @return LUserPhoneAssociation
     */
    public function setDirectoryURI($directoryURI = null)
    {
        // validation for constraint: string
        if (!is_null($directoryURI) && !is_string($directoryURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directoryURI)), __LINE__);
        }
        $this->DirectoryURI = $directoryURI;
        return $this;
    }
    /**
     * Get DirectoryNumberURIPartition value
     * @return XFkType|null
     */
    public function getDirectoryNumberURIPartition()
    {
        return $this->DirectoryNumberURIPartition;
    }
    /**
     * Set DirectoryNumberURIPartition value
     * @param XFkType $directoryNumberURIPartition
     * @return LUserPhoneAssociation
     */
    public function setDirectoryNumberURIPartition(XFkType $directoryNumberURIPartition = null)
    {
        $this->DirectoryNumberURIPartition = $directoryNumberURIPartition;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LUserPhoneAssociation
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LUserPhoneAssociation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
