<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LUniversalDeviceTemplate StructType
 * @subpackage Structs
 */
class LUniversalDeviceTemplate extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The deviceDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceDescription;
    /**
     * The devicePool
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $devicePool;
    /**
     * The deviceSecurityProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $deviceSecurityProfile;
    /**
     * The sipProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $sipProfile;
    /**
     * The phoneButtonTemplate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $phoneButtonTemplate;
    /**
     * The sipDialRules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $sipDialRules;
    /**
     * The callingSearchSpace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $callingSearchSpace;
    /**
     * The callingPartyTransformationCSSForInboundCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $callingPartyTransformationCSSForInboundCalls;
    /**
     * The callingPartyTransformationCSSForOutboundCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $callingPartyTransformationCSSForOutboundCalls;
    /**
     * The reroutingCallingSearchSpace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $reroutingCallingSearchSpace;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The useDevicePoolCallingPartyTransformationCSSforInboundCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCallingPartyTransformationCSSforInboundCalls;
    /**
     * The useDevicePoolCallingPartyTransformationCSSforOutboundCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCallingPartyTransformationCSSforOutboundCalls;
    /**
     * The commonPhoneProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $commonPhoneProfile;
    /**
     * The commonDeviceConfiguration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $commonDeviceConfiguration;
    /**
     * The softkeyTemplate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $softkeyTemplate;
    /**
     * The featureControlPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $featureControlPolicy;
    /**
     * The phonePersonalization
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phonePersonalization;
    /**
     * The mtpPreferredOriginatingCodec
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mtpPreferredOriginatingCodec;
    /**
     * The outboundCallRollover
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $outboundCallRollover;
    /**
     * The mediaTerminationPointRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mediaTerminationPointRequired;
    /**
     * The unattendedPort
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unattendedPort;
    /**
     * The requiredDtmfReception
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $requiredDtmfReception;
    /**
     * The rfc2833Disabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rfc2833Disabled;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The protectedDevice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $protectedDevice;
    /**
     * The authenticationMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationMode;
    /**
     * The authenticationString
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationString;
    /**
     * The keySize
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $keySize;
    /**
     * The servicesProvisioning
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $servicesProvisioning;
    /**
     * The packetCaptureMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The packetCaptureDuration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The secureShellUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secureShellUser;
    /**
     * The secureShellPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secureShellPassword;
    /**
     * The userLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userLocale;
    /**
     * The networkLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocale;
    /**
     * The mlppDomain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $mlppDomain;
    /**
     * The mlppIndication
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppIndication;
    /**
     * The mlppPreemption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppPreemption;
    /**
     * The doNotDisturb
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $doNotDisturb;
    /**
     * The dndOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dndOption;
    /**
     * The dndIncomingCallAlert
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dndIncomingCallAlert;
    /**
     * The aarGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $aarGroup;
    /**
     * The aarCallingSearchSpace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $aarCallingSearchSpace;
    /**
     * The blfPresenceGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $blfPresenceGroup;
    /**
     * The blfAudibleAlertSettingPhoneBusy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $blfAudibleAlertSettingPhoneBusy;
    /**
     * The blfAudibleAlertSettingPhoneIdle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $blfAudibleAlertSettingPhoneIdle;
    /**
     * The userHoldMohAudioSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userHoldMohAudioSource;
    /**
     * The networkHoldMohAudioSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkHoldMohAudioSource;
    /**
     * The location
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $location;
    /**
     * The geoLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $geoLocation;
    /**
     * The deviceMobilityMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceMobilityMode;
    /**
     * The mediaResourceGroupList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $mediaResourceGroupList;
    /**
     * The remoteDevice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $remoteDevice;
    /**
     * The hotlineDevice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $hotlineDevice;
    /**
     * The retryVideoCallAsAudio
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retryVideoCallAsAudio;
    /**
     * The requireOffPremiseLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $requireOffPremiseLocation;
    /**
     * The ownerUserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $ownerUserId;
    /**
     * The mobilityUserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $mobilityUserId;
    /**
     * The joinAcrossLines
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $joinAcrossLines;
    /**
     * The alwaysUsePrimeLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The singleButtonBarge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $singleButtonBarge;
    /**
     * The builtInBridge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $builtInBridge;
    /**
     * The allowControlOfDeviceFromCti
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowControlOfDeviceFromCti;
    /**
     * The ignorePresentationIndicators
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ignorePresentationIndicators;
    /**
     * The enableExtensionMobility
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableExtensionMobility;
    /**
     * The recordingOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $recordingOptions;
    /**
     * The privacy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $privacy;
    /**
     * The loggedIntoHuntGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $loggedIntoHuntGroup;
    /**
     * The proxyServer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $proxyServer;
    /**
     * The servicesUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $servicesUrl;
    /**
     * The idle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $idle;
    /**
     * The idleTimer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $idleTimer;
    /**
     * The secureDirUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secureDirUrl;
    /**
     * The messages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $messages;
    /**
     * The secureIdleUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secureIdleUrl;
    /**
     * The authenticationServer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationServer;
    /**
     * The directory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $directory;
    /**
     * The secureServicesUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secureServicesUrl;
    /**
     * The information
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $information;
    /**
     * The secureMessagesUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secureMessagesUrl;
    /**
     * The secureInformationUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secureInformationUrl;
    /**
     * The secureAuthenticationUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secureAuthenticationUrl;
    /**
     * The externalPhoneNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $externalPhoneNumber;
    /**
     * The audibleMsgWaitingicatorPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $audibleMsgWaitingicatorPolicy;
    /**
     * The logMissedCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $logMissedCalls;
    /**
     * The visualMsgWaitingIndicatorPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $visualMsgWaitingIndicatorPolicy;
    /**
     * The lineLabel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lineLabel;
    /**
     * The displayCallerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $displayCallerId;
    /**
     * The MaxNumberOfCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MaxNumberOfCalls;
    /**
     * The ringSettingWhenPhoneIdle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ringSettingWhenPhoneIdle;
    /**
     * The busyTrigger
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $busyTrigger;
    /**
     * The ringSettingWhenPhoneInUse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ringSettingWhenPhoneInUse;
    /**
     * The directoryNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $directoryNumber;
    /**
     * The recordingProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $recordingProfile;
    /**
     * The callPickupGroupAudioAlertSettingPhoneActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callPickupGroupAudioAlertSettingPhoneActive;
    /**
     * The callPickupGroupAudioAlertSettingPhoneIdle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callPickupGroupAudioAlertSettingPhoneIdle;
    /**
     * The monitoringCallingSearchSpace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $monitoringCallingSearchSpace;
    /**
     * The confidentialAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LUniversalDeviceTemplate
     * @uses LUniversalDeviceTemplate::setName()
     * @uses LUniversalDeviceTemplate::setDeviceDescription()
     * @uses LUniversalDeviceTemplate::setDevicePool()
     * @uses LUniversalDeviceTemplate::setDeviceSecurityProfile()
     * @uses LUniversalDeviceTemplate::setSipProfile()
     * @uses LUniversalDeviceTemplate::setPhoneButtonTemplate()
     * @uses LUniversalDeviceTemplate::setSipDialRules()
     * @uses LUniversalDeviceTemplate::setCallingSearchSpace()
     * @uses LUniversalDeviceTemplate::setCallingPartyTransformationCSSForInboundCalls()
     * @uses LUniversalDeviceTemplate::setCallingPartyTransformationCSSForOutboundCalls()
     * @uses LUniversalDeviceTemplate::setReroutingCallingSearchSpace()
     * @uses LUniversalDeviceTemplate::setSubscribeCallingSearchSpaceName()
     * @uses LUniversalDeviceTemplate::setUseDevicePoolCallingPartyTransformationCSSforInboundCalls()
     * @uses LUniversalDeviceTemplate::setUseDevicePoolCallingPartyTransformationCSSforOutboundCalls()
     * @uses LUniversalDeviceTemplate::setCommonPhoneProfile()
     * @uses LUniversalDeviceTemplate::setCommonDeviceConfiguration()
     * @uses LUniversalDeviceTemplate::setSoftkeyTemplate()
     * @uses LUniversalDeviceTemplate::setFeatureControlPolicy()
     * @uses LUniversalDeviceTemplate::setPhonePersonalization()
     * @uses LUniversalDeviceTemplate::setMtpPreferredOriginatingCodec()
     * @uses LUniversalDeviceTemplate::setOutboundCallRollover()
     * @uses LUniversalDeviceTemplate::setMediaTerminationPointRequired()
     * @uses LUniversalDeviceTemplate::setUnattendedPort()
     * @uses LUniversalDeviceTemplate::setRequiredDtmfReception()
     * @uses LUniversalDeviceTemplate::setRfc2833Disabled()
     * @uses LUniversalDeviceTemplate::setUseTrustedRelayPoint()
     * @uses LUniversalDeviceTemplate::setProtectedDevice()
     * @uses LUniversalDeviceTemplate::setAuthenticationMode()
     * @uses LUniversalDeviceTemplate::setAuthenticationString()
     * @uses LUniversalDeviceTemplate::setKeySize()
     * @uses LUniversalDeviceTemplate::setServicesProvisioning()
     * @uses LUniversalDeviceTemplate::setPacketCaptureMode()
     * @uses LUniversalDeviceTemplate::setPacketCaptureDuration()
     * @uses LUniversalDeviceTemplate::setSecureShellUser()
     * @uses LUniversalDeviceTemplate::setSecureShellPassword()
     * @uses LUniversalDeviceTemplate::setUserLocale()
     * @uses LUniversalDeviceTemplate::setNetworkLocale()
     * @uses LUniversalDeviceTemplate::setMlppDomain()
     * @uses LUniversalDeviceTemplate::setMlppIndication()
     * @uses LUniversalDeviceTemplate::setMlppPreemption()
     * @uses LUniversalDeviceTemplate::setDoNotDisturb()
     * @uses LUniversalDeviceTemplate::setDndOption()
     * @uses LUniversalDeviceTemplate::setDndIncomingCallAlert()
     * @uses LUniversalDeviceTemplate::setAarGroup()
     * @uses LUniversalDeviceTemplate::setAarCallingSearchSpace()
     * @uses LUniversalDeviceTemplate::setBlfPresenceGroup()
     * @uses LUniversalDeviceTemplate::setBlfAudibleAlertSettingPhoneBusy()
     * @uses LUniversalDeviceTemplate::setBlfAudibleAlertSettingPhoneIdle()
     * @uses LUniversalDeviceTemplate::setUserHoldMohAudioSource()
     * @uses LUniversalDeviceTemplate::setNetworkHoldMohAudioSource()
     * @uses LUniversalDeviceTemplate::setLocation()
     * @uses LUniversalDeviceTemplate::setGeoLocation()
     * @uses LUniversalDeviceTemplate::setDeviceMobilityMode()
     * @uses LUniversalDeviceTemplate::setMediaResourceGroupList()
     * @uses LUniversalDeviceTemplate::setRemoteDevice()
     * @uses LUniversalDeviceTemplate::setHotlineDevice()
     * @uses LUniversalDeviceTemplate::setRetryVideoCallAsAudio()
     * @uses LUniversalDeviceTemplate::setRequireOffPremiseLocation()
     * @uses LUniversalDeviceTemplate::setOwnerUserId()
     * @uses LUniversalDeviceTemplate::setMobilityUserId()
     * @uses LUniversalDeviceTemplate::setJoinAcrossLines()
     * @uses LUniversalDeviceTemplate::setAlwaysUsePrimeLine()
     * @uses LUniversalDeviceTemplate::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses LUniversalDeviceTemplate::setSingleButtonBarge()
     * @uses LUniversalDeviceTemplate::setBuiltInBridge()
     * @uses LUniversalDeviceTemplate::setAllowControlOfDeviceFromCti()
     * @uses LUniversalDeviceTemplate::setIgnorePresentationIndicators()
     * @uses LUniversalDeviceTemplate::setEnableExtensionMobility()
     * @uses LUniversalDeviceTemplate::setRecordingOptions()
     * @uses LUniversalDeviceTemplate::setPrivacy()
     * @uses LUniversalDeviceTemplate::setLoggedIntoHuntGroup()
     * @uses LUniversalDeviceTemplate::setProxyServer()
     * @uses LUniversalDeviceTemplate::setServicesUrl()
     * @uses LUniversalDeviceTemplate::setIdle()
     * @uses LUniversalDeviceTemplate::setIdleTimer()
     * @uses LUniversalDeviceTemplate::setSecureDirUrl()
     * @uses LUniversalDeviceTemplate::setMessages()
     * @uses LUniversalDeviceTemplate::setSecureIdleUrl()
     * @uses LUniversalDeviceTemplate::setAuthenticationServer()
     * @uses LUniversalDeviceTemplate::setDirectory()
     * @uses LUniversalDeviceTemplate::setSecureServicesUrl()
     * @uses LUniversalDeviceTemplate::setInformation()
     * @uses LUniversalDeviceTemplate::setSecureMessagesUrl()
     * @uses LUniversalDeviceTemplate::setSecureInformationUrl()
     * @uses LUniversalDeviceTemplate::setSecureAuthenticationUrl()
     * @uses LUniversalDeviceTemplate::setExternalPhoneNumber()
     * @uses LUniversalDeviceTemplate::setAudibleMsgWaitingicatorPolicy()
     * @uses LUniversalDeviceTemplate::setLogMissedCalls()
     * @uses LUniversalDeviceTemplate::setVisualMsgWaitingIndicatorPolicy()
     * @uses LUniversalDeviceTemplate::setLineLabel()
     * @uses LUniversalDeviceTemplate::setDisplayCallerId()
     * @uses LUniversalDeviceTemplate::setMaxNumberOfCalls()
     * @uses LUniversalDeviceTemplate::setRingSettingWhenPhoneIdle()
     * @uses LUniversalDeviceTemplate::setBusyTrigger()
     * @uses LUniversalDeviceTemplate::setRingSettingWhenPhoneInUse()
     * @uses LUniversalDeviceTemplate::setDirectoryNumber()
     * @uses LUniversalDeviceTemplate::setRecordingProfile()
     * @uses LUniversalDeviceTemplate::setCallPickupGroupAudioAlertSettingPhoneActive()
     * @uses LUniversalDeviceTemplate::setCallPickupGroupAudioAlertSettingPhoneIdle()
     * @uses LUniversalDeviceTemplate::setMonitoringCallingSearchSpace()
     * @uses LUniversalDeviceTemplate::setConfidentialAccess()
     * @uses LUniversalDeviceTemplate::setUuid()
     * @param string $name
     * @param string $deviceDescription
     * @param XFkType $devicePool
     * @param XFkType $deviceSecurityProfile
     * @param XFkType $sipProfile
     * @param XFkType $phoneButtonTemplate
     * @param XFkType $sipDialRules
     * @param XFkType $callingSearchSpace
     * @param XFkType $callingPartyTransformationCSSForInboundCalls
     * @param XFkType $callingPartyTransformationCSSForOutboundCalls
     * @param XFkType $reroutingCallingSearchSpace
     * @param XFkType $subscribeCallingSearchSpaceName
     * @param string $useDevicePoolCallingPartyTransformationCSSforInboundCalls
     * @param string $useDevicePoolCallingPartyTransformationCSSforOutboundCalls
     * @param XFkType $commonPhoneProfile
     * @param XFkType $commonDeviceConfiguration
     * @param XFkType $softkeyTemplate
     * @param XFkType $featureControlPolicy
     * @param string $phonePersonalization
     * @param string $mtpPreferredOriginatingCodec
     * @param string $outboundCallRollover
     * @param string $mediaTerminationPointRequired
     * @param string $unattendedPort
     * @param string $requiredDtmfReception
     * @param string $rfc2833Disabled
     * @param string $useTrustedRelayPoint
     * @param string $protectedDevice
     * @param string $authenticationMode
     * @param string $authenticationString
     * @param string $keySize
     * @param string $servicesProvisioning
     * @param string $packetCaptureMode
     * @param string $packetCaptureDuration
     * @param string $secureShellUser
     * @param string $secureShellPassword
     * @param string $userLocale
     * @param string $networkLocale
     * @param XFkType $mlppDomain
     * @param string $mlppIndication
     * @param string $mlppPreemption
     * @param string $doNotDisturb
     * @param string $dndOption
     * @param string $dndIncomingCallAlert
     * @param XFkType $aarGroup
     * @param XFkType $aarCallingSearchSpace
     * @param XFkType $blfPresenceGroup
     * @param string $blfAudibleAlertSettingPhoneBusy
     * @param string $blfAudibleAlertSettingPhoneIdle
     * @param string $userHoldMohAudioSource
     * @param string $networkHoldMohAudioSource
     * @param XFkType $location
     * @param XFkType $geoLocation
     * @param string $deviceMobilityMode
     * @param XFkType $mediaResourceGroupList
     * @param string $remoteDevice
     * @param string $hotlineDevice
     * @param string $retryVideoCallAsAudio
     * @param string $requireOffPremiseLocation
     * @param XFkType $ownerUserId
     * @param XFkType $mobilityUserId
     * @param string $joinAcrossLines
     * @param string $alwaysUsePrimeLine
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @param string $singleButtonBarge
     * @param string $builtInBridge
     * @param string $allowControlOfDeviceFromCti
     * @param string $ignorePresentationIndicators
     * @param string $enableExtensionMobility
     * @param string $recordingOptions
     * @param string $privacy
     * @param string $loggedIntoHuntGroup
     * @param string $proxyServer
     * @param string $servicesUrl
     * @param string $idle
     * @param string $idleTimer
     * @param string $secureDirUrl
     * @param string $messages
     * @param string $secureIdleUrl
     * @param string $authenticationServer
     * @param string $directory
     * @param string $secureServicesUrl
     * @param string $information
     * @param string $secureMessagesUrl
     * @param string $secureInformationUrl
     * @param string $secureAuthenticationUrl
     * @param string $externalPhoneNumber
     * @param string $audibleMsgWaitingicatorPolicy
     * @param string $logMissedCalls
     * @param string $visualMsgWaitingIndicatorPolicy
     * @param string $lineLabel
     * @param string $displayCallerId
     * @param string $maxNumberOfCalls
     * @param string $ringSettingWhenPhoneIdle
     * @param string $busyTrigger
     * @param string $ringSettingWhenPhoneInUse
     * @param XFkType $directoryNumber
     * @param XFkType $recordingProfile
     * @param string $callPickupGroupAudioAlertSettingPhoneActive
     * @param string $callPickupGroupAudioAlertSettingPhoneIdle
     * @param XFkType $monitoringCallingSearchSpace
     * @param ConfidentialAccess $confidentialAccess
     * @param string $uuid
     */
    public function __construct($name = null, $deviceDescription = null, XFkType $devicePool = null, XFkType $deviceSecurityProfile = null, XFkType $sipProfile = null, XFkType $phoneButtonTemplate = null, XFkType $sipDialRules = null, XFkType $callingSearchSpace = null, XFkType $callingPartyTransformationCSSForInboundCalls = null, XFkType $callingPartyTransformationCSSForOutboundCalls = null, XFkType $reroutingCallingSearchSpace = null, XFkType $subscribeCallingSearchSpaceName = null, $useDevicePoolCallingPartyTransformationCSSforInboundCalls = null, $useDevicePoolCallingPartyTransformationCSSforOutboundCalls = null, XFkType $commonPhoneProfile = null, XFkType $commonDeviceConfiguration = null, XFkType $softkeyTemplate = null, XFkType $featureControlPolicy = null, $phonePersonalization = null, $mtpPreferredOriginatingCodec = null, $outboundCallRollover = null, $mediaTerminationPointRequired = null, $unattendedPort = null, $requiredDtmfReception = null, $rfc2833Disabled = null, $useTrustedRelayPoint = null, $protectedDevice = null, $authenticationMode = null, $authenticationString = null, $keySize = null, $servicesProvisioning = null, $packetCaptureMode = null, $packetCaptureDuration = null, $secureShellUser = null, $secureShellPassword = null, $userLocale = null, $networkLocale = null, XFkType $mlppDomain = null, $mlppIndication = null, $mlppPreemption = null, $doNotDisturb = null, $dndOption = null, $dndIncomingCallAlert = null, XFkType $aarGroup = null, XFkType $aarCallingSearchSpace = null, XFkType $blfPresenceGroup = null, $blfAudibleAlertSettingPhoneBusy = null, $blfAudibleAlertSettingPhoneIdle = null, $userHoldMohAudioSource = null, $networkHoldMohAudioSource = null, XFkType $location = null, XFkType $geoLocation = null, $deviceMobilityMode = null, XFkType $mediaResourceGroupList = null, $remoteDevice = null, $hotlineDevice = null, $retryVideoCallAsAudio = null, $requireOffPremiseLocation = null, XFkType $ownerUserId = null, XFkType $mobilityUserId = null, $joinAcrossLines = null, $alwaysUsePrimeLine = null, $alwaysUsePrimeLineForVoiceMessage = null, $singleButtonBarge = null, $builtInBridge = null, $allowControlOfDeviceFromCti = null, $ignorePresentationIndicators = null, $enableExtensionMobility = null, $recordingOptions = null, $privacy = null, $loggedIntoHuntGroup = null, $proxyServer = null, $servicesUrl = null, $idle = null, $idleTimer = null, $secureDirUrl = null, $messages = null, $secureIdleUrl = null, $authenticationServer = null, $directory = null, $secureServicesUrl = null, $information = null, $secureMessagesUrl = null, $secureInformationUrl = null, $secureAuthenticationUrl = null, $externalPhoneNumber = null, $audibleMsgWaitingicatorPolicy = null, $logMissedCalls = null, $visualMsgWaitingIndicatorPolicy = null, $lineLabel = null, $displayCallerId = null, $maxNumberOfCalls = null, $ringSettingWhenPhoneIdle = null, $busyTrigger = null, $ringSettingWhenPhoneInUse = null, XFkType $directoryNumber = null, XFkType $recordingProfile = null, $callPickupGroupAudioAlertSettingPhoneActive = null, $callPickupGroupAudioAlertSettingPhoneIdle = null, XFkType $monitoringCallingSearchSpace = null, ConfidentialAccess $confidentialAccess = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDeviceDescription($deviceDescription)
            ->setDevicePool($devicePool)
            ->setDeviceSecurityProfile($deviceSecurityProfile)
            ->setSipProfile($sipProfile)
            ->setPhoneButtonTemplate($phoneButtonTemplate)
            ->setSipDialRules($sipDialRules)
            ->setCallingSearchSpace($callingSearchSpace)
            ->setCallingPartyTransformationCSSForInboundCalls($callingPartyTransformationCSSForInboundCalls)
            ->setCallingPartyTransformationCSSForOutboundCalls($callingPartyTransformationCSSForOutboundCalls)
            ->setReroutingCallingSearchSpace($reroutingCallingSearchSpace)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setUseDevicePoolCallingPartyTransformationCSSforInboundCalls($useDevicePoolCallingPartyTransformationCSSforInboundCalls)
            ->setUseDevicePoolCallingPartyTransformationCSSforOutboundCalls($useDevicePoolCallingPartyTransformationCSSforOutboundCalls)
            ->setCommonPhoneProfile($commonPhoneProfile)
            ->setCommonDeviceConfiguration($commonDeviceConfiguration)
            ->setSoftkeyTemplate($softkeyTemplate)
            ->setFeatureControlPolicy($featureControlPolicy)
            ->setPhonePersonalization($phonePersonalization)
            ->setMtpPreferredOriginatingCodec($mtpPreferredOriginatingCodec)
            ->setOutboundCallRollover($outboundCallRollover)
            ->setMediaTerminationPointRequired($mediaTerminationPointRequired)
            ->setUnattendedPort($unattendedPort)
            ->setRequiredDtmfReception($requiredDtmfReception)
            ->setRfc2833Disabled($rfc2833Disabled)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setProtectedDevice($protectedDevice)
            ->setAuthenticationMode($authenticationMode)
            ->setAuthenticationString($authenticationString)
            ->setKeySize($keySize)
            ->setServicesProvisioning($servicesProvisioning)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setSecureShellUser($secureShellUser)
            ->setSecureShellPassword($secureShellPassword)
            ->setUserLocale($userLocale)
            ->setNetworkLocale($networkLocale)
            ->setMlppDomain($mlppDomain)
            ->setMlppIndication($mlppIndication)
            ->setMlppPreemption($mlppPreemption)
            ->setDoNotDisturb($doNotDisturb)
            ->setDndOption($dndOption)
            ->setDndIncomingCallAlert($dndIncomingCallAlert)
            ->setAarGroup($aarGroup)
            ->setAarCallingSearchSpace($aarCallingSearchSpace)
            ->setBlfPresenceGroup($blfPresenceGroup)
            ->setBlfAudibleAlertSettingPhoneBusy($blfAudibleAlertSettingPhoneBusy)
            ->setBlfAudibleAlertSettingPhoneIdle($blfAudibleAlertSettingPhoneIdle)
            ->setUserHoldMohAudioSource($userHoldMohAudioSource)
            ->setNetworkHoldMohAudioSource($networkHoldMohAudioSource)
            ->setLocation($location)
            ->setGeoLocation($geoLocation)
            ->setDeviceMobilityMode($deviceMobilityMode)
            ->setMediaResourceGroupList($mediaResourceGroupList)
            ->setRemoteDevice($remoteDevice)
            ->setHotlineDevice($hotlineDevice)
            ->setRetryVideoCallAsAudio($retryVideoCallAsAudio)
            ->setRequireOffPremiseLocation($requireOffPremiseLocation)
            ->setOwnerUserId($ownerUserId)
            ->setMobilityUserId($mobilityUserId)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setBuiltInBridge($builtInBridge)
            ->setAllowControlOfDeviceFromCti($allowControlOfDeviceFromCti)
            ->setIgnorePresentationIndicators($ignorePresentationIndicators)
            ->setEnableExtensionMobility($enableExtensionMobility)
            ->setRecordingOptions($recordingOptions)
            ->setPrivacy($privacy)
            ->setLoggedIntoHuntGroup($loggedIntoHuntGroup)
            ->setProxyServer($proxyServer)
            ->setServicesUrl($servicesUrl)
            ->setIdle($idle)
            ->setIdleTimer($idleTimer)
            ->setSecureDirUrl($secureDirUrl)
            ->setMessages($messages)
            ->setSecureIdleUrl($secureIdleUrl)
            ->setAuthenticationServer($authenticationServer)
            ->setDirectory($directory)
            ->setSecureServicesUrl($secureServicesUrl)
            ->setInformation($information)
            ->setSecureMessagesUrl($secureMessagesUrl)
            ->setSecureInformationUrl($secureInformationUrl)
            ->setSecureAuthenticationUrl($secureAuthenticationUrl)
            ->setExternalPhoneNumber($externalPhoneNumber)
            ->setAudibleMsgWaitingicatorPolicy($audibleMsgWaitingicatorPolicy)
            ->setLogMissedCalls($logMissedCalls)
            ->setVisualMsgWaitingIndicatorPolicy($visualMsgWaitingIndicatorPolicy)
            ->setLineLabel($lineLabel)
            ->setDisplayCallerId($displayCallerId)
            ->setMaxNumberOfCalls($maxNumberOfCalls)
            ->setRingSettingWhenPhoneIdle($ringSettingWhenPhoneIdle)
            ->setBusyTrigger($busyTrigger)
            ->setRingSettingWhenPhoneInUse($ringSettingWhenPhoneInUse)
            ->setDirectoryNumber($directoryNumber)
            ->setRecordingProfile($recordingProfile)
            ->setCallPickupGroupAudioAlertSettingPhoneActive($callPickupGroupAudioAlertSettingPhoneActive)
            ->setCallPickupGroupAudioAlertSettingPhoneIdle($callPickupGroupAudioAlertSettingPhoneIdle)
            ->setMonitoringCallingSearchSpace($monitoringCallingSearchSpace)
            ->setConfidentialAccess($confidentialAccess)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return LUniversalDeviceTemplate
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get deviceDescription value
     * @return string|null
     */
    public function getDeviceDescription()
    {
        return $this->deviceDescription;
    }
    /**
     * Set deviceDescription value
     * @param string $deviceDescription
     * @return LUniversalDeviceTemplate
     */
    public function setDeviceDescription($deviceDescription = null)
    {
        // validation for constraint: string
        if (!is_null($deviceDescription) && !is_string($deviceDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deviceDescription)), __LINE__);
        }
        $this->deviceDescription = $deviceDescription;
        return $this;
    }
    /**
     * Get devicePool value
     * @return XFkType|null
     */
    public function getDevicePool()
    {
        return $this->devicePool;
    }
    /**
     * Set devicePool value
     * @param XFkType $devicePool
     * @return LUniversalDeviceTemplate
     */
    public function setDevicePool(XFkType $devicePool = null)
    {
        $this->devicePool = $devicePool;
        return $this;
    }
    /**
     * Get deviceSecurityProfile value
     * @return XFkType|null
     */
    public function getDeviceSecurityProfile()
    {
        return $this->deviceSecurityProfile;
    }
    /**
     * Set deviceSecurityProfile value
     * @param XFkType $deviceSecurityProfile
     * @return LUniversalDeviceTemplate
     */
    public function setDeviceSecurityProfile(XFkType $deviceSecurityProfile = null)
    {
        $this->deviceSecurityProfile = $deviceSecurityProfile;
        return $this;
    }
    /**
     * Get sipProfile value
     * @return XFkType|null
     */
    public function getSipProfile()
    {
        return $this->sipProfile;
    }
    /**
     * Set sipProfile value
     * @param XFkType $sipProfile
     * @return LUniversalDeviceTemplate
     */
    public function setSipProfile(XFkType $sipProfile = null)
    {
        $this->sipProfile = $sipProfile;
        return $this;
    }
    /**
     * Get phoneButtonTemplate value
     * @return XFkType|null
     */
    public function getPhoneButtonTemplate()
    {
        return $this->phoneButtonTemplate;
    }
    /**
     * Set phoneButtonTemplate value
     * @param XFkType $phoneButtonTemplate
     * @return LUniversalDeviceTemplate
     */
    public function setPhoneButtonTemplate(XFkType $phoneButtonTemplate = null)
    {
        $this->phoneButtonTemplate = $phoneButtonTemplate;
        return $this;
    }
    /**
     * Get sipDialRules value
     * @return XFkType|null
     */
    public function getSipDialRules()
    {
        return $this->sipDialRules;
    }
    /**
     * Set sipDialRules value
     * @param XFkType $sipDialRules
     * @return LUniversalDeviceTemplate
     */
    public function setSipDialRules(XFkType $sipDialRules = null)
    {
        $this->sipDialRules = $sipDialRules;
        return $this;
    }
    /**
     * Get callingSearchSpace value
     * @return XFkType|null
     */
    public function getCallingSearchSpace()
    {
        return $this->callingSearchSpace;
    }
    /**
     * Set callingSearchSpace value
     * @param XFkType $callingSearchSpace
     * @return LUniversalDeviceTemplate
     */
    public function setCallingSearchSpace(XFkType $callingSearchSpace = null)
    {
        $this->callingSearchSpace = $callingSearchSpace;
        return $this;
    }
    /**
     * Get callingPartyTransformationCSSForInboundCalls value
     * @return XFkType|null
     */
    public function getCallingPartyTransformationCSSForInboundCalls()
    {
        return $this->callingPartyTransformationCSSForInboundCalls;
    }
    /**
     * Set callingPartyTransformationCSSForInboundCalls value
     * @param XFkType $callingPartyTransformationCSSForInboundCalls
     * @return LUniversalDeviceTemplate
     */
    public function setCallingPartyTransformationCSSForInboundCalls(XFkType $callingPartyTransformationCSSForInboundCalls = null)
    {
        $this->callingPartyTransformationCSSForInboundCalls = $callingPartyTransformationCSSForInboundCalls;
        return $this;
    }
    /**
     * Get callingPartyTransformationCSSForOutboundCalls value
     * @return XFkType|null
     */
    public function getCallingPartyTransformationCSSForOutboundCalls()
    {
        return $this->callingPartyTransformationCSSForOutboundCalls;
    }
    /**
     * Set callingPartyTransformationCSSForOutboundCalls value
     * @param XFkType $callingPartyTransformationCSSForOutboundCalls
     * @return LUniversalDeviceTemplate
     */
    public function setCallingPartyTransformationCSSForOutboundCalls(XFkType $callingPartyTransformationCSSForOutboundCalls = null)
    {
        $this->callingPartyTransformationCSSForOutboundCalls = $callingPartyTransformationCSSForOutboundCalls;
        return $this;
    }
    /**
     * Get reroutingCallingSearchSpace value
     * @return XFkType|null
     */
    public function getReroutingCallingSearchSpace()
    {
        return $this->reroutingCallingSearchSpace;
    }
    /**
     * Set reroutingCallingSearchSpace value
     * @param XFkType $reroutingCallingSearchSpace
     * @return LUniversalDeviceTemplate
     */
    public function setReroutingCallingSearchSpace(XFkType $reroutingCallingSearchSpace = null)
    {
        $this->reroutingCallingSearchSpace = $reroutingCallingSearchSpace;
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * @return XFkType|null
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return $this->subscribeCallingSearchSpaceName;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * @param XFkType $subscribeCallingSearchSpaceName
     * @return LUniversalDeviceTemplate
     */
    public function setSubscribeCallingSearchSpaceName(XFkType $subscribeCallingSearchSpaceName = null)
    {
        $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get useDevicePoolCallingPartyTransformationCSSforInboundCalls value
     * @return string|null
     */
    public function getUseDevicePoolCallingPartyTransformationCSSforInboundCalls()
    {
        return $this->useDevicePoolCallingPartyTransformationCSSforInboundCalls;
    }
    /**
     * Set useDevicePoolCallingPartyTransformationCSSforInboundCalls value
     * @param string $useDevicePoolCallingPartyTransformationCSSforInboundCalls
     * @return LUniversalDeviceTemplate
     */
    public function setUseDevicePoolCallingPartyTransformationCSSforInboundCalls($useDevicePoolCallingPartyTransformationCSSforInboundCalls = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCallingPartyTransformationCSSforInboundCalls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCallingPartyTransformationCSSforInboundCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCallingPartyTransformationCSSforInboundCalls, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCallingPartyTransformationCSSforInboundCalls) && !is_string($useDevicePoolCallingPartyTransformationCSSforInboundCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCallingPartyTransformationCSSforInboundCalls)), __LINE__);
        }
        $this->useDevicePoolCallingPartyTransformationCSSforInboundCalls = $useDevicePoolCallingPartyTransformationCSSforInboundCalls;
        return $this;
    }
    /**
     * Get useDevicePoolCallingPartyTransformationCSSforOutboundCalls value
     * @return string|null
     */
    public function getUseDevicePoolCallingPartyTransformationCSSforOutboundCalls()
    {
        return $this->useDevicePoolCallingPartyTransformationCSSforOutboundCalls;
    }
    /**
     * Set useDevicePoolCallingPartyTransformationCSSforOutboundCalls value
     * @param string $useDevicePoolCallingPartyTransformationCSSforOutboundCalls
     * @return LUniversalDeviceTemplate
     */
    public function setUseDevicePoolCallingPartyTransformationCSSforOutboundCalls($useDevicePoolCallingPartyTransformationCSSforOutboundCalls = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCallingPartyTransformationCSSforOutboundCalls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCallingPartyTransformationCSSforOutboundCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCallingPartyTransformationCSSforOutboundCalls, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCallingPartyTransformationCSSforOutboundCalls) && !is_string($useDevicePoolCallingPartyTransformationCSSforOutboundCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCallingPartyTransformationCSSforOutboundCalls)), __LINE__);
        }
        $this->useDevicePoolCallingPartyTransformationCSSforOutboundCalls = $useDevicePoolCallingPartyTransformationCSSforOutboundCalls;
        return $this;
    }
    /**
     * Get commonPhoneProfile value
     * @return XFkType|null
     */
    public function getCommonPhoneProfile()
    {
        return $this->commonPhoneProfile;
    }
    /**
     * Set commonPhoneProfile value
     * @param XFkType $commonPhoneProfile
     * @return LUniversalDeviceTemplate
     */
    public function setCommonPhoneProfile(XFkType $commonPhoneProfile = null)
    {
        $this->commonPhoneProfile = $commonPhoneProfile;
        return $this;
    }
    /**
     * Get commonDeviceConfiguration value
     * @return XFkType|null
     */
    public function getCommonDeviceConfiguration()
    {
        return $this->commonDeviceConfiguration;
    }
    /**
     * Set commonDeviceConfiguration value
     * @param XFkType $commonDeviceConfiguration
     * @return LUniversalDeviceTemplate
     */
    public function setCommonDeviceConfiguration(XFkType $commonDeviceConfiguration = null)
    {
        $this->commonDeviceConfiguration = $commonDeviceConfiguration;
        return $this;
    }
    /**
     * Get softkeyTemplate value
     * @return XFkType|null
     */
    public function getSoftkeyTemplate()
    {
        return $this->softkeyTemplate;
    }
    /**
     * Set softkeyTemplate value
     * @param XFkType $softkeyTemplate
     * @return LUniversalDeviceTemplate
     */
    public function setSoftkeyTemplate(XFkType $softkeyTemplate = null)
    {
        $this->softkeyTemplate = $softkeyTemplate;
        return $this;
    }
    /**
     * Get featureControlPolicy value
     * @return XFkType|null
     */
    public function getFeatureControlPolicy()
    {
        return $this->featureControlPolicy;
    }
    /**
     * Set featureControlPolicy value
     * @param XFkType $featureControlPolicy
     * @return LUniversalDeviceTemplate
     */
    public function setFeatureControlPolicy(XFkType $featureControlPolicy = null)
    {
        $this->featureControlPolicy = $featureControlPolicy;
        return $this;
    }
    /**
     * Get phonePersonalization value
     * @return string|null
     */
    public function getPhonePersonalization()
    {
        return $this->phonePersonalization;
    }
    /**
     * Set phonePersonalization value
     * @uses XPhonePersonalization::valueIsValid()
     * @uses XPhonePersonalization::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phonePersonalization
     * @return LUniversalDeviceTemplate
     */
    public function setPhonePersonalization($phonePersonalization = null)
    {
        // validation for constraint: enumeration
        if (!XPhonePersonalization::valueIsValid($phonePersonalization)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $phonePersonalization, implode(', ', XPhonePersonalization::getValidValues())), __LINE__);
        }
        $this->phonePersonalization = $phonePersonalization;
        return $this;
    }
    /**
     * Get mtpPreferredOriginatingCodec value
     * @return string|null
     */
    public function getMtpPreferredOriginatingCodec()
    {
        return $this->mtpPreferredOriginatingCodec;
    }
    /**
     * Set mtpPreferredOriginatingCodec value
     * @uses XSIPCodec::valueIsValid()
     * @uses XSIPCodec::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mtpPreferredOriginatingCodec
     * @return LUniversalDeviceTemplate
     */
    public function setMtpPreferredOriginatingCodec($mtpPreferredOriginatingCodec = null)
    {
        // validation for constraint: enumeration
        if (!XSIPCodec::valueIsValid($mtpPreferredOriginatingCodec)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mtpPreferredOriginatingCodec, implode(', ', XSIPCodec::getValidValues())), __LINE__);
        }
        $this->mtpPreferredOriginatingCodec = $mtpPreferredOriginatingCodec;
        return $this;
    }
    /**
     * Get outboundCallRollover value
     * @return string|null
     */
    public function getOutboundCallRollover()
    {
        return $this->outboundCallRollover;
    }
    /**
     * Set outboundCallRollover value
     * @uses XOutboundCallRollover::valueIsValid()
     * @uses XOutboundCallRollover::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $outboundCallRollover
     * @return LUniversalDeviceTemplate
     */
    public function setOutboundCallRollover($outboundCallRollover = null)
    {
        // validation for constraint: enumeration
        if (!XOutboundCallRollover::valueIsValid($outboundCallRollover)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $outboundCallRollover, implode(', ', XOutboundCallRollover::getValidValues())), __LINE__);
        }
        $this->outboundCallRollover = $outboundCallRollover;
        return $this;
    }
    /**
     * Get mediaTerminationPointRequired value
     * @return string|null
     */
    public function getMediaTerminationPointRequired()
    {
        return $this->mediaTerminationPointRequired;
    }
    /**
     * Set mediaTerminationPointRequired value
     * @param string $mediaTerminationPointRequired
     * @return LUniversalDeviceTemplate
     */
    public function setMediaTerminationPointRequired($mediaTerminationPointRequired = null)
    {
        // validation for constraint: pattern
        if (is_scalar($mediaTerminationPointRequired) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $mediaTerminationPointRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($mediaTerminationPointRequired, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mediaTerminationPointRequired) && !is_string($mediaTerminationPointRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mediaTerminationPointRequired)), __LINE__);
        }
        $this->mediaTerminationPointRequired = $mediaTerminationPointRequired;
        return $this;
    }
    /**
     * Get unattendedPort value
     * @return string|null
     */
    public function getUnattendedPort()
    {
        return $this->unattendedPort;
    }
    /**
     * Set unattendedPort value
     * @param string $unattendedPort
     * @return LUniversalDeviceTemplate
     */
    public function setUnattendedPort($unattendedPort = null)
    {
        // validation for constraint: pattern
        if (is_scalar($unattendedPort) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($unattendedPort, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unattendedPort) && !is_string($unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unattendedPort)), __LINE__);
        }
        $this->unattendedPort = $unattendedPort;
        return $this;
    }
    /**
     * Get requiredDtmfReception value
     * @return string|null
     */
    public function getRequiredDtmfReception()
    {
        return $this->requiredDtmfReception;
    }
    /**
     * Set requiredDtmfReception value
     * @param string $requiredDtmfReception
     * @return LUniversalDeviceTemplate
     */
    public function setRequiredDtmfReception($requiredDtmfReception = null)
    {
        // validation for constraint: pattern
        if (is_scalar($requiredDtmfReception) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $requiredDtmfReception)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($requiredDtmfReception, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requiredDtmfReception) && !is_string($requiredDtmfReception)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requiredDtmfReception)), __LINE__);
        }
        $this->requiredDtmfReception = $requiredDtmfReception;
        return $this;
    }
    /**
     * Get rfc2833Disabled value
     * @return string|null
     */
    public function getRfc2833Disabled()
    {
        return $this->rfc2833Disabled;
    }
    /**
     * Set rfc2833Disabled value
     * @param string $rfc2833Disabled
     * @return LUniversalDeviceTemplate
     */
    public function setRfc2833Disabled($rfc2833Disabled = null)
    {
        // validation for constraint: pattern
        if (is_scalar($rfc2833Disabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $rfc2833Disabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($rfc2833Disabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rfc2833Disabled) && !is_string($rfc2833Disabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rfc2833Disabled)), __LINE__);
        }
        $this->rfc2833Disabled = $rfc2833Disabled;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return LUniversalDeviceTemplate
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useTrustedRelayPoint, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get protectedDevice value
     * @return string|null
     */
    public function getProtectedDevice()
    {
        return $this->protectedDevice;
    }
    /**
     * Set protectedDevice value
     * @param string $protectedDevice
     * @return LUniversalDeviceTemplate
     */
    public function setProtectedDevice($protectedDevice = null)
    {
        // validation for constraint: pattern
        if (is_scalar($protectedDevice) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $protectedDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($protectedDevice, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($protectedDevice) && !is_string($protectedDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($protectedDevice)), __LINE__);
        }
        $this->protectedDevice = $protectedDevice;
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return string|null
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @uses XAuthenticationMode::valueIsValid()
     * @uses XAuthenticationMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationMode
     * @return LUniversalDeviceTemplate
     */
    public function setAuthenticationMode($authenticationMode = null)
    {
        // validation for constraint: enumeration
        if (!XAuthenticationMode::valueIsValid($authenticationMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authenticationMode, implode(', ', XAuthenticationMode::getValidValues())), __LINE__);
        }
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get authenticationString value
     * @return string|null
     */
    public function getAuthenticationString()
    {
        return $this->authenticationString;
    }
    /**
     * Set authenticationString value
     * @param string $authenticationString
     * @return LUniversalDeviceTemplate
     */
    public function setAuthenticationString($authenticationString = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationString) && !is_string($authenticationString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authenticationString)), __LINE__);
        }
        $this->authenticationString = $authenticationString;
        return $this;
    }
    /**
     * Get keySize value
     * @return string|null
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @uses XKeySize::valueIsValid()
     * @uses XKeySize::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keySize
     * @return LUniversalDeviceTemplate
     */
    public function setKeySize($keySize = null)
    {
        // validation for constraint: enumeration
        if (!XKeySize::valueIsValid($keySize)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $keySize, implode(', ', XKeySize::getValidValues())), __LINE__);
        }
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get servicesProvisioning value
     * @return string|null
     */
    public function getServicesProvisioning()
    {
        return $this->servicesProvisioning;
    }
    /**
     * Set servicesProvisioning value
     * @uses XPhoneServiceDisplay::valueIsValid()
     * @uses XPhoneServiceDisplay::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $servicesProvisioning
     * @return LUniversalDeviceTemplate
     */
    public function setServicesProvisioning($servicesProvisioning = null)
    {
        // validation for constraint: enumeration
        if (!XPhoneServiceDisplay::valueIsValid($servicesProvisioning)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $servicesProvisioning, implode(', ', XPhoneServiceDisplay::getValidValues())), __LINE__);
        }
        $this->servicesProvisioning = $servicesProvisioning;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @uses XPacketCaptureMode::valueIsValid()
     * @uses XPacketCaptureMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureMode
     * @return LUniversalDeviceTemplate
     */
    public function setPacketCaptureMode($packetCaptureMode = null)
    {
        // validation for constraint: enumeration
        if (!XPacketCaptureMode::valueIsValid($packetCaptureMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureMode, implode(', ', XPacketCaptureMode::getValidValues())), __LINE__);
        }
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return $this->packetCaptureDuration;
    }
    /**
     * Set packetCaptureDuration value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureDuration
     * @return LUniversalDeviceTemplate
     */
    public function setPacketCaptureDuration($packetCaptureDuration = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($packetCaptureDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureDuration, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->packetCaptureDuration = $packetCaptureDuration;
        return $this;
    }
    /**
     * Get secureShellUser value
     * @return string|null
     */
    public function getSecureShellUser()
    {
        return $this->secureShellUser;
    }
    /**
     * Set secureShellUser value
     * @param string $secureShellUser
     * @return LUniversalDeviceTemplate
     */
    public function setSecureShellUser($secureShellUser = null)
    {
        // validation for constraint: string
        if (!is_null($secureShellUser) && !is_string($secureShellUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureShellUser)), __LINE__);
        }
        $this->secureShellUser = $secureShellUser;
        return $this;
    }
    /**
     * Get secureShellPassword value
     * @return string|null
     */
    public function getSecureShellPassword()
    {
        return $this->secureShellPassword;
    }
    /**
     * Set secureShellPassword value
     * @param string $secureShellPassword
     * @return LUniversalDeviceTemplate
     */
    public function setSecureShellPassword($secureShellPassword = null)
    {
        // validation for constraint: string
        if (!is_null($secureShellPassword) && !is_string($secureShellPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureShellPassword)), __LINE__);
        }
        $this->secureShellPassword = $secureShellPassword;
        return $this;
    }
    /**
     * Get userLocale value
     * @return string|null
     */
    public function getUserLocale()
    {
        return $this->userLocale;
    }
    /**
     * Set userLocale value
     * @uses XUserLocale::valueIsValid()
     * @uses XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userLocale
     * @return LUniversalDeviceTemplate
     */
    public function setUserLocale($userLocale = null)
    {
        // validation for constraint: enumeration
        if (!XUserLocale::valueIsValid($userLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userLocale, implode(', ', XUserLocale::getValidValues())), __LINE__);
        }
        $this->userLocale = $userLocale;
        return $this;
    }
    /**
     * Get networkLocale value
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return $this->networkLocale;
    }
    /**
     * Set networkLocale value
     * @uses XCountry::valueIsValid()
     * @uses XCountry::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocale
     * @return LUniversalDeviceTemplate
     */
    public function setNetworkLocale($networkLocale = null)
    {
        // validation for constraint: enumeration
        if (!XCountry::valueIsValid($networkLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkLocale, implode(', ', XCountry::getValidValues())), __LINE__);
        }
        $this->networkLocale = $networkLocale;
        return $this;
    }
    /**
     * Get mlppDomain value
     * @return XFkType|null
     */
    public function getMlppDomain()
    {
        return $this->mlppDomain;
    }
    /**
     * Set mlppDomain value
     * @param XFkType $mlppDomain
     * @return LUniversalDeviceTemplate
     */
    public function setMlppDomain(XFkType $mlppDomain = null)
    {
        $this->mlppDomain = $mlppDomain;
        return $this;
    }
    /**
     * Get mlppIndication value
     * @return string|null
     */
    public function getMlppIndication()
    {
        return $this->mlppIndication;
    }
    /**
     * Set mlppIndication value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppIndication
     * @return LUniversalDeviceTemplate
     */
    public function setMlppIndication($mlppIndication = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($mlppIndication)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mlppIndication, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->mlppIndication = $mlppIndication;
        return $this;
    }
    /**
     * Get mlppPreemption value
     * @return string|null
     */
    public function getMlppPreemption()
    {
        return $this->mlppPreemption;
    }
    /**
     * Set mlppPreemption value
     * @uses XPreemption::valueIsValid()
     * @uses XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppPreemption
     * @return LUniversalDeviceTemplate
     */
    public function setMlppPreemption($mlppPreemption = null)
    {
        // validation for constraint: enumeration
        if (!XPreemption::valueIsValid($mlppPreemption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mlppPreemption, implode(', ', XPreemption::getValidValues())), __LINE__);
        }
        $this->mlppPreemption = $mlppPreemption;
        return $this;
    }
    /**
     * Get doNotDisturb value
     * @return string|null
     */
    public function getDoNotDisturb()
    {
        return $this->doNotDisturb;
    }
    /**
     * Set doNotDisturb value
     * @param string $doNotDisturb
     * @return LUniversalDeviceTemplate
     */
    public function setDoNotDisturb($doNotDisturb = null)
    {
        // validation for constraint: pattern
        if (is_scalar($doNotDisturb) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $doNotDisturb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($doNotDisturb, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($doNotDisturb) && !is_string($doNotDisturb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($doNotDisturb)), __LINE__);
        }
        $this->doNotDisturb = $doNotDisturb;
        return $this;
    }
    /**
     * Get dndOption value
     * @return string|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @uses XDNDOption::valueIsValid()
     * @uses XDNDOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndOption
     * @return LUniversalDeviceTemplate
     */
    public function setDndOption($dndOption = null)
    {
        // validation for constraint: enumeration
        if (!XDNDOption::valueIsValid($dndOption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndOption, implode(', ', XDNDOption::getValidValues())), __LINE__);
        }
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get dndIncomingCallAlert value
     * @return string|null
     */
    public function getDndIncomingCallAlert()
    {
        return $this->dndIncomingCallAlert;
    }
    /**
     * Set dndIncomingCallAlert value
     * @uses XRingSetting::valueIsValid()
     * @uses XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndIncomingCallAlert
     * @return LUniversalDeviceTemplate
     */
    public function setDndIncomingCallAlert($dndIncomingCallAlert = null)
    {
        // validation for constraint: enumeration
        if (!XRingSetting::valueIsValid($dndIncomingCallAlert)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndIncomingCallAlert, implode(', ', XRingSetting::getValidValues())), __LINE__);
        }
        $this->dndIncomingCallAlert = $dndIncomingCallAlert;
        return $this;
    }
    /**
     * Get aarGroup value
     * @return XFkType|null
     */
    public function getAarGroup()
    {
        return $this->aarGroup;
    }
    /**
     * Set aarGroup value
     * @param XFkType $aarGroup
     * @return LUniversalDeviceTemplate
     */
    public function setAarGroup(XFkType $aarGroup = null)
    {
        $this->aarGroup = $aarGroup;
        return $this;
    }
    /**
     * Get aarCallingSearchSpace value
     * @return XFkType|null
     */
    public function getAarCallingSearchSpace()
    {
        return $this->aarCallingSearchSpace;
    }
    /**
     * Set aarCallingSearchSpace value
     * @param XFkType $aarCallingSearchSpace
     * @return LUniversalDeviceTemplate
     */
    public function setAarCallingSearchSpace(XFkType $aarCallingSearchSpace = null)
    {
        $this->aarCallingSearchSpace = $aarCallingSearchSpace;
        return $this;
    }
    /**
     * Get blfPresenceGroup value
     * @return XFkType|null
     */
    public function getBlfPresenceGroup()
    {
        return $this->blfPresenceGroup;
    }
    /**
     * Set blfPresenceGroup value
     * @param XFkType $blfPresenceGroup
     * @return LUniversalDeviceTemplate
     */
    public function setBlfPresenceGroup(XFkType $blfPresenceGroup = null)
    {
        $this->blfPresenceGroup = $blfPresenceGroup;
        return $this;
    }
    /**
     * Get blfAudibleAlertSettingPhoneBusy value
     * @return string|null
     */
    public function getBlfAudibleAlertSettingPhoneBusy()
    {
        return $this->blfAudibleAlertSettingPhoneBusy;
    }
    /**
     * Set blfAudibleAlertSettingPhoneBusy value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $blfAudibleAlertSettingPhoneBusy
     * @return LUniversalDeviceTemplate
     */
    public function setBlfAudibleAlertSettingPhoneBusy($blfAudibleAlertSettingPhoneBusy = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($blfAudibleAlertSettingPhoneBusy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $blfAudibleAlertSettingPhoneBusy, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->blfAudibleAlertSettingPhoneBusy = $blfAudibleAlertSettingPhoneBusy;
        return $this;
    }
    /**
     * Get blfAudibleAlertSettingPhoneIdle value
     * @return string|null
     */
    public function getBlfAudibleAlertSettingPhoneIdle()
    {
        return $this->blfAudibleAlertSettingPhoneIdle;
    }
    /**
     * Set blfAudibleAlertSettingPhoneIdle value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $blfAudibleAlertSettingPhoneIdle
     * @return LUniversalDeviceTemplate
     */
    public function setBlfAudibleAlertSettingPhoneIdle($blfAudibleAlertSettingPhoneIdle = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($blfAudibleAlertSettingPhoneIdle)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $blfAudibleAlertSettingPhoneIdle, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->blfAudibleAlertSettingPhoneIdle = $blfAudibleAlertSettingPhoneIdle;
        return $this;
    }
    /**
     * Get userHoldMohAudioSource value
     * @return string|null
     */
    public function getUserHoldMohAudioSource()
    {
        return $this->userHoldMohAudioSource;
    }
    /**
     * Set userHoldMohAudioSource value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userHoldMohAudioSource
     * @return LUniversalDeviceTemplate
     */
    public function setUserHoldMohAudioSource($userHoldMohAudioSource = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($userHoldMohAudioSource)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userHoldMohAudioSource, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->userHoldMohAudioSource = $userHoldMohAudioSource;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSource value
     * @return string|null
     */
    public function getNetworkHoldMohAudioSource()
    {
        return $this->networkHoldMohAudioSource;
    }
    /**
     * Set networkHoldMohAudioSource value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkHoldMohAudioSource
     * @return LUniversalDeviceTemplate
     */
    public function setNetworkHoldMohAudioSource($networkHoldMohAudioSource = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($networkHoldMohAudioSource)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkHoldMohAudioSource, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->networkHoldMohAudioSource = $networkHoldMohAudioSource;
        return $this;
    }
    /**
     * Get location value
     * @return XFkType|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param XFkType $location
     * @return LUniversalDeviceTemplate
     */
    public function setLocation(XFkType $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get geoLocation value
     * @return XFkType|null
     */
    public function getGeoLocation()
    {
        return $this->geoLocation;
    }
    /**
     * Set geoLocation value
     * @param XFkType $geoLocation
     * @return LUniversalDeviceTemplate
     */
    public function setGeoLocation(XFkType $geoLocation = null)
    {
        $this->geoLocation = $geoLocation;
        return $this;
    }
    /**
     * Get deviceMobilityMode value
     * @return string|null
     */
    public function getDeviceMobilityMode()
    {
        return $this->deviceMobilityMode;
    }
    /**
     * Set deviceMobilityMode value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceMobilityMode
     * @return LUniversalDeviceTemplate
     */
    public function setDeviceMobilityMode($deviceMobilityMode = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($deviceMobilityMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deviceMobilityMode, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->deviceMobilityMode = $deviceMobilityMode;
        return $this;
    }
    /**
     * Get mediaResourceGroupList value
     * @return XFkType|null
     */
    public function getMediaResourceGroupList()
    {
        return $this->mediaResourceGroupList;
    }
    /**
     * Set mediaResourceGroupList value
     * @param XFkType $mediaResourceGroupList
     * @return LUniversalDeviceTemplate
     */
    public function setMediaResourceGroupList(XFkType $mediaResourceGroupList = null)
    {
        $this->mediaResourceGroupList = $mediaResourceGroupList;
        return $this;
    }
    /**
     * Get remoteDevice value
     * @return string|null
     */
    public function getRemoteDevice()
    {
        return $this->remoteDevice;
    }
    /**
     * Set remoteDevice value
     * @param string $remoteDevice
     * @return LUniversalDeviceTemplate
     */
    public function setRemoteDevice($remoteDevice = null)
    {
        // validation for constraint: pattern
        if (is_scalar($remoteDevice) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $remoteDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($remoteDevice, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($remoteDevice) && !is_string($remoteDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remoteDevice)), __LINE__);
        }
        $this->remoteDevice = $remoteDevice;
        return $this;
    }
    /**
     * Get hotlineDevice value
     * @return string|null
     */
    public function getHotlineDevice()
    {
        return $this->hotlineDevice;
    }
    /**
     * Set hotlineDevice value
     * @param string $hotlineDevice
     * @return LUniversalDeviceTemplate
     */
    public function setHotlineDevice($hotlineDevice = null)
    {
        // validation for constraint: pattern
        if (is_scalar($hotlineDevice) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $hotlineDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($hotlineDevice, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hotlineDevice) && !is_string($hotlineDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotlineDevice)), __LINE__);
        }
        $this->hotlineDevice = $hotlineDevice;
        return $this;
    }
    /**
     * Get retryVideoCallAsAudio value
     * @return string|null
     */
    public function getRetryVideoCallAsAudio()
    {
        return $this->retryVideoCallAsAudio;
    }
    /**
     * Set retryVideoCallAsAudio value
     * @param string $retryVideoCallAsAudio
     * @return LUniversalDeviceTemplate
     */
    public function setRetryVideoCallAsAudio($retryVideoCallAsAudio = null)
    {
        // validation for constraint: pattern
        if (is_scalar($retryVideoCallAsAudio) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($retryVideoCallAsAudio, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($retryVideoCallAsAudio) && !is_string($retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retryVideoCallAsAudio)), __LINE__);
        }
        $this->retryVideoCallAsAudio = $retryVideoCallAsAudio;
        return $this;
    }
    /**
     * Get requireOffPremiseLocation value
     * @return string|null
     */
    public function getRequireOffPremiseLocation()
    {
        return $this->requireOffPremiseLocation;
    }
    /**
     * Set requireOffPremiseLocation value
     * @param string $requireOffPremiseLocation
     * @return LUniversalDeviceTemplate
     */
    public function setRequireOffPremiseLocation($requireOffPremiseLocation = null)
    {
        // validation for constraint: pattern
        if (is_scalar($requireOffPremiseLocation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $requireOffPremiseLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($requireOffPremiseLocation, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requireOffPremiseLocation) && !is_string($requireOffPremiseLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requireOffPremiseLocation)), __LINE__);
        }
        $this->requireOffPremiseLocation = $requireOffPremiseLocation;
        return $this;
    }
    /**
     * Get ownerUserId value
     * @return XFkType|null
     */
    public function getOwnerUserId()
    {
        return $this->ownerUserId;
    }
    /**
     * Set ownerUserId value
     * @param XFkType $ownerUserId
     * @return LUniversalDeviceTemplate
     */
    public function setOwnerUserId(XFkType $ownerUserId = null)
    {
        $this->ownerUserId = $ownerUserId;
        return $this;
    }
    /**
     * Get mobilityUserId value
     * @return XFkType|null
     */
    public function getMobilityUserId()
    {
        return $this->mobilityUserId;
    }
    /**
     * Set mobilityUserId value
     * @param XFkType $mobilityUserId
     * @return LUniversalDeviceTemplate
     */
    public function setMobilityUserId(XFkType $mobilityUserId = null)
    {
        $this->mobilityUserId = $mobilityUserId;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return string|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $joinAcrossLines
     * @return LUniversalDeviceTemplate
     */
    public function setJoinAcrossLines($joinAcrossLines = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($joinAcrossLines)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $joinAcrossLines, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return string|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLine
     * @return LUniversalDeviceTemplate
     */
    public function setAlwaysUsePrimeLine($alwaysUsePrimeLine = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($alwaysUsePrimeLine)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLine, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return string|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @return LUniversalDeviceTemplate
     */
    public function setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($alwaysUsePrimeLineForVoiceMessage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLineForVoiceMessage, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return string|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @uses XBarge::valueIsValid()
     * @uses XBarge::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $singleButtonBarge
     * @return LUniversalDeviceTemplate
     */
    public function setSingleButtonBarge($singleButtonBarge = null)
    {
        // validation for constraint: enumeration
        if (!XBarge::valueIsValid($singleButtonBarge)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $singleButtonBarge, implode(', ', XBarge::getValidValues())), __LINE__);
        }
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get builtInBridge value
     * @return string|null
     */
    public function getBuiltInBridge()
    {
        return $this->builtInBridge;
    }
    /**
     * Set builtInBridge value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $builtInBridge
     * @return LUniversalDeviceTemplate
     */
    public function setBuiltInBridge($builtInBridge = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($builtInBridge)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $builtInBridge, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->builtInBridge = $builtInBridge;
        return $this;
    }
    /**
     * Get allowControlOfDeviceFromCti value
     * @return string|null
     */
    public function getAllowControlOfDeviceFromCti()
    {
        return $this->allowControlOfDeviceFromCti;
    }
    /**
     * Set allowControlOfDeviceFromCti value
     * @param string $allowControlOfDeviceFromCti
     * @return LUniversalDeviceTemplate
     */
    public function setAllowControlOfDeviceFromCti($allowControlOfDeviceFromCti = null)
    {
        // validation for constraint: pattern
        if (is_scalar($allowControlOfDeviceFromCti) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowControlOfDeviceFromCti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowControlOfDeviceFromCti, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowControlOfDeviceFromCti) && !is_string($allowControlOfDeviceFromCti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowControlOfDeviceFromCti)), __LINE__);
        }
        $this->allowControlOfDeviceFromCti = $allowControlOfDeviceFromCti;
        return $this;
    }
    /**
     * Get ignorePresentationIndicators value
     * @return string|null
     */
    public function getIgnorePresentationIndicators()
    {
        return $this->ignorePresentationIndicators;
    }
    /**
     * Set ignorePresentationIndicators value
     * @param string $ignorePresentationIndicators
     * @return LUniversalDeviceTemplate
     */
    public function setIgnorePresentationIndicators($ignorePresentationIndicators = null)
    {
        // validation for constraint: pattern
        if (is_scalar($ignorePresentationIndicators) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $ignorePresentationIndicators)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($ignorePresentationIndicators, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ignorePresentationIndicators) && !is_string($ignorePresentationIndicators)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ignorePresentationIndicators)), __LINE__);
        }
        $this->ignorePresentationIndicators = $ignorePresentationIndicators;
        return $this;
    }
    /**
     * Get enableExtensionMobility value
     * @return string|null
     */
    public function getEnableExtensionMobility()
    {
        return $this->enableExtensionMobility;
    }
    /**
     * Set enableExtensionMobility value
     * @param string $enableExtensionMobility
     * @return LUniversalDeviceTemplate
     */
    public function setEnableExtensionMobility($enableExtensionMobility = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableExtensionMobility) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableExtensionMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableExtensionMobility, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableExtensionMobility) && !is_string($enableExtensionMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableExtensionMobility)), __LINE__);
        }
        $this->enableExtensionMobility = $enableExtensionMobility;
        return $this;
    }
    /**
     * Get recordingOptions value
     * @return string|null
     */
    public function getRecordingOptions()
    {
        return $this->recordingOptions;
    }
    /**
     * Set recordingOptions value
     * @uses XRecordingFlag::valueIsValid()
     * @uses XRecordingFlag::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recordingOptions
     * @return LUniversalDeviceTemplate
     */
    public function setRecordingOptions($recordingOptions = null)
    {
        // validation for constraint: enumeration
        if (!XRecordingFlag::valueIsValid($recordingOptions)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $recordingOptions, implode(', ', XRecordingFlag::getValidValues())), __LINE__);
        }
        $this->recordingOptions = $recordingOptions;
        return $this;
    }
    /**
     * Get privacy value
     * @return string|null
     */
    public function getPrivacy()
    {
        return $this->privacy;
    }
    /**
     * Set privacy value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $privacy
     * @return LUniversalDeviceTemplate
     */
    public function setPrivacy($privacy = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($privacy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $privacy, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->privacy = $privacy;
        return $this;
    }
    /**
     * Get loggedIntoHuntGroup value
     * @return string|null
     */
    public function getLoggedIntoHuntGroup()
    {
        return $this->loggedIntoHuntGroup;
    }
    /**
     * Set loggedIntoHuntGroup value
     * @param string $loggedIntoHuntGroup
     * @return LUniversalDeviceTemplate
     */
    public function setLoggedIntoHuntGroup($loggedIntoHuntGroup = null)
    {
        // validation for constraint: pattern
        if (is_scalar($loggedIntoHuntGroup) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $loggedIntoHuntGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($loggedIntoHuntGroup, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($loggedIntoHuntGroup) && !is_string($loggedIntoHuntGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loggedIntoHuntGroup)), __LINE__);
        }
        $this->loggedIntoHuntGroup = $loggedIntoHuntGroup;
        return $this;
    }
    /**
     * Get proxyServer value
     * @return string|null
     */
    public function getProxyServer()
    {
        return $this->proxyServer;
    }
    /**
     * Set proxyServer value
     * @param string $proxyServer
     * @return LUniversalDeviceTemplate
     */
    public function setProxyServer($proxyServer = null)
    {
        // validation for constraint: string
        if (!is_null($proxyServer) && !is_string($proxyServer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($proxyServer)), __LINE__);
        }
        $this->proxyServer = $proxyServer;
        return $this;
    }
    /**
     * Get servicesUrl value
     * @return string|null
     */
    public function getServicesUrl()
    {
        return $this->servicesUrl;
    }
    /**
     * Set servicesUrl value
     * @param string $servicesUrl
     * @return LUniversalDeviceTemplate
     */
    public function setServicesUrl($servicesUrl = null)
    {
        // validation for constraint: string
        if (!is_null($servicesUrl) && !is_string($servicesUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servicesUrl)), __LINE__);
        }
        $this->servicesUrl = $servicesUrl;
        return $this;
    }
    /**
     * Get idle value
     * @return string|null
     */
    public function getIdle()
    {
        return $this->idle;
    }
    /**
     * Set idle value
     * @param string $idle
     * @return LUniversalDeviceTemplate
     */
    public function setIdle($idle = null)
    {
        // validation for constraint: string
        if (!is_null($idle) && !is_string($idle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idle)), __LINE__);
        }
        $this->idle = $idle;
        return $this;
    }
    /**
     * Get idleTimer value
     * @return string|null
     */
    public function getIdleTimer()
    {
        return $this->idleTimer;
    }
    /**
     * Set idleTimer value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $idleTimer
     * @return LUniversalDeviceTemplate
     */
    public function setIdleTimer($idleTimer = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($idleTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $idleTimer, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->idleTimer = $idleTimer;
        return $this;
    }
    /**
     * Get secureDirUrl value
     * @return string|null
     */
    public function getSecureDirUrl()
    {
        return $this->secureDirUrl;
    }
    /**
     * Set secureDirUrl value
     * @param string $secureDirUrl
     * @return LUniversalDeviceTemplate
     */
    public function setSecureDirUrl($secureDirUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureDirUrl) && !is_string($secureDirUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureDirUrl)), __LINE__);
        }
        $this->secureDirUrl = $secureDirUrl;
        return $this;
    }
    /**
     * Get messages value
     * @return string|null
     */
    public function getMessages()
    {
        return $this->messages;
    }
    /**
     * Set messages value
     * @param string $messages
     * @return LUniversalDeviceTemplate
     */
    public function setMessages($messages = null)
    {
        // validation for constraint: string
        if (!is_null($messages) && !is_string($messages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messages)), __LINE__);
        }
        $this->messages = $messages;
        return $this;
    }
    /**
     * Get secureIdleUrl value
     * @return string|null
     */
    public function getSecureIdleUrl()
    {
        return $this->secureIdleUrl;
    }
    /**
     * Set secureIdleUrl value
     * @param string $secureIdleUrl
     * @return LUniversalDeviceTemplate
     */
    public function setSecureIdleUrl($secureIdleUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureIdleUrl) && !is_string($secureIdleUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureIdleUrl)), __LINE__);
        }
        $this->secureIdleUrl = $secureIdleUrl;
        return $this;
    }
    /**
     * Get authenticationServer value
     * @return string|null
     */
    public function getAuthenticationServer()
    {
        return $this->authenticationServer;
    }
    /**
     * Set authenticationServer value
     * @param string $authenticationServer
     * @return LUniversalDeviceTemplate
     */
    public function setAuthenticationServer($authenticationServer = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationServer) && !is_string($authenticationServer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authenticationServer)), __LINE__);
        }
        $this->authenticationServer = $authenticationServer;
        return $this;
    }
    /**
     * Get directory value
     * @return string|null
     */
    public function getDirectory()
    {
        return $this->directory;
    }
    /**
     * Set directory value
     * @param string $directory
     * @return LUniversalDeviceTemplate
     */
    public function setDirectory($directory = null)
    {
        // validation for constraint: string
        if (!is_null($directory) && !is_string($directory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directory)), __LINE__);
        }
        $this->directory = $directory;
        return $this;
    }
    /**
     * Get secureServicesUrl value
     * @return string|null
     */
    public function getSecureServicesUrl()
    {
        return $this->secureServicesUrl;
    }
    /**
     * Set secureServicesUrl value
     * @param string $secureServicesUrl
     * @return LUniversalDeviceTemplate
     */
    public function setSecureServicesUrl($secureServicesUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureServicesUrl) && !is_string($secureServicesUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureServicesUrl)), __LINE__);
        }
        $this->secureServicesUrl = $secureServicesUrl;
        return $this;
    }
    /**
     * Get information value
     * @return string|null
     */
    public function getInformation()
    {
        return $this->information;
    }
    /**
     * Set information value
     * @param string $information
     * @return LUniversalDeviceTemplate
     */
    public function setInformation($information = null)
    {
        // validation for constraint: string
        if (!is_null($information) && !is_string($information)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($information)), __LINE__);
        }
        $this->information = $information;
        return $this;
    }
    /**
     * Get secureMessagesUrl value
     * @return string|null
     */
    public function getSecureMessagesUrl()
    {
        return $this->secureMessagesUrl;
    }
    /**
     * Set secureMessagesUrl value
     * @param string $secureMessagesUrl
     * @return LUniversalDeviceTemplate
     */
    public function setSecureMessagesUrl($secureMessagesUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureMessagesUrl) && !is_string($secureMessagesUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureMessagesUrl)), __LINE__);
        }
        $this->secureMessagesUrl = $secureMessagesUrl;
        return $this;
    }
    /**
     * Get secureInformationUrl value
     * @return string|null
     */
    public function getSecureInformationUrl()
    {
        return $this->secureInformationUrl;
    }
    /**
     * Set secureInformationUrl value
     * @param string $secureInformationUrl
     * @return LUniversalDeviceTemplate
     */
    public function setSecureInformationUrl($secureInformationUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureInformationUrl) && !is_string($secureInformationUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureInformationUrl)), __LINE__);
        }
        $this->secureInformationUrl = $secureInformationUrl;
        return $this;
    }
    /**
     * Get secureAuthenticationUrl value
     * @return string|null
     */
    public function getSecureAuthenticationUrl()
    {
        return $this->secureAuthenticationUrl;
    }
    /**
     * Set secureAuthenticationUrl value
     * @param string $secureAuthenticationUrl
     * @return LUniversalDeviceTemplate
     */
    public function setSecureAuthenticationUrl($secureAuthenticationUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureAuthenticationUrl) && !is_string($secureAuthenticationUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureAuthenticationUrl)), __LINE__);
        }
        $this->secureAuthenticationUrl = $secureAuthenticationUrl;
        return $this;
    }
    /**
     * Get externalPhoneNumber value
     * @return string|null
     */
    public function getExternalPhoneNumber()
    {
        return $this->externalPhoneNumber;
    }
    /**
     * Set externalPhoneNumber value
     * @param string $externalPhoneNumber
     * @return LUniversalDeviceTemplate
     */
    public function setExternalPhoneNumber($externalPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($externalPhoneNumber) && !is_string($externalPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalPhoneNumber)), __LINE__);
        }
        $this->externalPhoneNumber = $externalPhoneNumber;
        return $this;
    }
    /**
     * Get audibleMsgWaitingicatorPolicy value
     * @return string|null
     */
    public function getAudibleMsgWaitingicatorPolicy()
    {
        return $this->audibleMsgWaitingicatorPolicy;
    }
    /**
     * Set audibleMsgWaitingicatorPolicy value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $audibleMsgWaitingicatorPolicy
     * @return LUniversalDeviceTemplate
     */
    public function setAudibleMsgWaitingicatorPolicy($audibleMsgWaitingicatorPolicy = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($audibleMsgWaitingicatorPolicy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $audibleMsgWaitingicatorPolicy, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->audibleMsgWaitingicatorPolicy = $audibleMsgWaitingicatorPolicy;
        return $this;
    }
    /**
     * Get logMissedCalls value
     * @return string|null
     */
    public function getLogMissedCalls()
    {
        return $this->logMissedCalls;
    }
    /**
     * Set logMissedCalls value
     * @param string $logMissedCalls
     * @return LUniversalDeviceTemplate
     */
    public function setLogMissedCalls($logMissedCalls = null)
    {
        // validation for constraint: pattern
        if (is_scalar($logMissedCalls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $logMissedCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($logMissedCalls, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($logMissedCalls) && !is_string($logMissedCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($logMissedCalls)), __LINE__);
        }
        $this->logMissedCalls = $logMissedCalls;
        return $this;
    }
    /**
     * Get visualMsgWaitingIndicatorPolicy value
     * @return string|null
     */
    public function getVisualMsgWaitingIndicatorPolicy()
    {
        return $this->visualMsgWaitingIndicatorPolicy;
    }
    /**
     * Set visualMsgWaitingIndicatorPolicy value
     * @uses XMWLPolicy::valueIsValid()
     * @uses XMWLPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $visualMsgWaitingIndicatorPolicy
     * @return LUniversalDeviceTemplate
     */
    public function setVisualMsgWaitingIndicatorPolicy($visualMsgWaitingIndicatorPolicy = null)
    {
        // validation for constraint: enumeration
        if (!XMWLPolicy::valueIsValid($visualMsgWaitingIndicatorPolicy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $visualMsgWaitingIndicatorPolicy, implode(', ', XMWLPolicy::getValidValues())), __LINE__);
        }
        $this->visualMsgWaitingIndicatorPolicy = $visualMsgWaitingIndicatorPolicy;
        return $this;
    }
    /**
     * Get lineLabel value
     * @return string|null
     */
    public function getLineLabel()
    {
        return $this->lineLabel;
    }
    /**
     * Set lineLabel value
     * @param string $lineLabel
     * @return LUniversalDeviceTemplate
     */
    public function setLineLabel($lineLabel = null)
    {
        // validation for constraint: string
        if (!is_null($lineLabel) && !is_string($lineLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lineLabel)), __LINE__);
        }
        $this->lineLabel = $lineLabel;
        return $this;
    }
    /**
     * Get displayCallerId value
     * @return string|null
     */
    public function getDisplayCallerId()
    {
        return $this->displayCallerId;
    }
    /**
     * Set displayCallerId value
     * @param string $displayCallerId
     * @return LUniversalDeviceTemplate
     */
    public function setDisplayCallerId($displayCallerId = null)
    {
        // validation for constraint: string
        if (!is_null($displayCallerId) && !is_string($displayCallerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayCallerId)), __LINE__);
        }
        $this->displayCallerId = $displayCallerId;
        return $this;
    }
    /**
     * Get MaxNumberOfCalls value
     * @return string|null
     */
    public function getMaxNumberOfCalls()
    {
        return $this->MaxNumberOfCalls;
    }
    /**
     * Set MaxNumberOfCalls value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxNumberOfCalls
     * @return LUniversalDeviceTemplate
     */
    public function setMaxNumberOfCalls($maxNumberOfCalls = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($maxNumberOfCalls)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxNumberOfCalls, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->MaxNumberOfCalls = $maxNumberOfCalls;
        return $this;
    }
    /**
     * Get ringSettingWhenPhoneIdle value
     * @return string|null
     */
    public function getRingSettingWhenPhoneIdle()
    {
        return $this->ringSettingWhenPhoneIdle;
    }
    /**
     * Set ringSettingWhenPhoneIdle value
     * @uses XRingSetting::valueIsValid()
     * @uses XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSettingWhenPhoneIdle
     * @return LUniversalDeviceTemplate
     */
    public function setRingSettingWhenPhoneIdle($ringSettingWhenPhoneIdle = null)
    {
        // validation for constraint: enumeration
        if (!XRingSetting::valueIsValid($ringSettingWhenPhoneIdle)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ringSettingWhenPhoneIdle, implode(', ', XRingSetting::getValidValues())), __LINE__);
        }
        $this->ringSettingWhenPhoneIdle = $ringSettingWhenPhoneIdle;
        return $this;
    }
    /**
     * Get busyTrigger value
     * @return string|null
     */
    public function getBusyTrigger()
    {
        return $this->busyTrigger;
    }
    /**
     * Set busyTrigger value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $busyTrigger
     * @return LUniversalDeviceTemplate
     */
    public function setBusyTrigger($busyTrigger = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($busyTrigger)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $busyTrigger, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->busyTrigger = $busyTrigger;
        return $this;
    }
    /**
     * Get ringSettingWhenPhoneInUse value
     * @return string|null
     */
    public function getRingSettingWhenPhoneInUse()
    {
        return $this->ringSettingWhenPhoneInUse;
    }
    /**
     * Set ringSettingWhenPhoneInUse value
     * @uses XRingSetting::valueIsValid()
     * @uses XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSettingWhenPhoneInUse
     * @return LUniversalDeviceTemplate
     */
    public function setRingSettingWhenPhoneInUse($ringSettingWhenPhoneInUse = null)
    {
        // validation for constraint: enumeration
        if (!XRingSetting::valueIsValid($ringSettingWhenPhoneInUse)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ringSettingWhenPhoneInUse, implode(', ', XRingSetting::getValidValues())), __LINE__);
        }
        $this->ringSettingWhenPhoneInUse = $ringSettingWhenPhoneInUse;
        return $this;
    }
    /**
     * Get directoryNumber value
     * @return XFkType|null
     */
    public function getDirectoryNumber()
    {
        return $this->directoryNumber;
    }
    /**
     * Set directoryNumber value
     * @param XFkType $directoryNumber
     * @return LUniversalDeviceTemplate
     */
    public function setDirectoryNumber(XFkType $directoryNumber = null)
    {
        $this->directoryNumber = $directoryNumber;
        return $this;
    }
    /**
     * Get recordingProfile value
     * @return XFkType|null
     */
    public function getRecordingProfile()
    {
        return $this->recordingProfile;
    }
    /**
     * Set recordingProfile value
     * @param XFkType $recordingProfile
     * @return LUniversalDeviceTemplate
     */
    public function setRecordingProfile(XFkType $recordingProfile = null)
    {
        $this->recordingProfile = $recordingProfile;
        return $this;
    }
    /**
     * Get callPickupGroupAudioAlertSettingPhoneActive value
     * @return string|null
     */
    public function getCallPickupGroupAudioAlertSettingPhoneActive()
    {
        return $this->callPickupGroupAudioAlertSettingPhoneActive;
    }
    /**
     * Set callPickupGroupAudioAlertSettingPhoneActive value
     * @uses XRingSetting::valueIsValid()
     * @uses XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callPickupGroupAudioAlertSettingPhoneActive
     * @return LUniversalDeviceTemplate
     */
    public function setCallPickupGroupAudioAlertSettingPhoneActive($callPickupGroupAudioAlertSettingPhoneActive = null)
    {
        // validation for constraint: enumeration
        if (!XRingSetting::valueIsValid($callPickupGroupAudioAlertSettingPhoneActive)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callPickupGroupAudioAlertSettingPhoneActive, implode(', ', XRingSetting::getValidValues())), __LINE__);
        }
        $this->callPickupGroupAudioAlertSettingPhoneActive = $callPickupGroupAudioAlertSettingPhoneActive;
        return $this;
    }
    /**
     * Get callPickupGroupAudioAlertSettingPhoneIdle value
     * @return string|null
     */
    public function getCallPickupGroupAudioAlertSettingPhoneIdle()
    {
        return $this->callPickupGroupAudioAlertSettingPhoneIdle;
    }
    /**
     * Set callPickupGroupAudioAlertSettingPhoneIdle value
     * @uses XRingSetting::valueIsValid()
     * @uses XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callPickupGroupAudioAlertSettingPhoneIdle
     * @return LUniversalDeviceTemplate
     */
    public function setCallPickupGroupAudioAlertSettingPhoneIdle($callPickupGroupAudioAlertSettingPhoneIdle = null)
    {
        // validation for constraint: enumeration
        if (!XRingSetting::valueIsValid($callPickupGroupAudioAlertSettingPhoneIdle)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callPickupGroupAudioAlertSettingPhoneIdle, implode(', ', XRingSetting::getValidValues())), __LINE__);
        }
        $this->callPickupGroupAudioAlertSettingPhoneIdle = $callPickupGroupAudioAlertSettingPhoneIdle;
        return $this;
    }
    /**
     * Get monitoringCallingSearchSpace value
     * @return XFkType|null
     */
    public function getMonitoringCallingSearchSpace()
    {
        return $this->monitoringCallingSearchSpace;
    }
    /**
     * Set monitoringCallingSearchSpace value
     * @param XFkType $monitoringCallingSearchSpace
     * @return LUniversalDeviceTemplate
     */
    public function setMonitoringCallingSearchSpace(XFkType $monitoringCallingSearchSpace = null)
    {
        $this->monitoringCallingSearchSpace = $monitoringCallingSearchSpace;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param ConfidentialAccess $confidentialAccess
     * @return LUniversalDeviceTemplate
     */
    public function setConfidentialAccess(ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LUniversalDeviceTemplate
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LUniversalDeviceTemplate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
