<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LRouteFilterMember StructType
 * @subpackage Structs
 */
class LRouteFilterMember extends AbstractStructBase
{
    /**
     * The dialPlanTagName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $dialPlanTagName;
    /**
     * The digits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $digits;
    /**
     * The operator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $operator;
    /**
     * The priority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $priority;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LRouteFilterMember
     * @uses LRouteFilterMember::setDialPlanTagName()
     * @uses LRouteFilterMember::setDigits()
     * @uses LRouteFilterMember::setOperator()
     * @uses LRouteFilterMember::setPriority()
     * @uses LRouteFilterMember::setUuid()
     * @param XFkType $dialPlanTagName
     * @param string $digits
     * @param string $operator
     * @param string $priority
     * @param string $uuid
     */
    public function __construct(XFkType $dialPlanTagName = null, $digits = null, $operator = null, $priority = null, $uuid = null)
    {
        $this
            ->setDialPlanTagName($dialPlanTagName)
            ->setDigits($digits)
            ->setOperator($operator)
            ->setPriority($priority)
            ->setUuid($uuid);
    }
    /**
     * Get dialPlanTagName value
     * @return XFkType|null
     */
    public function getDialPlanTagName()
    {
        return $this->dialPlanTagName;
    }
    /**
     * Set dialPlanTagName value
     * @param XFkType $dialPlanTagName
     * @return LRouteFilterMember
     */
    public function setDialPlanTagName(XFkType $dialPlanTagName = null)
    {
        $this->dialPlanTagName = $dialPlanTagName;
        return $this;
    }
    /**
     * Get digits value
     * @return string|null
     */
    public function getDigits()
    {
        return $this->digits;
    }
    /**
     * Set digits value
     * @param string $digits
     * @return LRouteFilterMember
     */
    public function setDigits($digits = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($digits) && strlen($digits) > 50) || (is_array($digits) && count($digits) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($digits) ? strlen($digits) : count($digits)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($digits) && !is_string($digits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($digits)), __LINE__);
        }
        $this->digits = $digits;
        return $this;
    }
    /**
     * Get operator value
     * @return string|null
     */
    public function getOperator()
    {
        return $this->operator;
    }
    /**
     * Set operator value
     * @uses XOperator::valueIsValid()
     * @uses XOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operator
     * @return LRouteFilterMember
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: enumeration
        if (!XOperator::valueIsValid($operator)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $operator, implode(', ', XOperator::getValidValues())), __LINE__);
        }
        $this->operator = $operator;
        return $this;
    }
    /**
     * Get priority value
     * @return string|null
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return LRouteFilterMember
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $priority, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LRouteFilterMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LRouteFilterMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
