<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LRemoteCluster StructType
 * @subpackage Structs
 */
class LRemoteCluster extends AbstractStructBase
{
    /**
     * The clusterId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $clusterId;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The fullyQualifiedName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $fullyQualifiedName;
    /**
     * The emcc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var LRemoteClusterMember
     */
    public $emcc;
    /**
     * The pstnAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var LRemoteClusterMember
     */
    public $pstnAccess;
    /**
     * The rsvpAgent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var LRemoteClusterMember
     */
    public $rsvpAgent;
    /**
     * The tftp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var LRemoteClusterMember
     */
    public $tftp;
    /**
     * The lbm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var LRemoteClusterMember
     */
    public $lbm;
    /**
     * The uds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var LRemoteClusterMember
     */
    public $uds;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LRemoteCluster
     * @uses LRemoteCluster::setClusterId()
     * @uses LRemoteCluster::setDescription()
     * @uses LRemoteCluster::setFullyQualifiedName()
     * @uses LRemoteCluster::setEmcc()
     * @uses LRemoteCluster::setPstnAccess()
     * @uses LRemoteCluster::setRsvpAgent()
     * @uses LRemoteCluster::setTftp()
     * @uses LRemoteCluster::setLbm()
     * @uses LRemoteCluster::setUds()
     * @uses LRemoteCluster::setUuid()
     * @param string $clusterId
     * @param string $description
     * @param string $fullyQualifiedName
     * @param LRemoteClusterMember $emcc
     * @param LRemoteClusterMember $pstnAccess
     * @param LRemoteClusterMember $rsvpAgent
     * @param LRemoteClusterMember $tftp
     * @param LRemoteClusterMember $lbm
     * @param LRemoteClusterMember $uds
     * @param string $uuid
     */
    public function __construct($clusterId = null, $description = null, $fullyQualifiedName = null, LRemoteClusterMember $emcc = null, LRemoteClusterMember $pstnAccess = null, LRemoteClusterMember $rsvpAgent = null, LRemoteClusterMember $tftp = null, LRemoteClusterMember $lbm = null, LRemoteClusterMember $uds = null, $uuid = null)
    {
        $this
            ->setClusterId($clusterId)
            ->setDescription($description)
            ->setFullyQualifiedName($fullyQualifiedName)
            ->setEmcc($emcc)
            ->setPstnAccess($pstnAccess)
            ->setRsvpAgent($rsvpAgent)
            ->setTftp($tftp)
            ->setLbm($lbm)
            ->setUds($uds)
            ->setUuid($uuid);
    }
    /**
     * Get clusterId value
     * @return string|null
     */
    public function getClusterId()
    {
        return $this->clusterId;
    }
    /**
     * Set clusterId value
     * @param string $clusterId
     * @return LRemoteCluster
     */
    public function setClusterId($clusterId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($clusterId) && strlen($clusterId) > 255) || (is_array($clusterId) && count($clusterId) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($clusterId) ? strlen($clusterId) : count($clusterId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($clusterId) && !is_string($clusterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clusterId)), __LINE__);
        }
        $this->clusterId = $clusterId;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return LRemoteCluster
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get fullyQualifiedName value
     * @return string|null
     */
    public function getFullyQualifiedName()
    {
        return $this->fullyQualifiedName;
    }
    /**
     * Set fullyQualifiedName value
     * @param string $fullyQualifiedName
     * @return LRemoteCluster
     */
    public function setFullyQualifiedName($fullyQualifiedName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($fullyQualifiedName) && strlen($fullyQualifiedName) > 50) || (is_array($fullyQualifiedName) && count($fullyQualifiedName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($fullyQualifiedName) ? strlen($fullyQualifiedName) : count($fullyQualifiedName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fullyQualifiedName) && !is_string($fullyQualifiedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fullyQualifiedName)), __LINE__);
        }
        $this->fullyQualifiedName = $fullyQualifiedName;
        return $this;
    }
    /**
     * Get emcc value
     * @return LRemoteClusterMember|null
     */
    public function getEmcc()
    {
        return $this->emcc;
    }
    /**
     * Set emcc value
     * @param LRemoteClusterMember $emcc
     * @return LRemoteCluster
     */
    public function setEmcc(LRemoteClusterMember $emcc = null)
    {
        $this->emcc = $emcc;
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return LRemoteClusterMember|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param LRemoteClusterMember $pstnAccess
     * @return LRemoteCluster
     */
    public function setPstnAccess(LRemoteClusterMember $pstnAccess = null)
    {
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get rsvpAgent value
     * @return LRemoteClusterMember|null
     */
    public function getRsvpAgent()
    {
        return $this->rsvpAgent;
    }
    /**
     * Set rsvpAgent value
     * @param LRemoteClusterMember $rsvpAgent
     * @return LRemoteCluster
     */
    public function setRsvpAgent(LRemoteClusterMember $rsvpAgent = null)
    {
        $this->rsvpAgent = $rsvpAgent;
        return $this;
    }
    /**
     * Get tftp value
     * @return LRemoteClusterMember|null
     */
    public function getTftp()
    {
        return $this->tftp;
    }
    /**
     * Set tftp value
     * @param LRemoteClusterMember $tftp
     * @return LRemoteCluster
     */
    public function setTftp(LRemoteClusterMember $tftp = null)
    {
        $this->tftp = $tftp;
        return $this;
    }
    /**
     * Get lbm value
     * @return LRemoteClusterMember|null
     */
    public function getLbm()
    {
        return $this->lbm;
    }
    /**
     * Set lbm value
     * @param LRemoteClusterMember $lbm
     * @return LRemoteCluster
     */
    public function setLbm(LRemoteClusterMember $lbm = null)
    {
        $this->lbm = $lbm;
        return $this;
    }
    /**
     * Get uds value
     * @return LRemoteClusterMember|null
     */
    public function getUds()
    {
        return $this->uds;
    }
    /**
     * Set uds value
     * @param LRemoteClusterMember $uds
     * @return LRemoteCluster
     */
    public function setUds(LRemoteClusterMember $uds = null)
    {
        $this->uds = $uds;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LRemoteCluster
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LRemoteCluster
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
